Rem drv: <create type="pkgdefs" pos="blackout/blackout_pkgdefs.sql+"/>
Rem
Rem $Header: log_pkgdefs.sql 01-jul-2005.17:22:40 gsbhatia Exp $
Rem
Rem log_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      log_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem       Used for logging system errors.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    aholser     08/22/03 - change default level 
Rem    aholser     03/15/03 - add log levels
Rem    rpinnama    10/15/02 - Set default for display name
Rem    rpinnama    10/15/02 - Remove is_dbmsjob parameter
Rem    rpinnama    10/14/02 - Provide a registration interface for logging
Rem    aholser     07/10/02 - add emd_url column to error log
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_LOG AS

--
-- PROCEDURE register_logging_module - register a module for logging
--
-- PARAMETERS
--    v_job_name_in - required. - the modulename to be registered.
--    v_display_name_in - optional. - the display in the system error log page.
--                                    defaults to v_job_name_in if not provided
--    v_dbms_jobname_in - optional. - the dbms job name 
--
  PROCEDURE register_logging_module(v_job_name_in     IN VARCHAR2,
                                    v_display_name_in IN VARCHAR2 DEFAULT NULL,
                                    v_dbms_jobname_in IN VARCHAR2 DEFAULT NULL);


--
-- PROCEDURE log_error - logs an error
--
-- PARAMETERS
--       module_name - required.  This must be a name that exists in mgmt_performance_names
--       error_code  - optional.  The error number
--       error_msg  - optional.  The error message
--       facility - optional.  The facitily string for the error message.  Defaults to 'MGMT'
--       client_data - optional.  Client-specific data.  This can be used to create subgroupings of
--           a job's error messages.
--       oms_url - optional.  The oms url for process (non-dbms) oms thread entries.
--       emd_url - optional.  The emd url for the error.
--       log_level - optional.  The error log level.  Defaults to 'ERROR'
--
  PROCEDURE log_error(v_module_name_in IN VARCHAR2,
                      v_error_code_in  IN NUMBER,
                      v_error_msg_in   IN VARCHAR2,
                      v_facility_in    IN VARCHAR2 DEFAULT 'MGMT',
                      v_client_data_in IN VARCHAR2 DEFAULT NULL,
                      v_oms_url_in     IN VARCHAR2 DEFAULT NULL,
                      v_emd_url_in     IN VARCHAR2 DEFAULT NULL,
                      v_log_level_in   IN VARCHAR2 DEFAULT 'ERROR'
                      );


--
-- PROCEDURE log_performance - logs a performance record
--
-- PARAMETERS
--       module_name - required.  This must be a name that exists in mgmt_performance_names
--       duration  - optional but expected.  Defaults to 0.  The length of time in milliseconds
--            of the performance item being tracked.
--       time_in - optional.  Defaults to SYSDATE.  Normally this would be the start time for
--            the performance item being tracked.
--       is_total - optional.  Defaults to 'Y'.  'Y' values are used to track the overall performance
--            of the job.  A job would normally have one 'Y' log entry per main loop/pass and any
--            number of 'N' entries.  A 'Y' entry may use the name and value fields to track the
--            main item it is processing (e.g. 'records') on each main loop.  'N' entries are not
--            summed in the total job performance.  'N' entries normally should have a 'name' and
--            'value' field to indicate the item and quantity that the entry is tracking (e.g. 'writes')
--       name - optional.  The name of the item being processed for this record, e.g. 'records' or 'writes'
--       value - optional.  The value of the item specified by 'name' processed over the duration
--            This will normally be a number
--       module - optional.  The module name.  This can be used to provide additional performance
--            granularity.
--       action - optional.  The name of the action being performed.  This can be used to provide
--            additional performance granularity
--       client_data - optional.  Client-specific data.  This can be used to create subgroupings of
--           a job's overall performance.  I.e., if a job is made up of several threads, then each
--           could use this field to allow breakdown by threadid.
--       oms_url - optional.  The oms url for process (non-dbms) oms thread entries.
--
  PROCEDURE log_performance(v_job_name_in IN VARCHAR2,
                            v_duration_in IN NUMBER DEFAULT 0,
                            v_time_in IN DATE DEFAULT SYSDATE,
                            v_is_total_in IN VARCHAR2 DEFAULT 'Y',
                            v_name_in IN VARCHAR2 DEFAULT NULL,
                            v_value_in IN VARCHAR2 DEFAULT NULL,
                            v_module_in IN VARCHAR2 DEFAULT NULL,
                            v_action_in IN VARCHAR2 DEFAULT NULL,
                            v_client_data_in IN VARCHAR2 DEFAULT NULL,
                            v_oms_url_in     IN VARCHAR2 DEFAULT NULL
                            );

END MGMT_LOG;
/

