Rem drv: <create type="pkgdefs" pos="assoc/assoc_main_pkgdefs.sql+"/>
Rem
Rem $Header: metric_pkgdef.sql 16-jul-2006.23:24:41 neearora Exp $
Rem
Rem metric_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      metric_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    neearora    04/23/06 - Bug 5108394. Adding function 
Rem                           is_server_gen_alert_metric 
Rem    jsadras     09/12/05 - add keys_from_mult_colls 
Rem    rpinnama    09/01/05 - Add copy_metric 
Rem    rpinnama    08/31/05 - Change the type_meta_ver default for 
Rem                           delete_metric 
Rem    gan         07/18/05 - add metric metadata callback 
Rem    rkpandey    06/20/05 - Moved upsert_metric to EM_REGISTRY 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    pmodi       06/09/05 - Bug:4406767 - Changing call back singnature 
Rem    rpinnama    05/17/05 - Support is_renderable column in mgmt_metrics 
Rem    rpinnama    05/27/05 - Fix 4399189 : Get more attributes for metric 
Rem    jsadras     05/02/05 - add is_long_running 
Rem    pmodi       04/19/05 - upsert_metric added 
Rem    pmodi       04/07/05 - API for remove key value 
Rem    rpinnama    03/03/05 - Make the column label default NULL 
Rem    rpinnama    02/25/05 - Bug 3924067: Add non_thresholded_alerts and 
Rem                           keyonly_thresholds columns 
Rem    rpinnama    01/07/05 - Add support for start/end type_meta_vers 
Rem    rpinnama    01/06/05 - Procedures to handle mgmt_metric_versions 
Rem    rpinnama    01/06/05 - Add target type addition callback 
Rem    jsadras     12/10/04 - store_metric
Rem    jsadras     10/19/04 - metric_timing
Rem    gan         09/14/04 - add remote parameter 
Rem    rpinnama    08/30/04 - Add get_key_columns() function 
Rem    rpinnama    08/19/04 - Add has_push, has_pull attributes 
Rem    rpinnama    08/18/04 - Add is_test_metric 
Rem    streddy     08/10/04 - Add is_transposed 
Rem    rpinnama    08/12/04 - Add update_* API 
Rem    rpinnama    08/03/04 - Add category class and category API 
Rem    rpinnama    07/28/04 - add more APIs to add metric records 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/23/04 - Created
Rem


CREATE OR REPLACE PACKAGE em_metric
AS

  G_MODULE_NAME CONSTANT VARCHAR2(30) := 'EM_METRIC';

  PROCEDURE add_metric_row(
              p_metric_guid        IN RAW,
              p_target_type        IN VARCHAR2,
              p_metric_name        IN VARCHAR2,
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_prop_1    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_2    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_3    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_4    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_5    IN VARCHAR2 DEFAULT ' ',
              p_metric_type        IN NUMBER   DEFAULT 0,
              p_usage_type         IN NUMBER   DEFAULT 0,
              p_metric_label       IN VARCHAR2 DEFAULT NULL,
              p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
	      p_column_label       IN VARCHAR2 DEFAULT NULL,
	      p_column_label_nlsid IN VARCHAR2 DEFAULT NULL,
	      p_key_column         IN VARCHAR2 DEFAULT NULL,
	      p_key_order          IN NUMBER   DEFAULT 0,
	      p_num_keys           IN NUMBER   DEFAULT 0,
              p_description        IN VARCHAR2 DEFAULT ' ',
              p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
              p_unit               IN VARCHAR2 DEFAULT ' ',
              p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
              p_short_name         IN VARCHAR2 DEFAULT NULL,
              p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
	      p_is_for_summary     IN NUMBER   DEFAULT 0,
              p_keys_from_mult_colls IN NUMBER DEFAULT 0,
	      p_statefull          IN NUMBER   DEFAULT 1,
              p_is_repository      IN NUMBER   DEFAULT 0,
              p_author             IN VARCHAR2 DEFAULT 'ORACLE',
              p_source_type        IN NUMBER   DEFAULT  NULL,
              p_source             IN VARCHAR2 DEFAULT NULL,
	      p_is_transposed      IN NUMBER   DEFAULT 0,
	      p_is_test_metric     IN NUMBER   DEFAULT 0,
	      p_has_push           IN NUMBER   DEFAULT 0,
	      p_has_pull           IN NUMBER   DEFAULT 0,
              p_remote             IN NUMBER   DEFAULT 0,
	      p_non_thresholded_alerts IN NUMBER DEFAULT 0,
	      p_keyonly_thresholds IN NUMBER   DEFAULT 0,
              p_is_long_running    IN NUMBER   DEFAULT 0,
              p_is_renderable      IN NUMBER   DEFAULT 1);

  PROCEDURE update_metric_row(
              p_metric_guid        IN RAW,
              p_target_type        IN VARCHAR2,
              p_metric_name        IN VARCHAR2,
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_prop_1    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_2    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_3    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_4    IN VARCHAR2 DEFAULT ' ',
              p_category_prop_5    IN VARCHAR2 DEFAULT ' ',
              p_metric_type        IN NUMBER   DEFAULT NULL,
              p_usage_type         IN NUMBER   DEFAULT NULL,
              p_metric_label       IN VARCHAR2 DEFAULT NULL,
              p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
	      p_column_label       IN VARCHAR2 DEFAULT NULL,
	      p_column_label_nlsid IN VARCHAR2 DEFAULT NULL,
	      p_key_column         IN VARCHAR2 DEFAULT NULL,
	      p_key_order          IN NUMBER   DEFAULT NULL,
	      p_num_keys           IN NUMBER   DEFAULT NULL,
              p_description        IN VARCHAR2 DEFAULT NULL,
              p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
              p_unit               IN VARCHAR2 DEFAULT NULL,
              p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
              p_short_name         IN VARCHAR2 DEFAULT NULL,
              p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
	      p_is_for_summary     IN NUMBER   DEFAULT NULL,
              p_keys_from_mult_colls IN NUMBER DEFAULT NULL,
	      p_statefull          IN NUMBER   DEFAULT NULL,
              p_is_repository      IN NUMBER   DEFAULT NULL,
              p_author             IN VARCHAR2 DEFAULT NULL,
              p_source_type        IN NUMBER   DEFAULT NULL,
              p_source             IN VARCHAR2 DEFAULT NULL,
	      p_is_transposed      IN NUMBER   DEFAULT NULL,
	      p_is_test_metric     IN NUMBER   DEFAULT NULL,
	      p_has_push           IN NUMBER   DEFAULT NULL,
	      p_has_pull           IN NUMBER   DEFAULT NULL,
	      p_remote             IN NUMBER   DEFAULT NULL,
	      p_non_thresholded_alerts IN NUMBER DEFAULT NULL,
	      p_keyonly_thresholds IN NUMBER   DEFAULT NULL,
              p_is_long_running    IN NUMBER   DEFAULT NULL,
              p_is_renderable      IN NUMBER   DEFAULT NULL);

  PROCEDURE remove_metric_row(
              p_metric_guid        IN RAW,
              p_type_meta_ver      IN VARCHAR2 DEFAULT NULL);


  -- API to handle MGMT_METRIC_VERSIONS table
  -- Adds a row to the metric versions table (MGMT_METRIC_VERSIONS)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_metric_version_row(
              p_target_type         IN VARCHAR2,
              p_metric_name         IN VARCHAR2,
              p_start_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
              p_end_type_meta_ver   IN VARCHAR2 DEFAULT NULL);

  -- Updates a row in the metric versions table (MGMT_METRIC_VERSIONS)
  PROCEDURE update_metric_version_row(
              p_target_type         IN VARCHAR2,
              p_metric_name         IN VARCHAR2,
              p_start_type_meta_ver IN VARCHAR2 DEFAULT NULL,
              p_end_type_meta_ver   IN VARCHAR2 DEFAULT NULL);

  -- Deletes a row in the metric versions table (MGMT_METRIC_VERSIONS)
  -- Deletes using the primary key target type, metric name
  PROCEDURE remove_metric_version_row(
              p_target_type         IN VARCHAR2,
              p_metric_name         IN VARCHAR2);

  --Type to hold metric information 
  TYPE METRIC_INFO_REC IS RECORD
      (
       metric_guid    mgmt_metrics.metric_guid%type,
       metric_name    mgmt_metrics.metric_name%type,
       metric_type    mgmt_metrics.metric_type%type,
       num_keys       mgmt_metrics.num_keys%type,
       is_repository  mgmt_metrics.is_repository%type,
       is_transposed  mgmt_metrics.is_transposed%type,
       source_type    mgmt_metrics.source_type%type,
       key_cols       mgmt_short_string_array,
       metric_cols    mgmt_namevalue_array,
       keys_from_mult_colls mgmt_metrics.keys_from_mult_colls%type
      ) ;

  PROCEDURE get_metric_info(p_metric_guid IN RAW,
                            p_metric_info OUT NOCOPY METRIC_INFO_REC
                          );

  PROCEDURE get_metric_info_for_target(
                      p_metric_guid IN RAW,
                      p_target_guid IN RAW,
                      p_metric_info OUT NOCOPY METRIC_INFO_REC
                      ) ;


  PROCEDURE add_category_class(
              p_class_name        IN VARCHAR2, 
              p_class_name_nlsid  IN VARCHAR2 DEFAULT NULL);

  PROCEDURE remove_category_class(
              p_class_name        IN VARCHAR2);

  PROCEDURE add_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2,  
              p_category_name_nlsid IN VARCHAR2 DEFAULT NULL);

  PROCEDURE add_categories(
              p_class_name        IN VARCHAR2, 
              p_category_def_list IN MGMT_CATEGORY_DEF_ARRAY DEFAULT NULL);

  PROCEDURE remove_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2 DEFAULT NULL);

  PROCEDURE add_object_category(
              p_object_guid        IN RAW,
              p_object_type        IN NUMBER,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_class     IN VARCHAR2 DEFAULT NULL,
	      p_category_name      IN VARCHAR2 DEFAULT NULL);

  PROCEDURE add_object_categories(
              p_object_guid        IN RAW,
              p_object_type        IN NUMBER,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

  PROCEDURE remove_object_category(
              p_object_guid        IN RAW,
              p_object_type        IN NUMBER,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_class     IN VARCHAR2 DEFAULT NULL);

  PROCEDURE remove_object_categories(
              p_object_guid        IN RAW,
              p_object_type        IN NUMBER,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

  PROCEDURE add_metric_snapshot_assoc(
      p_metric_guid          IN RAW,
      p_snapshot_target_type IN VARCHAR2,
      p_snapshot_name        IN VARCHAR2,
      p_store_metric         IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE);

  PROCEDURE add_metric_snapshot_assoc(
      p_metric_guid      IN RAW,
      p_snapshot         IN MGMT_SNAPSHOT_OBJ);

  PROCEDURE add_metric_snapshot_assocs(
      p_metric_guid        IN RAW,
      p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY);

  PROCEDURE remove_metric_snapshot_assoc(
      p_metric_guid          IN RAW,
      p_snapshot_target_type IN VARCHAR2,
      p_snapshot_name        IN VARCHAR2);

  PROCEDURE remove_metric_snapshot_assocs(
      p_metric_guid        IN RAW,
      p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL);



  -- Delete metric data 
  PROCEDURE delete_metric_data(p_target_type IN VARCHAR2,
                               p_metric_name IN VARCHAR2,
			       p_type_meta_ver IN VARCHAR2 DEFAULT NULL);

  PROCEDURE copy_metric(p_target_type IN VARCHAR2,
                        p_metric_name IN VARCHAR2,
                        p_from_type_meta_ver IN VARCHAR2,
                        p_to_type_meta_ver IN VARCHAR2);

  -- Callback to handle the addition of new target type version
  PROCEDURE handle_tgttype_addition(p_target_type   IN VARCHAR2,
                                    p_type_meta_ver IN VARCHAR2);


  PROCEDURE set_repo_timing(
     p_target_type IN VARCHAR2,
     p_metric_name IN VARCHAR2,
     p_enabled     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE);

  --
  -- PROCEDURE: handle_metric_keyval_deletion
  --
  -- PURPOSE
  --   To delete a data when a key-value of a metric is permanently removed
  --
  -- IN Parameters:
  --   p_target_guids : MGMT_TARGET_GUID_ARRAY
  --     List of target guids for which key value of metric to be deleted
  --   p_metric_guid
  --     Metric guid
  --   p_key_value
  --     Key value of metric 
  --
  -- OUT Parameters:
  --
  PROCEDURE handle_metric_keyval_deletion
  (
    p_target_guid  IN mgmt_targets.target_guid%TYPE,
    p_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    p_key_value    IN mgmt_metrics_raw.key_value%TYPE
  ) ;

  --
  -- PROCEDURE: exec_cbk_metric_keyval
  --
  -- PURPOSE
  --   (1) To execute procedure synchronusly for  deleting metric key-value data from
  --       MGMT_CURRENT_METRICS, MGMT_CURRENT_SEVERITY and MGMT_CURRENT_VIOLATION
  --   (2) To submit a task which would execute all registered callback 
  --
  -- IN Parameters:
  --   p_target_guids : MGMT_TARGET_GUID_ARRAY
  --     List of target guids for which key value of metric to be deleted
  --   p_metric_guid
  --     Metric guid
  --   p_key_value
  --     Key value of metric 
  --
  -- OUT Parameters:
  --

  PROCEDURE exec_cbk_metric_keyval
  (
    p_target_guid  IN mgmt_targets.target_guid%TYPE,
    p_metric_guids IN SMP_EMD_STRING_ARRAY,
    p_key_value    IN mgmt_metrics_raw.key_value%TYPE
  ) ;


  --
  -- PROCEDURE: task_exec_cbk_metric_keyval
  --
  -- PURPOSE
  --   Executing all registered callbacks
  --
  -- IN Parameters:
  --   p_context
  --     Parameter for callback in specific object type as NAME-VALUE pair 
  --
  -- OUT Parameters:
  --
  PROCEDURE task_exec_cbk_metric_keyval
  (
    p_context IN MGMT_NAMEVALUE_ARRAY
  );



  --
  -- PROCEDURE: add_metric_keyval_callback
  --
  -- PURPOSE
  --   To register a call back when a key-value of a metric is permanently removed
  --
  -- IN Parameters:
  --   p_callback_name : VARCHAR2
  --     Name of the callback procedure  which needs to be executed when a key-value of a metric permanently removed
  --   p_callback_eval_order : NUMBER
  --     Execution order for given callback 
  --
  -- OUT Parameters:
  --

  PROCEDURE add_metric_keyval_callback
  (
    p_callback_name IN VARCHAR2,
    p_callback_eval_order IN NUMBER DEFAULT 0
  ) ;

  --
  -- PROCEDURE: del_metric_keyval_callback
  --
  -- PURPOSE
  --   To execute all registred call back when a key-value of a metric is permanently removed
  --
  -- IN Parameters:
  --   p_callback_name : VARCHAR2
  --     Name of the callback procedure  which needs to be deleted.
  --
  -- OUT Parameters:
  --

  PROCEDURE del_metric_keyval_callback
  (
    p_callback_name IN VARCHAR2
  ) ;

  --
  -- PROCEDURE: add_metric_metadata_reg_cb
  --
  -- PURPOSE
  --   register a callback for metric metadata registration. Signature for 
  --   the callback is callback_name(p_target_type VARCHAR2,
  --                                 p_type_meta_verRCHAR2);
  --                                
  --
  -- IN Parameters:
  --   p_callback_name : VARCHAR2
  --     Name of the callback procedure
  --   p_target_type: target type
  -- OUT Parameters:
  --
   PROCEDURE add_metric_metadata_reg_cb(p_callback_name IN VARCHAR2,
                                      p_target_type IN VARCHAR2 DEFAULT ' ');

  --
  -- PROCEDURE: del_metric_metadata_reg_cb
  --
  -- PURPOSE
  --   del a callback for metric metadata registration
  --
  -- IN Parameters:
  --   p_callback_name : VARCHAR2
  --     Name of the callback procedure
  --   p_target_type: target type
  -- OUT Parameters:
  --
   PROCEDURE del_metric_metadata_reg_cb(p_callback_name IN VARCHAR2,
                                      p_target_type IN VARCHAR2 DEFAULT ' ');

  --
  -- PROCEDURE: exec_metric_metadata_reg_cb
  --
  -- PURPOSE
  --   execute the  callbacks for metric metadata registration
  --
  -- IN Parameters:
  --   p_target_type: target type
  --   p_target_meta_ver: target type meta version
  -- OUT Parameters:
  --
   PROCEDURE exec_metric_metadata_reg_cb(p_target_type IN VARCHAR2,
                                         p_type_meta_ver IN VARCHAR2);

  --
  -- PROCEDURE: is_server_gen_alert_metric
  --
  -- PURPOSE
  --   to check the given metric is for a server generated alert
  --
  -- IN Parameters:
  --   p_metric_guid : guid of the metric
  --   p_target_guid : guid of the target for which this metric needs to be checked
  -- OUT Parameters : boolean true if the given metric is  
  --                  for a server generated alert else false
  --

FUNCTION is_server_gen_alert_metric
 (
   p_metric_guid IN mgmt_metrics.metric_guid%TYPE,
   p_target_guid IN mgmt_targets.target_guid%TYPE
 )  RETURN BOOLEAN;


END em_metric;
/

show errors

