Rem drv: <create type="type_bodys" pos="collections/collections_type_body.sql+"/>
Rem
Rem $Header: metric_type_bodys.sql 01-jul-2005.22:37:40 gsbhatia Exp $
Rem
Rem metric_type_bodys.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      metric_type_bodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    05/17/05 - Add is_renderable 
Rem    rpinnama    03/21/05 - 
Rem    rpinnama    03/03/05 - 
Rem    rpinnama    02/25/05 - Bug 3924067: Add non_thresholded_alerts, 
Rem                           keyonly_thresholds columns to mgmt_metrics 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     12/10/04 - store_metric
Rem    rpinnama    10/05/04 - Remove old constructor 
Rem    rpinnama    10/05/04 - Add source_type, source at metric_col_obj 
Rem    rpinnama    08/18/04 - Add category array for metric_column_obj 
Rem    rpinnama    08/16/04 - Create a type for snapshot-metric map 
Rem    rpinnama    08/03/04 - Remove usage_type 
Rem    rpinnama    07/06/04 - Add type body for mgmt_category_def obj 
Rem    rpinnama    06/29/04 - Add usage_type 
Rem    rpinnama    06/21/04 - rpinnama_monitor_policy_repository_modifications
Rem    rpinnama    06/20/04 - Use SDK types 
Rem    rpinnama    06/17/04 - Created
Rem

CREATE OR REPLACE TYPE BODY MGMT_VALIDIF_OBJ AS
    -- Constructs a new MGMT_VALIDIF_OBJ object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW(
        p_catprop_1_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_2_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_3_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_4_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_5_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL)
    RETURN MGMT_VALIDIF_OBJ
    AS
    BEGIN
      RETURN  MGMT_VALIDIF_OBJ(p_catprop_1_choices, p_catprop_2_choices,
        p_catprop_3_choices, p_catprop_4_choices, p_catprop_5_choices);
    END NEW;
END;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_CATEGORY_DEF_OBJ AS
  -- Constructs a new MGMT_CATEGORY_DEF_OBJ object
  -- Used to support type evolution in case we need to add
  -- more columns or obsolete columns
  STATIC FUNCTION NEW(
        p_category_name       IN VARCHAR2,
        p_category_name_nlsid IN VARCHAR2 DEFAULT NULL
      )
    RETURN MGMT_CATEGORY_DEF_OBJ AS
    BEGIN
      RETURN  MGMT_CATEGORY_DEF_OBJ(p_category_name, p_category_name_nlsid);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_CATEGORY_OBJ AS
  -- Constructs a new MGMT_CATEGORY_OBJ object
  -- Used to support type evolution in case we need to add
  -- more columns or obsolete columns
  STATIC FUNCTION NEW(
        p_class_name        IN VARCHAR2,
        p_category_name     IN VARCHAR2
      )
    RETURN MGMT_CATEGORY_OBJ AS
    BEGIN
      RETURN  MGMT_CATEGORY_OBJ(p_class_name, p_category_name);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_SNAPSHOT_OBJ AS
  -- Constructs a new MGMT_SNAPSHOT_OBJ object
  -- Used to support type evolution in case we need to add
  -- more columns or obsolete columns
  STATIC FUNCTION NEW(
        p_target_type   IN VARCHAR2,
        p_snapshot_name IN VARCHAR2,
        p_store_metric  IN NUMBER DEFAULT 0
      )
    RETURN MGMT_SNAPSHOT_OBJ AS
    BEGIN
      RETURN  MGMT_SNAPSHOT_OBJ(p_target_type, p_snapshot_name,p_store_metric);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_METRIC_COLUMN_OBJ AS
  -- Constructs a new MGMT_METRIC_COLUMN_OBJ object
  -- Used to support type evolution in case we need to add
  -- more columns or obsolete columns
    STATIC FUNCTION NEW(
        p_column_name        IN VARCHAR2,
        p_column_type        IN NUMBER,
        p_is_key             IN NUMBER   DEFAULT 0,
        p_column_label       IN VARCHAR2 DEFAULT NULL,
        p_column_label_nlsid IN VARCHAR2 DEFAULT NULL,
        p_description        IN VARCHAR2 DEFAULT ' ',
        p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
        p_unit               IN VARCHAR2 DEFAULT ' ',
        p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
        p_short_name         IN VARCHAR2 DEFAULT NULL,
        p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
        p_is_for_summary     IN NUMBER   DEFAULT 0,
        p_statefull          IN NUMBER   DEFAULT 1,
        p_source_type        IN NUMBER   DEFAULT 0,
        p_source             IN VARCHAR2 DEFAULT NULL,
        p_non_thresholded_alerts IN NUMBER DEFAULT 0,
        p_keyonly_thresholds IN NUMBER DEFAULT 0,
        p_is_renderable      IN NUMBER DEFAULT 1,
        p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_METRIC_COLUMN_OBJ AS
    BEGIN
      RETURN  MGMT_METRIC_COLUMN_OBJ(p_column_name, p_column_type, 
        p_is_key, p_column_label, p_column_label_nlsid, p_description,
        p_description_nlsid, p_unit, p_unit_nlsid, p_short_name,
        p_short_name_nlsid, p_is_for_summary, p_statefull, 
        p_source_type, p_source, p_non_thresholded_alerts, p_keyonly_thresholds, 
        p_is_renderable, p_category_list);
    END NEW;
END;
/
show errors

