Rem drv: <create type="pkgdefs" pos="metric/metric_pkgdef.sql+"/>
Rem
Rem $Header: metric_ui_pkgdef.sql 20-jun-2007.21:31:16 ssukavan Exp $
Rem
Rem metric_ui_pkgdef.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      metric_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ssukavan    06/19/07 - Adding new APIs
Rem    ssukavan    05/24/07 - Adding a new API for setting the Acknowledge flag
Rem                           from UI ER 5883319 Repeat Notifications
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    rpatti      05/20/05 - rpatti_bugs_1
Rem    rpatti      05/18/05 - Created
Rem

CREATE OR REPLACE PACKAGE em_metric_ui AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;
   TYPE TARGETS_CURSOR IS REF CURSOR;

--Module Name to be used for log4plSql
MODULE_NAME CONSTANT VARCHAR2(15) := 'EM.METRICS.UI';
ANNOTATION_TYPE CONSTANT VARCHAR2(20) := 'ACKNOWLEDGED';
--
-- PROCEDURE: get_all_metrics
--
-- PURPOSE:
--   This procedure returns all metrics information displayed in the all metrics
--   page for a given target name and target type.
--
-- IN Parameters:
--   target_name_in: The target name
--   target_type_in: The target type
--
-- OUT Parameters:
--   metrics_cur_out: The cursor containing all metrics information
--   collections_cur_out: CURSORTYPE collection information
--
PROCEDURE get_all_metrics(target_name_in IN VARCHAR2,
                          target_type_in IN VARCHAR2,
                          metrics_cur_out OUT cursorType,
                          target_info_out OUT cursorType,
                          collection_cur_out OUT cursorType);

-- This API will be called from the Alerts Details and Metric Details UI.
-- This information returned from this API will show an information / confirmation about
--    1. Insufficient user priv
--    2. Not applicable severity_guid if the user chooses 
--       an older severity_guid for acknowledgement.
--    3. A confirmation UI 
--        after processing the acknowledgement
--        for already processed acknowledgment
PROCEDURE acknowledge_alert( p_target_name    IN mgmt_targets.target_name%TYPE,
                             p_target_type    IN mgmt_targets.target_type%TYPE,
                             p_violation_guid IN RAW,
                             p_user           IN VARCHAR2,
                             p_acknowledged   OUT NUMBER,
                             p_not_applicable OUT NUMBER,
                             p_has_priv       OUT NUMBER,
                             p_ack_by         OUT VARCHAR2,
                             p_ack_when       OUT DATE);

-- This API will be called from the Alerts Details.
-- This information returned from this API will 
--    1. Not show the ack button for insufficient priv'd user.
--    2. Not show the ack button for older severity_guid for acknowledgement.
--    3. The ack attributes for already acknowledged violation. Not show the ack button.
--    4. Will show the ack button for non-ackd current violation.
PROCEDURE get_acknowledge_details(   p_target_name    IN mgmt_targets.target_name%TYPE,
                                     p_target_type    IN mgmt_targets.target_type%TYPE,
                                     p_violation_guid IN RAW,
                                     p_user           IN VARCHAR2,
                                     p_acknowledged   OUT NUMBER,
                                     p_not_applicable OUT NUMBER,
                                     p_has_priv       OUT NUMBER,
                                     p_ack_by         OUT VARCHAR2,
                                     p_ack_when       OUT DATE);

-- This procedure will be called from the Alerts Tab
-- to acknowledge a list of violation guids.
-- Internally, this API calls the mgmt_notification.acknowledge_alert API
PROCEDURE acknowledge_alerts( p_violation_guid_array IN MGMT_USER_GUID_ARRAY,
                              p_user                 IN VARCHAR2);

-- This API will be called from the Availability Staus page.
-- This information returned from this API will 
--    1. Not show the ack button for insufficient priv'd user.
--    2. Not show the ack button for severity_guid null for acknowledgement.
--    3. The ack attributes for already acknowledged violation. Not show the ack button.
--    4. Will show the ack button for non-ackd severity in Availability Page.
PROCEDURE get_acknowledge_details(  p_target_name    IN mgmt_targets.target_name%TYPE,
                                    p_target_type    IN mgmt_targets.target_type%TYPE,
                                    p_user           IN VARCHAR2,
                                    p_severity_guid  OUT mgmt_violations.violation_guid%TYPE,
                                    p_acknowledged   OUT NUMBER,
                                    p_not_applicable OUT NUMBER,
                                    p_has_priv       OUT NUMBER,
                                    p_ack_by         OUT VARCHAR2,
                                    p_ack_when       OUT DATE);

-- This API will be called from the Availability History page.
-- This acknowledges the alert 
PROCEDURE acknowledge_avail_alert( p_target_name    IN mgmt_targets.target_name%TYPE,
                                   p_target_type    IN mgmt_targets.target_type%TYPE,
                                   p_violation_guid IN RAW,
                                   p_user           IN VARCHAR2,
                                   p_acknowledged   OUT NUMBER,
                                   p_has_priv       OUT NUMBER);

end em_metric_ui;
/

show errors;
