Rem
Rem $Header: mp_homepage_pkgbody.sql 27-apr-2005.15:15:59 caroy Exp $
Rem
Rem mp_homepage_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      mp_homepage_ui_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       caroy    04/27/05 - error handling 
Rem       caroy    03/11/05 - caroy_add_reports_tab
Rem
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_mp_homepage AS


-- Gets a cursor for the reports for the given target type
PROCEDURE get_reports(p_target_type IN VARCHAR2, reports_out OUT CURSOR_TYPE)
IS
BEGIN
-- link into the reports tables
    OPEN reports_out for 
      SELECT home.target_type, home.report_title, home.report_owner, 
             home.report_order
      FROM mgmt_mp_homepage_reports home, mgmt_ip_report_def report
      WHERE home.target_type = p_target_type
        AND home.report_owner = report.owner
        AND home.report_title = report.title_nlsid
      ORDER by home.report_order;
END get_reports;


-- Adds a report to the target homepage
PROCEDURE add_report(p_target_type IN VARCHAR2, p_report_title IN VARCHAR2, 
                     p_report_owner IN VARCHAR2, p_report_order IN NUMBER)
IS
BEGIN
-- Since this is an API used in the MP framework, no exceptions will be thrown
-- up.  Most typical would be a primary key violation which merely means that
-- the row they want to put in there is already there.
    BEGIN
      INSERT INTO mgmt_mp_homepage_reports
      (target_type, report_title, report_owner, report_order) VALUES
      (p_target_type, p_report_title, p_report_owner, p_report_order);
    EXCEPTION
          WHEN OTHERS THEN
          NULL;
    END;
END add_report;


-- Deletes a report from the target homepage
PROCEDURE delete_report(p_target_type IN VARCHAR2, p_report_title IN VARCHAR2, 
                        p_report_owner IN VARCHAR2)
IS
BEGIN
    DELETE FROM mgmt_mp_homepage_reports
    WHERE target_type = p_target_type
      AND report_title = p_report_title
      AND report_owner = p_report_owner;
END delete_report;


PROCEDURE delete_all_reports(p_target_type IN VARCHAR2)
IS
BEGIN
    DELETE FROM mgmt_mp_homepage_reports
    WHERE target_type = p_target_type;
END delete_all_reports;

END mgmt_mp_homepage;
/
show errors;






