Rem
Rem $Header: mp_homepage_pkgdef.sql 11-mar-2005.00:15:14 caroy Exp $
Rem
Rem mp_homepage_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      mp_homepage_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       caroy    03/11/05 - caroy_add_reports_tab
Rem

-- 
-- Package: mgmt_mp_homepage
--
-- PURPOSE: 
--   This package provides access to the target homepage utilities
--
CREATE OR REPLACE PACKAGE mgmt_mp_homepage
AS

TYPE CURSOR_TYPE IS REF CURSOR;

--
-- FUNCTION: get_reports
--
-- PURPOSE:
--   Gets the reports for a given a target type.
--
-- IN Parameters:
--   p_target_type: The target type
--
-- OUT Parameters:
--   reports_out : The cursor for this target type's reports
--
PROCEDURE get_reports(p_target_type IN VARCHAR2, reports_out OUT CURSOR_TYPE);


--
-- FUNCTION: add_report
--
-- PURPOSE:
--   Adds the specified report for the given target type.
--
-- IN Parameters:
--   p_target_type: The target type
--   p_report_title: The report title
--   p_report_owner: The report owner
--   p_order: The order the report shows up in the homepage
--
PROCEDURE add_report(p_target_type IN VARCHAR2, p_report_title IN VARCHAR2, 
                     p_report_owner IN VARCHAR2, p_report_order IN NUMBER);

--
-- FUNCTION: delete_report
--
-- PURPOSE:
--   Deletes the specified report for the given target type from the target
--   type homepage.
--
-- IN Parameters:
--   p_target_type: The target type
--   p_report_title: The report title
--   p_report_owner: The report owner
--
PROCEDURE delete_report(p_target_type IN VARCHAR2, p_report_title IN VARCHAR2, 
                        p_report_owner IN VARCHAR2);

--
-- FUNCTION: delete_all_reports
--
-- PURPOSE:
--   Deletes all the reports for the given target type.
--
-- IN Parameters:
--   p_target_type: The target type
--
PROCEDURE delete_all_reports(p_target_type IN VARCHAR2);

END mgmt_mp_homepage;

/
show errors;




