Rem drv: <create type="out_of_box" params="EM_REPOS_USER" pos="ecm/ecm_metadata_update.sql+"/>
Rem
Rem $Header: default_notification_rules_setup.sql 01-jul-2005.01:01:24 vmotamar Exp $
Rem
Rem default_notification_rules_setup.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      default_notification_rules_setup.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vmotamar    07/01/05 - Pref subtab enhancement
Rem    yaofeng     12/03/03 - fix default value problems 
Rem    yaofeng     09/12/03 - fix schedule creation 
Rem    yaofeng     08/26/03 - default schedule 
Rem    yaofeng     08/20/03 - plsql API change 
Rem    rpinnama    02/27/03 - Parameterize repos user
Rem    yaofeng     02/14/03 - user name to update pref data
Rem    yaofeng     02/14/03 - email format for default user
Rem    tjaiswal    10/03/02 - tjaiswal_outofbox_notification_rules_3
Rem    tjaiswal    10/02/02 - Created
Rem

Rem 
Rem This script requires the following arguments
Rem  1. Name of the repository user
Rem 
DEFINE EM_REPOS_USER           = "&1"


Rem
Rem Do the user pref email setup, rule emails setup, mail gateway setup for 
Rem default notification rules for types - host, emrep, agent
Rem

BEGIN
 
 DECLARE 
 
         current_em_user VARCHAR2(128);
         
         -- variables for default notification rules
         rule_name VARCHAR2(64);
         rule_owner VARCHAR2(128);
         user_email VARCHAR2(128);
         send_email NUMBER(1);
         rule_emails SMP_EMD_STRING_ARRAY;
         rule_email_formats SMP_EMD_INTEGER_ARRAY;
         rule_device_names SMP_EMD_STRING_ARRAY;
         rule_device_types SMP_EMD_INTEGER_ARRAY;
         device_not_avail_list SMP_EMD_STRING_ARRAY;
         email_gateway_setup NUMBER;
         rules_subscribed NUMBER;
         schedule_setup NUMBER;
         mail_gateway_hosts SMP_EMD_STRING_ARRAY;
         mail_server_name VARCHAR2(128);
         mail_server_sender_name VARCHAR2(64);
         mail_server_sender_addr VARCHAR2(128);

         schedule_emails SMP_EMD_NVPAIR_ARRAY;
         emails_not_available SMP_EMD_STRING_ARRAY;
    BEGIN

        -- First get the currently logged in user. the default notification
        -- rules will be owned by this user
        current_em_user := mgmt_user.get_current_em_user();
        dbms_output.put_line( 'current em user: ' || current_em_user );
        rule_owner := current_em_user;
        
        -- get the user email address if available
        -- this will be the same for all the rules
        user_email := '&EMAIL_ADDRESS';
        dbms_output.put_line( 'user email as obtained from setup: ' || user_email );

        IF( user_email IS NULL OR 
            length(trim(user_email)) = 0 OR
            UPPER(user_email) = '_NOT_AVAILABLE_' OR
            UPPER(user_email) = '%EMAIL_ADDRESS%' )
        THEN
            dbms_output.put_line( 'email address of user is not specified' );
            send_email := 0;
            rule_emails := SMP_EMD_STRING_ARRAY();
            rule_email_formats := SMP_EMD_INTEGER_ARRAY();
        ELSE            
            dbms_output.put_line( 'email address of user is specified and is: ' || user_email );
            send_email := 1;
            rule_emails := SMP_EMD_STRING_ARRAY();
            rule_emails.extend( 1 );
            rule_emails( 1 ) := user_email;
            rule_email_formats := SMP_EMD_INTEGER_ARRAY();
            rule_email_formats.extend( 1 );
            rule_email_formats( 1 ) := 1;
        END IF;
            
        -- note that the mail gateway and the email of the user needs to be
        -- setup so as to be able to receive the email notifications. these
        -- are part of the core component and so are being setup in this
        -- file
        mail_server_name := '&MAIL_SERVER_NAME';
        mail_server_sender_name := '&MAIL_SERVER_SENDER_NAME';
        mail_server_sender_addr := '&MAIL_SERVER_SENDER_ADDR';

        dbms_output.put_line( 'mail server name as obtained from setup: ' || mail_server_name );
        dbms_output.put_line( 'mail server sender name as obtained from setup: ' || mail_server_sender_name );
        dbms_output.put_line( 'mail server sender address as obtained from setup: ' || mail_server_sender_addr );

        -- setup the mail gateway only if the values are all not empty
        IF( mail_server_name IS NULL OR 
            length(trim(mail_server_name)) = 0 OR 
            UPPER(mail_server_name) = '_NOT_AVAILABLE_' OR 
            UPPER(mail_server_name) = '%MAIL_SERVER_NAME%' )
        THEN
            dbms_output.put_line( 'mail gateway data is not specified and so not setting up the mail gateway' );
        ELSE
            dbms_output.put_line( 'mail gateway data is specified and so setting up the gateway' );

            IF (mail_server_sender_name IS NULL OR 
                length(trim(mail_server_sender_name)) = 0 OR
                UPPER(mail_server_sender_name) = '_NOT_AVAILABLE_' OR 
                UPPER(mail_server_sender_name) = '%MAIL_SERVER_SENDER_NAME%')
            THEN
                -- default to user_email
                -- The fact mail_server_sender_name is provided means
                -- user_email is also provided
                mail_server_sender_name := user_email;
            END IF;

            IF (mail_server_sender_addr IS NULL OR 
                length(trim(mail_server_sender_addr)) = 0 OR
                UPPER(mail_server_sender_addr) = '_NOT_AVAILABLE_' OR
                UPPER(mail_server_sender_addr) = '%MAIL_SERVER_SENDER_ADDR%')
                -- default to user_email
                -- The fact mail_server_sender_name is provided means
                -- user_email is also provided
            THEN
                mail_server_sender_addr := user_email;
            END IF;

            BEGIN
              mail_gateway_hosts := SMP_EMD_STRING_ARRAY();
              mail_gateway_hosts.extend( 1 );
              mail_gateway_hosts( 1 ) := mail_server_name;
              dbms_output.put_line( 'setting mail gateway ...' );
              mgmt_preferences.update_mail_gateway_data( mail_gateway_server_array => mail_gateway_hosts,
                                                         mail_address_in => mail_server_sender_addr,
                                                         mail_name_in => mail_server_sender_name );                                                   
              COMMIT;

              EXCEPTION
           
                WHEN OTHERS
                THEN
                  dbms_output.put_line( 'Exception occurred while setting mail gateway' || ', SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM );
                      
            END;
        END IF;
                    
        -- set up the preference email of the current user
        -- note, if the user email was supplied, rule_emails will be a string 
        -- array of size 1. otherwise, rule_emails will be empty
        dbms_output.put_line( 'setting pref emails of user: ' || current_em_user );        
        BEGIN
          mgmt_preferences.update_user_pref_data( '&EM_REPOS_USER',
                                                  ' ',
                                                  0,
                                                  rule_emails,
                                                  rule_email_formats,
                                                  email_gateway_setup,
                                                  rules_subscribed,
                                                  schedule_setup );
          dbms_output.put_line( 'email gateway setup: ' || email_gateway_setup );
          COMMIT;        
          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'Exception occurred while setting pref email of user: ' || current_em_user || ', SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM );
                      
        END;
      
        IF (send_email = 1)
        THEN
            -- create a default 24x7 notification schedule
            dbms_output.put_line( 'create the default notification schedule');

            schedule_emails := SMP_EMD_NVPAIR_ARRAY();
            schedule_emails.extend( 1 );
            schedule_emails(1) := SMP_EMD_NVPAIR(user_email,
                                                 'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY');

            emails_not_available := SMP_EMD_STRING_ARRAY();

            BEGIN
              mgmt_preferences.create_notification_schedule('&EM_REPOS_USER',
                                                            ' ',
                                                            1,
                                                            SYSDATE,
                                                            schedule_emails,
                                                            emails_not_available);
              EXCEPTION
                WHEN OTHERS
                THEN
                  dbms_output.put_line( 'Exception occurred while creating notification schedule, SQLCODE: ' || SQLCODE || ', SQLERRM: ' || SQLERRM );
                      
            END;
        END IF;

        -- no devices to be assigned with the rules ...  
        rule_device_names := SMP_EMD_STRING_ARRAY();
        rule_device_types := SMP_EMD_INTEGER_ARRAY();

        -- now setup the emails for each of the rules of 
        -- type - host, emrep, agent

        -- Assign email to the host targets rule 
        rule_name := 'Host Availability and Critical States';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;
        
        -- Assign email to the agents targets rule 
        rule_name := 'Agents Unreachable';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;

        -- Assign email to the emrep targets rule 
        rule_name := 'Repository Operations Availability';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;

        -- Assign email to the emrep targets rule 
        rule_name := 'Agent Upload Problems';

        BEGIN
          dbms_output.put_line( 'Assign email: ' || user_email || ' of ' || current_em_user || ' to rule: ' || rule_name || ' of: ' || rule_owner  );
          mgmt_preferences.update_rule_devices_data( rule_name, 
                                                     rule_owner, 
                                                     send_email,  
                                                     rule_device_names,  
                                                     rule_device_types, 
                                                     device_not_avail_list, 
                                                     email_gateway_setup ); 
          dbms_output.put_line( 'email_gateway_setup: ' || email_gateway_setup );
          COMMIT;

          EXCEPTION
           
            WHEN OTHERS
            THEN
              dbms_output.put_line( 'UNHANDLED EXCEPTION while assigning email: ' || user_email || ' to rule: ' || rule_name );
                      
        END;

    END;

END;
/
