Rem drv: <create type="pkgdefs" pos="notification/notification_pkgdefs.sql+"/>
Rem
Rem $Header: notification_ui_pkgdef.sql 02-jun-2007.07:47:31 ssukavan Exp $
Rem
Rem notification_ui_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ssukavan    05/17/07 - ER 5883319 Repeat Notifications support
Rem    yaofeng     12/07/05 - java device details 
Rem    yaofeng     07/13/05 - hidden key column 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    yaofeng     07/05/05 - hidden key column 
Rem    vmotamar    06/28/05 - Pref subtab enhancement
Rem    yaofeng     03/29/05 - search query 
Rem    yaofeng     03/18/05 - target name field 
Rem    yaofeng     03/14/05 - type related data 
Rem    yaofeng     01/14/05 - policy NLS 
Rem    yaofeng     01/10/05 - timezone again 
Rem    yaofeng     01/10/05 - timezone
Rem    yaofeng     12/28/04 - assign rules 
Rem    yaofeng     12/09/04 - send email checkbox 
Rem    yaofeng     11/19/04 - constant
Rem    yaofeng     10/26/04 - group support 
Rem    yaofeng     10/21/04 - rca support 
Rem    yaofeng     09/08/04 - back compatible 
Rem    yaofeng     09/02/04 - cleanup
Rem    yaofeng     08/13/04 - notification rule changes 
Rem    yaofeng     08/25/03 - confirmation page for delete 
Rem    yaofeng     08/19/03 - fix bug 3093073 
Rem    yaofeng     07/24/03 - os command line arguments
Rem    dcawley     06/20/03 - Remove test routines
Rem    yaofeng     04/15/03 - pass target type info out for rules
Rem    yaofeng     04/14/03 - correct comments
Rem    yaofeng     04/04/03 - get available metric indexes
Rem    yaofeng     02/07/03 - email customization
Rem    yaofeng     01/21/03 - get schedule defination
Rem    yaofeng     01/17/03 - notification schedule
Rem    yaofeng     11/19/02 - support Metric Error
Rem    tjaiswal    09/12/02 - User modify user of mgmt user package
Rem    dcawley     08/08/02 - Use new type definitions
Rem    tjaiswal    05/23/02 - Add target avail notif support
Rem    tjaiswal    05/21/02 - tjaiswal_multiple_notif_devices
Rem    tjaiswal    05/17/02 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_preferences AS

TYPE CURSOR_TYPE IS REF CURSOR;

CREATE_MODE NUMBER(1) := 0;
EDIT_MODE NUMBER(1) := 1;

RULES_TYPE_ALL CONSTANT VARCHAR2(3) := 'ALL';
RULES_TYPE_PUBLIC CONSTANT VARCHAR2(6) := 'PUBLIC';

RULE_VIEW_MODE NUMBER(1) := 1;
DEVICE_VIEW_MODE NUMBER(1) := 2;

DEFAULT_SCHEDULE_VALUE CONSTANT VARCHAR2(168) := 'YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY';

--
-- Name: update_user_pref_data
--
-- Purpose: 
--  Update the current user preferences data. This includes the user password 
--  and the user emails
--
-- IN parameters:
--  user_name_in: VARCHAR2
--      the user name 
--  user_password_in: VARCHAR2
--      If should_update_pwd_in=G_TRUE, the user's password will be updated to 
--      that specified by this string
--  should_update_pwd_in: NUMBER
--      If G_TRUE, the password should be updated
--  user_email_in: SMP_EMD_STRING_ARRAY
--      The user's email will be updated to that specified in this string array
--  user_email_format_in: SMP_EMD_INTEGER_ARRAY
--      The user's email will be updated to that specified in this string array
--
-- OUT parameters:
--  mail_gateway_setup_out: NUMBER
--      G_TRUE if mail gateway is setup, G_FALSE otherwise
--  rules_subscribed_out: NUMBER
--      G_TRUE if the user subscribed notification ruels, G_FALSE otherwise
--  schedule_setup_out: NUMBER
--      G_TRUE if the schedule is setup, G_FALSE otherwise
--
-- ERROR codes:
--  INVALID_PASSWORD_ERR: invalid password error(empty password or password does 
--                        not start with an alphabet or password is longer than
--                        30 characters)
--
PROCEDURE update_user_pref_data
  (user_name_in IN VARCHAR2,
   user_password_in IN VARCHAR2,
   should_update_pwd_in IN NUMBER,
   user_email_in IN SMP_EMD_STRING_ARRAY,
   user_email_format_in IN SMP_EMD_INTEGER_ARRAY,
   mail_gateway_setup_out OUT NUMBER,
   rules_subscribed_out OUT NUMBER,
   schedule_setup_out OUT NUMBER);

--
-- Name: try_update_user_pref
--
-- Purpose:
--  Try to update the current user preferences data. This includes the user password
--  and the user emails. If all email addresses used in the notification schedule are
--  going to be deleted, do nothing and return a list of all email addresses used in
--  the schedule. This will give the user a chance to confirm the deletion. Otherwise,
--  update user's preference data (same as update_user_pref_data)
--
-- IN parameters:
--  user_name_in: VARCHAR2
--      the user name
--  user_password_in: VARCHAR2
--      If should_update_pwd_in=G_TRUE, the user's password will be updated to
--      that specified by this string
--  should_update_pwd_in: NUMBER
--      If G_TRUE, the password should be updated
--  user_email_in: SMP_EMD_STRING_ARRAY
--      The user's email will be updated to that specified in this string array
--  user_email_format_in: SMP_EMD_INTEGER_ARRAY
--      The user's email will be updated to that specified in this string array
--
-- OUT parameters:
--  mail_gateway_setup_out: NUMBER
--      G_TRUE if mail gateway is setup, G_FALSE otherwise
--  rules_subscribed_out: NUMBER
--      G_TRUE if the user subscribed notification ruels, G_FALSE otherwise
--  schedule_setup_out: NUMBER
--      G_TRUE if the schedule is setup, G_FALSE otherwise
--  operation_done_out: NUMBER
--      G_TRUE if the update operation is performed, G_FALSE otherwise
--  email_used_out: CURSOR_TYPE
--      a list of email addresses used in the notification schedule
--
-- ERROR codes:
--  INVALID_PASSWORD_ERR: invalid password error(empty password or password does
--                        not start with an alphabet or password is longer than
--                        30 characters)
--
PROCEDURE try_update_user_pref
  (user_name_in IN VARCHAR2,
   user_password_in IN VARCHAR2,
   should_update_pwd_in IN NUMBER,
   user_email_in IN SMP_EMD_STRING_ARRAY,
   user_email_format_in IN SMP_EMD_INTEGER_ARRAY,
   mail_gateway_setup_out OUT NUMBER,
   rules_subscribed_out OUT NUMBER,
   schedule_setup_out OUT NUMBER,
   operation_done_out OUT NUMBER,
   email_used_out OUT CURSOR_TYPE);

--
-- Name: add_email_addresses
--
-- Purpose:
--  Add a list of email addresses to the user's preferences data.
--
-- IN parameters:
--  user_name_in: VARCHAR2
--      the user name
--  user_email_in: SMP_EMD_STRING_ARRAY
--      Email addresses specified in this string array will be added
--  user_email_format_in: SMP_EMD_INTEGER_ARRAY
--      The format of the email addresses to be added
--
-- OUT parameters:
--  None
--
PROCEDURE add_email_addresses
  (user_name_in IN VARCHAR2,
   user_email_in IN SMP_EMD_STRING_ARRAY,
   user_email_format_in IN SMP_EMD_INTEGER_ARRAY);

--
-- Name: get_metrics_for_rule
--
-- Purpose:
--  get a list of metric columns of a target type for a rule 
--
-- IN parameters:
--  target_type_in: VARCHAR2
--      the target type 
--
--  target_names_in: SMP_EMD_STRING_ARRAY
--      a list of target names
--
-- OUT parameters:
--  threshold_metric_columns_out: CURSOR_TYPE
--      The metric (which could have thresholds) columns of a target type 
--  key_metric_columns_out: CURSOR_TYPE
--      The metric columns which are keys
--
PROCEDURE get_metrics_for_rule
  (target_type_in IN VARCHAR2,
   target_names_in IN SMP_EMD_STRING_ARRAY,
   threshold_metric_colums_out OUT CURSOR_TYPE,
   key_metric_columns_out OUT CURSOR_TYPE);

--
-- Name: get_notification_rules
--
-- Purpose: 
--  Get the list of notification rules(with the overview data) for a user.
--
-- NOTE: This API should be called only by a super user.
--
--  If the user_name_in value is specified and is valid, then this procedure 
--  returns the list of rules(with the overview data) for the 
--  user - user_name_in according to:
--      If rules_type_in is RULES_TYPE_ALL then
--        this procedure returns all notification rules(with the overview data) 
--        for user - user_name_in.
--        all notification rules for user - user_name_in include all the rules that
--        the user - user_name_in created
--      if rules_type_in is RULES_TYPE_PUBLIC then
--        this procedure returns public notifications rules(with the overview 
--        data) for user - user_name_in.
--        public notification rules for user - user_name_in include all the rules 
--        that the user - user_name_in created and which are public plus all the 
--        rules that other users created and which are public
--  If the user_name_in value is not specified, then this procedure returns
--  the list of rules(with the overview data) for the current privileged user 
--  according to:
--      If rules_type_in is RULES_TYPE_ALL then
--        this procedure returns all notification rules(with the overview data) 
--        for the privileged user.
--        all notification rules for the privileged user include all the rules 
--        that the all users created
--      if rules_type_in is RULES_TYPE_PUBLIC then
--        this procedure returns public notifications rules(with the overview 
--        data) for the privileged user.
--        public notification rules for the privileged user include all the 
--        rules that the privileged user created and which are public plus all 
--        the rules that other users created and which are public
--
-- IN parameters:
--  user_name_in: VARCHAR2
--      The user name whose rules are to be obtained
--  rules_type_in: VARCHAR2
--      The type of rules to be obtained
--      Can be - RULES_TYPE_ALL,
--               RULES_TYPE_PUBLIC,
--      If anything else is passed, RULES_TYPE_PUBLIC will be used
--
-- OUT parameters:
--  rules_overview_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      rule_desc: VARCHAR2 the rule description
--      rule_public: NUMBER(1) if the rule is public or not
--                   G_TRUE if the rule is public, G_FALSE otherwise
--      want_clears: NUMBER(1) want clears?
--                   G_TRUE if want clears, G_FALSE otherwise
--      want_critical_alerts: NUMBER(1) want critical alerts?
--                   G_TRUE if want critical alerts, G_FALSE otherwise
--      want_warning_alerts: NUMBER(1) want warning alerts?
--                   G_TRUE if want warning alerts, G_FALSE otherwise
--  rules_target_type_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      target_type: VARCHAR2 target type of the rule
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--

PROCEDURE get_notification_rules
  (user_name_in IN VARCHAR2,
   rules_type_in IN VARCHAR2,
   rules_overview_list_out OUT CURSOR_TYPE,
   rules_target_type_list_out OUT CURSOR_TYPE);

--
-- Name: get_notification_rules
--
-- Purpose: 
--  Get the list of notification rules(with the overview data) for the current
--  user.
--
-- Note: This API can be used by any user
--
--  This procedure returns the list of rules(with the overview data) for the 
--  current user according to:
--      If rules_type_in is RULES_TYPE_ALL then
--        this procedure returns all notification rules(with the overview data) 
--        for the current user.
--        all notification rules for the current user include all the rules 
--        that the current user created
--      if rules_type_in is RULES_TYPE_PUBLIC then
--        this procedure returns public notifications rules(with the overview 
--        data) for the current user.
--        public notification rules for the current user include all the 
--        rules that the current user created and which are public plus all 
--        the rules that other users created and which are public
--
-- IN parameters:
--  rules_type_in: VARCHAR2
--      The type of rules to be obtained
--      Can be - RULES_TYPE_ALL,
--               RULES_TYPE_PUBLIC,
--      If anything else is passed, RULES_TYPE_PUBLIC will be used
--
-- OUT parameters:
--  rules_overview_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      rule_desc: VARCHAR2 the rule description
--      rule_public: NUMBER(1) if the rule is public or not
--                   G_TRUE if the rule is public, G_FALSE otherwise
--      want_clears: NUMBER(1) want clears?
--                   G_TRUE if want clears, G_FALSE otherwise
--      want_critical_alerts: NUMBER(1) want critical alerts?
--                   G_TRUE if want critical alerts, G_FALSE otherwise
--      want_warning_alerts: NUMBER(1) want warning alerts?
--                   G_TRUE if want warning alerts, G_FALSE otherwise
--  rules_target_type_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      target_type: VARCHAR2 target type of the rule
--
-- ERROR codes:
--  None
--
PROCEDURE get_notification_rules
  (rules_type_in IN VARCHAR2,
   rules_overview_list_out OUT CURSOR_TYPE,
   rules_target_type_list_out OUT CURSOR_TYPE);

--
-- Name: get_notification_rule_details
--
-- Purpose: 
--  Get the notification rule detail data for rule - rule_name_in of user - 
--  user_name_in
--
--  If the rule_owner_in is specified and is valid, then the rule detail data 
--  for rule - rule_name_in of owner - rule_owner_in will be returned ELSE 
--  the rule detail data for rule - rule_name_in of the current  
--  user will be returned
--
-- Note: This API can be used by any user
--
-- IN parameters:
--  rule_name_in: VARCHAR2
--      The rule for which the rule detail data needs will be returned
--  rule_owner_in: VARCHAR2
--      The user name whose rule detail data is to be obtained
--
-- OUT parameters:
--  rules_detail_list_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      rule_desc: VARCHAR2 the rule description
--      rule_public: NUMBER(1) if the rule is public or not
--                   G_TRUE if the rule is public, G_FALSE otherwise
--      want_clears: NUMBER(1) want clears?
--                   G_TRUE if want clears, G_FALSE otherwise
--      want_critical_alerts: NUMBER(1) want critical alerts?
--                   G_TRUE if want critical alerts, G_FALSE otherwise
--      want_warning_alerts: NUMBER(1) want warning alerts?
--                   G_TRUE if want warning alerts, G_FALSE otherwise
--      want_tgt_up_in: NUMBER(1) 
--          Want target up notifications? 
--          G_TRUE if want target up notifications, G_FALSE otherwise
--      want_tgt_down_in: NUMBER(1) 
--          Want target down notifications? 
--          G_TRUE if want target down notifications, G_FALSE otherwise
--      want_tgt_unreachable_start_in: NUMBER(1) 
--          Want target unreachable start notifications? 
--          G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--      want_tgt_unreachable_end_in: NUMBER(1) 
--          Want target unreachable end notifications? 
--          G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--      want_tgt_metric_err_start_in: NUMBER(1) 
--          Want target metric error start notifications? 
--          G_TRUE if want target metric error start notifications, G_FALSE otherwise
--      want_tgt_metric_err_end_in: NUMBER(1) 
--          Want target metric error end notifications? 
--          G_TRUE if want target metric error end notifications, G_FALSE otherwise
--      want_tgt_blkout_started_in: NUMBER(1) 
--          Want target blackout started notifications? 
--          G_TRUE if want target blackout started notifications, G_FALSE otherwise
--      want_tgt_blkout_ended_in: NUMBER(1) 
--          Want target blackout ended notifications? 
--          G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--  rules_target_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      target_type: VARCHAR2 the target type for which this rule was created
--      type_display_name: VARCHAR2 the display name of the target type - 
--                         target_type
--      target_name: VARCHAR2 the target name for rule - rule_name
--      Note: If a rule was created for target type - type1
--            involving targets - target1, target2, target3 of 
--            type - type1, then this cursor will return two rows as:
--              type1, type1DisplayName, target1
--              type1, type1DisplayName, target2
--              type1, type1DisplayName, target3
--            Also note that if all targets were selected, then the target 
--            cursor will have a single row: ttype, ttypedisplayname, %
--            where "%" denotes that all targets of type - ttype were selected
--            for this rule. Again, this will be the case if the targets data 
--            for a rule is stored in this way to denote "%" to mean all targets
--            of type - ttype
--  rules_metric_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name for rule - rule_name
--      metric_name_dname: VARCHAR2 the metric name display name for
--                         rule - rule_name
--      metric_column: VARCHAR2 the metric column for rule - rule_name
--      metric_column_dname: VARCHAR2 the metric column display name for
--                           rule - rule_name
--      Note: If a rule was created for metric names - mname1, mname2, mname3 
--            and the associating metric columns - mcol1, mcol2, mcol3,
--            then this cursor will return rows as:
--              mname1, mname1dname, mcol1, mcol1dname
--              mname2, mname2dname, mcol2, mcol2dname
--              mname3, mname3dname, mcol3, mcol3dname
--  rules_email_notif_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      email_notifyee: VARCHAR2 the email notifyee profile name for
--                      rule - rule_name
--      email_address: VARCHAR2 the email address associated with this profile
--                      name and with this rule
--  rules_device_notif_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      device_name: VARCHAR2 the name of the device associated with this rule
--      device_description: VARCHAR2 the description of the device
--      type: NUMBER the type of the device
--                   2 for os command device
--                   3 for snmp device
--                   4 for plsql device
--  user_pref_email_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      email_address: VARCHAR2 the email address part of the user' preferences
--  notif_devices_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      device_name: VARCHAR2 the name of the device associated with this rule
--      device_description: VARCHAR2 the description of the device
--      type: NUMBER the type of the device
--                   2 for os command device
--                   3 for snmp device
--                   4 for plsql device
--    Note that this cursor will return a list of all notif devices(os command,
--    plsql and snmp devices). This is different from user_pref_email_list_out
--    which returns only the devices associated with the rule - rule_name_in
--
--  key_metric_columns_out: CURSOR_TYPE
--      The metric columns which are keys
--
-- ERROR codes:
--   USER_DOES_NOT_EXIST_ERR: user does not exist error
--   RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE get_notification_rule_details
  (rule_name_in IN VARCHAR2,
   user_name_in IN VARCHAR2,
   rules_detail_list_out OUT CURSOR_TYPE,
   rules_target_list_out OUT CURSOR_TYPE,
   rules_metric_list_out OUT CURSOR_TYPE,
   rules_metric_index_list_out OUT CURSOR_TYPE,
   rules_policy_list_out OUT CURSOR_TYPE,
   rules_job_list_out OUT CURSOR_TYPE,
   rules_email_notif_list_out OUT CURSOR_TYPE,
   rules_device_notif_list_out OUT CURSOR_TYPE,
   user_pref_email_list_out OUT CURSOR_TYPE,
   notif_devices_list_out OUT CURSOR_TYPE,
   key_metric_columns_out OUT CURSOR_TYPE);

--
-- Name: get_notification_rule_details
--
-- Purpose: 
--  Get the notification rule detail data for rule - rule_name_in of the 
--  current user
--
-- Note: This API can be used by any user
--
-- IN parameters:
--  rule_name_in: VARCHAR2
--      The rule for which the rule detail data needs will be returned
--
-- OUT parameters:
--  rules_detail_list_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--      rule_name: VARCHAR2 the rule name
--      rule_owner: VARCHAR2 the rule owner
--      rule_desc: VARCHAR2 the rule description
--      rule_public: NUMBER(1) if the rule is public or not
--                   G_TRUE if the rule is public, G_FALSE otherwise
--      want_clears: NUMBER(1) want clears?
--                   G_TRUE if want clears, G_FALSE otherwise
--      want_critical_alerts: NUMBER(1) want critical alerts?
--                   G_TRUE if want critical alerts, G_FALSE otherwise
--      want_warning_alerts: NUMBER(1) want warning alerts?
--                   G_TRUE if want warning alerts, G_FALSE otherwise
--      want_tgt_up_in: NUMBER(1) 
--          Want target up notifications? 
--          G_TRUE if want target up notifications, G_FALSE otherwise
--      want_tgt_down_in: NUMBER(1) 
--          Want target down notifications? 
--          G_TRUE if want target down notifications, G_FALSE otherwise
--      want_tgt_unreachable_start_in: NUMBER(1) 
--          Want target unreachable start notifications? 
--          G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--      want_tgt_unreachable_end_in: NUMBER(1) 
--          Want target unreachable end notifications? 
--          G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--      want_tgt_metric_err_start_in: NUMBER(1) 
--          Want target metric error start notifications? 
--          G_TRUE if want target metric error start notifications, G_FALSE otherwise
--      want_tgt_metric_err_end_in: NUMBER(1) 
--          Want target metric error end notifications? 
--          G_TRUE if want target metric error end notifications, G_FALSE otherwise
--      want_tgt_blkout_started_in: NUMBER(1) 
--          Want target blackout started notifications? 
--          G_TRUE if want target blackout started notifications, G_FALSE otherwise
--      want_tgt_blkout_ended_in: NUMBER(1) 
--          Want target blackout ended notifications? 
--          G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--  rules_target_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      target_type: VARCHAR2 the target type for which this rule was created
--      type_display_name: VARCHAR2 the display name of the target type - 
--                         target_type
--      target_name: VARCHAR2 the target name for rule - rule_name
--      Note: If a rule was created for target type - type1
--            involving targets - target1, target2, target3 of 
--            type - type1, then this cursor will return two rows as:
--              type1, type1DisplayName, target1
--              type1, type1DisplayName, target2
--              type1, type1DisplayName, target3
--            Also note that if all targets were selected, then the target 
--            cursor will have a single row: ttype, ttypedisplayname, %
--            where "%" denotes that all targets of type - ttype were selected
--            for this rule. Again, this will be the case if the targets data 
--            for a rule is stored in this way to denote "%" to mean all targets
--            of type - ttype
--  rules_metric_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name for rule - rule_name
--      metric_name_dname: VARCHAR2 the metric name display name for
--                         rule - rule_name
--      metric_column: VARCHAR2 the metric column for rule - rule_name
--      metric_column_dname: VARCHAR2 the metric column display name for
--                           rule - rule_name
--      Note: If a rule was created for metric names - mname1, mname2, mname3 
--            and the associating metric columns - mcol1, mcol2, mcol3,
--            then this cursor will return rows as:
--              mname1, mname1dname, mcol1, mcol1dname
--              mname2, mname2dname, mcol2, mcol2dname
--              mname3, mname3dname, mcol3, mcol3dname
--  rules_email_notif_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      email_notifyee: VARCHAR2 the email notifyee profile name for
--                      rule - rule_name
--      email_address: VARCHAR2 the email address associated with this profile
--                      name and with this rule
--  rules_device_notif_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      device_name: VARCHAR2 the name of the device associated with this rule
--      device_description: VARCHAR2 the description of the device
--      type: NUMBER the type of the device
--                   2 for os command device
--                   3 for snmp device
--                   4 for plsql device
--  user_pref_email_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      email_address: VARCHAR2 the email address part of the user' preferences
--  notif_devices_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--      device_name: VARCHAR2 the name of the device associated with this rule
--      device_description: VARCHAR2 the description of the device
--      type: NUMBER the type of the device
--                   2 for os command device
--                   3 for snmp device
--                   4 for plsql device
--    Note that this cursor will return a list of all notif devices(os command,
--    plsql and snmp devices). This is different from user_pref_email_list_out
--    which returns only the devices associated with the rule - rule_name_in
--
--  key_metric_columns_out: CURSOR_TYPE
--      The metric columns which are keys
--
-- ERROR codes:
--   RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE get_notification_rule_details
  (rule_name_in IN VARCHAR2,
   rules_detail_list_out OUT CURSOR_TYPE,
   rules_target_list_out OUT CURSOR_TYPE,
   rules_metric_list_out OUT CURSOR_TYPE,
   rules_metric_index_list_out OUT CURSOR_TYPE,
   rules_policy_list_out OUT CURSOR_TYPE,
   rules_job_list_out OUT CURSOR_TYPE,
   rules_email_notif_list_out OUT CURSOR_TYPE,
   rules_device_notif_list_out OUT CURSOR_TYPE,
   user_pref_email_list_out OUT CURSOR_TYPE,
   notif_devices_list_out OUT CURSOR_TYPE,
   key_metric_columns_out OUT CURSOR_TYPE);

--
-- Name: get_notification_rule_details
--
-- Purpose: 
--  Get the notification rule detail (NLS format) data for rule 
--
PROCEDURE get_notification_rule_details
  (rule_name_in IN VARCHAR2,
   user_name_in IN VARCHAR2,
   language_in IN VARCHAR2,
   country_in IN VARCHAR2,
   rules_detail_list_out OUT CURSOR_TYPE,
   rules_target_list_out OUT CURSOR_TYPE,
   rules_metric_list_out OUT CURSOR_TYPE,
   rules_metric_index_list_out OUT CURSOR_TYPE,
   rules_policy_list_out OUT CURSOR_TYPE,
   rules_job_list_out OUT CURSOR_TYPE,
   rules_email_notif_list_out OUT CURSOR_TYPE,
   rules_device_notif_list_out OUT CURSOR_TYPE,
   user_pref_email_list_out OUT CURSOR_TYPE,
   notif_devices_list_out OUT CURSOR_TYPE,
   key_metric_columns_out OUT CURSOR_TYPE);


--
-- Name: create_notification_rule
--
-- Purpose: 
--  Create a notification rule - rule_name_in for the current user 
--  with the passed in values
--
-- Note: This API can be used by any user
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_desc_in: VARCHAR2 
--       The rule dscription
--   rule_public_in: NUMBER(1) 
--       Is rule public? G_TRUE if rule is public, G_FALSE otherwise
--   rule_target_type_in: VARCHAR2 
--       The rule target type
--   rule_targets_in: SMP_EMD_STRING_ARRAY 
--       The rule targets
--   want_clears_in: NUMBER(1) 
--       Want clears? G_TRUE if want clears, G_FALSE otherwise
--   want_critical_alerts_in: NUMBER(1) 
--       Want critical alerts? G_TRUE if want critical alerts, G_FALSE otherwise
--   want_warning_alerts_in: NUMBER(1) 
--       Want warning alerts? G_TRUE if want warning alerts, G_FALSE otherwise
--   want_tgt_up_in: NUMBER(1) 
--       Want target up notifications? 
--       G_TRUE if want target up notifications, G_FALSE otherwise
--   want_tgt_down_in: NUMBER(1) 
--       Want target down notifications? 
--       G_TRUE if want target down notifications, G_FALSE otherwise
--   want_tgt_unreachable_start_in: NUMBER(1) 
--       Want target unreachable start notifications? 
--       G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--   want_tgt_unreachable_end_in: NUMBER(1) 
--       Want target unreachable end notifications? 
--       G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--   want_tgt_metric_err_start_in: NUMBER(1) 
--       Want target metric error start notifications? 
--       G_TRUE if want target metric error start notifications, G_FALSE otherwise
--   want_tgt_metric_err_end_in: NUMBER(1) 
--       Want target metric error end notifications? 
--       G_TRUE if want target metric error end notifications, G_FALSE otherwise
--   want_tgt_blkout_started_in: NUMBER(1) 
--       Want target blackout started notifications? 
--       G_TRUE if want target blackout started notifications, G_FALSE otherwise
--   want_tgt_blkout_ended_in: NUMBER(1) 
--       Want target blackout ended notifications? 
--       G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--   rule_metric_names_in: SMP_EMD_STRING_ARRAY 
--       Rule metric names array
--   rule_metric_columns_in: SMP_EMD_STRING_ARRAY 
--       Rule metric columns array
--   rule_metric_indexes_in: SMP_EMD_NVPAIR_ARRAY 
--       Rule metric indexes array
--       NAME is a metric in the format of target_type|metric_name|metric_column
--       VALUE is an index
--       There could be multiple VALUEs (indexes) for one NAME (metric)
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   email_address_in SMP_EMD_STRING_ARRAY  - NOT USED, for backward compatabile
--       The email addresses to which email notifications for this rule will be
--       sent to. 
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   rule_repeat_enabled_in: NUMBER(1) DEFAULT 0
--       Repeated notfications enabled/disabled(1/0) for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  DUPLICATE_RULE_NAME_ERR: duplicate rule name error
--
PROCEDURE create_notification_rule
  (rule_name_in IN VARCHAR2,
   rule_desc_in IN VARCHAR2,
   rule_public_in IN NUMBER,
   rule_target_type_in IN VARCHAR2,
   rule_targets_in IN SMP_EMD_STRING_ARRAY,
   want_clears_in IN NUMBER,
   want_critical_alerts_in IN NUMBER,
   want_warning_alerts_in IN NUMBER,
   want_tgt_up_in IN NUMBER,
   want_tgt_down_in IN NUMBER,
   want_tgt_unreachable_start_in IN NUMBER,
   want_tgt_unreachable_end_in IN NUMBER,
   want_tgt_metric_err_start_in IN NUMBER,
   want_tgt_metric_err_end_in IN NUMBER,
   want_tgt_blkout_started_in IN NUMBER,
   want_tgt_blkout_ended_in IN NUMBER,
   rule_metric_names_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_columns_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_indexes_in IN SMP_EMD_NVPAIR_ARRAY,
   send_email_in IN NUMBER,
   email_address_in IN SMP_EMD_STRING_ARRAY,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER,
   rule_repeat_enabled_in IN NUMBER DEFAULT 0);

--
-- Name: create_notification_rule
--
-- Purpose: 
--  Create a notification rule - rule_name_in for the current user 
--  with the passed in values
--
-- Note: This API can be used by any user
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_desc_in: VARCHAR2 
--       The rule dscription
--   rule_public_in: NUMBER(1) 
--       Is rule public? G_TRUE if rule is public, G_FALSE otherwise
--   rule_target_type_in: VARCHAR2 
--       The rule target type
--   rule_targets_in: SMP_EMD_STRING_ARRAY 
--       The rule targets
--   target_types_in: SMP_EMD_STRING_ARRAY 
--       The rule target types (could be composite types)
--   want_tgt_up_in: NUMBER(1) 
--       Want target up notifications? 
--       G_TRUE if want target up notifications, G_FALSE otherwise
--   want_tgt_down_in: NUMBER(1) 
--       Want target down notifications? 
--       G_TRUE if want target down notifications, G_FALSE otherwise
--   want_tgt_unreachable_start_in: NUMBER(1) 
--       Want target unreachable start notifications? 
--       G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--   want_tgt_unreachable_end_in: NUMBER(1) 
--       Want target unreachable end notifications? 
--       G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--   want_tgt_metric_err_start_in: NUMBER(1) 
--       Want target metric error start notifications? 
--       G_TRUE if want target metric error start notifications, G_FALSE otherwise
--   want_tgt_metric_err_end_in: NUMBER(1) 
--       Want target metric error end notifications? 
--       G_TRUE if want target metric error end notifications, G_FALSE otherwise
--   want_tgt_blkout_started_in: NUMBER(1) 
--       Want target blackout started notifications? 
--       G_TRUE if want target blackout started notifications, G_FALSE otherwise
--   want_tgt_blkout_ended_in: NUMBER(1) 
--       Want target blackout ended notifications? 
--       G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--   ignore_rca_in NUMBER(1)
--       Ignore Root Cause Analysis? G_TRUE if ignore, G_FALSE otherwise
--   rule_metric_names_in: SMP_EMD_STRING_ARRAY 
--       Rule metric names array
--   rule_metric_columns_in: SMP_EMD_STRING_ARRAY 
--       Rule metric columns array
--   rule_metric_indexes_in: SMP_EMD_NVPAIR_ARRAY 
--       Rule metric indexes array
--       NAME is a metric in the format of target_type|metric_name|metric_column
--       VALUE is an index
--       There could be multiple VALUEs (indexes) for one NAME (metric)
--   want_clears_in IN NUMBER,
--   want_critical_alerts_in IN NUMBER,
--   want_warning_alerts_in IN NUMBER,
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   rule_repeat_enabled_in: NUMBER(1) DEFAULT 0
--       Repeated notfications enabled/disabled(1/0) for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  DUPLICATE_RULE_NAME_ERR: duplicate rule name error
--
PROCEDURE create_notification_rule
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2,
   rule_desc_in IN VARCHAR2,
   rule_public_in IN NUMBER,
   rule_target_type_in IN VARCHAR2,
   rule_targets_in IN SMP_EMD_STRING_ARRAY,
   target_types_in IN SMP_EMD_STRING_ARRAY,
   want_tgt_up_in IN NUMBER,
   want_tgt_down_in IN NUMBER,
   want_tgt_unreachable_start_in IN NUMBER,
   want_tgt_unreachable_end_in IN NUMBER,
   want_tgt_metric_err_start_in IN NUMBER,
   want_tgt_metric_err_end_in IN NUMBER,
   want_tgt_blkout_started_in IN NUMBER,
   want_tgt_blkout_ended_in IN NUMBER,
   ignore_rca_in IN NUMBER,
   rule_metric_names_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_columns_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_indexes_in IN SMP_EMD_NVPAIR_ARRAY,
   metric_want_clears_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_critical_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_warning_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_problem_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_problem_in IN SMP_EMD_INTEGER_ARRAY,
   policy_names_in IN SMP_EMD_STRING_ARRAY,
   want_policy_violation_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_clear_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   job_names_in IN SMP_EMD_STRING_ARRAY,
   job_owner_in IN SMP_EMD_STRING_ARRAY,
   job_types_in IN SMP_EMD_STRING_ARRAY,
   want_job_scheduled_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_started_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_suspended_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_succeeded_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   send_email_in IN NUMBER,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER,
   rule_repeat_enabled_in IN NUMBER DEFAULT 0);

--
-- Name: update_notification_rule
--
-- Purpose: 
--  Update the notification rule data for rule - rule_name_in of the currently
--  logged in user
--
-- Note: This API can be used by any user
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_desc_in: VARCHAR2 
--       The rule dscription
--   rule_public_in: NUMBER(1) 
--       Is rule public? G_TRUE if rule is public, G_FALSE otherwise
--   rule_target_type_in: VARCHAR2 
--       The rule target type
--   rule_targets_in: SMP_EMD_STRING_ARRAY 
--       The rule targets
--   target_types_in: SMP_EMD_STRING_ARRAY 
--       The rule target types (could be composite types)
--   want_clears_in: NUMBER(1) 
--       Want clears? G_TRUE if want clears, G_FALSE otherwise
--   want_critical_alerts_in: NUMBER(1) 
--       Want critical alerts? G_TRUE if want critical alerts, G_FALSE otherwise
--   want_warning_alerts_in: NUMBER(1) 
--       Want warning alerts? G_TRUE if want warning alerts, G_FALSE otherwise
--   want_tgt_up_in: NUMBER(1) 
--       Want target up notifications? 
--       G_TRUE if want target up notifications, G_FALSE otherwise
--   want_tgt_down_in: NUMBER(1) 
--       Want target down notifications? 
--       G_TRUE if want target down notifications, G_FALSE otherwise
--   want_tgt_unreachable_start_in: NUMBER(1) 
--       Want target unreachable start notifications? 
--       G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--   want_tgt_unreachable_end_in: NUMBER(1) 
--       Want target unreachable end notifications? 
--       G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--   want_tgt_metric_err_start_in: NUMBER(1) 
--       Want target metric error start notifications? 
--       G_TRUE if want target metric error start notifications, G_FALSE otherwise
--   want_tgt_metric_err_end_in: NUMBER(1) 
--       Want target metric error end notifications? 
--       G_TRUE if want target metric error end notifications, G_FALSE otherwise
--   want_tgt_blkout_started_in: NUMBER(1) 
--       Want target blackout started notifications? 
--       G_TRUE if want target blackout started notifications, G_FALSE otherwise
--   want_tgt_blkout_ended_in: NUMBER(1) 
--       Want target blackout ended notifications? 
--       G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--   ignore_rca_in NUMBER(1)
--       Ignore Root Cause Analysis? G_TRUE if ignore, G_FALSE otherwise
--   rule_metric_names_in: SMP_EMD_STRING_ARRAY 
--       Rule metric names array
--   rule_metric_columns_in: SMP_EMD_STRING_ARRAY 
--       Rule metric columns array
--   rule_metric_indexes_in: SMP_EMD_NVPAIR_ARRAY 
--       Rule metric indexes array
--       NAME is a metric in the format of target_type|metric_name|metric_column
--       VALUE is an index
--       There could be multiple VALUEs (indexes) for one NAME (metric)
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   rule_repeat_enabled_in: NUMBER(1) DEFAULT 0
--       Repeated notfications enabled/disabled(1/0) for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE update_notification_rule
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2,
   rule_desc_in IN VARCHAR2,
   rule_public_in IN NUMBER,
   rule_target_type_in IN VARCHAR2,
   rule_targets_in IN SMP_EMD_STRING_ARRAY,
   target_types_in IN SMP_EMD_STRING_ARRAY,
   want_tgt_up_in IN NUMBER,
   want_tgt_down_in IN NUMBER,
   want_tgt_unreachable_start_in IN NUMBER,
   want_tgt_unreachable_end_in IN NUMBER,
   want_tgt_metric_err_start_in IN NUMBER,
   want_tgt_metric_err_end_in IN NUMBER,
   want_tgt_blkout_started_in IN NUMBER,
   want_tgt_blkout_ended_in IN NUMBER,
   ignore_rca_in IN NUMBER,
   rule_metric_names_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_columns_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_indexes_in IN SMP_EMD_NVPAIR_ARRAY,
   metric_want_clears_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_critical_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_warning_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_problem_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_problem_in IN SMP_EMD_INTEGER_ARRAY,
   policy_names_in IN SMP_EMD_STRING_ARRAY,
   want_policy_violation_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_clear_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   job_names_in IN SMP_EMD_STRING_ARRAY,
   job_owner_in IN SMP_EMD_STRING_ARRAY,
   job_types_in IN SMP_EMD_STRING_ARRAY,
   want_job_scheduled_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_started_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_suspended_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_succeeded_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   send_email_in IN NUMBER,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER,
   rule_repeat_enabled_in IN NUMBER DEFAULT 0);

--
-- Name: update_notification_rule_priv
--
-- Purpose: 
--  Update the notification rule data for rule - rule_name_in
--
-- NOTE: This API should be called only by a super user.
--      
--  If rule_owner_in is specified and is valid, then the data for the 
--  notification rule - rule_name_in of owner - rule_owner_in will be updated
--  ELSE the data for the notification rule - rule_name_in of the currently 
--  logged in privileged user will be updated
--
-- NOTE: This API should be called only by a super user.
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_desc_in: VARCHAR2 
--       The rule dscription
--   rule_public_in: NUMBER(1) 
--       Is rule public? G_TRUE if rule is public, G_FALSE otherwise
--   rule_target_type_in: VARCHAR2 
--       The rule target type
--   rule_targets_in: SMP_EMD_STRING_ARRAY 
--       The rule targets
--   target_types_in: SMP_EMD_STRING_ARRAY 
--       The rule target types (could be composite types)
--   want_clears_in: NUMBER(1) 
--       Want clears? G_TRUE if want clears, G_FALSE otherwise
--   want_critical_alerts_in: NUMBER(1) 
--       Want critical alerts? G_TRUE if want critical alerts, G_FALSE otherwise
--   want_warning_alerts_in: NUMBER(1) 
--       Want warning alerts? G_TRUE if want warning alerts, G_FALSE otherwise
--   want_tgt_up_in: NUMBER(1) 
--       Want target up notifications? 
--       G_TRUE if want target up notifications, G_FALSE otherwise
--   want_tgt_down_in: NUMBER(1) 
--       Want target down notifications? 
--       G_TRUE if want target down notifications, G_FALSE otherwise
--   want_tgt_unreachable_start_in: NUMBER(1) 
--       Want target unreachable start notifications? 
--       G_TRUE if want target unreachable start notifications, G_FALSE otherwise
--   want_tgt_unreachable_end_in: NUMBER(1) 
--       Want target unreachable end notifications? 
--       G_TRUE if want target unreachable end notifications, G_FALSE otherwise
--   want_tgt_metric_err_start_in: NUMBER(1) 
--       Want target metric error start notifications? 
--       G_TRUE if want target metric error start notifications, G_FALSE otherwise
--   want_tgt_metric_err_end_in: NUMBER(1) 
--       Want target metric error end notifications? 
--       G_TRUE if want target metric error end notifications, G_FALSE otherwise
--   want_tgt_blkout_started_in: NUMBER(1) 
--       Want target blackout started notifications? 
--       G_TRUE if want target blackout started notifications, G_FALSE otherwise
--   want_tgt_blkout_ended_in: NUMBER(1) 
--       Want target blackout ended notifications? 
--       G_TRUE if want target blackout ended notifications, G_FALSE otherwise
--   rule_metric_names_in: SMP_EMD_STRING_ARRAY 
--       Rule metric names array
--   rule_metric_columns_in: SMP_EMD_STRING_ARRAY 
--       Rule metric columns array
--   rule_metric_indexes_in: SMP_EMD_NVPAIR_ARRAY 
--       Rule metric indexes array
--       NAME is a metric in the format of target_type|metric_name|metric_column
--       VALUE is an index
--       There could be multiple VALUEs (indexes) for one NAME (metric)
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   email_address_in SMP_EMD_STRING_ARRAY
--       The email addresses to which email notifications for this rule will be
--       sent to. 
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   rule_repeat_enabled_in: NUMBER(1) DEFAULT 0
--       Repeated notfications enabled/disabled(1/0) for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE update_notification_rule_priv
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2,
   rule_desc_in IN VARCHAR2,
   rule_public_in IN NUMBER,
   rule_target_type_in IN VARCHAR2,
   rule_targets_in IN SMP_EMD_STRING_ARRAY,
   target_types_in IN SMP_EMD_STRING_ARRAY,
   want_tgt_up_in IN NUMBER,
   want_tgt_down_in IN NUMBER,
   want_tgt_unreachable_start_in IN NUMBER,
   want_tgt_unreachable_end_in IN NUMBER,
   want_tgt_metric_err_start_in IN NUMBER,
   want_tgt_metric_err_end_in IN NUMBER,
   want_tgt_blkout_started_in IN NUMBER,
   want_tgt_blkout_ended_in IN NUMBER,
   ignore_rca_in IN NUMBER,
   rule_metric_names_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_columns_in IN SMP_EMD_STRING_ARRAY,
   rule_metric_indexes_in IN SMP_EMD_NVPAIR_ARRAY,
   metric_want_clears_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_critical_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   metric_want_warning_alerts_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_warning_problem_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_critical_problem_in IN SMP_EMD_INTEGER_ARRAY,
   policy_names_in IN SMP_EMD_STRING_ARRAY,
   want_policy_violation_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_clear_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_succeed_in IN SMP_EMD_INTEGER_ARRAY,
   want_policy_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   job_names_in IN SMP_EMD_STRING_ARRAY,
   job_owner_in IN SMP_EMD_STRING_ARRAY,
   job_types_in IN SMP_EMD_STRING_ARRAY,
   want_job_scheduled_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_started_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_suspended_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_succeeded_in IN SMP_EMD_INTEGER_ARRAY,
   want_job_problem_in IN SMP_EMD_INTEGER_ARRAY,
   send_email_in IN NUMBER,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER,
   rule_repeat_enabled_in IN NUMBER DEFAULT 0);

--
-- Name: delete_notification_rule
--
-- Purpose: 
--  Delete the notification rule - rule_name_in of the currently logged in user
--
-- Note: This API can be used by any user
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--
-- OUT parameters:
--   None
--
-- ERROR codes:
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE delete_notification_rule
  (rule_name_in IN VARCHAR2);

-- Name: delete_notification_rule_priv
--
-- Purpose: 
--  Delete the notification rule - rule_name_in
--
--  If rule_owner_in is specified and is valid, then the notification 
--  rule - rule_name_in of owner - rule_owner_in will be deleted
--  ELSE the notification rule - rule_name_in of the currently logged in 
--  privileged user will be delete
--
-- NOTE: This API should be called only by a super user.
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_owner_in: VARCHAR2 
--       The rule owner
--
-- OUT parameters:
--   None
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE delete_notification_rule_priv
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2);

--
-- Name: update_rule_overview_data
--
-- Purpose: 
--  Update the notification rule overview data for a set of rules
--  The overview data for the rules include the make public
--  rule_name_in(1), rule_owner_in(1), rule_public_in(1) are all associated 
--  to each other and are part of the same rule
--
--  NOTE: This is a UI specific API
--
-- IN parameters:
--   rule_name_in: SMP_EMD_STRING_ARRAY 
--       An array of the rule names
--   rule_owner_in: SMP_EMD_STRING_ARRAY 
--       An array of the rule owners
--   rule_public_in: SMP_EMD_INTEGER_ARRAY 
--       An array of the rule public info
--       For example, rule_public_in(1) will be associated with rule_name_in(1)
--       and so on ...
--       If this is G_TRUE, the corresponsing rule will be made public
--       If this is G_FALSE, the corresponding rule will be made non-public
--       If this is any other number, the corresponding rule will be made 
--       non-public
--   send_email_in: SMP_EMD_INTEGER_ARRAY 
--       An array of the rule "send email" info
--       If this is G_TRUE, email will be sent to the corresponsing rule
--       If this is G_FALSE, email will not be sent to the corresponding rule
--       If this is any other number, it will be treated as G_FALSE
--
-- OUT parameters:
--   None
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--  INVALID_RULE_DATA_ERR: invalid rule data error. This will happen if the 
--                         length of all the arrays passed to this are not 
--                         the same
--
PROCEDURE update_rule_overview_data
  (rule_name_in IN SMP_EMD_STRING_ARRAY,
   rule_owner_in IN SMP_EMD_STRING_ARRAY,
   rule_public_in IN SMP_EMD_INTEGER_ARRAY,
   send_email_in IN SMP_EMD_INTEGER_ARRAY);

--
-- Name: get_user_pref_email
--
-- Purpose: 
--  Get the configured email addresses(if any) of the currently logged in user
--
-- IN parameters:
--  None
--
-- OUT parameters: 
--   user_email_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     email_address: VARCHAR2 The email address of the user
--
-- ERROR codes:
--  None
--
PROCEDURE get_user_pref_email
  (user_email_out OUT CURSOR_TYPE);

--
-- Name: get_user_email
--
-- Purpose: 
--  Get the email addresses(if any) of the given user
--
-- IN parameters:
--  user_name_in VARCHAR2
--
-- OUT parameters: 
--   user_email_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     email_address: VARCHAR2 The email address of the user
--
-- ERROR codes:
--  None
--
PROCEDURE get_user_email
  (user_name_in VARCHAR2,
   user_email_out OUT CURSOR_TYPE);

--
-- Name: get_all_key_values
--
-- Purpose: 
--  Get key values for a metric in both current and history metric tables
--
-- IN parameters:
--  target_type_in
--  target_names_in
--  metric_name_in
--  metric_column_in
--  search_names_in 
--  search_target_name_in
--
-- OUT parameters: 
--   key_value_out: CURSOR_TYPE (key values in current metrics table)
--    A cursor which returns rows containing:
--     key_value: 
--     key_value_partN: composite keys
--   key_value_1day_out: CURSOR_TYPE (key values in 1day metrics table)
--    A cursor which returns rows containing:
--     key_value: 
--     key_value_partN: composite keys
--  key_metric_columns_out: CURSOR_TYPE
--      The metric columns which are keys
--
-- ERROR codes:
--  None
--
PROCEDURE get_all_key_values
  (target_type_in IN VARCHAR2,
   target_names_in IN SMP_EMD_STRING_ARRAY,
   metric_name_in IN VARCHAR2,
   metric_column_in IN VARCHAR2,
   search_names_in SMP_EMD_STRING_ARRAY,
   search_target_name_in IN VARCHAR2,
   key_value_current_out OUT CURSOR_TYPE,
   key_value_1day_out OUT CURSOR_TYPE,
   key_metric_columns_out OUT CURSOR_TYPE);

-- Name: get_rule_target_types
--
-- Purpose: 
--  Get target types which could have availability, metrics, policies, or jobs to create a notification rule
--
-- IN parameters: 
--  None
--
-- OUT parameters: 
--   avail_target_type_out: CURSOR_TYPE
--    A cursor which returns target types with availability 
--     target_type: target type 
--   metric_target_type_out: CURSOR_TYPE
--    A cursor which returns target types with thresholdable metrics
--     target_type: target type 
--   polcy_target_type_out: CURSOR_TYPE
--    A cursor which returns target types with policies
--     target_type: target type 
--   job_target_type_out: CURSOR_TYPE
--    A cursor which returns target types with jobs
--     target_type: target type 
--
-- ERROR codes:
--  None
--
PROCEDURE get_rule_target_types
  (avail_target_type_out OUT CURSOR_TYPE,
   metric_target_type_out OUT CURSOR_TYPE,
   policy_target_type_out OUT CURSOR_TYPE,
   job_target_type_out OUT CURSOR_TYPE );

--
-- Name: get_rule_devices_data
--
-- Purpose: 
--  Get the devices data for a rule creation. Note this is a UI specific plsql
--  
-- IN parameters:
--  None
--
-- OUT parameters: 
--   user_email_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     email_address: VARCHAR2 The email address of the user
--   rule_devices_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     device_name: VARCHAR2 The name of the device
--     device_description: VARCHAR2 The description of the device
--     type: NUMBER The type of the device 
--           2 for os command device
--           3 for snmp device
--           4 for plsql device
--
-- ERROR codes:
--  None
--
PROCEDURE get_rule_devices_data
  (user_email_out OUT CURSOR_TYPE,
   rule_devices_out OUT CURSOR_TYPE);

--
-- Name: get_rule_config_devices_data
--
-- Purpose: 
--  Get the rule devices data for rule - rule_name_in of the current user.
--  
-- IN parameters:
--  rule_name_in: VARCHAR2 the name of the rule
--
-- Note: This API can be used by any user
--
-- OUT parameters: 
--   rule_email_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     email_address: VARCHAR2 The email address of the user associated with 
--                    this rule
--   user_pref_email_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     email_address: VARCHAR2 The email address of the user's preferences
--   rule_devices_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     device_name: VARCHAR2 The name of the device
--     device_description: VARCHAR2 The description of the device
--     type: NUMBER The type of the device 
--           2 for os command device
--           3 for snmp device
--           4 for plsql device
--     This is the list of devices(os command, snmp, plsql) associated with
--     the rule - rule_name_in
--   all_devices_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     device_name: VARCHAR2 The name of the device
--     device_description: VARCHAR2 The description of the device
--     type: NUMBER The type of the device 
--           2 for os command device
--           3 for snmp device
--           4 for plsql device
--     This is the list of all devices(os command, snmp, plsql) that the user
--     can associate with the rule
--
-- ERROR codes:
--   RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE get_rule_config_devices_data
  (rule_name_in IN VARCHAR2,
   rule_email_out OUT CURSOR_TYPE,
   user_pref_email_out OUT CURSOR_TYPE,
   rule_devices_out OUT CURSOR_TYPE,
   all_devices_out OUT CURSOR_TYPE);

--
-- Name: get_rule_config_devices_data
--
-- Purpose: 
--  Get the rule devices data for rule - rule_name_in of rule_owner_in
--  
--  If the rule_owner_in is specified and is valid, then the rule detail data 
--  for rule - rule_name_in of owner - rule_owner_in will be returned ELSE 
--  the rule detail data for rule - rule_name_in of the current  
--  user will be returned
--
--  Note that rule_email_out and user_pref_email_out cursors will be
--  determined in all case. However, rule_devices_out and all_devices_out
--  cursors will be determined only in the following conditions:
--         (current user = rule_owner_in) OR
--         (current user != rule_owner_in AND current user is privileged)
--
-- Note: This API can be used by any user
--
-- IN parameters:
--  rule_name_in: VARCHAR2 the name of the rule
--  rule_owner_in: VARCHAR2 the owner of the rule
--
-- OUT parameters: 
--   rule_email_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     email_address: VARCHAR2 The email address of the user associated with 
--                    this rule
--   user_pref_email_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     email_address: VARCHAR2 The email address of the user's preferences
--   rule_devices_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     device_name: VARCHAR2 The name of the device
--     device_description: VARCHAR2 The description of the device
--     type: NUMBER The type of the device 
--           2 for os command device
--           3 for snmp device
--           4 for plsql device
--     This is the list of devices(os command, snmp, plsql) associated with
--     the rule - rule_name_in
--   all_devices_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     device_name: VARCHAR2 The name of the device
--     device_description: VARCHAR2 The description of the device
--     type: NUMBER The type of the device 
--           2 for os command device
--           3 for snmp device
--           4 for plsql device
--     This is the list of all devices(os command, snmp, plsql) that the user
--     can associate with the rule
--
-- ERROR codes:
--   USER_DOES_NOT_EXIST_ERR: user does not exist error
--   RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE get_rule_config_devices_data
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2,
   rule_email_out OUT CURSOR_TYPE,
   user_pref_email_out OUT CURSOR_TYPE,
   rule_devices_out OUT CURSOR_TYPE,
   all_devices_out OUT CURSOR_TYPE);

--
-- Name: update_rule_devices_data
--
-- Purpose: 
--  Update the notification rule devices data for rule - rule_name_in of the 
--  currently logged in user
--
-- Note: This API can be used by any user
--
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE update_rule_devices_data
  (rule_name_in IN VARCHAR2,
   send_email_in IN NUMBER,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER);

--
-- Name: update_rule_devices_data
--
-- Purpose: 
--  Update the notification rule devices data for rule - rule_name_in of
--  user - rule_owner_in
--
--  If rule_owner_in is specified and is valid, then the data for the 
--  notification rule - rule_name_in of owner - rule_owner_in will be updated
--  ELSE the data for the notification rule - rule_name_in of the currently 
--  logged in user will be updated
--
--  Note that device_names_in and device_types_in cursors will be
--  used only in the following conditions:
--         (current user = rule_owner_in) OR
--         (current user != rule_owner_in AND current user is privileged)
--
-- Note: This API can be used by any user
--      
-- IN parameters:
--   rule_name_in: VARCHAR2 
--       The rule name
--   rule_owner_in: VARCHAR2 
--       The rule owner
--   send_email_in: NUMBER(1) 
--       Send email for this rule? G_TRUE if send email, G_FALSE otherwise
--   device_names_in: SMP_EMD_STRING_ARRAY 
--       The names of the devices which will be notified for this rule
--   device_types_in: SMP_EMD_INTEGER_ARRAY 
--       The types of the devices which will be notified for this rule.
--   NOTES: device_name_in and device_types_in are co-related i.e 
--          device_types_in(i) is associated with device_names_in(i) and so on
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_INTEGER_ARRAY
--      A list of all devices which the user wanted associated with the rule
--      and which are no longer available - a super user might have deleted
--      them before the rule update went through
--   email_gateway_setup_out: NUMBER(1)
--      G_TRUE if the email gateway is setup, G_FALSE otherwise
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  RULE_DOES_NOT_EXIST_ERR: rule not found error
--
PROCEDURE update_rule_devices_data
  (rule_name_in IN VARCHAR2,
   rule_owner_in IN VARCHAR2,
   send_email_in IN NUMBER,
   device_names_in IN SMP_EMD_STRING_ARRAY,
   device_types_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   email_gateway_setup_out OUT NUMBER);

--
-- Name: update_mail_gateway_data
--
-- PURPOSE: Update the mail gateway data. The user can enter more than one
--          mail gateway server names.
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  mail_gateway_server_array: SMP_EMD_STRING_ARRAY An array of gateway server 
--                             names
--  mail_username: VARCHAR2 The username to be used for all gateways (default null)
--  mail_password_in: VARCHAR2 The password to be used for all gateways (default null)
--  mail_address_in: VARCHAR2 The email address to be used for all gateways
--  mail_name_in: VARCHAR2 The email name to be used for all gateways
--      
-- OUT parameters: 
--   no OUT parameters
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  
PROCEDURE update_mail_gateway_data
  (mail_gateway_server_array IN SMP_EMD_STRING_ARRAY,
   mail_username_in IN VARCHAR2 DEFAULT NULL,
   mail_password_in IN VARCHAR2 DEFAULT NULL,
   mail_address_in IN VARCHAR2,
   mail_name_in IN VARCHAR2);

--
-- Name: get_notif_devices_data
--
-- Purpose: 
--  Get the notification devices data.
--
-- This procedure returns the list of email gateways configured and also the
-- the list of notification devices(snmp device, os command, plsql device)
-- that are configured system wide
--
-- NOTE:
--  This API should be called only by a super user.
--
-- IN parameters:
--  None
--
-- OUT parameters:
--  mail_gateway_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     mail_gateway_host_name: VARCHAR2 The name of the users mail host
--     username: VARCHAR2 The users name
--     password: VARCHAR2 The users password
--     email_address: VARCHAR2 The users email address
--     email_name: VARCHAR2 The users email name
--     precedence: NUMBER The order in which the gateway will be used
--  notif_devices_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     device_name: VARCHAR2 The name of the device
--     profile_name: VARCHAR2 The owner of the device
--     type: NUMBER The type of the device
--              2 for OS command device
--              3 for snmp device
--              4 for plsql device
--
-- ERROR codes:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE get_notif_devices_data
  (mail_gateway_list_out OUT CURSOR_TYPE,
   notif_devices_list_out OUT CURSOR_TYPE);

--
-- Name: edit_program_device
--
-- PURPOSE: Create/Edit the program device. 
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the program device
--  device_description: VARCHAR2 The description of the program device
--  os_command_name: VARCHAR2 The actual os command 
--  mode_in: VARCHAR2 0 for create mode, 1 for edit mode
--      
-- OUT parameters: 
--   None
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DUPLICATE_DEVICE_NAME_ERR: duplicate device name error(create mode only)
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error(edit mode only)
--  
PROCEDURE edit_program_device
  (device_name_in IN VARCHAR2,
   device_desc_in IN VARCHAR2,
   os_command_name_in IN VARCHAR2,
   os_command_args_in IN EMDSYSTEM_ARGS,
   mode_in IN NUMBER);

--
-- Name: get_program_device_data
--
-- PURPOSE: get the program device detail data. a list of all the rules that
--          use this program device is also returned
--
-- NOTE: This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the program device
--      
-- OUT parameters: 
--   device_data_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--     device_name: VARCHAR2 The name of the program device
--     device_description: VARCHAR2 The description of the program device
--     type: NUMBER The type associated with the program device
--     profile_name: VARCHAR2 The user who created this device
--     program: VARCHAR2 The actual os command associated with this program device
--   device_rules_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     rule_name: VARCHAR2 The name of the rule which is associated with this 
--                program device
--     rule_owner: VARCHAR2 The owner of the rule
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE get_program_device_data
  (device_name_in IN VARCHAR2,
   device_data_out OUT CURSOR_TYPE,
   device_rules_list_out OUT CURSOR_TYPE,
   device_parameters_out OUT CURSOR_TYPE);

--
-- Name: delete_program_device_data
--
-- PURPOSE: delete the program device detail data. 
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the program device to be deleted
--      
-- OUT parameters: 
--   None
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE delete_program_device_data
  (device_name_in IN VARCHAR2);

--
-- Name: edit_plsql_device
--
-- PURPOSE: Create/Edit the plsql device. 
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the program device
--  device_description: VARCHAR2 The description of the program device
--  plsql_proc_name: VARCHAR2 The actual plsql procedure name
--  mode_in: VARCHAR2 0 for create mode, 1 for edit mode
--      
-- OUT parameters: 
--   no OUT parameters
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DUPLICATE_DEVICE_NAME_ERR: duplicate device name error(create mode only)
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error(edit mode only)
--  
PROCEDURE edit_plsql_device
  (device_name_in IN VARCHAR2,
   device_desc_in IN VARCHAR2,
   plsql_proc_name IN VARCHAR2,
   mode_in IN NUMBER);

--
-- Name: get_plsql_device_data
--
-- PURPOSE: get the plsql device detail data. a list of all the rules that
--          use this plsql device is also returned
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the plsql device
--      
-- OUT parameters: 
--   device_data_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--     device_name: VARCHAR2 The name of the plsql device
--     device_description: VARCHAR2 The description of the plsql device
--     type: NUMBER The type associated with the plsql device
--     profile_name: VARCHAR2 The user who created this device
--     program: VARCHAR2 The actual plsql procedure associated with this plsql 
--              device
--   device_rules_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     rule_name: VARCHAR2 The name of the rule which is associated with this 
--                plsql device
--     rule_owner: VARCHAR2 The owner of the rule
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE get_plsql_device_data
  (device_name_in IN VARCHAR2,
   device_data_out OUT CURSOR_TYPE,
   device_rules_list_out OUT CURSOR_TYPE);

--
-- Name: delete_plsql_device_data
--
-- PURPOSE: delete the plsql device detail data. 
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the plsql device to be deleted
--      
-- OUT parameters: 
--   None
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE delete_plsql_device_data
  (device_name_in IN VARCHAR2);

--
-- Name: edit_snmp_device
--
-- PURPOSE: Create/Edit the snmp device. 
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the snmp device
--  device_description: VARCHAR2 The description of the snmp device
--  snmp_host_name_in: VARCHAR2 The snmp trap agent host name
--  snmp_port_in: NUMBER The snmp host port
--  snmp_community_in: VARCHAR2 The snmp community
--  mode_in: VARCHAR2 0 for create mode, 1 for edit mode
--      
-- OUT parameters: 
--   no OUT parameters
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DUPLICATE_DEVICE_NAME_ERR: duplicate device name error(create mode only)
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error(edit mode only)
--  
PROCEDURE edit_snmp_device
  (device_name_in IN VARCHAR2,
   device_desc_in IN VARCHAR2,
   snmp_host_name_in IN VARCHAR2,
   snmp_port_in IN NUMBER,
   snmp_community_in IN VARCHAR2,
   mode_in IN NUMBER);

--
-- Name: get_snmp_device_data
--
-- PURPOSE: get the snmp device detail data. a list of all the rules that
--          use this plsql device is also returned
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the snmp device
--      
-- OUT parameters: 
--   device_data_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--     device_name: VARCHAR2 The name of the snmp device
--     device_description: VARCHAR2 The description of the snmp device
--     type: NUMBER The type associated with the snmp device
--     profile_name: VARCHAR2 The user who created this device
--     snmp_host: VARCHAR2 The snmp trap agent host name
--     snmp_port: VARCHAR2 The snmp host port
--     snmp_community: VARCHAR2 The snmp community
--   device_rules_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     rule_name: VARCHAR2 The name of the rule which is associated with this 
--                snmp device
--     rule_owner: VARCHAR2 The owner of the rule
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE get_snmp_device_data
  (device_name_in IN VARCHAR2,
   device_data_out OUT CURSOR_TYPE,
   device_rules_list_out OUT CURSOR_TYPE);

--
-- Name: delete_snmp_device_data
--
-- PURPOSE: delete the snmp device detail data. 
--
-- NOTE: This API should be called only by a super user.
--      
-- IN parameters:
--  device_name: VARCHAR2 The name of the snmp device to be deleted
--      
-- OUT parameters: 
--   None
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE delete_snmp_device_data
  (device_name_in IN VARCHAR2);

--
-- Name: get_java_device_data
--
-- PURPOSE: get the java device detail data. a list of all the rules that
--          use this java device is also returned
--
-- NOTE:
--  This API should be called only by a super user.
--      
-- IN parameters:  
--  device_name: VARCHAR2 The name of the java device
--      
-- OUT parameters: 
--   device_data_out: CURSOR_TYPE
--    A cursor which returns a single row containing:
--     device_name: VARCHAR2 The name of the java device
--     device_description: VARCHAR2 The description of the java device
--     type: NUMBER The type associated with the java device
--     profile_name: VARCHAR2 The user who created this device
--     program: VARCHAR2 The java class path and name
--   device_parameters_out: CURSOR_TYPE
--    A cursor which returns 0/1/multiple rows containing:
--     parameter: VARCHAR2 The parameter of the java device
--     position: NUMBER The position of the parameter
--   device_rules_list_out: CURSOR_TYPE
--    A cursor which returns rows containing:
--     rule_name: VARCHAR2 The name of the rule which is associated with this 
--                java device
--     rule_owner: VARCHAR2 The owner of the rule
--      
-- ERROR CODES:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DEVICE_DOES_NOT_EXIST_ERR: device does not exist error
--  
PROCEDURE get_java_device_data
  (device_name_in IN VARCHAR2,
   device_data_out OUT CURSOR_TYPE,
   device_parameter_out OUT CURSOR_TYPE,
   device_rules_list_out OUT CURSOR_TYPE);

--
-- Name: get_assign_dev_to_rules_data
--
-- PURPOSE: get the data for whether a device is assigned to a rule. this data
--          is returned for all devices for all the rules of the current user.
--
-- NOTE: This API can be called by any user
--      
-- IN parameters:
--   mode_in: NUMBER
--       if mode_in is RULE_VIEW_MODE, data is returned sorted by rule 
--       owner and rule name first
--       if mode_in is DEVICE_VIEW_MODE, data is returned sorted by device
--       type and device name first
--      
-- OUT parameters: 
--   devices_data_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     rule_name: VARCHAR2 The name of the rule
--     owner: VARCHAR2 The owner of the rule
--     device_name: VARCHAR2 The name of the device that is assigned to this rule
--     type: NUMBER The type of the device that is assigned to this rule
--     device_set: NUMBER Is this device set/assigned to this rule?
--                 0 if not set, 1 if set
--      
-- ERROR CODES:
--  None
--
PROCEDURE get_assign_dev_to_rules_data
  (mode_in IN NUMBER,
   devices_data_out OUT CURSOR_TYPE);

-- Name: get_assign_dev_to_rules_data
--
-- PURPOSE: get the data for whether a device is assigned to a rule. 
--
--  If rule_owner_in is specified and is valid, then the data for all rules 
--  of owner - rule_owner_in will be obtained.
--  ELSE the data for all rules for all users will be returned.
--
-- NOTE: This API should be called only by a super user.
--      
-- IN parameters:
--   rule_owner_in: VARCHAR2 
--       The user whose rules will be considered for the data to be returned 
--   mode_in: NUMBER
--       if mode_in is RULE_VIEW_MODE, data is returned sorted by rule 
--       owner and rule name first
--       if mode_in is DEVICE_VIEW_MODE, data is returned sorted by device
--       type and device name first
--      
-- OUT parameters: 
--   devices_data_out: CURSOR_TYPE
--    A cursor which returns a rows containing:
--     rule_name: VARCHAR2 The name of the rule
--     owner: VARCHAR2 The owner of the rule
--     device_name: VARCHAR2 The name of the device that is assigned to this rule
--     type: NUMBER The type of the device that is assigned to this rule
--     device_set: NUMBER Is this device set/assigned to this rule?
--                 0 if not set, 1 if set
--      
-- ERROR CODES:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE get_assign_dev_to_rules_data
  (rule_owner_in IN VARCHAR2,
   mode_in IN NUMBER,
   devices_data_out OUT CURSOR_TYPE);

--
-- Name: update_assign_data
--
-- Purpose: 
--  Update the notification rule devices data for the passed in array data
--
--  NOTE: rule_name_in(i), rule_owner_in(i), device_name_in(i), device_type_in(i) and
--        notify_in(i) indicate that if notify_in(i) is 1, then rule_name_in(i)
--        of rule_owner_in(i) will be notified using device_name_in(i) of type
--        device_type_in(i)
--
-- Note: This API can be used by any user
--      
-- IN parameters:
--   rule_name_in: SMP_EMD_STRING_ARRAY 
--       An array of the rule names
--   rule_owner_in: SMP_EMD_STRING_ARRAY 
--       An array of the rule owners
--   device_name_in: SMP_EMD_STRING_ARRAY 
--       An array of the device names
--   device_type_in: SMP_EMD_INTEGER_ARRAY 
--       An array of the device types
--   notify_in: SMP_EMD_INTEGER_ARRAY 
--       An array of the notify values
--
-- OUT parameters:
--   device_not_avail_list_out: SMP_EMD_STRING_ARRAY
--      A list of all devices which the user wants associated with the 
--      corresponding device and which are no longer available - a super user 
--      might have deleted them before the rule update went through
--   rule_not_avail_list_out: SMP_EMD_STRING_ARRAY
--      A list of all rules which no longer exist
--   user_not_avail_list_out: SMP_EMD_STRING_ARRAY
--      A list of all users that no longer exist
--
-- ERROR codes:
--  INVALID_RULE_DATA_ERR: invalid rule data error. This will happen if the 
--                         length of all the arrays passed to this are not 
--                         the same
--
PROCEDURE update_assign_data
  (rule_name_in IN SMP_EMD_STRING_ARRAY,
   rule_owner_in IN SMP_EMD_STRING_ARRAY,
   device_name_in IN SMP_EMD_STRING_ARRAY,
   device_type_in IN SMP_EMD_INTEGER_ARRAY,
   notify_in IN SMP_EMD_INTEGER_ARRAY,
   device_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   rule_not_avail_list_out OUT SMP_EMD_STRING_ARRAY,
   user_not_avail_list_out OUT SMP_EMD_STRING_ARRAY);

-- Name: subscribe_to_rules
--
-- PURPOSE: subscribe a user for a list of public notification rules
--
-- IN parameters:
--   user_name_in: VARCHAR2 
--       subscribe this user to a list of public rules
--   rule_name_list_in: SMP_EMD_STRING_ARRAY
--     a list of rule names
--   rule_owner_list_in: SMP_EMD_STRING_ARRAY
--     a list of rule owners
--      
-- OUT parameters: 
--   rule_not_avail_list_out SMP_EMD_STRING_ARRAY
--       a list of rule names which are not available (deleted or made private)
--      
-- ERROR CODES:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE subscribe_to_rules
  (user_name_in IN VARCHAR2,
   rule_name_list_in IN SMP_EMD_STRING_ARRAY,
   rule_owner_list_in IN SMP_EMD_STRING_ARRAY,
   rule_not_avail_list_out OUT SMP_EMD_STRING_ARRAY);

--
-- Name: get_schedule_defination
--
-- Purpose: 
--  get the details for a notification schedule
--
-- IN parameters:
--   owner_in: VARCHAR2 
--       The owner of the schedule
--   schedule_name_in: VARCHAR2 
--       The schedule name
--
-- OUT parameters:
--   schedule_info_out: CURSOR_TYPE
--       The schedule info: duration (in weeks), start date, etc.
--   schedule_emails_out: CURSOR_TYPE
--       The email addresses schedule;
--   avail_emails_out: CURSOR_TYPE 
--       A list of available email addresses which are set in user's preference.
--
-- ERROR codes:
--  
--
PROCEDURE get_schedule_defination
  (owner_in IN VARCHAR2,
   schedule_name_in IN VARCHAR2,
   schedule_info_out OUT CURSOR_TYPE,
   schedule_emails_out OUT CURSOR_TYPE,
   avail_emails_out OUT CURSOR_TYPE);

--
-- Name: create_notification_schedule
--
-- Purpose: 
--  Create a notification schedule
--
-- IN parameters:
--   owner_in: VARCHAR2 
--       The owner of the schedule
--   schedule_name_in: VARCHAR2 
--       The schedule name
--   schedule_weeks_in: NUMBER
--       The duration (in weeks) of this schedule
--   schedule_start_date_in: Date 
--       The start date of this schedule
--   schedule_emails_in: SMP_EMD_NVPAIR_ARRAY
--       The email addresses schedule;
--         name  - email address
--         value - a string representing if the email is scheduled for each hour
--                 of 24 hours * 7 days * schedule_weeks_in
--
-- OUT parameters:
--   emails_not_avail_out: SMP_EMD_STRING_ARRAY 
--       A list of email addresses which are not set in user's preference.
--       This could happen if some email addresses were deleted
--
-- ERROR codes:
--  
--
PROCEDURE create_notification_schedule
  (owner_in IN VARCHAR2,
   schedule_name_in IN VARCHAR2,
   schedule_weeks_in IN NUMBER,
   schedule_start_date_in IN Date,
   schedule_emails_in IN SMP_EMD_NVPAIR_ARRAY,
   emails_not_avail_out OUT SMP_EMD_STRING_ARRAY);

--
-- Name: create_notification_schedule
--
-- Purpose: 
--  Create a notification schedule
--
-- IN parameters:
--   owner_in: VARCHAR2 
--       The owner of the schedule
--   schedule_name_in: VARCHAR2 
--       The schedule name
--   schedule_weeks_in: NUMBER
--       The duration (in weeks) of this schedule
--   schedule_start_date_in: Date 
--       The start date of this schedule
--   schedule_timezone_in: Date 
--       The timezone of this schedule
--   schedule_emails_in: SMP_EMD_NVPAIR_ARRAY
--       The email addresses schedule;
--         name  - email address
--         value - a string representing if the email is scheduled for each hour
--                 of 24 hours * 7 days * schedule_weeks_in
--
-- OUT parameters:
--   emails_not_avail_out: SMP_EMD_STRING_ARRAY 
--       A list of email addresses which are not set in user's preference.
--       This could happen if some email addresses were deleted
--
-- ERROR codes:
--  
--
PROCEDURE create_notification_schedule
  (owner_in IN VARCHAR2,
   schedule_name_in IN VARCHAR2,
   schedule_weeks_in IN NUMBER,
   schedule_start_date_in IN Date,
   schedule_timezone_in IN VARCHAR2,
   schedule_emails_in IN SMP_EMD_NVPAIR_ARRAY,
   emails_not_avail_out OUT SMP_EMD_STRING_ARRAY);

--
-- Name: test_plsql_device
--
-- Purpose: 
--  Test the plsql device
--
-- NOTE: This API should be called only by a super user.
--      
-- IN parameters:
--   plsql_in: VARCHAR2 
--       The plsql procedure to be tested
--
-- OUT parameters:
--   err_msg_out: VARCHAR2 
--       The error message associated with the test of this plsql procedure
--
-- RETURNS:
--   NUMBER: 1 if the test was successful, 0 otherwise
--
-- ERROR codes:
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
FUNCTION test_plsql_device(plsql_in IN VARCHAR2,
                           err_msg_out OUT VARCHAR2)
RETURN NUMBER;

END mgmt_preferences;
/

SHOW ERRORS;

