Rem drv: <create type="post_creation" params="EM_REPOS_USER" pos="policy/policy_post_creation.sql-"/>
Rem
Rem $Header: default_policy_setup.sql 14-jul-2005.03:00:08 gsbhatia Exp $
Rem
Rem default_policy_setup.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      default_policy_setup.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    mningomb    12/10/04 - Cutover Critical patch advisories policy to 10.2 
Rem                           policy framework 
Rem    mningomb    12/09/04 - Create CPF policy as per 10.2 policy framework 
Rem    shuberma    09/15/04 - remove repository metrics. 
Rem    shuberma    09/03/04 - Adding creation of out-of-box metrics that 
Rem                           support policies. 
Rem    groyal      10/30/03 - Move cpf policy to different category 
Rem    groyal      10/07/03 - Change Location(Home) string 
Rem    shuberma    09/12/03 - Adding snapshot criterion for host and cpf 
Rem    groyal      09/08/03 - Update patch url...again.. 
Rem    shuberma    09/08/03 - Changing rule column list 
Rem    shuberma    09/04/03 - Change cpf query 
Rem    groyal      08/27/03 - Modify url for launching patch wizard 
Rem    groyal      08/20/03 - Fix patches column in policy sql 
Rem    shuberma    08/13/03 - Modifying policy test to include check for 
Rem                           existing patch 
Rem    groyal      08/07/03 - Fix patch url 
Rem    groyal      08/04/03 - Rename policy rule and group 
Rem    shuberma    07/28/03 - Change name of policy
Rem    shuberma    07/28/03 - Correcting the critical patch query
Rem    groyal      07/24/03 - groyal_policy_0717
Rem    groyal      07/22/03 - Created
Rem
@&EM_SQL_ROOT/core/latest/ecm/patch/critical/create_cpf_policy.sql
/*
SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_ruleObj ECM_POLICY_RULE;
    l_colList ECM_RULE_COLUMN_LIST;
    l_paramList ECM_RULE_PARAM_LIST;

    l_ruleCriteria ECM_POLICY_RULE_CRITERIA;
    l_targetCriteria ECM_POLICY_TARGET_CRITERIA;
    l_policyId MGMT_POLICY_GROUP.POLICY_ID%TYPE;
    
  BEGIN

    -- -------------------------------------------------------------------------
    -- Critical Patch Policy Rule
    -- -------------------------------------------------------------------------    

    -- Use of non-standard initialization parameters
    l_colList := ECM_RULE_COLUMN_LIST(
      ECM_RULE_COLUMN('ADVISORY_NAME', 'Y', 'Y', '^ADVISORY_URL^', 'Advisory', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),
      ECM_RULE_COLUMN('IMPACT', 'N', 'Y', NULL, 'Impact', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),
      ECM_RULE_COLUMN('PATCHES', 'N', 'Y', 'ecm/patch/critical/patchAdvisoriesCriticalPatch$guid=^PATCH_GUIDS^$host=^HOST_NAME^$dir=^HOME_LOCATION^?event=getMultiListOfOracleHomes', 'Patch', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),
      ECM_RULE_COLUMN('ADVISORY_ABSTRACT', 'N', 'Y', NULL, 'Advisory Abstract', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),
      ECM_RULE_COLUMN('HOME_LOCATION_DISPLAY', 'N', 'Y', 'ecm/track/view/oracleHome$target=^TARGET_NAME^$type=host$location=^HOME_LOCATION^?event=doLoad', 'Oracle Home', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),
      -- hidden columns used for key.  can't use bug_number since the key name and value are
      -- shown in the rollup page's details column.  instead we'll use the bug_display_name
      -- as the first key column...see above
      ECM_RULE_COLUMN('HOME_LOCATION', 'Y', 'N', NULL, 'HOME_LOCATION', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),  
      ECM_RULE_COLUMN('HOST_NAME', 'Y', 'N', NULL, 'HOST', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),  
      -- hidden columns used for urls of visible columns
      ECM_RULE_COLUMN('ADVISORY_URL', 'N', 'N', NULL, 'ADVISORY_URL', MGMT_ECM_POLICY.CONS_TEXT_FORMAT),  
      ECM_RULE_COLUMN('PATCH_GUIDS', 'N', 'N', NULL, 'PATCH_GUIDS', MGMT_ECM_POLICY.CONS_TEXT_FORMAT));

    l_ruleObj := MGMT_ECM_POLICY.CREATE_POLICY_RULE(
        'Oracle',
        'host',
        'Configuration',
        'Critical Patch Advisories for Oracle Homes',
        '1.0',
        'Checks Oracle Homes for missing critical patches',
        'QUERY',
        'select
          ADVISORY_NAME,
          IMPACT,
          PATCHES ,  
          ADVISORY_ABSTRACT,
          HOME_LOCATION_DISPLAY, 
          HOME_LOCATION,
          HOST_NAME,
          ADVISORY_URL,
          PATCH_GUIDS,
          TARGET_GUID
         from TABLE(MGMT_ECM_POLICY.CPF_QUERY)',
        'rownum > 0',
        MGMT_ECM_POLICY.CONS_HIGH,
        'To help ensure a secure and reliable configuration, all relevant and current  
          critical patches should be applied.  Vulnerabilities have been identified 
          for the following critical patch advisories.',
        'Apply one of the identified patches for each critical patch advisory.',
        l_colList,
        null,
        'CRITICAL_PATCH');
        
     COMMIT;
    -- create 'Critical Patch Facility' policy
    l_ruleCriteria := ECM_POLICY_RULE_CRITERIA(
      ECM_POLICY_RULE_CRITERION('Oracle', 'host', 'Configuration', 'Critical Patch Advisories for Oracle Homes'));

    l_targetCriteria := ECM_POLICY_TARGET_CRITERIA(
      ECM_POLICY_TARGET_CRITERION('N', 'host', '%', 'like'));

    l_policyId := MGMT_ECM_POLICY.CREATE_POLICY_GROUP(
      'Oracle',
      'Critical Patch Advisories for Oracle Homes',
      '1.0',
      'Oracle recommended critical patches must have been installed',
      l_ruleCriteria,
      l_targetCriteria,
      null,
      'CRITICAL_PATCH_ADVISORY');
      
    COMMIT;  
    
    INSERT INTO MGMT_POLICY_SNAPSHOT_CRITERIA
      ( POLICY_ID,
        SNAPSHOT_TYPE,
        TARGET_TYPE
        )
    VALUES (
        l_policyId, 
        'host_configuration', 
        'host');
      
    COMMIT;

  END;

END;
/

SET DEFINE ON
*/
