Rem drv: <create type="pkgdefs" pos="metric/metric_ui_pkgdef.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/policy/policy_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2009/04/27 22:10:50 bram Exp $
Rem
Rem policy_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      policy_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bram        04/24/09 - Backport jsadras_rfi_backport_6686041_10.2.0.5
Rem                           from st_emcore_10.2.0.1.0
Rem    sthiruna    07/28/06 - Copying 10.2.0.3 Config Standard changes from
Rem                           EMCORE_MAIN_LINUX
Rem    pratagar    07/25/06 - Backport pratagar_bug-4653111 from main 
Rem    pratagar    12/08/05 - Delete UDM and 2 Col SQL UDM Support.
Rem    neearora    03/29/06 - Bug 5108394. Adding rowset handler for deleting 
Rem                           rows from MGMT_POLICY_ASSOC_CFG and 
Rem                           MGMT_POLICY_ASSOC_CFG_PARAMS 
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    kchiasso    02/23/06 - change owner to author
Rem    niramach    01/25/06 - Add config_std name and rule name parameters to 
Rem                           the create_cs_policy procedure. 
Rem    niramach    01/11/06 - 10.3 Work start: Add create_cs_policy procedure. 
Rem    rpinnama    09/01/05 - Add delete_policy_data API 
Rem    jsadras     08/02/05 - Add config key match util 
Rem    rpinnama    07/27/05 - Fix 4495845 : Support a proc to remove CA 
Rem                           associations 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    pmodi       06/10/05 - Bug:4406767 -New proc for key-val deletion 
Rem    niramach    05/13/05 - clear_expired_suppressions is moved from 
Rem                           em_policy_ui to em_policy since it is no longer 
Rem                           called from UI code.
Rem    rpinnama    06/15/05 - Fix 4340418: Re-associate policies on detecting 
Rem                           metaver change 
Rem    rpinnama    05/23/05 - Add copy_object_policy_assoc_cfg proc
Rem    niramach    05/13/05 - clear_expired_suppressions is moved from 
Rem                           em_policy_ui to em_policy since it is no longer 
Rem                           called from UI code.
Rem    rpinnama    05/19/05 - Add POLICY_INFO_REC type 
Rem    rpinnama    04/15/05 - Add dump routines 
Rem    rpinnama    02/23/05 - Use separate coll name for src and dest. 
Rem    rpinnama    01/07/05 - Add support for start/end type_meta_vers 
Rem    rpinnama    01/06/05 - Add target type addition callback 
Rem    rpinnama    12/02/04 - Add support for clear_message and 
Rem                           clear_message_nlsid 
Rem    rpatti      11/29/04 - fix copy_object_policy_assoc 
Rem    rpinnama    11/22/04 - Add policy type to assoc table 
Rem    rpinnama    11/18/04 - Add support for UDM 
Rem    jsadras     10/19/04 - policy_timing
Rem    groyal      10/13/04 - Move ui procedures to policy_ui_pkgbody 
Rem    rpinnama    10/10/04 - Replace template_ca with mntr_ca 
Rem    rpinnama    10/06/04 - Add remove API for policy eval tables 
Rem    rpinnama    09/30/04 - Add copy_object_policy_assoc 
Rem    rpinnama    09/28/04 - Add get_ca_id function 
Rem    rpinnama    09/23/04 - Rename template_override as prevent_override 
Rem    shuberma    09/20/04 - Adding cleare_expired_exemptions. 
Rem    shuberma    09/03/04 - Add refresh_policy_eval_sum. 
Rem    rpinnama    09/08/04 - 
Rem    rpinnama    08/27/04 - Add add_target/delete_target callbacks
Rem    rpinnama    08/19/04 - Support is_push 
Rem    rpinnama    08/18/04 - Complete the implementation 
Rem    rpinnama    08/16/04 - Add APIs to update policy eval details 
Rem    rpinnama    08/12/04 - Provide update* API 
Rem    rpinnama    08/11/04 - Make simultaction NUMBER. 
Rem    rpinnama    08/04/04 - Add corrective action API 
Rem    rpinnama    07/28/04 - Add more internal APIs 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/23/04 - Created
Rem


CREATE OR REPLACE PACKAGE em_policy
AS

  G_MODULE_NAME CONSTANT VARCHAR2(30) := 'EM_POLICY';

  EST_POLICY_NAME CONSTANT VARCHAR2(30) := 'EST_POLICY';

  PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);

  -- API to hanle MGMT_POLICIES table
  -- Adds a row to the policy table 
  -- Defaults the columns to table defaults
  PROCEDURE add_policy(
      p_policy_guid          IN RAW,
      p_target_type          IN VARCHAR2,
      p_policy_name          IN VARCHAR2,
      p_metric_guid          IN RAW,
      p_start_type_meta_ver  IN VARCHAR2 DEFAULT '1.0',
      p_end_type_meta_ver    IN VARCHAR2 DEFAULT NULL,
      p_policy_type          IN NUMBER   DEFAULT 1,
      p_policy_label_nlsid   IN VARCHAR2 DEFAULT NULL,
      p_description          IN VARCHAR2 DEFAULT NULL,
      p_description_nlsid    IN VARCHAR2 DEFAULT NULL,
      p_author               IN VARCHAR2 DEFAULT 'ORACLE',
      p_auto_enable          IN NUMBER   DEFAULT 0,
      p_cs_consider_percentage IN NUMBER DEFAULT 0,
      p_impact               IN VARCHAR2 DEFAULT NULL,
      p_impact_nlsid         IN VARCHAR2 DEFAULT NULL,
      p_recommendation       IN VARCHAR2 DEFAULT NULL,
      p_recommendation_nlsid IN VARCHAR2 DEFAULT NULL,
      p_violation_level      IN NUMBER   DEFAULT NULL,
      p_condition_type       IN NUMBER   DEFAULT 1,
      p_condition            IN VARCHAR2 DEFAULT NULL,
      p_condition_operator   IN VARCHAR2 DEFAULT NULL,
      p_detailed_url_link    IN VARCHAR2 DEFAULT NULL,
      p_message              IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_clear_message        IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid  IN VARCHAR2 DEFAULT NULL,
      p_owner                IN VARCHAR2 DEFAULT '<SYSTEM>',
      p_last_updated_by      IN VARCHAR2 DEFAULT NULL);
      
  -- Updates a row in the policy table (MGMT_POLICIES)
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_policy(
      p_policy_guid          IN RAW,
      p_target_type          IN VARCHAR2,
      p_policy_name          IN VARCHAR2,
      p_metric_guid          IN RAW      DEFAULT NULL,
      p_start_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
      p_end_type_meta_ver    IN VARCHAR2 DEFAULT NULL,
      p_policy_type          IN NUMBER   DEFAULT NULL,
      p_policy_label_nlsid   IN VARCHAR2 DEFAULT NULL,
      p_description          IN VARCHAR2 DEFAULT NULL,
      p_description_nlsid    IN VARCHAR2 DEFAULT NULL,
      p_author               IN VARCHAR2 DEFAULT NULL,
      p_auto_enable          IN NUMBER   DEFAULT NULL,
      p_cs_consider_percentage IN NUMBER DEFAULT NULL,
      p_impact               IN VARCHAR2 DEFAULT NULL,
      p_impact_nlsid         IN VARCHAR2 DEFAULT NULL,
      p_recommendation       IN VARCHAR2 DEFAULT NULL,
      p_recommendation_nlsid IN VARCHAR2 DEFAULT NULL,
      p_violation_level      IN NUMBER   DEFAULT NULL,
      p_condition_type       IN NUMBER   DEFAULT NULL,
      p_condition            IN VARCHAR2 DEFAULT NULL,
      p_condition_operator   IN VARCHAR2 DEFAULT NULL,
      p_detailed_url_link    IN VARCHAR2 DEFAULT NULL,
      p_message              IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_clear_message        IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid  IN VARCHAR2 DEFAULT NULL,
      p_owner                IN VARCHAR2 DEFAULT NULL,
      p_last_updated_by      IN VARCHAR2 DEFAULT NULL);

  -- Deletes a row in the policy table (MGMT_POLICIES)
  -- Deletes using the primary key policy_guid
  PROCEDURE remove_policy(
      p_policy_guid          IN RAW);




  -- API to handle MGMT_POLICY_PARAMETERS table
  -- Adds a row to the policy parameter table (MGMT_POLICY_PARAMETERS)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_parameter(p_policy_guid       IN RAW,
                                 p_param_name        IN VARCHAR2,
                                 p_param_name_nlsid  IN VARCHAR2,
                                 p_param_type        IN NUMBER DEFAULT 0);

  -- Updates a row in the policy parameter table (MGMT_POLICY_PARAMETERS)
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_policy_parameter(p_policy_guid       IN RAW,
                                    p_param_name        IN VARCHAR2,
                                    p_param_name_nlsid  IN VARCHAR2 DEFAULT NULL,
                                    p_param_type        IN NUMBER   DEFAULT NULL);

  -- Deletes a row in the policy parameter table
  PROCEDURE remove_policy_parameter(
      p_policy_guid   IN RAW,
      p_param_name    IN VARCHAR2);

  -- Deletes a set of parameters from policy parameter table
  -- If p_param_name_list is NULL, all parameters are deleted
  PROCEDURE remove_policy_parameters(
      p_policy_guid       IN RAW,
      p_param_name_list   IN MGMT_POLICY_PARAM_DEF_ARRAY DEFAULT NULL);




  -- API to handle MGMT_POLICY_BIND_VARS table
  -- Adds a row to the policy bind variables table (MGMT_POLICY_BIND_VARS)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_bind_var(p_policy_guid       IN RAW,
                                p_bind_column_name  IN VARCHAR2,
                                p_bind_column_type  IN NUMBER DEFAULT 1);

  -- Deletes all the bind variables for given policy
  PROCEDURE remove_policy_bind_vars(p_policy_guid IN RAW);




  -- API to handle MGMT_POLICY_VIOL_CTXT_DEF table
  -- Adds a row to the policy violation context definition table (MGMT_POLICY_VIOL_CTXT_DEF)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_viol_ctxt_def(p_policy_guid IN RAW,
                              p_column_name IN VARCHAR2,
                              p_metric_guid IN RAW,
                              p_column_position IN NUMBER DEFAULT 0,
                              p_is_hidden       IN NUMBER DEFAULT 0,
                              p_url_link_type   IN NUMBER DEFAULT 0,
                              p_url_link_template IN VARCHAR2 DEFAULT NULL);

  -- Updates a row in the policy violation context definition table (MGMT_POLICY_VIOL_CTXT_DEF)
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_viol_ctxt_def(p_policy_guid IN RAW,
                                 p_column_name IN VARCHAR2,
                                 p_metric_guid       IN RAW      DEFAULT NULL,
                                 p_column_position   IN NUMBER   DEFAULT NULL,
                                 p_is_hidden         IN NUMBER   DEFAULT NULL,
                                 p_url_link_type     IN NUMBER   DEFAULT NULL,
                                 p_url_link_template IN VARCHAR2 DEFAULT NULL);

  -- Deletes all the violation context definition rows for a given policy
  PROCEDURE remove_viol_ctxt_defs(p_policy_guid IN RAW);

  -- API to handle MMGT_POLICY_TYPE_VERSIONS table
  -- Adds a row to the policy type versions table (MGMT_POLICY_TYPE_VERSIONS)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_type_version(p_policy_guid   IN RAW,
                                    p_type_meta_ver IN VARCHAR2);

  -- Deletes one or all the policy type version rows for a given policy
  PROCEDURE remove_policy_type_version(p_policy_guid   IN RAW,
                                       p_type_meta_ver IN VARCHAR2 DEFAULT NULL);


  -- API to handle MGMT_POLICY_ASSOC table
  -- Adds a row to the policy association table (MGMT_POLICY_ASSOC)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_assoc(p_object_guid IN RAW,
                             p_policy_guid IN RAW,
                             p_coll_name   IN VARCHAR2,
                             p_object_type IN NUMBER DEFAULT 1,
                             p_policy_type IN NUMBER DEFAULT 1,
                             p_is_enabled  IN NUMBER DEFAULT 1,
                             p_add_or_delete IN NUMBER DEFAULT 0);

  -- Updates a row in the policy assoc table 
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_policy_assoc(p_object_guid IN RAW,
                                p_policy_guid IN RAW,
                                p_coll_name   IN VARCHAR2,
                                p_is_enabled  IN NUMBER   DEFAULT NULL);

  -- Deletes specified row(s) from the policy assoc table.
  PROCEDURE remove_policy_assocs(p_object_guid IN RAW,
                                 p_policy_guid IN RAW,
                                 p_coll_name   IN VARCHAR2 DEFAULT NULL);




  -- API to handle MGMT_POLICY_ASSOC_CFG table
  -- Adds a row to the policy association configuration table (MGMT_POLICY_ASSOC_CFG)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_assoc_cfg(
      p_object_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2,
      p_key_value            IN VARCHAR2 DEFAULT ' ',
      p_key_operator         IN NUMBER   DEFAULT 0,
      p_eval_order           IN NUMBER   DEFAULT 1,
      p_is_exception         IN NUMBER   DEFAULT 0,
      p_has_active_baseline  IN NUMBER   DEFAULT 0,
      p_prevent_override     IN NUMBER   DEFAULT 0,
      p_crit_action_job_id   IN RAW      DEFAULT NULL,
      p_warn_action_job_id   IN RAW      DEFAULT NULL,
      p_info_action_job_id   IN RAW      DEFAULT NULL,
      p_fixit_job            IN VARCHAR2 DEFAULT NULL,
      p_simultaneous_actions IN NUMBER   DEFAULT 1,
      p_importance           IN NUMBER   DEFAULT NULL,
      p_num_occurrences      IN NUMBER   DEFAULT 1,
      p_is_push              IN NUMBER   DEFAULT 0,
      p_condition_operator   IN NUMBER   DEFAULT 0,
      p_message              IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_clear_message        IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid  IN VARCHAR2 DEFAULT NULL);

  -- Updates a row in the policy assoc config table 
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_policy_assoc_cfg(
      p_object_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2,
      p_key_value            IN VARCHAR2 DEFAULT ' ',
      p_key_operator         IN NUMBER   DEFAULT 0,
      p_eval_order           IN NUMBER   DEFAULT NULL,
      p_is_exception         IN NUMBER   DEFAULT NULL,
      p_has_active_baseline  IN NUMBER   DEFAULT NULL,
      p_prevent_override     IN NUMBER   DEFAULT NULL,
      p_crit_action_job_id   IN RAW      DEFAULT NULL,
      p_warn_action_job_id   IN RAW      DEFAULT NULL,
      p_info_action_job_id   IN RAW      DEFAULT NULL,
      p_fixit_job            IN VARCHAR2 DEFAULT NULL,
      p_simultaneous_actions IN NUMBER   DEFAULT NULL,
      p_importance           IN NUMBER   DEFAULT NULL,
      p_num_occurrences      IN NUMBER   DEFAULT NULL,
      p_is_push              IN NUMBER   DEFAULT NULL,
      p_condition_operator   IN NUMBER   DEFAULT NULL,
      p_message              IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_clear_message        IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid  IN VARCHAR2 DEFAULT NULL);

  -- Deletes corrective action assocation for the 
  -- specified row(s) from the policy assoc config table.
  PROCEDURE remove_policy_assoc_cas(
      p_object_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2 DEFAULT NULL,
      p_key_value            IN VARCHAR2 DEFAULT NULL,
      p_key_operator         IN NUMBER   DEFAULT NULL);

  -- Deletes specified row(s) from the policy assoc config table.
  PROCEDURE remove_policy_assoc_cfgs(
      p_object_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2 DEFAULT NULL,
      p_key_value            IN VARCHAR2 DEFAULT NULL,
      p_key_operator         IN NUMBER   DEFAULT NULL);




  -- API to handle MGMT_POLICY_ASSOC_CFG_PARAMS table
  -- Adds a row to the policy association configuration parameters table (MGMT_POLICY_ASSOC_CFG_PARAMS)
  -- The default values used here are the defaults specified for the table
  PROCEDURE add_policy_assoc_cfg_param(
      p_object_guid    IN RAW,
      p_policy_guid    IN RAW,
      p_coll_name      IN VARCHAR2,
      p_key_value      IN VARCHAR2 DEFAULT ' ',
      p_key_operator   IN NUMBER   DEFAULT 0,
      p_param_name     IN VARCHAR2 DEFAULT ' ',
      p_crit_threshold IN VARCHAR2 DEFAULT ' ',
      p_warn_threshold IN VARCHAR2 DEFAULT ' ',
      p_info_threshold IN VARCHAR2 DEFAULT ' ');

  -- Updates a row in the policy assoc config params table 
  -- Updates the non-PK columns using the primary key (policy_guid)
  -- If the value passed for a non-PK column is NULL, that column value is not updated.
  PROCEDURE update_policy_assoc_cfg_param(
      p_object_guid    IN RAW,
      p_policy_guid    IN RAW,
      p_coll_name      IN VARCHAR2,
      p_key_value      IN VARCHAR2 DEFAULT ' ',
      p_key_operator   IN NUMBER   DEFAULT NULL,
      p_param_name     IN VARCHAR2 DEFAULT NULL,
      p_crit_threshold IN VARCHAR2 DEFAULT NULL,
      p_warn_threshold IN VARCHAR2 DEFAULT NULL,
      p_info_threshold IN VARCHAR2 DEFAULT NULL);

  -- Deletes specified row(s) from the policy assoc config params table.
  PROCEDURE remove_policy_assoc_cfg_params(
      p_object_guid    IN RAW,
      p_policy_guid    IN RAW,
      p_coll_name      IN VARCHAR2 DEFAULT NULL,
      p_key_value      IN VARCHAR2 DEFAULT NULL,
      p_key_operator   IN NUMBER   DEFAULT NULL,
      p_param_name     IN VARCHAR2 DEFAULT NULL);




  -- API to handle MGMT_POLICY_ASSOC_EVAL_SUMM table
  -- Updates (or adds, if does not exist) a policy association evaluation summary row 
  -- The default values used here are the defaults specified for the table
  PROCEDURE update_policy_eval_summ(
      p_target_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2,
      p_evaluation_date      IN DATE     DEFAULT NULL,
      p_rows_evaluated       IN NUMBER   DEFAULT NULL,
      p_violations_logged    IN NUMBER   DEFAULT NULL,
      p_non_exempt_violations IN NUMBER   DEFAULT NULL,
      p_max_violation_level  IN NUMBER   DEFAULT NULL,
      p_compliance_score     IN NUMBER   DEFAULT NULL);

  -- Deletes specified row(s) from the policy assoc eval summary table
  PROCEDURE remove_policy_eval_summ(
      p_target_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2 DEFAULT NULL);




  -- update_compliance_score
  -- 
  -- Purpose:
  -- This procedure updates the compliance score, non_exempt_violations and
  -- max violations level to reflect changes in exemptions.  Compliance score is 
  -- only calculated for the target-policy pair and not on individual columns, so
  -- col_name is ' '.
  -- 
  -- Parameters
  -- p_target_guid : part of ID of eval summ
  -- p_policy_guid : part of ID of eval summ
  -- 
  -- Exceptions
  --  None expected.
  -- Notes:
  --
  PROCEDURE update_compliance_score(
      p_target_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2 := ' ' );




  -- API to handle MGMT_POLICY_ASSOC_EVAL_DETAILS table
  -- Updates (or adds, if does not exist) a policy association evaluation details row 
  -- The default values used here are the defaults specified for the table
  PROCEDURE update_policy_eval_detail(
      p_target_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2,
      p_result_key_value     IN VARCHAR2 DEFAULT ' ',
      p_crit_counter         IN NUMBER   DEFAULT NULL,
      p_warn_counter         IN NUMBER   DEFAULT NULL,
      p_info_counter         IN NUMBER   DEFAULT NULL,
      p_evaluation_date      IN DATE     DEFAULT NULL,
      p_last_error_message   IN VARCHAR  DEFAULT NULL,
      p_cfg_key_value        IN VARCHAR2 DEFAULT ' ',
      p_cfg_key_operator     IN NUMBER   DEFAULT 0);

  -- Deletes specified row(s) from the policy assoc eval details table
  PROCEDURE remove_policy_eval_details(
      p_target_guid          IN RAW,
      p_policy_guid          IN RAW,
      p_coll_name            IN VARCHAR2 DEFAULT NULL,
      p_result_key_value     IN VARCHAR2 DEFAULT NULL);




  -- API to handle MGMT_METRICS_COMPOSITE_KEYS table
  -- Gets key part details for a given composite key.
  PROCEDURE get_composite_key_parts(
                 p_object_guid IN RAW,
		 p_composite_key_guid IN RAW,
		 p_key_part_list OUT NOCOPY mgmt_medium_string_array);

  -- Adds composite key entry to the composite key table
  -- If the composite key entry already exists, no action is performed
  PROCEDURE add_composite_key_entry(
                   p_object_guid IN RAW,
                   p_composite_key_guid IN RAW,
		   p_key_part1_value IN VARCHAR2,
		   p_key_part2_value IN VARCHAR2,
		   p_key_part3_value IN VARCHAR2,
		   p_key_part4_value IN VARCHAR2,
		   p_key_part5_value IN VARCHAR2);

  -- Another API to add the composite key entry
  PROCEDURE add_composite_key_entry(
                   p_object_guid IN RAW,
                   p_composite_key_guid IN RAW,
                   p_key_part_list IN  mgmt_medium_string_array DEFAULT NULL);

  -- Adds a policy association and the association configuration and paramters
  -- for the given object, policy and coll_name
  PROCEDURE add_object_policy_assoc(
      p_object_guid     IN RAW,
      p_policy_guid     IN RAW,
      p_coll_name       IN VARCHAR2,
      p_object_type     IN NUMBER   DEFAULT 1,
      p_policy_type     IN NUMBER   DEFAULT 1,
      p_is_enabled      IN NUMBER   DEFAULT 1,
      p_policy_val_list IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL,
      p_add_or_delete IN NUMBER DEFAULT 0,
      p_metric_info     IN EM_METRIC.METRIC_INFO_REC DEFAULT NULL);

  -- Copies all policy associations from src object to dest object
  PROCEDURE copy_all_policy_assocs(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER,
      p_ca_creds            IN MGMT_MNTR_CA_ARRAY DEFAULT NULL);

  -- Copies a specific policy associations from src object to dest object
  PROCEDURE copy_object_policy_assoc(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER,
      p_policy_guid         IN RAW,
      p_policy_type         IN NUMBER   DEFAULT 1,
      p_src_coll_name       IN VARCHAR2 DEFAULT NULL,
      p_dest_coll_name      IN VARCHAR2 DEFAULT NULL,
      p_is_enabled          IN NUMBER   DEFAULT 1,
      p_ca_creds            IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
      p_add_or_delete       IN NUMBER DEFAULT 0);

  PROCEDURE copy_object_policy_assoc_cfg(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER,
      p_policy_guid         IN RAW,
      p_src_coll_name       IN VARCHAR2 DEFAULT NULL,
      p_dest_coll_name      IN VARCHAR2 DEFAULT NULL,
      p_src_key_value       IN VARCHAR2 DEFAULT ' ',
      p_src_key_oper        IN NUMBER   DEFAULT 0,
      p_dest_eval_order     IN NUMBER   DEFAULT 0,
      p_metric_info         IN EM_METRIC.METRIC_INFO_REC DEFAULT NULL,
      p_ca_creds            IN MGMT_MNTR_CA_ARRAY DEFAULT NULL);

  -- Deletes policy associations and their details
  PROCEDURE remove_object_policy_assoc(
      p_object_guid     IN RAW,
      p_policy_guid     IN RAW,
      p_coll_name       IN VARCHAR2 DEFAULT NULL,
      p_remove_ca_assoc IN NUMBER   DEFAULT 1);

  -- Bulk version of remove object policy assoc for given
  -- set of policy guids
  PROCEDURE remove_object_policy_assocs(
      p_object_guid     IN RAW,
      p_policy_guids    IN mgmt_target_guid_array,
      p_coll_name       IN VARCHAR2 DEFAULT NULL,
      p_remove_ca_assoc IN NUMBER   DEFAULT 1) ;

  -- Bulk version of remove object policy assoc for given
  -- object_guid
  PROCEDURE remove_object_policy_assocs(
      p_object_guid     IN RAW,
      p_remove_ca_assoc IN NUMBER   DEFAULT 1) ;

  -- Bulk version of remove object policy assoc for given
  -- policy_guid
  PROCEDURE remove_object_policy_assocs(
      p_policy_guid     IN RAW,
      p_remove_ca_assoc IN NUMBER   DEFAULT 1) ;


  -- Get the key details
  -- This procedure gets the composite key and key operator for the given key_col_cond_list
  -- NOTE : Returns ' ' if all key_values passed in are ' '
  PROCEDURE get_key_details(
      p_key_col_cond_list  IN MGMT_POLICY_KEY_COL_COND_ARRAY,
      p_metric_info        IN EM_METRIC.METRIC_INFO_REC,
      p_key_value          OUT VARCHAR2,
      p_key_part_array     OUT NOCOPY mgmt_medium_string_array,
      p_key_operator       OUT NUMBER);

  -- Utility function which returns TRUE if the config key matches the result key
 
  FUNCTION config_key_match(p_cfg_key       IN mgmt_medium_string_array,
                            p_result_key    IN mgmt_medium_string_array,
                            p_key_operator  IN VARCHAR2,
                            p_num_keys      IN NUMBER
                            )
  RETURN BOOLEAN ;

  -- Get the matching association configuration details
  -- This procedure gets the key details of the matching configuration
  PROCEDURE get_config_key_details(
      p_object_guid      IN RAW,
      p_policy_guid      IN RAW,
      p_key_value        IN VARCHAR2,
      p_cfg_coll_name    OUT VARCHAR2,
      p_cfg_key_value    OUT VARCHAR2,
      p_cfg_key_operator OUT NUMBER);


  -- Get the corrective action ID.
  FUNCTION get_ca_id(p_object_guid IN RAW,
                     p_object_type IN NUMBER DEFAULT 1,
                     p_ca_name     IN VARCHAR2 DEFAULT NULL,
		     p_incr_ref    IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE)
    RETURN RAW;

  FUNCTION get_ca_id_list(
      p_object_guid     IN RAW,
      p_policy_guid     IN RAW,
      p_coll_name       IN VARCHAR2 DEFAULT NULL,
      p_key_value       IN VARCHAR2 DEFAULT NULL,
      p_key_operator    IN NUMBER   DEFAULT NULL)
    RETURN MGMT_TARGET_GUID_ARRAY;

  PROCEDURE decrement_ca_ids(p_ca_id_list IN MGMT_TARGET_GUID_ARRAY DEFAULT NULL);

  -- Copies the corrective from one scope to another
  FUNCTION copy_ca_id(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER,
      p_ca_id               IN RAW,
      p_ca_creds            IN MGMT_MNTR_CA_ARRAY DEFAULT NULL)
    RETURN RAW ;

  -- Callback to be called when the corrective action is deleted.
  PROCEDURE handle_delete_ca(p_ca_job_id IN RAW);

  -- Callback to auto-associate policies
  -- This callback associates all associatable policies (auto_associate = 1)
  -- to the target being added.
  -- NOTE : This is a target addition callback.
  PROCEDURE auto_associate_policies(p_target_name VARCHAR2,
                                    p_target_type VARCHAR2,
                                    p_target_guid RAW);

  -- Callback to delete policy data
  PROCEDURE handle_target_delete(p_target_name VARCHAR2, 
                                 p_target_type VARCHAR2,
                                 p_target_guid RAW);

  -- Callback to handle type metaver changes
  PROCEDURE handle_type_meta_ver_change(p_meta_ver_cbk_obj IN MGMT_TARGET_META_VER_CBK_OBJ);

  -- Callback to handle the addition of new target type version
  PROCEDURE handle_tgttype_addition(p_target_type   IN VARCHAR2,
                                    p_type_meta_ver IN VARCHAR2);

  PROCEDURE set_repo_timing
              (p_target_type IN VARCHAR2,
               p_policy_name IN VARCHAR2,
               p_enabled     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE); 


  --Type to hold policy information 
  TYPE POLICY_INFO_REC IS RECORD
  (
    policy_guid    mgmt_policies.policy_guid%type,
    metric_guid    mgmt_metrics.metric_guid%type,
    metric_name    mgmt_metrics.metric_name%type,
    policy_params  mgmt_namevalue_array
  );

  PROCEDURE get_policy_info(
                p_policy_guid IN RAW,
                p_policy_info OUT NOCOPY POLICY_INFO_REC);

  PROCEDURE get_policy_info_for_target(
                p_policy_guid IN RAW,
                p_target_guid IN RAW,
                p_policy_info OUT NOCOPY POLICY_INFO_REC) ;

  PROCEDURE delete_policy_data(
                p_target_type IN VARCHAR2,
                p_policy_name IN VARCHAR2);

  -- Dump routines
  PROCEDURE dump_access_list(
      p_access_list IN MGMT_TEMPLATE_ACCESS_ARRAY DEFAULT NULL,
      p_prefix      IN VARCHAR2 DEFAULT ' ',
      p_module      IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_key_col_cond_list(
      p_key_cond_list IN MGMT_POLICY_KEY_COL_COND_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_param_val_list (
      p_param_values IN MGMT_POLICY_PARAM_VAL_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_key_val_list (
      p_key_val_list IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_metric_list(
      p_metric_list IN MGMT_MNTR_METRIC_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_policy_list(
      p_policy_list IN MGMT_MNTR_POLICY_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_cred_row_list(
      p_cred_row_list IN MGMT_CRED_ROW_ARRAY DEFAULT NULL,
      p_prefix       IN VARCHAR2 DEFAULT ' ',
      p_module       IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_cred_list(
      p_cred_list    IN MGMT_CRED_ARRAY DEFAULT NULL,
      p_prefix       IN VARCHAR2 DEFAULT ' ',
      p_module       IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_coll_prop_list(
      p_prop_list    IN MGMT_COLL_PROP_ARRAY DEFAULT NULL,
      p_prefix       IN VARCHAR2 DEFAULT ' ',
      p_module       IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_coll_metric_list(
      p_cmetric_list IN MGMT_COLL_METRIC_ARRAY DEFAULT NULL,
      p_prefix       IN VARCHAR2 DEFAULT ' ',
      p_module       IN VARCHAR2 DEFAULT NULL);

  PROCEDURE dump_collection_list(
      p_coll_list IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL,
      p_prefix    IN VARCHAR2 DEFAULT ' ',
      p_module    IN VARCHAR2 DEFAULT NULL);

  -- End dump routines
  
  -- Clear exemptions that are expired.  These are exempt_until_date type exemptions.   
  PROCEDURE clear_expired_suppressions;

  -- Procedure for deletion of all policies based on target_guid, metric_guid and key-value
  -- Would be call by callback EM_METRIC.handle_metric_keyval_deletion

  PROCEDURE del_keyval_policy
  (
    p_target_guid  IN mgmt_targets.target_guid%TYPE,
    p_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    p_key_value    IN mgmt_metrics_raw.key_value%TYPE
  );
  
  --Procedure for creating a configuration standard policy.
  --For the given existing policy and target type it creates a new policy with
  --all of its existing policy properties.
  PROCEDURE create_cs_policy
  (
    p_policy_name VARCHAR2,
    p_target_type VARCHAR2,
    p_config_std_name VARCHAR2,
    p_rule_name VARCHAR2,
    p_author VARCHAR2,
    p_version NUMBER,
    p_cs_policy_guid OUT RAW
  );  

  PROCEDURE assoc_cfg_del_handler
  (
    p_object_guid          IN RAW,
    p_policy_guid          IN RAW,
    p_coll_name            IN VARCHAR2,
    p_key_value            IN VARCHAR2 DEFAULT ' ',
    p_key_operator         IN NUMBER   DEFAULT 0,
    p_eval_order           IN NUMBER   DEFAULT 1,
    p_is_exception         IN NUMBER   DEFAULT 0,
    p_has_active_baseline  IN NUMBER   DEFAULT 0,
    p_prevent_override     IN NUMBER   DEFAULT 0,
    p_crit_action_job_id   IN RAW      DEFAULT NULL,
    p_warn_action_job_id   IN RAW      DEFAULT NULL,
    p_info_action_job_id   IN RAW      DEFAULT NULL,
    p_fixit_job            IN VARCHAR2 DEFAULT NULL,
    p_simultaneous_actions IN NUMBER   DEFAULT 1,
    p_importance           IN NUMBER   DEFAULT NULL,
    p_num_occurrences      IN NUMBER   DEFAULT 1,
    p_is_push              IN NUMBER   DEFAULT 0,
    p_condition_operator   IN NUMBER   DEFAULT 0,
    p_message              IN VARCHAR2 DEFAULT NULL,
    p_message_nlsid        IN VARCHAR2 DEFAULT NULL,
    p_clear_message        IN VARCHAR2 DEFAULT NULL,
    p_clear_message_nlsid  IN VARCHAR2 DEFAULT NULL
  );

 PROCEDURE assoc_cfg_params_del_handler 
 (
    p_object_guid    IN RAW,
    p_policy_guid    IN RAW,
    p_coll_name      IN VARCHAR2,
    p_key_value      IN VARCHAR2 DEFAULT ' ',
    p_key_operator   IN NUMBER   DEFAULT NULL,
    p_param_name     IN VARCHAR2 DEFAULT NULL,
    p_crit_threshold IN VARCHAR2 DEFAULT NULL,
    p_warn_threshold IN VARCHAR2 DEFAULT NULL,
    p_info_threshold IN VARCHAR2 DEFAULT NULL
 );
  
END em_policy;
/

show errors
