Rem drv: <create type="post_creation" pos="policy/reports/policy_outofbox_reports.sql-"/>
Rem
Rem $Header: policy_post_creation.sql 24-jul-2007.16:47:02 rrawat Exp $
Rem
Rem policy_post_creation.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      policy_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rrawat      07/24/07 - Backport rrawat_bug-5357750 from main
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    rrawat      07/12/07 - Bug-5357750
Rem    neearora    03/28/06 - Bug 5108394. Adding capability in loader to 
Rem                           delete rows through uploads 
Rem    niramach    08/01/05 - Copied the source from v102020 policy_post_creation
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    rpinnama    06/16/05 - Remove additional /
Rem    rpinnama    05/12/05 - Move the policy init to v102010/policy_init directory
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    01/06/05 - Add target type addition callback 
Rem    jsadras     10/14/04 - performance module 
Rem    rpinnama    09/02/04 - rpinnama_add_policy_api_4
Rem    rpinnama    08/27/04 - Created
Rem
SET ECHO ON
@&EM_SQL_ROOT/core/v102010/policy/policy_init.sql
@&EM_SQL_ROOT/core/v102020/policy/policy_post_creation.sql

BEGIN
  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('EST_POLICY', 'OFF', 'Extended SQL trace for EM_POLICY.CLEAR_EXPIRED_SUPPRESSIONS dbms jobs. ' ||
                           'Use EM_POLICY.DBMSJOB_EXTENDED_SQL_TRACE_ON(boolean) to alter');

  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    UPDATE MGMT_PARAMETERS SET parameter_value = 'OFF' WHERE parameter_name = 'EST_POLICY';
    COMMIT;
END;
/
BEGIN
  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('policy_purge_batchsize_parameter', '10000', ' Policy Purge Batch Size for MGMT_VIOLATIONS ' );

  COMMIT;
EXCEPTION
  -- Dont set the value to 10000 if its already set  
  WHEN OTHERS THEN NULL;
END;
/
BEGIN
  EMD_MAINTENANCE.COMPRESS_INDEX('mgmt_policy_assoc_pk',
                                 1,FALSE);
END ;
/
BEGIN
  EMD_MAINTENANCE.COMPRESS_INDEX('mgmt_policy_assoc_cfg_param_pk',
                                 1,FALSE);
END ;
/

-- register a rowset handler to delete the records from MGMT_POLICY_ASSOC_CFG and MGMT_POLICY_ASSOC_CFG_PARAMS
BEGIN
  emd_loader.add_plsql_handler_for_rowset(p_rowset_name => 'MGMT_POLICY_ASSOC_CFG',
                                          p_proc_name   => 'EM_POLICY.assoc_cfg_del_handler',
                                          p_handler_type => EMD_LOADER.G_ROWSET_HANDLER_PLSQL_DELETE   
                                         );
 
 emd_loader.add_plsql_handler_for_rowset(p_rowset_name => 'MGMT_POLICY_ASSOC_CFG_PARAMS',
                                         p_proc_name   => 'EM_POLICY.assoc_cfg_params_del_handler',
                                         p_handler_type => EMD_LOADER.G_ROWSET_HANDLER_PLSQL_DELETE   
                                         );
  COMMIT;
END;
/
