Rem drv: <create type="type_bodys" pos="ecm/ecm_type_bodies.sql+"/>
Rem
Rem $Header: policy_type_bodys.sql 01-jul-2005.22:37:45 gsbhatia Exp $
Rem
Rem policy_type_bodys.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      policy_type_bodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    jsadras     02/08/05 - bug4169776
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    12/02/04 - Add clear message and clear_message_nlsid 
Rem    rpinnama    11/18/04 - Add condition_operator at key_value level 
Rem    rpinnama    09/23/04 - Add prevent_override.sql 
Rem    rpinnama    09/08/04 - Default key_value to % and has_wildcard to 1 
Rem    rpinnama    08/26/04 - Add MGMT_POLICY_KEY_COL_COND and 
Rem                           MGMT_POLICY_KEY_COL_COND_ARRAY types 
Rem    groyal      08/20/04 - Default for p_url_link_type should be 0 
Rem    rpinnama    08/19/04 - Add is_push attribute 
Rem    rpinnama    08/11/04 - Change default simult_actions to 1 
Rem    rpinnama    06/21/04 - rpinnama_monitor_policy_repository_modifications
Rem    rpinnama    06/17/04 - Created
Rem

CREATE OR REPLACE TYPE BODY MGMT_POLICY_PARAM_DEF AS
    -- Constructs a new MGMT_POLICY_PARAM_DEF object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_param_name       IN VARCHAR2,
        p_param_name_nlsid IN VARCHAR2 DEFAULT NULL,
        p_param_type       IN NUMBER DEFAULT 0
      ) 
    RETURN MGMT_POLICY_PARAM_DEF AS
    BEGIN
      RETURN MGMT_POLICY_PARAM_DEF(p_param_name, p_param_name_nlsid, 
          p_param_type);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_POLICY_PARAM_VAL AS
    -- Constructs a new MGMT_POLICY_PARAM_VAL object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_param_name     IN VARCHAR2,
        p_crit_threshold IN VARCHAR2 DEFAULT NULL,
        p_warn_threshold IN VARCHAR2 DEFAULT NULL,
        p_info_threshold IN VARCHAR2 DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_PARAM_VAL AS
    BEGIN
      RETURN MGMT_POLICY_PARAM_VAL(p_param_name, p_crit_threshold, 
          p_warn_threshold, p_info_threshold);
    END NEW;
END;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_VIOL_CTXT_DEF AS
    -- Constructs a new MGMT_VIOL_CTXT_DEF object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW(
        p_metric_column     IN VARCHAR2,
        p_is_hidden         IN NUMBER DEFAULT 0,
        p_url_link_template IN VARCHAR2 DEFAULT NULL,
        p_url_link_type     IN NUMBER DEFAULT 0
      )
    RETURN MGMT_VIOL_CTXT_DEF AS
    BEGIN
      RETURN MGMT_VIOL_CTXT_DEF(p_metric_column, p_is_hidden, 
          p_url_link_template, p_url_link_type);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY MGMT_POLICY_KEY_COL_COND AS
    -- Constructs a new MGMT_POLICY_KEY_COL_COND object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_key_value       IN VARCHAR2 DEFAULT '%',
        p_has_wildcard    IN NUMBER   DEFAULT 1,
        p_key_column_name IN VARCHAR2 DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_KEY_COL_COND AS
    BEGIN
      RETURN MGMT_POLICY_KEY_COL_COND(p_key_value, p_has_wildcard, p_key_column_name);
    END NEW;
END;
/
show errors


CREATE OR REPLACE TYPE BODY MGMT_POLICY_KEY_VAL AS
    -- Constructs a new MGMT_POLICY_KEY_VAL object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW(
        p_key_value        IN MGMT_POLICY_KEY_COL_COND_ARRAY DEFAULT NULL,
        p_is_exception     IN NUMBER DEFAULT 0,
        p_prevent_override IN NUMBER DEFAULT 0,
        p_crit_job_name    IN VARCHAR2 DEFAULT ' ',
        p_warn_job_name    IN VARCHAR2 DEFAULT ' ',
        p_info_job_name    IN VARCHAR2 DEFAULT ' ',
        p_agent_fixit      IN VARCHAR2 DEFAULT ' ',
        p_simult_actions   IN NUMBER DEFAULT 1,
        p_importance       IN NUMBER DEFAULT NULL,
        p_num_occurrences  IN NUMBER DEFAULT 1,
	p_is_push          IN NUMBER   DEFAULT 0,
	p_condition_operator IN NUMBER DEFAULT NULL,
	p_message          IN VARCHAR2 DEFAULT NULL,
	p_message_nlsid    IN VARCHAR2 DEFAULT NULL,
	p_clear_message    IN VARCHAR2 DEFAULT NULL,
	p_clear_message_nlsid IN VARCHAR2 DEFAULT NULL,
        p_param_values     IN MGMT_POLICY_PARAM_VAL_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_KEY_VAL AS
    BEGIN
      RETURN MGMT_POLICY_KEY_VAL(
          p_key_value, p_is_exception, p_prevent_override,
          p_crit_job_name, p_warn_job_name, p_info_job_name,
          p_agent_fixit, p_simult_actions, p_importance,
          p_num_occurrences, p_is_push, p_condition_operator, 
	  p_message, p_message_nlsid, p_clear_message, p_clear_message_nlsid, 
	  p_param_values);
    END NEW;
END;
/
show errors

