Rem drv: <create type="pkgdefs" pos="notification/notification_ui_pkgdef.sql+"/>
Rem
Rem $Header: preferences_pkgdefs.sql 01-jul-2005.17:22:48 gsbhatia Exp $
Rem
Rem preferences_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dtsao       12/27/04 - Add name & type columns 
Rem    mfidanbo    12/07/04 - website table customization changes 
Rem    jpyang      11/05/04 - add group member type column 
Rem    asawant     09/27/04 - Adding constants for well known subtabs 
Rem    rpatti      09/16/02 - resurrecting create_folders
Rem    rpatti      09/12/02 - support custom folders
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    rpatti      02/25/02 - use function to get current user
Rem    ancheng     02/05/02 - modify query
Rem    ancheng     02/01/02 - fix duplicate
Rem    ancheng     01/25/02 - fix get_folders_info
Rem    ancheng     01/23/02 - Merged ancheng_folder_git3
Rem    ancheng     01/22/02 - Created
Rem

CREATE OR REPLACE PACKAGE emd_pref AS

TYPE CURSOR_TYPE IS REF CURSOR;

-- Constants used to store the types of columns stored in 
-- mgmt_user_subtab_col_prefs
MGMT_USER_PREF_METRIC_COL_TP    CONSTANT NUMBER(1) := 0;
MGMT_USER_PREF_PROPERTY_COL_TP  CONSTANT NUMBER(1) := 1;
MGMT_USER_PREF_GENERIC_COL_TP   CONSTANT NUMBER(1) := 2;

-- Constants used to store prefs for subtabs
MGMT_USER_PREF_ALL_TARGETS      CONSTANT VARCHAR2(20) := 'All Targets';
MGMT_USER_PREF_GROUPS           CONSTANT VARCHAR2(20) := 'Groups';
MGMT_USER_PREF_DATABASES        CONSTANT VARCHAR2(20) := 'Databases';
MGMT_USER_PREF_APPSERVER        CONSTANT VARCHAR2(20) := 'applicationServers';
MGMT_USER_PREF_WEBAPPS          CONSTANT VARCHAR2(20) := 'Web Applications';
MGMT_USER_PREF_SYSTEMS          CONSTANT VARCHAR2(20) := 'Systems';
MGMT_USER_PREF_SERVICES         CONSTANT VARCHAR2(20) := 'Services';

-- Constants used to refer to the generic columns in subtabs (if modifying
-- these values, please update their java counterparts)
MGMT_USER_PREF_AVAIL_COL           CONSTANT VARCHAR2(20) := 'availability';
MGMT_USER_PREF_STATUS_COLUMN       CONSTANT VARCHAR2(20) := 'status';
MGMT_USER_PREF_ALERTS_COL          CONSTANT VARCHAR2(20) := 'alerts';
MGMT_USER_PREF_NAME_COL            CONSTANT VARCHAR2(20) := 'targetName';
MGMT_USER_PREF_TYPE_COL            CONSTANT VARCHAR2(20) := 'typeName';
MGMT_USER_PREF_POL_VIOL_COL        CONSTANT VARCHAR2(20) := 'policyviolation';
MGMT_USER_PREF_POL_COMP_COLUMN     CONSTANT VARCHAR2(20) := 'policycompliance';
MGMT_USER_PREF_PERF_ALRTS_COL      CONSTANT VARCHAR2(20) := 'perfAlertsColumn';
MGMT_USER_PREF_USAGE_ALRTS_COL     CONSTANT VARCHAR2(20) := 'usageAlertsColumn';
MGMT_USER_PREF_SYS_KEY_CMP_COL     CONSTANT VARCHAR2(20) := 'systemkeycompnts';
MGMT_USER_PREF_SYS_TESTS_COL       CONSTANT VARCHAR2(20) := 'systemkeytests';
MGMT_USER_PREF_MNTRG_BCNS_COL      CONSTANT VARCHAR2(20) := 'monitoringbcns';
MGMT_USER_PREF_GRP_MEM_COL         CONSTANT VARCHAR2(20) := 'grpMemberTypes';

--
-- Name: get_folders_info
--
-- Package: emd_pref
--
-- Purpose: 
--  Get folder related info
--
-- IN parameters:
--   show_avail_group_tgts_in: NUMBER
--                             If 1, will also return the group targets 
--                             that are visible to the user but not in the 
--                             mgmt_user_folders yet.
--                             If 0, will not return these group targets
-- OUT parameters:
--   folders_cur_out: CURSORTYPE
--                    The cursor containing folder related info.
PROCEDURE get_folders_info(show_avail_group_tgts_in IN NUMBER,
                           folders_cur_out OUT CURSOR_TYPE);

--
-- Name: set_folders_info
--
-- Package: emd_pref
--
-- Purpose: 
--  Set folder related info
--
-- IN parameters:
--   folders_array_in: MGMT_FOLDER_ARRAY
--                     The array containing folder related info.
-- OUT parameters:
--
PROCEDURE set_folders_info(folders_array_in IN MGMT_FOLDER_ARRAY);

--
-- Name: manage_user_folders
--
-- Package: emd_pref
--
-- Purpose: 
--  manager folder related info - called as a call back when a user is 
--  created/dropped
--
-- IN parameters:
--   user_name_in: VARCHAR2
--                 The user name for whom the folders are created
--   type_in: NUMBER
--            MGMT_USER.USER_CREATED_CALLBACK when user is being created
--            MGMT_USER.USER_DROPPED_CALLBACK when user is being dropped
-- OUT parameters:
--
PROCEDURE manage_user_folders(user_name_in IN VARCHAR2,
                              type_in      IN NUMBER);

END emd_pref;
/

SHOW ERRORS;

