Rem drv: <create type="post_creation" params="EM_REPOS_USER" pos="purge/purge_post_creation.sql-"/>
Rem
Rem $Header: preferences_post_creation.sql 24-aug-2005.10:42:57 paachary Exp $
Rem
Rem preferences_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    08/24/05 - Moved the scripts creating default (generic) columns for 
Rem                           Folder types to v102010/preferences_post_creation.sql
Rem                           Refer Bug 4567891.
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    dtsao       04/25/05 - Add member column to system folder 
Rem    dtsao       03/14/05 - Remove Status Column in group folder 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    mfidanbo    12/22/04 - remove the policies column 
Rem    mfidanbo    12/07/04 - add website cols 
Rem    jpyang      11/05/04 - add group member type column 
Rem    jpyang      11/02/04 - add availability column for group folder 
Rem    rzazueta    11/01/04 - Add EM_REPOS_USER parameter 
Rem    asawant     09/27/04 - Adding prefs for generic tabs (i.e. all_tgts and 
Rem                           groups) 
Rem    rpatti      09/16/02 - rpatti_fix_mgmt_rep_folders
Rem    rpatti      09/16/02 - fix
Rem    rpatti      09/16/02 - Created
Rem

Rem 
Rem This script requires the following arguments
Rem  1. Name of the repository user
Rem 
DEFINE EM_REPOS_USER           = "&1"

-- add a call back so that after a user is created/dropped - this method
--  is called to provide the user with default folders/clean up the folders data
BEGIN
  mgmt_user.add_callback('emd_pref.manage_user_folders', MGMT_USER.USER_CREATED_CALLBACK);
  mgmt_user.add_callback('emd_pref.manage_user_folders', MGMT_USER.USER_DROPPED_CALLBACK);

  COMMIT;
END;
/
--
--
-- Create folders for MGMT_REP
-- by simulating a call back when user is created
BEGIN
  emd_pref.manage_user_folders('&EM_REPOS_USER', MGMT_USER.USER_CREATED_CALLBACK);
  COMMIT;
END;
/

-- Making a call to v102010/preferences_post_creation.sql for 
-- Inserting default / generic columns to folder tabs (Groups, Systems etc).
@&EM_SQL_ROOT/core/v102010/preferences_post_creation.sql
