Rem drv: <create type="tables"/>
Rem
Rem $Header: preferences_tables.sql 14-jul-2005.18:35:30 jpyang Exp $
Rem
Rem preferences_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jpyang      07/14/05 - increase display_order column 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    lgloyd      03/23/05 - remove portlets 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    asawant     09/13/04 - Adding columns to mgmt_user_type_metric_prefs 
Rem    gan         08/20/04 - add monitoring 
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem  PURPOSE AND OTHER RELEVAN REMARKS
rem
rem       The MGMT_USER_SUBTAB_COL_PREFS table holds the list of 
rem     columns that a user chooses to see for a given sub tab. The primary
rem     key is composed of the user_name, subtab_name, and display_order (which
rem     also reflects the access pattern and thus a good index). The column
rem     identifier may be stored in either column_id_guid or column_id, which
rem     allows integrators the flexibility of storing either data type. It is
rem     illegal (though not enforced automatically) to populate both identifier
rem     columns in the same row (one should be NULL).
rem       This table replaces the earlier MGMT_USER_TYPE_METRIC_PREFS. A view
rem     with the same name as the earlier table has been added for integrator
rem     backward compatability.
rem     
rem
rem  COLUMNS
rem
rem     USER_NAME         - the name of the user that owns the preference.
rem                         A "*" is used to store the default preferences
rem                         for all users.
rem
rem     SUBTAB_NAME       - the name of the subtab the prefs apply to.
rem
rem     DISPLAY_ORDER     - the order in which a given metric is shown in 
rem                         the UI.
rem
rem     COLUMN_ID_GUID    - the column identifier when using GUIDs for 
rem                         colum_id (e.g. metric_guid). When this is used
rem                         the column_id SHOULD BE NULL.
rem
rem     COLUMN_ID         - the column identifier when not using GUIDs for
rem                         column_id (e.g. property names, generic columns).
rem                         When this is used, the column_id_guid SHOULD BE
rem                         NULL.
rem
rem     COLUMN_TYPE       - the column type stored. Sub-Folder owners using
rem                         this table may overwrite with their own codes here.
rem                         The following are the codes used by the framework:
rem                              0 - metric_guid
rem                              1 - properties
rem                              2 - generic columns (e.g. "policy violations")
rem
rem  NOTES
rem

CREATE TABLE MGMT_USER_SUBTAB_COL_PREFS
    (user_name          VARCHAR2(256)   NOT NULL,
     subtab_name        VARCHAR2(64)   NOT NULL,
     display_order      NUMBER(3) DEFAULT 0 NOT NULL,
     column_id_guid     RAW(16) DEFAULT NULL,
     column_id          VARCHAR2(256) DEFAULT NULL,
     column_type        NUMBER(1) DEFAULT 0 NOT NULL)
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_USER_FOLDERS table holds the list of folder preferences 
rem     for a user.
rem
rem  COLUMNS
rem
rem     USER_NAME         - the name of the user that owns the preference.
rem
rem     FOLDER_NAME       - the internal folder name
rem
rem     DISPLAY_ORDER     - the UI display order for the given folder
rem
rem     TARGET_GUID       - if the folder is user-defined, then this is the 
rem                         target guid of the group target
rem                         else it's NULL for system folders.
rem
rem  NOTES
rem

CREATE TABLE MGMT_USER_FOLDERS
    (user_name          VARCHAR2(256)   NOT NULL,
     folder_name        VARCHAR2(256)   NOT NULL,
     display_order      NUMBER(2) DEFAULT 0,
     target_guid        RAW(16)  )
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_USER_PREFERENCES table holds the list of user preferences
rem
rem  COLUMNS
rem
rem     USER_NAME         - the name of the user that owns the preference.
rem
rem     PREFERENCE_NAME   - the name of the user preference.
rem
rem     PREFERENCE_VALUE  - the value of the user preference.
rem
rem     ADDITIONAL_VALUE   - an optional additional value of the user
rem                          preference.
rem
rem  NOTES
rem

CREATE TABLE MGMT_USER_PREFERENCES
    (user_name          VARCHAR2(256)   NOT NULL,
     preference_name    VARCHAR2(512)   NOT NULL,
     preference_value   VARCHAR2(4000)  NOT NULL,
     additional_value   VARCHAR2(2048)  )
  MONITORING;



