Rem drv: <create type="views" pos="basic/basic_views.sql+"/>
Rem
Rem $Header: preferences_views.sql 01-jul-2005.18:43:35 gsbhatia Exp $
Rem
Rem preferences_views.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_views.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    asawant     10/09/04 - asawant_sub_tab_pref
Rem    asawant     09/27/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

rem
rem  PURPOSE
rem
rem     This view supports the depracated table of the same name. Consumers
rem  of this view MAY NOT consume directly the base table or its functionality
rem  without cutting over all their code to directly access the base table.
rem  Failing to do so might result in unexpected and unsupported behavior (since
rem  the display_order returned by this view in such usage will be sparse and 
rem  not continuos).
rem     The MGMT_USER_TYPE_METRIC_PREFS view holds the list of 
rem       metrics that a user chooses to see in the dense UI for a given
rem       target type.
rem
rem  COLUMNS
rem
rem     USER_NAME         - the name of the user that owns the preference.
rem
rem     TARGET_TYPE       - the target type
rem
rem     METRIC_GUID       - the guid of a given metric of a target type
rem
rem     DISPLAY_ORDER     -  the order in which a given metric is shown in 
rem                          the UI.

CREATE OR REPLACE VIEW MGMT_USER_TYPE_METRIC_PREFS
    (user_name, target_type, metric_guid, display_order)
  AS
    SELECT user_name, subtab_name, column_id_guid, 1 + display_order - 
           MIN(display_order) OVER (PARTITION BY subtab_name, user_name) AS
           "display_order"
      FROM MGMT_USER_SUBTAB_COL_PREFS
     WHERE column_type = 0;

