Rem drv: <create type="pkgdefs" pos="credentials/credentials_pkgdef.sql+"/>
Rem
Rem $Header: properties_pkgdef.sql 01-jul-2005.17:28:30 gsbhatia Exp $
Rem
Rem properties_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      properties_pkgdef.sql - Properties Package Definition
Rem
Rem    DESCRIPTION
Rem      Contains the internal (accessible to EM system components only) API
Rem    to the properties manipulation functionality.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    jsadras     05/20/05 - target property change callback 
Rem    jpyang      05/26/05 - prefix nlsid with em__sys__ 
Rem    asawant     02/09/05 - Add rowset handler. 
Rem    asawant     11/10/04 - Add propagate. 
Rem    asawant     09/29/04 - Adding defs for various constants. 
Rem    asawant     08/06/04 - asawant_udtp_063004
Rem    asawant     06/05/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_properties AS

TYPE t_cursor_type IS REF CURSOR;

E_UNAUTHORIZED EXCEPTION;

E_INVALID_TYPE EXCEPTION;

E_SYS_PROP_EXISTS EXCEPTION;

E_INVALID_PARAMS EXCEPTION;

-- This is the name that is registered with the logging system
PROPERTIES_MODULE CONSTANT VARCHAR2(20) := 'MGMT_PROPERTIES';
INSTANCE CONSTANT VARCHAR2(15) := 'INSTANCE';

-- Size of MGMT_SYSTEM_ERROR_LOG.error_msg
MAX_ERR_MSG_SZ    CONSTANT NUMBER(4) := 2048;

--------------------------------------------------------------------------------
PROCEDURE add_user_target_property(
     p_property_name          IN MGMT_TARGET_PROP_DEFS.property_name%TYPE,
     p_target_type_list       IN SMP_EMD_STRING_ARRAY,
     p_property_display_name  IN 
       MGMT_TARGET_PROP_DEFS.property_display_name%TYPE DEFAULT NULL,
     p_property_display_nlsid IN 
       MGMT_TARGET_PROP_DEFS.property_display_nlsid%TYPE DEFAULT NULL,
     p_default_value          IN 
       MGMT_TARGET_PROP_DEFS.default_value%TYPE DEFAULT NULL,
     p_computed_flag          IN 
       MGMT_TARGET_PROP_DEFS.computed_flag%TYPE DEFAULT 0,
     p_credential_flag        IN 
       MGMT_TARGET_PROP_DEFS.credential_flag%TYPE DEFAULT 0,
     p_required_flag          IN 
       MGMT_TARGET_PROP_DEFS.required_flag%TYPE DEFAULT 0,
     p_read_only_flag         IN 
       MGMT_TARGET_PROP_DEFS.read_only_flag%TYPE DEFAULT 0,
     p_hidden_flag            IN 
       MGMT_TARGET_PROP_DEFS.hidden_flag%TYPE DEFAULT 0);

--------------------------------------------------------------------------------
PROCEDURE add_sys_target_property(
     p_property_name          IN MGMT_TARGET_PROP_DEFS.property_name%TYPE,
     p_target_type_list       IN SMP_EMD_STRING_ARRAY,
     p_property_display_name  IN 
       MGMT_TARGET_PROP_DEFS.property_display_name%TYPE DEFAULT NULL,
     p_property_display_nlsid IN 
       MGMT_TARGET_PROP_DEFS.property_display_nlsid%TYPE DEFAULT NULL,
     p_default_value          IN 
       MGMT_TARGET_PROP_DEFS.default_value%TYPE DEFAULT NULL,
     p_computed_flag          IN 
       MGMT_TARGET_PROP_DEFS.computed_flag%TYPE DEFAULT 0,
     p_credential_flag        IN 
       MGMT_TARGET_PROP_DEFS.credential_flag%TYPE DEFAULT 0,
     p_required_flag          IN 
       MGMT_TARGET_PROP_DEFS.required_flag%TYPE DEFAULT 0,
     p_read_only_flag         IN 
       MGMT_TARGET_PROP_DEFS.read_only_flag%TYPE DEFAULT 0,
     p_hidden_flag            IN 
       MGMT_TARGET_PROP_DEFS.hidden_flag%TYPE DEFAULT 0);

--------------------------------------------------------------------------------
PROCEDURE propagate_target_properties(
     p_target_type   IN mgmt_target_type_versions.target_type%TYPE,
     p_type_meta_ver IN mgmt_target_type_versions.type_meta_ver%TYPE);

--------------------------------------------------------------------------------
PROCEDURE set_target_property(
     p_target_name    IN mgmt_targets.target_name%TYPE,
     p_target_type    IN mgmt_targets.target_type%TYPE,
     p_property_name  IN mgmt_target_properties.property_name%TYPE,
     p_property_type  IN mgmt_target_properties.property_type%TYPE,
     p_property_value IN mgmt_target_properties.property_value%TYPE);

--------------------------------------------------------------------------------
PROCEDURE set_target_properties(
     p_target_name    IN mgmt_targets.target_name%TYPE,
     p_target_type    IN mgmt_targets.target_type%TYPE,
     p_properties         IN MGMT_TARGET_PROPERTY_LIST);

--------------------------------------------------------------------------------
PROCEDURE handle_mgmt_tgt_props(
     p_target_guid      IN mgmt_target_properties.target_guid%TYPE
                           DEFAULT NULL,
     p_property_name    IN mgmt_target_properties.property_name%TYPE,
     p_property_type    IN mgmt_target_properties.property_type%TYPE 
                           DEFAULT mgmt_properties.INSTANCE,
     p_property_value   IN mgmt_target_properties.property_value%TYPE
                           DEFAULT ' ');

--------------------------------------------------------------------------------
-- Property change callback registration and execution functions
-- these functions are called whenever a target property of interest
-- changes.
-- For example: if a procedure db_util.handle_property_change is to be called
-- whenever the db_version property of a database changes to 10.2.0.0
-- add_property_change_callback('db_util.handle_target_property_change',
--                              'oracle_database',
--                              'db_version',
--                              '10.2.0.0') ;
-- whenever a DB target (target_guid=DB1) is upgraded and 
-- its version changes to 10.2.0.0
-- the registered procedure will be called with the parameters
-- db_util.handle_target_property_change('DB1','db_version','9.2.0','10.2.0.0');
-- if the new version is not important, it need not be passed
-- in which case the callback will be called whenever db_version changes
-- if the callback needs to be executed for all property changes for a target
-- type, it need not be passed
--------------------------------------------------------------------------------
PROCEDURE add_property_change_callback
            (p_procedure_name     IN mgmt_callbacks.callback_name%TYPE,
             p_target_type        IN mgmt_callbacks.selector_1%TYPE := '%',
             p_property_name      IN mgmt_callbacks.selector_2%TYPE := '%',
             p_new_property_value IN mgmt_callbacks.selector_3%TYPE := '%',
             p_eval_order         IN mgmt_callbacks.eval_order%TYPE := 0) ;
--------------------------------------------------------------------------------
PROCEDURE del_property_change_callback
            (p_procedure_name     IN mgmt_callbacks.callback_name%TYPE,
             p_target_type        IN mgmt_callbacks.selector_1%TYPE := '%',
             p_property_name      IN mgmt_callbacks.selector_2%TYPE := '%',
             p_new_property_value IN mgmt_callbacks.selector_3%TYPE := '%'
            ) ;
--------------------------------------------------------------------------------
PROCEDURE exec_property_change_callbacks
            (p_target_guid        IN mgmt_targets.target_guid%TYPE,
             p_property_name      IN mgmt_callbacks.selector_1%TYPE,
             p_old_property_value IN mgmt_callbacks.selector_2%TYPE,
             p_new_property_value IN mgmt_callbacks.selector_3%TYPE) ;

--------------------------------------------------------------------------------
-- DO NOT CALL DIRECTLY, INSTEAD CALL ONE OF THE ABOVE
-- Only made public for automated testing.
PROCEDURE add_target_property(
  p_property_name          IN MGMT_TARGET_PROP_DEFS.property_name%TYPE,
  p_property_type          IN MGMT_TARGET_PROP_DEFS.property_type%TYPE,
  p_system_flag            IN MGMT_TARGET_PROP_DEFS.system_flag%TYPE,
  p_credential_flag        IN MGMT_TARGET_PROP_DEFS.credential_flag%TYPE,
  p_required_flag          IN MGMT_TARGET_PROP_DEFS.required_flag%TYPE,
  p_computed_flag          IN MGMT_TARGET_PROP_DEFS.computed_flag%TYPE,
  p_read_only_flag         IN MGMT_TARGET_PROP_DEFS.read_only_flag%TYPE,
  p_hidden_flag            IN MGMT_TARGET_PROP_DEFS.hidden_flag%TYPE,
  p_default_value          IN MGMT_TARGET_PROP_DEFS.default_value%TYPE,
  p_property_display_name  IN MGMT_TARGET_PROP_DEFS.property_display_name%TYPE,
  p_property_display_nlsid IN MGMT_TARGET_PROP_DEFS.property_display_nlsid%TYPE,
  p_target_type_list       IN SMP_EMD_STRING_ARRAY);


-- The prefix used for all system defined property names
DEFAULT_SYS_PREFIX         CONSTANT VARCHAR2(10) := 'orcl_';

-- The prefix used for all user defined property names
DEFAULT_USR_PREFIX         CONSTANT VARCHAR2(10) := 'udtp_';

-- The definitions pertaining various global properties

-- Property name for various properties
-- If modifying these, please update the post creation and their Java
-- counterparts in TgtSrch
ORCL_GTP_DEPLOYMENT_TYPE   CONSTANT VARCHAR2(25) :=
  DEFAULT_SYS_PREFIX || 'gtp_deployment_type';
ORCL_GTP_CONTACT           CONSTANT VARCHAR2(25) :=
  DEFAULT_SYS_PREFIX || 'gtp_contact';
ORCL_GTP_LOCATION          CONSTANT VARCHAR2(25) :=
  DEFAULT_SYS_PREFIX || 'gtp_location';
ORCL_GTP_LINE_OF_BUS       CONSTANT VARCHAR2(25) :=
  DEFAULT_SYS_PREFIX || 'gtp_line_of_bus';
ORCL_GTP_COMMENT           CONSTANT VARCHAR2(25) :=
  DEFAULT_SYS_PREFIX || 'gtp_comment';

-- Property NLSIDs for the properties defined above
-- If modifying these, please update Java their counterparts in the
-- OracleGenericMsg bundle.
GTP_DEPLOYMENT_TYPE        CONSTANT VARCHAR2(25) :=
  MGMT_GLOBAL.G_EM_SYS_PREFIX || 'GTP_DEPLOY_TYPE';
GTP_CONTACT                CONSTANT VARCHAR2(25) :=
  MGMT_GLOBAL.G_EM_SYS_PREFIX || 'GTP_CONTACT';
GTP_LOCATION               CONSTANT VARCHAR2(25) :=
  MGMT_GLOBAL.G_EM_SYS_PREFIX || 'GTP_LOCATION';
GTP_LINE_OF_BUS            CONSTANT VARCHAR2(25) :=
  MGMT_GLOBAL.G_EM_SYS_PREFIX || 'GTP_LINE_OF_BUS';
GTP_COMMENT                CONSTANT VARCHAR2(25) :=
  MGMT_GLOBAL.G_EM_SYS_PREFIX || 'GTP_COMMENT';

END mgmt_properties;
/
SHOW ERRORS;


