Rem drv: <create type="pkgdefs" pos="system/system_pkgdef.sql+"/>
Rem
Rem $Header: provision_pkgdef.sql 10-aug-2007.07:56:24 saurgarg Exp $
Rem
Rem provision_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      provision_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saurgarg    08/10/07 - Adding purge_prov_collection definition for purging
Rem                           the table entries in mgmt_prov_collection table
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    rkaggarw    05/26/05 - Added assignment_subtype 
Rem    rmadampa    05/08/05 - add cluster insert proc 
Rem    pshroff     04/30/05 - adding propertyDict to assignment table 
Rem    rmadampa    04/27/05 - data model enhancements 1 
Rem    ashwikum    04/15/05 - Removing def of net config related stored 
Rem                           procedure 
Rem    pshroff     03/16/05 - to fix issues in bug#4221658 
Rem    ashwikum    02/24/05 - Functions for net config value generator 
Rem    pshroff     02/01/05 - adding label/desciption field for assignment 
Rem    prayarot    12/12/04 - To add Default Image function 
Rem    pshroff     11/29/04 - adding assignmenttype param in assignment 
Rem    pshroff     11/02/04 - Modified insert methods 
Rem    pshroff     10/26/04 - Modified PRELOAD_PROC as per review comments
Rem    pshroff     10/18/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE  PACKAGE "SYSMAN"."MGMT_PROVISION" AS

G_TARGET_GUID CONSTANT VARCHAR2(11) := 'TARGET_GUID';

FUNCTION insert_provision_hw_table (
    p_status              IN VARCHAR2,
	p_hostname            IN VARCHAR2,
	p_macaddr1            IN VARCHAR2,
	p_macaddr2            IN VARCHAR2,
	p_macaddr3            IN VARCHAR2,
	p_macaddr4            IN VARCHAR2,
    p_interfacename1      IN VARCHAR2,
 	p_interfacename2      IN VARCHAR2,
 	p_interfacename3      IN VARCHAR2,
 	p_interfacename4      IN VARCHAR2,
	p_target_type         IN VARCHAR2,
	p_name                IN VARCHAR2 DEFAULT NULL,
	p_desc                IN VARCHAR2 DEFAULT NULL
) RETURN VARCHAR2;

FUNCTION insert_provision_cluster_table (
    p_status        IN VARCHAR2,
    p_name          IN VARCHAR2,
    p_desc          IN VARCHAR2 DEFAULT NULL,
    p_target_type   IN VARCHAR2,
    p_imageUrn      IN VARCHAR2
) RETURN VARCHAR2;

FUNCTION insert_provision_si_table (
    p_status        IN VARCHAR2,
    p_name          IN VARCHAR2,
    p_desc          IN VARCHAR2 DEFAULT NULL,
    p_target_type   IN VARCHAR2,
    p_imageUrn      IN VARCHAR2
) RETURN VARCHAR2;


FUNCTION insert_provision_op_table (
    p_optype          IN VARCHAR2,
    p_statusmsg       IN VARCHAR2,
    p_jobid           IN VARCHAR2
) RETURN VARCHAR2;


PROCEDURE   insert_provision_history_table (
    p_tgt_guid        IN VARCHAR2,
    p_op_guid         IN VARCHAR2,
    p_assignment_guid IN VARCHAR2,
    p_hostname        IN VARCHAR2 DEFAULT NULL
) ;


FUNCTION insert_provision_assign_table (
    p_name                     IN VARCHAR2,
    p_description              IN VARCHAR2,
    p_status                   IN VARCHAR2,
    p_type                     IN VARCHAR2,
    p_subtype                  IN VARCHAR2,
    p_username                 IN VARCHAR2,
    p_stage_urn                IN VARCHAR2,
    p_comp_urn                 IN VARCHAR2,
    p_network_urn              IN VARCHAR2,
    p_boot_server_urn          IN VARCHAR2,
    p_starttime                IN TIMESTAMP WITH TIME ZONE,
    p_stage_username           IN VARCHAR2,
    p_stage_password           IN VARCHAR2,
    p_configuration_properties IN MGMT_PROV_ASSIGNMENT.PROPERTIES%TYPE,
    p_suite_guid               IN VARCHAR2,
    p_dependent_on_assignment  IN VARCHAR2,
    p_target_reset_time        IN NUMBER
) RETURN VARCHAR2;


FUNCTION insert_prov_default_img_table (
    p_ip_addr_prefix  IN MGMT_PROV_DEFAULT_IMAGE.IP_ADDRESS_PREFIX%TYPE,
    p_name            IN MGMT_PROV_DEFAULT_IMAGE.NAME%TYPE DEFAULT NULL,
    p_desc            IN MGMT_PROV_DEFAULT_IMAGE.DESCRIPTION%TYPE DEFAULT NULL
) RETURN VARCHAR2;


PROCEDURE call_provision_job (
     p_hostname IN VARCHAR2
);


PROCEDURE preload_callback (
    v_input IN SMP_EMD_NVPAIR_ARRAY,
    v_preLoadOutput OUT SMP_EMD_NVPAIR_ARRAY
); 

PROCEDURE PURGE_PROV_COLLECTION( pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

END MGMT_PROVISION;
/


show errors;
