Rem drv: <create type="post_creation" />
Rem
Rem $Header: provision_post_creation.sql 10-aug-2007.07:57:09 saurgarg Exp $
Rem
Rem provision_post_creation.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      provision_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saurgarg    08/10/07  - registering purge_prov_collection with em_purge
Rem                            for purging the table entries in
Rem                            mgmt_prov_collection table
Rem    rattipal    12/04/05  - Backport rattipal_damtr from main 
Rem    rattipal    11/17/05  - Fix 4627280 
Rem    pshroff     07/28/05 -  addd rep manager header 
Rem    neearora    07/25/05 - neearora_bug-4500972
Rem    neearora    07/22/05 - Created
Rem

rem
rem Register valid preLoad and postLoad callbacks.
rem
BEGIN
  MGMT_LOADER.register_pre_load_callback('MGMT_PROVISION.PRELOAD_CALLBACK');
 
END;
/

BEGIN
  EM_PURGE.add_purge_policy('MGMT_PROV_COLLECTION_PURGE',
                             EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'MGMT_PROVISION.PURGE_PROV_COLLECTION',
                            24,
                            NULL, -- No rollup procedure
                            'Purge policy for prov collection data',
                            EM_PURGE.G_RETENTION_GROUP_SYSTEM,
                            EM_PURGE.G_POLICY_EXEC_GROUP_DEFAULT,
                            EM_PURGE.G_POLICY_NOT_CONFIGURABLE
                            );
END ;
/

CREATE OR REPLACE VIEW mgmt_provision_asn_hw_search2
AS 
SELECT 
    hw.hw_guid, hw.hostname, hw.new_hostname, hw.purpose, hw.serial_number, 
    hw.name, hw.description, tgt.current_asn_guid, 
    tgt.component_urn, tgt.network_urn, tgt.status, asntgt.status as prov_status,
    summ.system_config, summ.mem, cpu.freq_in_mhz as freq, summ.cpu_count
FROM 
    mgmt_prov_hardware hw, mgmt_prov_tgt_status tgt, 
    mgmt_prov_asn_targets asntgt, mgmt$os_hw_summary summ, ecm$cpu_details cpu
WHERE 
   tgt.current_asn_guid !=  ' '
AND 
    hw.hw_guid = asntgt.prov_tgt_guid 
AND
    tgt.prov_tgt_guid = asntgt.prov_tgt_guid
AND 
    (tgt.current_asn_guid = asntgt.assignment_guid)
AND
    summ.host_name = hw.hostname 
AND 
    tgt.prov_target_type = 'hw'
AND
   cpu.ecm_snapshot_id =summ.snapshot_guid
UNION
SELECT 
    hw.hw_guid, hw.hostname, hw.new_hostname, hw.purpose, hw.serial_number, 
    hw.name, hw.description, tgt.current_asn_guid, 
    tgt.component_urn, tgt.network_urn, tgt.status, 'STATE_Provisioned' as prov_status,
    summ.system_config, summ.mem, cpu.freq_in_mhz as freq, summ.cpu_count
FROM 
    mgmt_prov_hardware hw, mgmt_prov_tgt_status tgt, mgmt$os_hw_summary summ, ecm$cpu_details cpu
WHERE 
    hw.hw_guid = tgt.prov_tgt_guid 
AND 
    decode(rawtohex(tgt.current_asn_guid), '', 'EMPTY') = 'EMPTY' 
AND
    summ.host_name = hw.hostname 
AND 
    tgt.prov_target_type = 'hw'
AND
   cpu.ecm_snapshot_id =summ.snapshot_guid
WITH READ ONLY;

commit;
show errors;
