Rem drv: <create type="pkgdefs" pos="ping/ping_pkgdefs.sql+"/>
Rem
Rem $Header: purge_pkgdefs.sql 08-jul-2005.09:50:55 scgrover Exp $
Rem
Rem purge_pkgdefs.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      purge_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rzazueta    10/29/03 - Add procedures for detailed logging 
Rem    rpinnama    09/08/03 - rpinnama_purge_policies 
Rem    rpinnama    09/08/03 - 
Rem    rpinnama    09/07/03 - 
Rem    rpinnama    09/05/03 - 
Rem    rpinnama    08/28/03 - Created
Rem

CREATE OR REPLACE PACKAGE EM_PURGE AS

  ---------------------------------------------------------
  -- Package Variables
  ---------------------------------------------------------
  debug_enabled BOOLEAN := FALSE;

  ---------------------------------------------------------
  -- Package Constants
  ---------------------------------------------------------
  G_MODULE_NAME        CONSTANT VARCHAR2(32) := 'PURGE_POLICIES';

  -- Types of purge policies
  G_POLICY_TYPE_TARGET CONSTANT NUMBER(1) := 1;
  G_POLICY_TYPE_SYSTEM CONSTANT NUMBER(1) := 2;

  -- Types of predefined purge retention groups
  G_RETENTION_GROUP_DETAILED      CONSTANT VARCHAR2(32) := 'DETAILED';
  G_RETENTION_GROUP_LVL1_SUMMARY  CONSTANT VARCHAR2(32) := 'LEVEL1_SUMMARY';
  G_RETENTION_GROUP_LVL2_SUMMARY  CONSTANT VARCHAR2(32) := 'LEVEL2_SUMMARY';
  G_RETENTION_GROUP_ALERTS        CONSTANT VARCHAR2(32) := 'ALERTS';
  G_RETENTION_GROUP_CONFIG        CONSTANT VARCHAR2(32) := 'CONFIGURATION';
  G_RETENTION_GROUP_JOB_HISTORY   CONSTANT VARCHAR2(32) := 'JOB_HISTORY';
  G_RETENTION_GROUP_SYSTEM        CONSTANT VARCHAR2(32) := 'SYSTEM';

  -- Policy execution group
  G_POLICY_EXEC_GROUP_DEFAULT CONSTANT VARCHAR2(64) := 'DEFAULT';

  -- 
  G_POLICY_NOT_CONFIGURABLE   CONSTANT NUMBER(1) := 0;
  G_POLICY_CONFIGURABLE       CONSTANT NUMBER(1) := 1;

  G_POLICY_DISABLED           CONSTANT NUMBER(1) := 0;
  G_POLICY_ENABLED            CONSTANT NUMBER(1) := 1;

  G_DATE_01_01_1970   CONSTANT DATE := TO_DATE('01-01-1970', 'MM-DD-YYYY');
  G_ALLZERO_GUID      CONSTANT RAW(16) := HEXTORAW('00000000000000000000000000000000');

  -- Module names for logging errors
  PURGE_POLICY_MODULE    CONSTANT VARCHAR2(32) := 'PURGE_POLICIES';
  PURGE_POLICY_DISP_NAME CONSTANT VARCHAR2(64) := 'Purge Policies';

  DETAILED_PURGE_LOGGING     CONSTANT VARCHAR2(32)  := 'detailed_purge_logging';
  DETAILED_PURGE_LOGGING_CMT CONSTANT VARCHAR2(128) := 
    'Property that defines whether the detailed purge logging should be enabled or not';

  EST_PURGE_NAME    CONSTANT VARCHAR2(32)  := 'EST_PURGE';

  ---------------------------------------------------------
  -- Package Types
  ---------------------------------------------------------
  TYPE t_policy_name_list IS 
    TABLE OF MGMT_PURGE_POLICY.policy_name%TYPE
    INDEX BY BINARY_INTEGER;

  TYPE t_proc_name_list IS
    TABLE OF MGMT_PURGE_POLICY.purge_proc_name%TYPE
    INDEX BY BINARY_INTEGER;

  TYPE t_number_list IS
    TABLE OF NUMBER
    INDEX BY BINARY_INTEGER;

  TYPE t_date_list IS 
    TABLE OF DATE 
    INDEX BY BINARY_INTEGER;
  
  TYPE t_guid_list IS 
    TABLE OF RAW(16) 
    INDEX BY BINARY_INTEGER;
  
  TYPE t_purge_policy_rec IS
    RECORD
    (
      policy_name          t_policy_name_list,
      policy_type          t_number_list,
      rollup_proc_name     t_proc_name_list,
      purge_proc_name      t_proc_name_list,
      policy_retent_hrs    t_number_list,
      retent_group_name    t_policy_name_list,
      can_rollup_upto_time t_date_list,
      rolledup_upto_time   t_date_list,
      target_retent_hrs    t_number_list
    );

  ---------------------------------------------------------
  -- Package Error Codes
  ---------------------------------------------------------


  ---------------------------------------------------------
  -- Package Exceptions
  ---------------------------------------------------------


  ---------------------------------------------------------
  -- procedures/functions
  ---------------------------------------------------------

  PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);

  -- Enables debugging
  PROCEDURE enable_debugging;

  -- Disables debugging
  PROCEDURE disable_debugging;


  --
  -- PURPOSE 
  --   Procedure(s) to enable/disable/verify detailed logging
  -- 
  PROCEDURE enable_detailed_logging;

  PROCEDURE disable_detailed_logging;

  FUNCTION  is_detailed_logging_enabled RETURN INTEGER;


  -- Purge Policy group management procedures
  PROCEDURE add_purge_policy_group(p_policy_group_name IN VARCHAR2,
                                   p_policy_group_desc IN VARCHAR2,
                                   p_retention_hours   IN NUMBER);

  PROCEDURE modify_purge_policy_group(p_policy_group_name IN VARCHAR2,
                                      p_policy_group_desc IN VARCHAR2,
                                      p_retention_hours   IN NUMBER);

  PROCEDURE drop_purge_policy_group(p_policy_group_name IN VARCHAR2);

  -- Purge Policy Management procedures
  PROCEDURE add_purge_policy(p_policy_name       IN VARCHAR2,
                             p_policy_type       IN NUMBER,
                             p_purge_proc_name   IN VARCHAR2,
                             p_retention_hours   IN NUMBER   DEFAULT 0,
                             p_rollup_proc_name  IN VARCHAR2 DEFAULT NULL,
                             p_policy_desc       IN VARCHAR2 DEFAULT NULL,
                             p_retent_group_name IN VARCHAR2 DEFAULT NULL,
                             p_exec_group_name   IN VARCHAR2 DEFAULT G_POLICY_EXEC_GROUP_DEFAULT,
                             p_user_configurable IN NUMBER   DEFAULT G_POLICY_CONFIGURABLE,
                             p_is_enabled        IN NUMBER   DEFAULT G_POLICY_ENABLED);

  PROCEDURE modify_purge_policy;

  PROCEDURE drop_purge_policy(p_policy_name IN VARCHAR2);

  PROCEDURE enable_purge_policy(p_policy_name IN VARCHAR2);

  PROCEDURE disable_purge_policy(p_policy_name IN VARCHAR2);

  PROCEDURE configure_purge_policy;

  PROCEDURE add_target_policy_details(p_target_guid IN RAW,
                                      p_purge_policy IN VARCHAR2,
				      p_can_rollup_upto_time IN DATE DEFAULT G_DATE_01_01_1970,
				      p_rolledup_upto_time IN DATE DEFAULT G_DATE_01_01_1970,
				      p_retention_hours NUMBER DEFAULT 0);

  -- Add target callback
  PROCEDURE add_target(p_target_guid IN RAW);

  -- job control
  PROCEDURE remove_purge_policy_jobs;
  PROCEDURE submit_purge_policy_jobs;

  -- procedure called by DBMS jobs
  PROCEDURE apply_purge_policies;

END EM_PURGE;
/
show errors;
