Rem
Rem $Header: type_registry_pkgbody.sql 30-aug-2005.20:24:23 rkpandey Exp $
Rem
Rem type_registry_pkgbody.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      type_registry_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkpandey    08/30/05 - Added UPSERT_TARGET_ASSOC_DEF
Rem    rkpandey    06/24/05 - rkpandey_bug-4429923
Rem    rkpandey    06/22/05 - Created
Rem

CREATE OR REPLACE PACKAGE BODY em_type_registry
AS

  -- Create metric with the given details
  PROCEDURE upsert_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                          p_valid_if_list      IN MGMT_VALIDIF_ARRAY DEFAULT NULL,
                          p_metric_type        IN NUMBER   DEFAULT 0,
                          p_usage_type         IN NUMBER   DEFAULT 0,
                          p_metric_label       IN VARCHAR2 DEFAULT NULL,
                          p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
                          p_description        IN VARCHAR2 DEFAULT ' ',
                          p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
                          p_unit               IN VARCHAR2 DEFAULT ' ',
                          p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
                          p_short_name         IN VARCHAR2 DEFAULT NULL,
                          p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
                          p_is_repository      IN NUMBER   DEFAULT 0,
                          p_author             IN VARCHAR2 DEFAULT 'ORACLE',
                          p_source_type        IN NUMBER   DEFAULT 0,
                          p_source             IN VARCHAR2 DEFAULT NULL,
                          p_keys_from_mult_colls IN NUMBER DEFAULT 0 ,
                          p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL,
                          p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
                          p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY DEFAULT NULL,
                          p_is_transposed      IN NUMBER   DEFAULT 0,
                          p_is_test_metric     IN NUMBER   DEFAULT 0,
                          p_has_push           IN NUMBER   DEFAULT 0,
                          p_has_pull           IN NUMBER   DEFAULT 0,
                          p_remote             IN NUMBER   DEFAULT 0,
                          p_non_thresholded_alerts IN NUMBER DEFAULT 0,
                          p_keyonly_thresholds IN NUMBER   DEFAULT 0,
                          p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
                          p_is_long_running    IN NUMBER   DEFAULT 0,
                          p_is_renderable      IN NUMBER   DEFAULT 1)
  IS
  BEGIN
    MGMT_METRIC.create_metric(p_target_type       => p_target_type, 
                              p_metric_name       => p_metric_name,
                              p_type_meta_ver     => p_type_meta_ver,
                              p_valid_if_list     => p_valid_if_list,
                              p_metric_type       => p_metric_type,
                              p_usage_type        => p_usage_type,
                              p_metric_label      => p_metric_label,
                              p_metric_label_nlsid => p_metric_label_nlsid,
                              p_description       => p_description,
                              p_description_nlsid  => p_description_nlsid,
                              p_unit              => p_unit,
                              p_unit_nlsid        => p_unit_nlsid,
                              p_short_name        => p_short_name,
                              p_short_name_nlsid  => p_short_name_nlsid,
                              p_is_repository     => p_is_repository,
                              p_author            => p_author,
                              p_source_type       => p_source_type,
                              p_source            => p_source,
                              p_keys_from_mult_colls => p_keys_from_mult_colls,
                              p_snapshot_name_list  => p_snapshot_name_list,
                              p_category_list     => p_category_list,
                              p_metric_column_list => p_metric_column_list,
                              p_is_transposed     => p_is_transposed,
                              p_is_test_metric    => p_is_test_metric,
                              p_has_push          => p_has_push,
                              p_has_pull          => p_has_pull,
                              p_remote            => p_remote,
                              p_non_thresholded_alerts => p_non_thresholded_alerts,
                              p_keyonly_thresholds=> p_keyonly_thresholds,
                              p_end_type_meta_ver => p_end_type_meta_ver,
                              p_is_long_running => p_is_long_running,
                              p_is_renderable => p_is_renderable
                              ) ;
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      NULL;

  END upsert_metric;


  --Procedure to create a specified target association DEF
  PROCEDURE upsert_target_assoc_def
  (
    p_assoc_name           IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT MGMT_ASSOC.GLOBAL_SCOPE_TARGET_TYPE,
    p_assoc_name_nlsid     IN mgmt_target_assoc_defs.name_nlsid%TYPE
                              DEFAULT NULL,
    p_description          IN mgmt_target_assoc_defs.description%TYPE
                              DEFAULT NULL,
    p_description_nlsid    IN mgmt_target_assoc_defs.description_nlsid%TYPE
                              DEFAULT NULL,
    p_assoc_type           IN mgmt_target_assoc_defs.association_type%TYPE
                              DEFAULT MGMT_ASSOC.ASSOC_TYPE_RELATES_TO,
    p_cardinality          IN mgmt_target_assoc_defs.cardinality%TYPE
                              DEFAULT MGMT_ASSOC.OPTIONAL_MULTI_CARDINAL,
    p_prop_view_priv       IN mgmt_target_assoc_defs.prop_view_priv%type
                              DEFAULT MGMT_ASSOC.NO_VIEW_PROPAGATION

  )
  IS
  BEGIN
    MGMT_ASSOC.CREATE_TARGET_ASSOC_DEF(
      p_assoc_name         => p_assoc_name,
      p_source_target_type => p_source_target_type,
      p_assoc_target_type  => p_assoc_target_type,
      p_scope_target_type  => p_scope_target_type,
      p_assoc_name_nlsid   => p_assoc_name_nlsid,
      p_description        => p_description,
      p_description_nlsid  => p_description_nlsid,
      p_assoc_type         => p_assoc_type,
      p_cardinality        => p_cardinality,
      p_prop_view_priv     => p_prop_view_priv);
 
  EXCEPTION
    WHEN MGMT_GLOBAL.ASSOC_ALREADY_EXIST THEN
        NULL;

  END upsert_target_assoc_def;

END em_type_registry;
/

show errors

