Rem
Rem $Header: rep_consolidator_pkgbodys.sql 08-feb-2005.13:19:36 gsbhatia Exp $
Rem
Rem rep_consolidator_pkgbodys.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_consolidator_pkgbodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    02/08/05 - Removing header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dmshah      09/05/02 - dmshah_repository_upload_git5_main
Rem    dmshah      06/26/02 - Adding emd_url as input param
Rem    dmshah      06/25/02 - Updating the sql statements
Rem    dmshah      06/18/02 - Created
Rem

CREATE OR REPLACE PACKAGE BODY REP_CONSOLIDATOR AS

PROCEDURE get_table_data( table_name_in IN VARCHAR2,
                          time_column_in IN VARCHAR2,
                          emd_url_in IN VARCHAR2,
                          column_list_in IN VARCHAR2,
                          table_data_out OUT CURSORTYPE ) IS

    sql_statement   VARCHAR2(1000);
    table_name_str  VARCHAR2(256);

    last_upload_time  MGMT_REP_CONSOLIDATOR_STATE.LAST_UPLOAD_TIME%TYPE;

BEGIN

 table_name_str := UPPER(table_name_in);

 sql_statement := 'SELECT last_upload_time FROM' ||
                  ' mgmt_rep_consolidator_state' || 
                  ' WHERE UPPER(table_name) = :1' ;

 EXECUTE IMMEDIATE sql_statement INTO last_upload_time USING table_name_str;

 sql_statement := 'UPDATE mgmt_rep_consolidator_state ' ||
                  ' SET last_upload_time = (SELECT SYSDATE FROM DUAL), ' ||
                  ' emd_url = :1' ||
                  ' WHERE UPPER(table_name) = :2';

 EXECUTE IMMEDIATE sql_statement USING emd_url_in, table_name_str;

 COMMIT;

 sql_statement := 'SELECT ' || column_list_in ||
                  ' FROM ' || table_name_str ||
                  ' WHERE ' || time_column_in ||
                  ' > :1';

 OPEN table_data_out FOR sql_statement USING last_upload_time;

END get_table_data;

END REP_CONSOLIDATOR;
/
SHOW ERRORS;


