Rem
Rem $Header: rep_consolidator_pkgdefs.sql 08-feb-2005.13:17:50 gsbhatia Exp $
Rem
Rem rep_consolidator_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_consolidator_pkgdefs.sql - Package definition file
Rem
Rem    DESCRIPTION
Rem     Defines the package that executes the sql to retreive
Rem     data for repository consolidation.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    02/08/05 - Removing header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dmshah      09/05/02 - dmshah_repository_upload_git5_main
Rem    dmshah      06/26/02 - Adding emd_url as input param
Rem    dmshah      06/18/02 - Created
Rem

CREATE OR REPLACE PACKAGE REP_CONSOLIDATOR AS

TYPE CURSORTYPE IS REF CURSOR;

-- get_table_data
--
-- PURPOSE : Generic procedure to obtain entire table data given the table
--           name. It queries for the last upload time of that table
--           obtains data changed in the given table name since the 
--           last upload time and returns the cursor. In the process
--           it saves the state information (the current time) for use
--           during the next upload.
--
--  IN parameters:
--    table_name_in : Name of the table from which the data is to be retrieved.
--    time_column_in : Time column that indicates when this row got modified.
--    column_list_in : Comma separated list of columns that is retreived
--    emd_url_in : EMD_URL which is gathering the repository consolidation
--
--  OUT parameters:
--    table_data_out : Cursor to the table data

PROCEDURE get_table_data( table_name_in IN VARCHAR2,
                          time_column_in IN VARCHAR2,
                          emd_url_in IN VARCHAR2,
                          column_list_in IN VARCHAR2,
                          table_data_out OUT CURSORTYPE );

END REP_CONSOLIDATOR;
/

SHOW ERRORS;


