Rem
Rem $Header: rep_consolidator_postcre.sql 07-sep-2004.00:36:56 ramalhot Exp $
Rem
Rem rep_consolidator_postcre.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_consolidator_postcre.sql - Inserts defaults after post creation
Rem                                     steps.
Rem
Rem    DESCRIPTION
Rem      Inserts defaults to the Repository consolidator schema after post
Rem      creation steps
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot    08/25/04 - cutover to new assoc tables  
Rem    dmshah      09/05/02 - dmshah_repository_upload_git5_main
Rem    dmshah      06/17/02 - 
Rem    dmshah      06/12/02 - Created
Rem

Rem
Rem All the inserts follow the generic statement as below. For Host Inventory
Rem we stick to an all encompasing "table name" like "ECM Host Inventory", for
Rem rest of the tables, we insert them individually.
Rem
Rem
Rem INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
Rem     (last_upload_time, current_upload_time, time_taken_for_upload, emd_url)
Rem   VALUES
Rem     ((SELECT SYSDATE FROM DUAL), NULL, NULL, NULL);

-- Seed the defaults for host inventory.
INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('ECM Host Inventory', (SELECT SYSDATE FROM DUAL));

-- Seed the defaults for DB Configuration.
--
-- Currently the following tables are covered under DB Configuration
--
--
-- MGMT_DB_DBNINSTANCEINFO
-- MGMT_DB_INIT_PARAMS
-- MGMT_DB_TABLESPACES
-- MGMT_DB_DATAFILES
-- MGMT_DB_REDOLOGS
-- MGMT_DB_CONTROLFILES
-- MGMT_DB_ROLLBACK_SEGS
-- MGMT_DB_SGA
-- MGMT_DB_LICENSE
-- MGMT_DB_OPTION
-- MGMT_DB_COMPATIBILITY


INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_DBNINSTANCEINFO', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_INIT_PARAMS', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_TABLESPACES', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_DATAFILES', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_REDOLOGS', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_CONTROLFILES', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_ROLLBACK_SEGS', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_SGA', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_LICENSE', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_OPTION', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_DB_COMPATIBILITY', (SELECT SYSDATE FROM DUAL));

-- The generic metrics stuff
-- The tables are :
--
-- MGMT_TARGETS
-- MGMT_TARGET_MEMBERSHIPS
-- MGMT_TARGET_PROPERTIES
-- MGMT_STRING_METRIC_HISTORY
-- MGMT_METRICS_1HOUR
-- MGMT_METRICS_1DAY

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_TARGETS', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_TARGET_ASSOCS', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_TARGET_PROPERTIES', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_STRING_METRIC_HISTORY', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_METRICS_1HOUR', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_METRICS_1DAY', (SELECT SYSDATE FROM DUAL));

--
-- Tables marked for repository consolidator from 
--
-- Database monitoring
--
-- mgmt_sql_summary
-- mgmt_sql_bind_vars

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_SQL_SUMMARY', (SELECT SYSDATE FROM DUAL));

INSERT INTO MGMT_REP_CONSOLIDATOR_STATE
    (table_name, last_upload_time)
  VALUES
    ('MGMT_SQL_BIND_VARS', (SELECT SYSDATE FROM DUAL));

