Rem
Rem $Header: rep_consolidator_tables.sql 08-feb-2005.12:49:40 gsbhatia Exp $
Rem
Rem rep_consolidator_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_consolidator_tables.sql - Schema for repository consolidator
Rem
Rem    DESCRIPTION
Rem      Repository consolidator allows federated EM repository to be 
Rem      consolidated into a large single repository. 
Rem
Rem      The schema for repository consolidator will be created on each
Rem      Repository. This schema keeps track of the repository consolidator
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    02/08/05 - Removing header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dmshah      09/05/02 - dmshah_repository_upload_git5_main
Rem    dmshah      06/12/02 - Created
Rem

rem
rem  PURPOSE
rem
rem      This table contains information of the last consolidation state
rem      for a particular table. The idea is to consolidate only data that 
rem      has changed from the last consolidation for that table. 
rem      This table stores that state i.e., it stores
rem      the last consolidation time and other control data for that table.
rem
rem  COLUMNS
rem
rem    TABLE_NAME - Name of the table for which the current state is stored 
rem
rem    LAST_UPLOAD_TIME - The time when the last upload took place. Only
rem                       data modified from this time onwards will be
rem                       a candidate for upload
rem
rem    EMD_URL - URL of the EMD on the source repository.
rem

CREATE TABLE MGMT_REP_CONSOLIDATOR_STATE
    (
     table_name                 VARCHAR2(256)      NOT NULL,
     last_upload_time           DATE               NOT NULL,
     emd_url                    VARCHAR2(2000)     DEFAULT NULL
    )
  MONITORING;

