Rem drv: <create type="pkgbodys" pos="log/log_pkgbodys.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/rep_metric/rep_metric_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/1 2009/02/26 20:39:36 jsadras Exp $
Rem
Rem rep_metric_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      rep_metric_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras    10/15/08 - perf sql fix
Rem    gan        05/15/08 - handle null for is_transposed
Rem    gan        09/27/07 - handle corrupted data
Rem    gan        09/07/07 - Backport gan_bug-6336199 from main
Rem    gan        06/01/07 - Backport gan_bug-4523381 from main
Rem    pmodi      05/15/07 - bug-5043780 Use SEC in parse interval
Rem    pmodi      05/21/07 - Backport pmodi_bug-5043780 from main
Rem    eporter    07/11/06 - Backport eporter_bug-5218244 from main 
Rem    gan        03/21/06 - Backport gan_bug-5049342 from main 
Rem    gan        09/27/05 -  bug 4458308 
Rem    gan        09/13/05 - no purge test based promotion 
Rem    rmarripa   09/08/05 - pass key value for thresholds for creating 
Rem                          response/status thresholds 
Rem    gan        08/15/05 - add opt code for api 
Rem    gan        08/12/05 - catch repo_metric_only 
Rem    gan        07/01/05 - add auto-copy for new meta ver 
Rem    gan        06/28/05 - calulate interval 
Rem    gsbhatia   07/01/05 - New repmgr header impl 
Rem    gan        06/21/05 - add cb for key deletion 
Rem    gan        06/17/05 - check duplicate key or collection name 
Rem    streddy    04/17/05 - Evaluate availability synchronously 
Rem    streddy    04/14/05 - Fix Out-of-sequence registration 
Rem    gan        04/01/05 - Change param order for get_collection_name 
Rem    gan        03/31/05 - check non-existence of repo metric 
Rem    gan        03/30/05 - coll for event metric 
Rem    jsadras    03/17/05 - Bug:4148617, check callback signature 
Rem    gan        03/16/05 - add coll on table metric 
Rem    gan        03/01/05 - take dep collection names 
Rem    gan        02/21/05 - new remove bcn dep 
Rem    gan        02/17/05 - save coll name when config a repo metric 
Rem    ramalhot   02/23/05 - added proc handle_add_target 
Rem    rmarripa   02/17/05 - add beacon dependency deletion API 
Rem    ramalhot   02/02/05 - changed signature for target_deleted_callback 
Rem    gan        01/25/05 - add interval parameter 
Rem    ramalhot   01/17/05 - g_member_guid->g_contains_guid
Rem    gan        01/03/05 - check key 
Rem    gan        12/21/04 - temp handle test based interval 
Rem    gan        12/15/04 - repo coll interval 
Rem    gan        12/01/04 - exclude aggregate service 
Rem    gan        11/19/04 - repo collection interval 
Rem    jsadras    11/09/04 - run_metric_eval
Rem    streddy    10/20/04 - Evaluation order support 
Rem    gan        10/14/04 - add internal remove metric dep 
Rem    gan        10/12/04 - add delete_metric 
Rem    streddy    10/12/04 - Timezone support 
Rem    streddy    10/08/04 - Add delete_dependencies API 
Rem    streddy    10/04/04 - Remove collection suspension code 
Rem    streddy    10/03/04 - Enable repo collections 
Rem    ramalhot   08/25/04 - cutover to new assoc tables
Rem    streddy    08/17/04 - Added target_deleted_callback 
Rem    streddy    08/12/04 - Refactor the sql queries 
Rem    streddy    08/10/04 - Add data metric collections 
Rem    streddy    06/29/04 - Handle out-of-sequence registrations 
Rem    rzazueta   04/15/04 - Fix 3376838: Handle changes in agent url 
Rem    streddy    10/07/03 - Add members_ready column 
Rem    streddy    09/26/03 - type_meta_ver support 
Rem    streddy    09/25/03 - Added type_meta_ver support 
Rem    streddy    04/17/03 - Handle membership changes correctly
Rem    streddy    04/09/03 - streddy_composite_target_availability
Rem    created    04/05/03 - Created
Rem

Rem
Rem TODO for 10gR2
Rem - Add a locking mechanism between the metric_dependency and runtime engine
Rem - Integrate with delete target API properly
Rem

CREATE OR REPLACE PACKAGE body em_rep_metric AS

TYPE t_guids_list IS TABLE OF MGMT_TARGETS.target_guid%TYPE INDEX BY BINARY_INTEGER;

G_MODULE constant VARCHAR2(100) := 'em_rep_metric';

G_DEFINED constant NUMBER(1) := 1;
G_NOT_DEFINED constant NUMBER(1) := 0;

G_MIN_REPO_COLL_INTERVAL NUMBER(1) := 5;

-- if none of dependent metric is interval based
G_DEFAULT_REPO_COLL_INTERVAL NUMBER(2) := 10;

-- Collection names cannot longer than 64 
G_MAX_COLL_NAME_LENGTH NUMBER(2) := 64;


TYPE cur_ref is REF CURSOR;
TYPE FREQ_CODE_ARRAY is TABLE OF mgmt_collections.frequency_code%TYPE;
TYPE SCHEDULE_EX_ARRAY is TABLE of mgmt_collections.schedule_ex%TYPE;

-- Forward declarations

PROCEDURE RESUME_DATA_COLL(v_target_type IN VARCHAR2,
                                   v_target_name IN VARCHAR2,
                                   v_metric_name IN VARCHAR2,
                                   v_metric_column IN VARCHAR2,
                                   v_coll_name IN VARCHAR2,
                                   v_key_value IN VARCHAR2,
                                   v_target_guid mgmt_targets.target_guid%TYPE,
                                   v_metric_guid mgmt_metrics.metric_guid%TYPE);
-- clean open severity etc
PROCEDURE cleanup_metric(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_key_value IN VARCHAR2);

-- remove entry from details table for dependent
PROCEDURE remove_metric_dependency(p_dep_target_guid IN RAW,
                               p_dep_metric_guid IN RAW,
                               p_dep_key_value IN VARCHAR2);


PROCEDURE UPDATE_DEPENDENCY_READINESS(v_target_guid IN RAW,
                                      v_metric_guid IN RAW,
                                      v_type_meta_ver IN VARCHAR2,
                                      v_target_tzrgn IN VARCHAR2);

-- Internal function to get start times in parent timezone
FUNCTION GET_START_TIME_IN_PARENT_TZ(v_target_guid IN RAW, 
                                     v_dep_target_guid IN RAW)
RETURN DATE;

-- Internal function to get the calculation start time of a target
-- based on its members
FUNCTION COMPUTE_START_TIME(v_target_guid IN RAW,
                        v_metric_guid IN RAW)
  RETURN DATE;
                        

PROCEDURE ADD_DEPENDENCY_DEF_TARGET(v_target_type     IN VARCHAR2,
                                    v_target_guid     IN RAW,
                                    v_target_tzrgn    IN VARCHAR2,
                                    v_type_meta_ver   IN VARCHAR2,
                                    v_dep_target_type IN VARCHAR2,
                                    v_dep_target_guid IN RAW);

PROCEDURE check_repo_metric_only(v_target_name IN VARCHAR2,
                                 v_target_type IN VARCHAR2,
                                 v_repo_metric_only OUT NUMBER)
AS
l_repo_metric_only NUMBER;
BEGIN
     IF emdw_log.p_is_debug_set THEN
        emdw_log.debug('evaluate_target_severity: Enter,  type ' 
                      || v_target_type || ' name ' || v_target_name
                      , G_MODULE);
     END IF; 

      -- check if this target type only has repo side metric and catch it
     SELECT 1 - count(*) INTO l_repo_metric_only
       FROM mgmt_metrics m, mgmt_targets t
      WHERE t.target_name = v_target_name
        AND t.target_type = v_target_type
        AND m.target_type = t.target_type
        AND m.type_meta_ver = t.type_meta_ver
        AND (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ')
        AND (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ')
        AND (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ')
        AND (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ')
        AND (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ')
        AND m.is_repository  <> 1
        AND ROWNUM = 1;
      
     v_repo_metric_only := l_repo_metric_only;

     IF emdw_log.p_is_debug_set THEN
        emdw_log.debug('evaluate_target_severity: Exit, ' ||
                      ' repo_metric_only flag is ' 
                      || l_repo_metric_only, G_MODULE);
     END IF; 
END check_repo_metric_only;


-- if eval_func is the standard AND/OR, set v_opt_code_out according
-- otherwise, if v_opt_code_in is null, set v_opt_code_out to NONE
PROCEDURE check_standard_eval(v_eval_func IN VARCHAR2,
                              v_opt_code_in IN NUMBER,
                              v_opt_code_out OUT NUMBER)
AS
BEGIN
  IF emdw_log.p_is_debug_set THEN
     emdw_log.debug('check_standard_eval: Enter ' ||
                    v_eval_func || ' ' || v_opt_code_in, G_MODULE);
  END IF;
 
  IF v_eval_func IS NULL THEN
     v_opt_code_out := mgmt_global.G_REPO_SEV_OPT_NONE;
  ELSIF  UPPER(v_eval_func) = UPPER(mgmt_severity_helper.G_AND_AVAIL_EVAL_PROC_NAME) THEN
    v_opt_code_out := mgmt_global.G_REPO_SEV_OPT_AND;
  ELSIF UPPER(v_eval_func) = UPPER(mgmt_severity_helper.G_OR_AVAIL_EVAL_PROC_NAME) THEN
    v_opt_code_out := mgmt_global.G_REPO_SEV_OPT_OR;
  ELSIF v_opt_code_in IS NULL THEN
    v_opt_code_out := mgmt_global.G_REPO_SEV_OPT_NONE;
  ELSE
    v_opt_code_out := v_opt_code_in;
  END IF;

  IF emdw_log.p_is_debug_set THEN
     emdw_log.debug('check_standard_eval: Exit ' ||
                    v_eval_func || ' ' || v_opt_code_out, G_MODULE);
  END IF;

END check_standard_eval;

FUNCTION check_repo_metric_existence(v_target_guid IN RAW,
                                 v_metric_guid IN RAW,
                                 v_key_value IN VARCHAR2)
RETURN BOOLEAN
AS
l_count NUMBER;
BEGIN
   select count(*) into l_count
     from mgmt_metric_dependency
    where target_guid = v_target_guid
      and metric_guid = v_metric_guid
      and key_value = v_key_value;

   if l_count = 0 then
     return FALSE;
   else
     return TRUE;
   end if;

END check_repo_metric_existence;

-- check if the coll_name has been used for the target, if so
-- throw exception
PROCEDURE check_existing_coll_name(v_target_name IN VARCHAR2,
                                   v_target_type IN VARCHAR2,
                                   v_coll_name IN VARCHAR2)
AS
l_coll_count NUMBER;
BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('check_existing_coll_name: Enter '
                    || v_target_name || ':' 
                    || v_coll_name,
                    G_MODULE);
  END IF;

  SELECT count(*) into l_coll_count
    FROM mgmt_targets t,
         mgmt_collections c
   WHERE t.target_name = v_target_name
     AND t.target_type = v_target_type
     AND t.target_guid = c.object_guid
     AND c.coll_name = v_coll_name
     AND ROWNUM = 1;

  IF l_coll_count > 0 THEN
        raise_application_error(mgmt_global.KEY_ALREADY_EXITS_ERR, 
                                mgmt_global.KEY_ALREADY_EXITS_ERR_M || 
                                ' <target_name>: ' || v_target_name
                                || ' <key_value/coll_name>: ' || v_coll_name);
  END IF;

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('check_existing_coll_name: Exit '
                    || v_target_name || ':' 
                    || v_coll_name,
                    G_MODULE);
  END IF;


END check_existing_coll_name;


PROCEDURE add_dummy_collection(v_target_name IN VARCHAR2,
                               v_target_type IN VARCHAR2,
                               v_metric_name IN VARCHAR2,
                               v_metric_column IN VARCHAR2,
                               v_key_value IN VARCHAR2)
IS
  l_coll_name mgmt_collections.coll_name%TYPE;
  l_target_guid RAW(16);
  l_policy_params MGMT_POLICY_PARAM_VAL_ARRAY := MGMT_POLICY_PARAM_VAL_ARRAY();
  l_policy_keys   MGMT_POLICY_KEY_COL_COND_ARRAY := MGMT_POLICY_KEY_COL_COND_ARRAY();
  l_policy_vals MGMT_POLICY_KEY_VAL_ARRAY := MGMT_POLICY_KEY_VAL_ARRAY();
  l_key_value MGMT_METRIC_THRESHOLDS.KEY_VALUE%TYPE;
BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('add_dummy_collection: Enter '
                    || v_target_name || ':' 
                    || v_metric_name || ':'
                    || v_metric_column || ':'
                    || v_key_value,
                    G_MODULE);
  END IF;
  -- If the key value is null 
  IF ( v_key_value IS NULL ) OR ( LENGTH(TRIM(v_key_value)) = 0) THEN 
      l_key_value := ' ';
  END IF;
  l_coll_name := GET_COLLECTION_NAME(v_target_type,
                             v_metric_name,
                             v_metric_column,
                             l_key_value);
  check_existing_coll_name(v_target_name,
                          v_target_type,
                          l_coll_name);

  -- construct the collection name

  mgmt_collection.start_collection(
           p_target_type   =>  v_target_type,
           p_target_name   =>  v_target_name,
           p_metric_name   =>  v_metric_name,
           p_metric_column =>  ' ',
           p_coll_name     =>  l_coll_name,
           p_coll_schedule =>  mgmt_coll_schedule_obj.on_demand_schedule
           );

  l_policy_keys.extend(1);
  l_policy_keys(1) := MGMT_POLICY_KEY_COL_COND.new(
                             p_key_value => l_key_value,
                             p_has_wildcard => 0);
     
  l_policy_params.extend(1);
  IF (v_metric_name = mgmt_global.G_AVAIL_METRIC_NAME AND
      v_metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN) 
  THEN
      l_policy_params(1) := MGMT_POLICY_PARAM_VAL.new(
                                  p_param_name => ' ',
                                  p_crit_threshold => '0');
  ELSE
      l_policy_params(1) := MGMT_POLICY_PARAM_VAL.new(
                                  p_param_name => ' ',
                                  p_crit_threshold => '0',
                                  p_warn_threshold => '1');
  END IF;
                    
  l_policy_vals.extend(1);
  l_policy_vals(1) := MGMT_POLICY_KEY_VAL.new(
                          p_key_value => l_policy_keys,
                          p_condition_operator => mgmt_global.G_THRESHOLD_EQ,
                          p_param_values => l_policy_params);
          
  mgmt_monitoring.save_target_metric_config (
      p_target_type   =>  v_target_type,
      p_target_name   =>  v_target_name,
      p_metric_name   =>  v_metric_name,
      p_metric_column =>  v_metric_column,
      p_coll_name     =>  l_coll_name,
      p_policy_val_list => l_policy_vals
    );

 IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('add_dummy_collection: Exit ', 
                    G_MODULE);
  END IF;

END add_dummy_collection;

PROCEDURE delete_dummy_collection(v_target_name IN VARCHAR2,
                                  v_target_type IN VARCHAR2,
                                  v_metric_name IN VARCHAR2,
                                  v_metric_column IN VARCHAR2,
                                  v_key_value IN VARCHAR2)
AS
  l_coll_name mgmt_collections.coll_name%TYPE;
BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('delete_dummy_collection: Enter '
                    || v_target_name || ':' 
                    || v_metric_name || ':'
                    || v_metric_column || ':'
                    || v_key_value,
                    G_MODULE);
  END IF;

  l_coll_name := GET_COLLECTION_NAME(v_target_type,
                             v_metric_name,
                             v_metric_column,
                             v_key_value);

  mgmt_collection.stop_collection(
        p_target_name => v_target_name,
        p_target_type => v_target_type,
        p_metric_name => v_metric_name, 
        p_metric_column => ' ',
        p_coll_name => l_coll_name);

  mgmt_monitoring.delete_target_metric_config(
        p_target_name => v_target_name,
        p_target_type => v_target_type,
        p_metric_name => v_metric_name, 
        p_metric_column => v_metric_column,
        p_coll_name => l_coll_name);

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('delete_dummy_collection: Exit ',
                    G_MODULE);
  END IF;

END delete_dummy_collection;

--
-- Internal procedure to get guid info based on a
-- mgmt_metric_instance object
--
PROCEDURE GET_METRIC_INFO(v_metric IN MGMT_METRIC_INSTANCE,
                          v_target_guid OUT RAW,
                          v_metric_guid OUT RAW,
                          v_target_tzrgn OUT VARCHAR2,
                          v_event_metric OUT NUMBER)
IS
BEGIN
   BEGIN
     SELECT target_guid, timezone_region, metric_guid,
            DECODE(metric_type, mgmt_global.G_METRIC_TYPE_REPOS_EVENT, 1, 0)
       INTO v_target_guid, v_target_tzrgn, v_metric_guid, v_event_metric
       FROM mgmt_metrics m, 
            mgmt_targets t
      WHERE t.target_name = v_metric.target_name
        AND t.target_type = v_metric.target_type
        AND m.target_type = v_metric.target_type
        AND m.metric_name = v_metric.metric_name
        AND m.metric_column = v_metric.metric_column
        AND m.type_meta_ver = t.type_meta_ver
        AND (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ')
        AND (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ')
        AND (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ')
        AND (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ')
        AND (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ');
   EXCEPTION
     WHEN NO_DATA_FOUND THEN
        IF EMDW_LOG.P_IS_ERROR_SET THEN
          EMDW_LOG.error('Either the target or the metric does not exist for ' ||
                          '<target_name>/<metric_name>/<metric_column> ' || 
                         v_metric.target_name || '/' || v_metric.metric_name || 
                         v_metric.metric_column,
                         G_MODULE);
        END IF;
        raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Either the target or the metric does not exist for ' ||
        '<target_name>/<metric_name>/<metric_column> ' || 
       v_metric.target_name || '/' || v_metric.metric_name || v_metric.metric_column);

   END;
END GET_METRIC_INFO;

PROCEDURE check_callback_signature(p_event_metric IN NUMBER,
                                   p_callback_name IN VARCHAR2)
IS
l_error_message VARCHAR2(2000) ;
BEGIN

  IF p_event_metric = MGMT_GLOBAL.G_TRUE AND
     p_callback_name IS NOT NULL AND
     NOT EM_CHECK.is_valid_signature(
       p_callback_name,
       mgmt_short_string_array('RAW','RAW','MGMT_METRIC_DETAILS_ARRAY',
           'NUMBER','VARCHAR2','VARCHAR2','VARCHAR2'),
       l_error_message)
  THEN
    raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
      l_error_message) ;
  END IF ;

END check_callback_signature ;

-- check whether one metric has more than one collection
-- return coll name, if null, means no coll found
FUNCTION check_collection_for_metric(v_dep_metric IN MGMT_METRIC_INSTANCE,
                                     v_coll_names IN SMP_EMD_STRING_ARRAY)
RETURN VARCHAR2
IS
l_temp_coll_name mgmt_collections.coll_name%TYPE;
l_message VARCHAR2(1024);
BEGIN
     IF v_coll_names.COUNT > 1 THEN
        l_message := SUBSTR( ' metric ' || v_dep_metric.target_name 
                                || '/' || v_dep_metric.metric_name
                                || '/' || v_dep_metric.metric_column
                                || '/' || v_dep_metric.key_value
                                || ' has more than one collections ', 1, 1024);
        IF emdw_log.P_IS_ERROR_SET THEN
           emdw_log.error('check_collection_for_metric: ' || l_message,
                          G_MODULE);
        END IF;
        raise_application_error(mgmt_global.INVALID_METRIC_DEP_ERR,
                                l_message);
     END IF;

     IF v_coll_names.COUNT = 1 THEN
        l_temp_coll_name := v_coll_names(1);
     END IF;
     return l_temp_coll_name;

END check_collection_for_metric;

-- figure out collection name for a metric (non_beacon metric)
PROCEDURE RESOLVE_COLL_NAME_FOR_METRIC(v_dep_metric IN MGMT_METRIC_INSTANCE,
                                       v_coll_name OUT VARCHAR2)
AS
CURSOR coll_name_key_cur (v_dep_target_guid IN RAW,
                              v_dep_metric_guid IN RAW,
                              v_dep_key_value IN VARCHAR2)
IS
       SELECT c.coll_name
         FROM mgmt_collections c, mgmt_collection_metric_tasks cmt
        WHERE c.object_guid = cmt.target_guid
          AND  c.coll_name = cmt.coll_name
          AND  c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET 
          AND  c.object_guid = v_dep_target_guid
          AND  c.coll_name = v_dep_key_value
          AND  cmt.metric_guid = v_dep_metric_guid;

CURSOR coll_name_cur (v_dep_target_guid IN RAW,
                          v_dep_metric_guid IN RAW)
IS
          SELECT c.coll_name
            FROM mgmt_collections c, mgmt_collection_metric_tasks cmt
           WHERE c.object_guid = cmt.target_guid
             AND  c.coll_name = cmt.coll_name
             AND  c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET 
             AND  c.object_guid = v_dep_target_guid
             AND  cmt.metric_guid = v_dep_metric_guid;

     
l_table_metric_guid mgmt_metrics.metric_guid%TYPE;
l_message VARCHAR2(1024);
l_target_guid RAW(16);
l_metric_guid RAW(16);
l_temp_coll_names SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
l_coll_name mgmt_collections.coll_name%TYPE;

BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('resolve_coll_name_for_metric: Enter '
                    || v_dep_metric.target_name || ':' 
                    || v_dep_metric.metric_name || ':'
                    || v_dep_metric.metric_column || ':'
                    || v_dep_metric.key_value,
                    G_MODULE);
  END IF;
 
  -- we try the four senarios (starting with the most strict case)
  -- 1. v_metric_guid as column guid, with key (tranposed metric)
  -- 3. find table guid for v_metric_guid, with key (UDM)
  -- 4. find table guid for v_metric_guid without key (Agent)
  -- throw exception if dep metric has more than collection during checking

  l_target_guid := mgmt_target.get_target_guid(v_dep_metric.target_name,
                                               v_dep_metric.target_type);
  l_metric_guid := mgmt_target.get_metric_guid(v_dep_metric.target_type, 
                                               v_dep_metric.metric_name,
                                               v_dep_metric.metric_column);

  OPEN coll_name_key_cur(l_target_guid,
                             l_metric_guid,
                             v_dep_metric.key_value);
  FETCH coll_name_key_cur
     BULK COLLECT INTO l_temp_coll_names;
  CLOSE coll_name_key_cur;
  l_coll_name := check_collection_for_metric(v_dep_metric,
                                             l_temp_coll_names);

  IF l_coll_name IS NULL THEN
     SELECT UNIQUE m1.metric_guid
       INTO l_table_metric_guid
       FROM mgmt_metrics m1, mgmt_metrics m2
      WHERE m2.metric_guid = l_metric_guid
        AND m1.metric_name = m2.metric_name
        AND m1.target_type = m2.target_type
        AND m1.type_meta_ver = m2.type_meta_ver
        AND m1.category_prop_1 = m2.category_prop_1
        AND m1.category_prop_2 = m2.category_prop_2
        AND m1.category_prop_3 = m2.category_prop_3
        AND m1.category_prop_4 = m2.category_prop_4
        AND m1.category_prop_5 = m2.category_prop_5
        AND m1.metric_column = ' ';

      IF emdw_log.p_is_debug_set THEN
        emdw_log.debug('resolve_coll_name_for_metric:  '
                      || v_dep_metric.target_name || '/'
                      || v_dep_metric.metric_name|| '/'
                      || v_dep_metric.metric_column || '/'
                      || v_dep_metric.key_value
                      || ' try table metric guid ' || l_table_metric_guid
                      || '  and key ', G_MODULE);
      END IF;

      OPEN coll_name_key_cur(l_target_guid,
                             l_table_metric_guid,
                             v_dep_metric.key_value);
      FETCH coll_name_key_cur 
        BULK COLLECT INTO l_temp_coll_names;
      CLOSE coll_name_key_cur;

      l_coll_name := check_collection_for_metric(v_dep_metric,
                                                 l_temp_coll_names);
     IF l_coll_name IS NULL THEN
        IF emdw_log.p_is_debug_set THEN
           emdw_log.debug('resolve_coll_name for_metric: '
                      || v_dep_metric.target_name || '/'
                      || v_dep_metric.metric_name|| '/'
                      || v_dep_metric.metric_column || '/'
                      || v_dep_metric.key_value
                      || ' try table metric guid ' || l_table_metric_guid
                      || '  without key ', G_MODULE);
         END IF;

         OPEN coll_name_cur(l_target_guid,
                            l_table_metric_guid);
         FETCH coll_name_cur 
           BULK COLLECT INTO l_temp_coll_names;
         CLOSE coll_name_cur;
         l_coll_name := check_collection_for_metric(v_dep_metric,
                                                 l_temp_coll_names);
         -- For Response/Status metric
         IF l_coll_name IS NULL THEN 
            l_message := SUBSTR('Do not find coll name for dependent '
                      || v_dep_metric.target_name || '/'
                      || v_dep_metric.metric_name|| '/'
                      || v_dep_metric.metric_column || '/'
                      || v_dep_metric.key_value,
                      1, 1024);
            IF emdw_log.p_is_debug_set THEN
               emdw_log.debug('resolve_coll_name_for_metric: ' || l_message,
                       G_MODULE);
            END IF;
            --raise_application_error(mgmt_global.INVALID_METRIC_DEP_ERR,
            --                         l_message);
        END IF;
    END IF;
  END IF;
  
  v_coll_name := l_coll_name;
 
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
     EMDW_LOG.debug('resolve_coll_name_for_metric: Exit. '
                    || ' Collection name is ' || v_coll_name,
                    G_MODULE);
  END IF;

END RESOLVE_COLL_NAME_FOR_METRIC;

-- Internal procedure to add dependencies to a metric
PROCEDURE ADD_DEPENDENCIES(v_target_guid IN RAW,
                           v_metric_guid IN RAW,
                           v_key_value   IN VARCHAR2,
                           v_dep_metrics IN MGMT_METRIC_INSTANCE_ARRAY,
                           v_dep_coll_names IN 
                                     SMP_EMD_STRING_ARRAY DEFAULT NULL)
IS
   l_dep_metric_guid   MGMT_METRICS.metric_guid%TYPE;
   l_dep_target_guid   MGMT_TARGETS.target_guid%TYPE;
   l_dep_start_ts      DATE;
   l_event_metric      NUMBER(1);
   l_target_tzrgn      MGMT_TARGETS.timezone_region%TYPE;
   l_dep_tgt_tzrgn     MGMT_TARGETS.timezone_region%TYPE;
   l_dep_key_value     mgmt_metric_dependency_details.dep_key_value%TYPE;
   l_num_keys          mgmt_metrics.num_keys%TYPE;
   l_dep_coll_name     mgmt_collections.coll_name%TYPE;
   l_is_remote         mgmt_metrics.remote%TYPE;
BEGIN

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('add_dependencies:Enter' || 
                     '/' || v_target_guid || '/' || v_metric_guid || '/' ||
                      v_key_value,
                      G_MODULE);
   END IF;

   IF (v_dep_metrics IS NULL) THEN
     return;
   END IF;

   FOR i IN 1..v_dep_metrics.COUNT
   LOOP

      get_metric_info(v_dep_metrics(i), l_dep_target_guid, l_dep_metric_guid, 
                      l_dep_tgt_tzrgn, l_event_metric);
      SELECT DISTINCT num_keys, remote
        INTO l_num_keys, l_is_remote
        FROM mgmt_metrics m, mgmt_targets t
       WHERE t.target_name = v_dep_metrics(i).target_name
         AND t.target_type = v_dep_metrics(i).target_type
         AND m.target_type = v_dep_metrics(i).target_type
         AND m.metric_name = v_dep_metrics(i).metric_name
         AND m.metric_column = v_dep_metrics(i).metric_column
         AND m.type_meta_ver = t.type_meta_ver
         AND (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ')
         AND (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ')
         AND (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ')
         AND (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ')
         AND (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ');
      
      IF l_num_keys > 0 AND v_dep_metrics(i).key_value is NULL THEN
        IF EMDW_LOG.P_IS_ERROR_SET THEN
          EMDW_LOG.error('Key value is null for keyed metric '
                         || ' - raising an exception', 
                         G_MODULE);
        END IF;

        raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Keyed metric needs key value to be set ' ||
        '<target_name>/<metric_name>/<metric_column> ' || 
         v_dep_metrics(i).target_name ||
        '/' || v_dep_metrics(i).metric_name ||
        '/' || v_dep_metrics(i).metric_column);
      ELSE
        l_dep_key_value := NVL(v_dep_metrics(i).key_value, ' ');
      END IF; 

      l_dep_start_ts := get_start_time_in_parent_tz(v_target_guid, l_dep_target_guid);

      IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('add_dependencies: dep start ts = ' || 
                         to_char(l_dep_start_ts, 'MM/DD/YYYY HH24:MI:SS'),
                         G_MODULE);
     END IF;
     
     IF v_dep_coll_names IS NOT NULL AND 
        v_dep_coll_names(i) IS NOT NULL 
     THEN
        l_dep_coll_name := v_dep_coll_names(i);
     ELSE
        IF l_is_remote = 0 AND l_event_metric = 0 THEN
         resolve_coll_name_for_metric(v_dep_metrics(i), l_dep_coll_name);
        END IF;
     END IF;

     BEGIN
        INSERT INTO mgmt_metric_dependency_details
          (target_guid, metric_guid,  key_value, dep_target_guid, 
           dep_metric_guid, edep_target_guid, edep_metric_guid,
           dep_key_value, start_timestamp, dep_coll_name)
        VALUES
          (v_target_guid, v_metric_guid, v_key_value,
           l_dep_target_guid, l_dep_metric_guid,
           l_dep_target_guid, l_dep_metric_guid,
           l_dep_key_value, 
           l_dep_start_ts,
           l_dep_coll_name);
     EXCEPTION
       WHEN DUP_VAL_ON_INDEX THEN
          IF EMDW_LOG.P_IS_DEBUG_SET THEN
             EMDW_LOG.debug('add_dependencies: Ignoring dup-val ' ||
                           l_dep_target_guid || ' / ' || l_dep_metric_guid,
                          G_MODULE);
          END IF;
          -- Ignore duplicate dependencies.
          NULL;
     END;
   END LOOP;

   EMDW_LOG.debug('add_dependencies:Exit',G_MODULE);
END ADD_DEPENDENCIES;


-- Internal procedure to disable repository collection if needed
PROCEDURE CHECK_FOR_NULL_DEPENDENCIES(v_target_guid IN RAW,
                                      v_metric_guid IN RAW,
                                      v_key_value   IN VARCHAR2)
IS
  l_count NUMBER;
  l_target_name mgmt_targets.target_name%TYPE;
  l_target_type mgmt_targets.target_type%TYPE;
  l_metric_name mgmt_metrics.metric_name%TYPE;
  l_metric_column mgmt_metrics.metric_column%TYPE;
  l_event_metric NUMBER;
BEGIN


   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('check_for_null_dependencies:Enter' || 
                     '/' || v_target_guid || '/' || v_metric_guid || '/' ||
                      v_key_value,
                      G_MODULE);
   END IF;


   SELECT event_metric 
     INTO l_event_metric
     FROM mgmt_metric_dependency
    WHERE metric_guid = v_metric_guid 
      AND target_guid = v_target_guid
      AND key_value   = v_key_value;

   SELECT count(*) 
     INTO l_count
     FROM mgmt_metric_dependency_details
    WHERE metric_guid = v_metric_guid 
      AND target_guid = v_target_guid
      AND key_value   = v_key_value;

   IF (l_event_metric = 1) THEN
     IF (l_count = 0) THEN
         IF EMDW_LOG.P_IS_DEBUG_SET THEN
             EMDW_LOG.debug('Setting member_ready to 0', G_MODULE);
         END IF;

         UPDATE mgmt_metric_dependency
           SET members_ready = 0
          WHERE metric_guid = v_metric_guid
            AND target_guid = v_target_guid
            AND key_value   = v_key_value;
      ELSE
         IF EMDW_LOG.P_IS_DEBUG_SET THEN
             EMDW_LOG.debug('Setting force_calculate to 1', G_MODULE);
         END IF;

          -- mark all the metrics to be re-evaluated because
          -- of membership changes
          UPDATE mgmt_metric_dependency
             SET force_calculate = 1, members_ready = 1
           WHERE metric_guid = v_metric_guid
             AND target_guid = v_target_guid
             AND key_value   = v_key_value;
     END IF;

   END IF;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('check_for_null_dependencies:Exit',  G_MODULE);
   END IF;

END CHECK_FOR_NULL_DEPENDENCIES;

-- generates the collection name based on the key value
FUNCTION GET_COLLECTION_NAME(v_target_type IN VARCHAR2,
                             v_metric_name IN VARCHAR2,
                             v_metric_column IN VARCHAR2,
                             v_key_value IN VARCHAR2)
   RETURN VARCHAR2
IS
l_is_transposed NUMBER;
l_coll_name mgmt_collections.coll_name%TYPE;
BEGIN
      -- for transposed metric, use v_key_value, throw exception if v_key_value is 
      -- null or ' '
      -- for other metric, use v_metric_column:v_key_value
      BEGIN
         select unique is_transposed into l_is_transposed
           from mgmt_metrics
          where target_type = v_target_type
            and metric_name = v_metric_name
            and is_transposed IS NOT NULL;
      EXCEPTION
         WHEN NO_DATA_FOUND THEN
            l_is_transposed := 0;
      END;

      IF l_is_transposed = 0 THEN
         l_coll_name := SUBSTR(v_metric_name||':'||v_metric_column||':'||v_key_value, 1, G_MAX_COLL_NAME_LENGTH);
      ELSE
         IF (v_key_value IS NULL OR v_key_value = ' ') THEN
           raise_application_error(mgmt_global.EMPTY_KEY_VALUE_ERR,
                                   mgmt_global.EMPTY_KEY_VALUE_ERR_M);
         END IF;
         l_coll_name := v_key_value;
      END IF;
      
      l_coll_name := TRIM(l_coll_name);

      return l_coll_name;
END GET_COLLECTION_NAME;

-- Internal function to get start times in parent timezone
FUNCTION GET_START_TIME_IN_PARENT_TZ(v_target_guid IN RAW, 
                                     v_dep_target_guid IN RAW)
RETURN DATE
IS
  l_tzrgn mgmt_targets.timezone_region%TYPE;
  l_dep_tzrgn  mgmt_targets.timezone_region%TYPE;
  l_dep_start_ts DATE;
BEGIN

  SELECT MIN(start_collection_timestamp)
    INTO l_dep_start_ts
    FROM mgmt_availability
   WHERE target_guid = v_dep_target_guid;

   SELECT timezone_region
     INTO l_tzrgn
     FROM mgmt_targets
    WHERE target_guid = v_target_guid;

   SELECT timezone_region
     INTO l_dep_tzrgn
     FROM mgmt_targets
    WHERE target_guid = v_dep_target_guid;


   IF (l_tzrgn <> l_dep_tzrgn) THEN
     return MGMT_GLOBAL.ADJUST_TZ(l_dep_start_ts, l_dep_tzrgn, l_tzrgn);
   ELSE
      return l_dep_start_ts;
   END IF;

END GET_START_TIME_IN_PARENT_TZ;

-- parse the interval schedule.
-- The string is like <IntervalSchedule INTERVAL="168" TIME_UNIT="Hr"/>
FUNCTION PARSE_INTERVAL(v_interval_xml IN VARCHAR2)
 RETURN NUMBER
IS
INTERVAL_START constant VARCHAR2(32) := 'INTERVAL="';
INTERVAL_STOP constant VARCHAR2(2) :='"';
TIME_UNIT_START constant VARCHAR2(32) := 'TIME_UNIT="';
TIME_UNIT_STOP constant VARCHAR2(2) :='"';
MIN constant VARCHAR2(3) :='MIN';
HR constant VARCHAR2(2) := 'HR';
DAY constant VARCHAR2(3) := 'DAY';
SEC constant VARCHAR2(3) := 'SEC';

l_unit_multiplier NUMBER := 1;
l_interval_xml mgmt_collections.schedule_ex%TYPE;
l_interval_string mgmt_collections.schedule_ex%TYPE;
l_interval_unit mgmt_collections.schedule_ex%TYPE;
l_interval_num NUMBER;

FUNCTION get_token(v_string IN VARCHAR2,
                   v_start IN VARCHAR2,
                   v_stop IN VARCHAR2)
RETURN VARCHAR2
IS
l_start_pos NUMBER;
l_stop_pos NUMBER;
l_start_token_len NUMBER := LENGTH(v_start);
BEGIN
   l_start_pos := INSTR(v_string, v_start);
   IF l_start_pos = 0 THEN
      return null;
   END IF;
   l_stop_pos := INSTR(v_string, v_stop, l_start_pos+l_start_token_len);
   IF l_stop_pos = 0 THEN
      return null;
   END IF;
  
   return SUBSTR(v_string, l_start_pos+l_start_token_len,
                l_stop_pos-l_start_pos-l_start_token_len);
END get_token;

BEGIN
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('parse interval:Enter' || v_interval_xml ,
                     G_MODULE); 
   END IF;
  
   IF v_interval_xml IS NULL OR LENGTH(v_interval_xml) = 0 THEN
      IF emdw_log.P_IS_DEBUG_SET THEN
         emdw_log.debug('Schedule string is empty, return null', G_MODULE);
      END IF;
      return null;
   END IF;

   l_interval_xml := UPPER(v_interval_xml);
   l_interval_string := get_token(l_interval_xml,
                                  INTERVAL_START,
                                  INTERVAL_STOP);
   IF l_interval_string IS NULL THEN
      IF emdw_log.P_IS_DEBUG_SET THEN
         emdw_log.debug(' Depedent metric schedule is not interval based '
                          || v_interval_xml || ' return null', G_MODULE);
      END IF;
      return null;
   END IF;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('parse interval: interval string is ' 
                     || l_interval_string ,
                     G_MODULE); 
   END IF;
  
   l_interval_num := CAST(l_interval_string AS NUMBER);
   
   l_interval_unit := get_token(l_interval_xml,
                                TIME_UNIT_START,
                                TIME_UNIT_STOP);

   CASE l_interval_unit
   WHEN DAY THEN
      l_unit_multiplier := 1440;
   WHEN HR THEN
      l_unit_multiplier := 60;
   WHEN SEC THEN
      l_unit_multiplier := 1/60;

   ELSE
      l_unit_multiplier := 1;
   END CASE;
   
   -- If interval is less then one mins then default it to 1 Min.
   -- We should not have collection interval less then 1 Min due to perf reason
   l_interval_num := ROUND( GREATEST((l_interval_num * l_unit_multiplier), 1));

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('parse interval:Exit. Interval is ' || l_interval_num,
                     G_MODULE); 
   END IF;

   return l_interval_num;
END PARSE_INTERVAL;

PROCEDURE GET_DEP_COLL_INTERVAL(v_target_guid IN RAW,
                               v_metric_guid IN RAW,
                               v_key_value IN VARCHAR2,
                               v_temp_interval IN NUMBER,
                               v_frequency_code IN NUMBER,
                               v_schedule_ex IN VARCHAR2,
                               v_dep_intervals IN OUT NOCOPY MGMT_INTEGER_TABLE)
IS
l_interval_value NUMBER;
l_message VARCHAR(1024);
BEGIN
         
     IF  v_temp_interval IS NOT NULL THEN
          l_interval_value := v_temp_interval;
     ELSE
          l_interval_value := parse_interval(v_schedule_ex);
     END IF;

     IF emdw_log.P_IS_DEBUG_SET THEN
          emdw_log.debug('GET_DEP_COLL_INTERVAL: Got interval for ' 
                      || v_target_guid || '/' || v_metric_guid 
                      || '/' || v_key_value || ' interval is '
                      || l_interval_value ,
                      G_MODULE);
     END IF;
     
     IF l_interval_value IS NOT NULL THEN    
       v_dep_intervals.extend;
       v_dep_intervals(v_dep_intervals.COUNT) := l_interval_value;
     END IF;
  
END GET_DEP_COLL_INTERVAL;


-- gets the frequency based on the member frequencies
-- assume for each target/metric/column/key there is one
-- collection for it
-- It is used to set min_dep_interval and collection interval
FUNCTION get_min_dep_interval(v_target_guid IN RAW,
                                 v_metric_guid IN RAW,
                                 v_key_value IN VARCHAR2)
  RETURN NUMBER
IS

CURSOR dep_metrics_cur IS
     SELECT dd.dep_target_guid, dd.dep_metric_guid, dd.dep_key_value,
            c.interval, c.frequency_code, c.schedule_ex
       FROM mgmt_metric_dependency_details dd,
            mgmt_collections c
      WHERE dd.dep_target_guid = c.object_guid
        AND dd.dep_coll_name = c.coll_name
        AND dd.target_guid = v_target_guid
        AND dd.metric_guid = v_metric_guid
        AND dd.key_value = v_key_value;

l_intervals MGMT_INTEGER_TABLE := MGMT_INTEGER_TABLE();

l_coll_interval NUMBER;
l_message VARCHAR2(1024);
BEGIN
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('get_min_dep_interval:Enter' || '/' ||
              v_target_guid || '/' || v_metric_guid || '/' || v_key_value,
              G_MODULE); 
   END IF;
 
  FOR rec IN dep_metrics_cur
  LOOP
     get_dep_coll_interval(rec.dep_target_guid,
                          rec.dep_metric_guid,
                          rec.dep_key_value,
                          rec.interval,
                          rec.frequency_code,
                          rec.schedule_ex,
                          l_intervals);

  END LOOP;
  
  IF l_intervals IS NULL OR l_intervals.COUNT = 0 THEN
     l_message := 'Do not find interval for dependents of ' || v_target_guid
                 || '/' || v_metric_guid || '/' || v_key_value;
     IF emdw_log.p_is_error_set THEN
        emdw_log.error('get_min_dep_interval: ' || l_message,
                       G_MODULE);
     END IF;
     IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('get_min_dep_interval:Exit.' 
                         || ' Do not get any interval, return default ', 
                         G_MODULE); 
     END IF;

     return G_DEFAULT_REPO_COLL_INTERVAL;
  END IF; 

  
  l_coll_interval := l_intervals(1);  
  FOR indx IN 2..l_intervals.COUNT
  LOOP
    IF l_intervals(indx) < l_coll_interval THEN
        l_coll_interval := l_intervals(indx);
    END IF;
  END LOOP;
     

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('get_min_dep_interval:Exit. Value is ' 
                     || l_coll_interval,
                     G_MODULE); 
  END IF;

  return l_coll_interval;

END get_min_dep_interval;


-- Computes the eval-order for the direct dependents of
-- the specified (target-guid, metric-guid, key-value)
PROCEDURE COMPUTE_PARENT_EVAL_ORDER(v_target_guid IN RAW,
                                    v_metric_guid IN RAW,
                                    v_key_value IN VARCHAR2)
IS
BEGIN 

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_parent_eval_order:Enter' || '/' ||
      v_target_guid || '/' || v_metric_guid || '/' || v_key_value,
      G_MODULE); 
   END IF;

    -- Use ORDER BY clause here is used avoid deadlocks.
    FOR ptgt IN (SELECT target_guid, metric_guid, key_value
                   FROM mgmt_metric_dependency_details
                  WHERE dep_target_guid = v_target_guid
                    AND dep_metric_guid = v_metric_guid
                    AND dep_key_value = v_key_value
                  ORDER BY target_guid, metric_guid, key_value)
    LOOP
       compute_eval_order(ptgt.target_guid, 
                          ptgt.metric_guid,
                          ptgt.key_value);
    END LOOP;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_parent_eval_order:Exit' || '/' ||
      v_target_guid || '/' || v_metric_guid || '/' || v_key_value,
      G_MODULE); 
   END IF;

END COMPUTE_PARENT_EVAL_ORDER;


-- Computes the eval-order for the direct dependents of
-- the specified target guid
PROCEDURE COMPUTE_PARENT_EVAL_ORDER(v_target_guid IN RAW)
IS
BEGIN 

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_parent_eval_order:Enter' || v_target_guid,
                    G_MODULE); 
   END IF;

    -- Use ORDER BY clause here is used avoid deadlocks.
    FOR ptgt IN (SELECT DISTINCT dep.target_guid, 
                        dep.metric_guid,     
                        dep.key_value
                   FROM mgmt_metric_dependency dep,
                        mgmt_metric_dependency_details det
                  WHERE dep.target_guid = det.target_guid
                    AND dep.metric_guid = det.metric_guid
                    AND dep.key_value   = det.key_value
                    AND dep.rs_metric   = G_DEFINED
                    AND det.dep_target_guid = v_target_guid
                  ORDER BY target_guid, metric_guid, key_value)
    LOOP
       compute_eval_order(ptgt.target_guid, 
                          ptgt.metric_guid,
                          ptgt.key_value);
    END LOOP;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_parent_eval_order:Exit' || v_target_guid,
                    G_MODULE); 
   END IF;

END COMPUTE_PARENT_EVAL_ORDER;



-- Computes the eval-order for the specified 
-- (target, metric,key) combination. This also 
-- computes the eval-order for all the ancestors
PROCEDURE COMPUTE_EVAL_ORDER(v_target_guid IN RAW,
                             v_metric_guid IN RAW,
                             v_key_value IN VARCHAR2)
IS
  l_order      NUMBER := 0;
  l_rs_metric  NUMBER := 0;
BEGIN

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_eval_order:Enter' || '/' ||
      v_target_guid || '/' || v_metric_guid || '/' || v_key_value,
      G_MODULE); 
   END IF;
  
   SELECT rs_metric
     INTO l_rs_metric
     FROM mgmt_metric_dependency
    WHERE target_guid = v_target_guid
      AND metric_guid = v_metric_guid
      AND key_value   = v_key_value;

   -- If this is not rs_metric, then don't evaluate
   -- the metric
   IF (l_rs_metric = G_NOT_DEFINED) THEN
      IF EMDW_LOG.P_IS_DEBUG_SET THEN
        EMDW_LOG.debug('compute_eval_order:Exit - not rs_metric', G_MODULE);
      END IF;
      RETURN;
   END IF;


   -- Eval-order of the target is the MAX of all the
   -- child eval-orders plus one
   SELECT NVL(max(eval_order) + 1, 1)
     INTO l_order
     FROM mgmt_metric_dependency dep,
          mgmt_metric_dependency_details det
    WHERE det.target_guid = v_target_guid
      AND det.metric_guid = v_metric_guid
      AND det.key_value   = v_key_value
      AND dep.target_guid = det.dep_target_guid
      AND dep.metric_guid = det.dep_metric_guid
      AND dep.key_value   = det.key_value;


    IF EMDW_LOG.P_IS_DEBUG_SET THEN
       EMDW_LOG.debug('Eval order = ' || l_order,
                      G_MODULE);
    END IF;


   -- update the eval-order
   UPDATE mgmt_metric_dependency
      SET eval_order = l_order
    WHERE target_guid = v_target_guid
      AND metric_guid = v_metric_guid
      AND key_value   = v_key_value
      AND eval_order <> l_order;

   -- If the rowcount = 1, then that means that we need to update   
   -- the parent eval-orders too
   IF SQL%ROWCOUNT=1 THEN
      compute_parent_eval_order(v_target_guid, v_metric_guid, v_key_value);
  END IF;

   -- Add target-guid info since this is a recursive function
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_eval_order:Exit' || 
                     '/' || v_target_guid ||
                     '/' || v_metric_guid ||
                     '/' || v_key_value,
                      G_MODULE);
   END IF;

END COMPUTE_EVAL_ORDER;

--
-- Computes the evaluation order for the 
-- rs/metric of the specified target
-- 
PROCEDURE COMPUTE_EVAL_ORDER(v_target_guid IN RAW)
IS
  l_metric_guid mgmt_metrics.metric_guid%TYPE;
  l_key_value mgmt_metrics_raw.key_value%TYPE;
BEGIN

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_eval_order:Enter' || v_target_guid,
      G_MODULE); 
   END IF;

   BEGIN
     SELECT metric_guid, key_value
       INTO l_metric_guid, l_key_value
       FROM mgmt_metric_dependency
      WHERE target_guid = v_target_guid
        AND rs_metric = G_DEFINED;

     compute_eval_order(v_target_guid, l_metric_guid, l_key_value);
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
       IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('no rs_metric found for ' || v_target_guid,
                        G_MODULE); 
       END IF;
   END;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('compute_eval_order:Exit' || v_target_guid,
      G_MODULE); 
   END IF;

END COMPUTE_EVAL_ORDER;



-----   BEGIN : SDK API implementation

--
-- PURPOSE
--   To add a list of dependencies that affects the severity state
--   of a metric. The dependencies themselves are metrics. These dependencies
--   are used by the repository to trigger the execution of metric's
--   severity_eval_proc.
--
--   This method allows specifying dependencies at a target type
--   level and meant to be used only for composite target types.
--   
-- PARAMTERS
--
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
--
--   v_dependency_list: A list of MGMT_METRIC_DESC objects containing
--                      the metric dependencies. 
--                     
-- ERROR CODES
--    NO_SUCH_METRIC_ERR: If the metric in metric_desc is not defined.
--    ALREADY_EXISTS_ERR: If dependencies are already defiend for this
--                        metric. Call DELETE_METRIC_SEVERITY_DEPS
--                        to delete existing dependencies.
--
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC,
                                   v_dependency_list IN 
                                             MGMT_METRIC_DESC_ARRAY,
                                   v_opt_code IN NUMBER
                                             DEFAULT NULL)
IS
   l_target_type       MGMT_TARGETS.target_type%TYPE;
   l_count             NUMBER;
   l_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_dep_metric_guid   MGMT_METRICS.metric_guid%TYPE;
   l_opt_code          NUMBER;
   l_eval_proc         MGMT_METRICS.SOURCE%TYPE;
BEGIN
   -- Figure out the metric guid for the metric
   l_metric_guid := mgmt_target.get_metric_guid(v_metric_desc.target_type,
                                                v_metric_desc.metric_name,
                                                v_metric_desc.metric_column);

   -- Make sure that dependencies don't exist for this metric
   SELECT count(*) INTO l_count
     FROM mgmt_metric_dependency_def
    WHERE metric_guid = l_metric_guid
      AND type_meta_ver = v_metric_desc.type_meta_ver;

   IF (l_count > 0) THEN
      raise_application_error (MGMT_GLOBAL.ALREADY_EXISTS_ERR,
       'Metric dependencies already exist for metric ' || 
       v_metric_desc.metric_name || '/' || v_metric_desc.metric_column);
   END IF;


   SELECT DISTINCT target_type INTO l_target_type
     FROM MGMT_METRICS
    WHERE metric_guid = l_metric_guid;

   SELECT DISTINCT source INTO l_eval_proc
     FROM mgmt_metrics
    WHERE type_meta_ver = v_metric_desc.type_meta_ver
      AND metric_guid = l_metric_guid;

   check_standard_eval(l_eval_proc, v_opt_code, l_opt_code);


   -- Add each of the metric dependencies to 
   FOR i IN 1..v_dependency_list.COUNT
   LOOP
      -- Note that we cannot use get_metric_guid here as the metadata
      -- may not have been loaded for the dependency metric.
      l_dep_metric_guid := 
          mgmt_target.generate_metric_column_guid(
                                         v_dependency_list(i).target_type,
                                         v_dependency_list(i).metric_name,
                                         v_dependency_list(i).metric_column);
      BEGIN
        INSERT INTO mgmt_metric_dependency_def
          (target_type, type_meta_ver, metric_guid,
           dep_target_type, dep_metric_guid, opt_code)
        VALUES
          (l_target_type, v_metric_desc.type_meta_ver, l_metric_guid, 
           v_dependency_list(i).target_type, l_dep_metric_guid, l_opt_code);
      EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
        raise_application_error (MGMT_GLOBAL.ALREADY_EXISTS_ERR,
        'Duplicate metric dependencies found for metric ' || 
        v_metric_desc.metric_name || '/' || v_metric_desc.metric_column);
      END;
    END LOOP;

END ADD_METRIC_SEVERITY_DEPS;


--
-- PURPOSE
--     Remove the dependency list for a metric for an entire target
--     type.
-- PARAMTERS
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
-- ERROR CODES
--    NO_SUCH_METRIC_ERR  - If there is no such metric 
-- 
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC)
IS
  l_metric_guid MGMT_METRICS.metric_guid%TYPE;
BEGIN
   l_metric_guid := mgmt_target.get_metric_guid(v_metric_desc.target_type,
                                                v_metric_desc.metric_name,
                                                v_metric_desc.metric_column);

   -- Delete all the dependency details for the metric
   DELETE FROM mgmt_metric_dependency_details d
         WHERE d.metric_guid = l_metric_guid
           AND EXISTS 
               (SELECT 1 
                  FROM mgmt_targets t
                 WHERE t.target_guid = d.target_guid
                   AND t.type_meta_ver = v_metric_desc.type_meta_ver);

   -- Now delete the dependency
   DELETE FROM mgmt_metric_dependency d
         WHERE metric_guid = l_metric_guid
           AND EXISTS 
               (SELECT 1 
                  FROM mgmt_targets t
                 WHERE t.target_guid = d.target_guid
                   AND t.type_meta_ver = v_metric_desc.type_meta_ver);

   -- Finally delete the definition itself
   DELETE FROM mgmt_metric_dependency_def
         WHERE metric_guid = l_metric_guid
           AND type_meta_ver = v_metric_desc.type_meta_ver;

   
   SUSPEND_NULL_DEP_DATA_COLL;

END DELETE_METRIC_SEVERITY_DEPS;



--
-- This is deprecated.Use add_repo_metric_collection instead.
--                     
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_instance IN MGMT_METRIC_INSTANCE,
                                   v_dependency_list IN 
                                        MGMT_METRIC_INSTANCE_ARRAY)
IS
  l_eval_func VARCHAR2(256);
BEGIN

  BEGIN
   SELECT DISTINCT source
     INTO l_eval_func
     FROM mgmt_metrics m, mgmt_targets t
    WHERE m.metric_name = v_metric_instance.metric_name
      AND m.metric_column = v_metric_instance.metric_column
      AND m.target_type = v_metric_instance.target_type
      AND t.target_name = v_metric_instance.target_name
      AND t.target_type = v_metric_instance.target_type
      AND m.type_meta_ver = t.type_meta_ver;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
        raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Eval func not registered for metric evaluation ' ||
        '<target_name>/<metric_name>/<metric_column> ' || 
       v_metric_instance.target_name || '/' || v_metric_instance.metric_name
       || v_metric_instance.metric_column);

    -- This will happen if different eval-funcs are registered based on
    -- cat props and this is not supported
    WHEN TOO_MANY_ROWS THEN
        raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Multiple eval funcs registered for metric evaluation ' ||
        '<target_name>/<metric_name>/<metric_column> ' || 
       v_metric_instance.target_name || '/' || v_metric_instance.metric_name
       || v_metric_instance.metric_column);
  END;

  ADD_REPO_METRIC_COLLECTION(v_metric_instance, l_eval_func, v_dependency_list);

END ADD_METRIC_SEVERITY_DEPS;



--
-- This is deprecated. Use modify_repo_metric_collection and
-- delete_repo_metric_collection instead.
--
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_instance IN
                                            MGMT_METRIC_INSTANCE,
                                      v_dependency_list IN
                                            MGMT_METRIC_INSTANCE_ARRAY)
IS
   l_target_guid  MGMT_TARGETS.target_guid%TYPE;
   l_metric_guid  MGMT_METRICS.metric_guid%TYPE;
   l_dep_target_guid MGMT_TARGETS.target_guid%TYPE;
   l_dep_metric_guid MGMT_METRICS.metric_guid%TYPE;
   l_count       NUMBER;
   l_key_value   MGMT_SEVERITY.key_value%TYPE;
   l_rs_metric   NUMBER(1);
BEGIN
   l_target_guid := mgmt_target.get_target_guid(v_metric_instance.target_name,
                                                v_metric_instance.target_type);

   l_metric_guid := mgmt_target.get_metric_guid(v_metric_instance.target_type,
                                                v_metric_instance.metric_name,
                                                v_metric_instance.metric_column);

   l_key_value := NVL(v_metric_instance.key_value, ' ');

   IF (v_dependency_list IS NULL) THEN
      -- Delete all the dependency details for the metric
      DELETE FROM mgmt_metric_dependency_details
            WHERE metric_guid = l_metric_guid 
              AND target_guid = l_target_guid
              AND key_value   = l_key_value;
  
      -- Now delete the dependency itself
      DELETE FROM mgmt_metric_dependency 
            WHERE metric_guid = l_metric_guid 
              AND target_guid = l_target_guid
              AND key_value   = l_key_value
          RETURNING rs_metric INTO l_rs_metric;

     -- recompute parent's eval orders
     IF (l_rs_metric = G_DEFINED) THEN
       compute_parent_eval_order(l_target_guid, l_metric_guid, l_key_value);
     END IF;

   ELSE
       FOR i IN 1..v_dependency_list.COUNT
       LOOP
          l_dep_target_guid := 
               mgmt_target.get_target_guid(v_dependency_list(i).target_name,
                                           v_dependency_list(i).target_type);

          l_dep_metric_guid := 
             mgmt_target.get_metric_guid(v_dependency_list(i).target_type,
                                         v_dependency_list(i).metric_name,
                                         v_dependency_list(i).metric_column);
       
          DELETE FROM mgmt_metric_dependency_details
               WHERE target_guid = l_target_guid
                 AND metric_guid = l_metric_guid 
                 AND key_value   = l_key_value 
                 AND dep_target_guid = l_dep_target_guid
                 AND dep_metric_guid = l_dep_metric_guid
                 AND dep_key_value = NVL(v_dependency_list(i).key_value, ' ');

      END LOOP;

     check_for_null_dependencies(l_target_guid, l_metric_guid, l_key_value);

   END IF;
   SUSPEND_NULL_DEP_DATA_COLL; 
END DELETE_METRIC_SEVERITY_DEPS;

--
-- private fucntion
-- 1. save min_dep_interval
-- 2. return coll_interval
FUNCTION get_coll_interval(v_target_guid IN RAW,
                           v_metric_guid IN RAW,
                           v_key_value IN VARCHAR2,
                           v_min_dep_interval IN NUMBER,
                           v_coll_interval IN NUMBER)
RETURN NUMBER
IS
l_min_dep_interval NUMBER;
l_coll_interval NUMBER;
BEGIN
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('get_coll_interval:Enter' || 
                     '/' || v_target_guid ||
                     '/' || v_metric_guid ||
                     '/' || v_key_value ||
                     '/ min interval ' || v_min_dep_interval ||
                     '/ coll interval ' || v_coll_interval,
                      G_MODULE);
   END IF;

   IF v_min_dep_interval IS NOT NULL THEN
      l_min_dep_interval := v_min_dep_interval;
   ELSE
      l_min_dep_interval := get_min_dep_interval(v_target_guid,
                                            v_metric_guid, v_key_value);
   END IF;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('get_coll_interval: ' || 
                     ' min dep collection interval is ' || l_min_dep_interval,
                      G_MODULE);
   END IF;

   UPDATE mgmt_metric_dependency
      SET min_dep_interval = l_min_dep_interval
    WHERE target_guid = v_target_guid
      AND metric_guid = v_metric_guid
      AND key_value = v_key_value;
      
   IF v_coll_interval IS NOT NULL THEN
      l_coll_interval := v_coll_interval;
   ELSE
      l_coll_interval := l_min_dep_interval;
   END IF;

   IF l_coll_interval < G_MIN_REPO_COLL_INTERVAL THEN
       l_coll_interval := G_MIN_REPO_COLL_INTERVAL;
   END IF;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('get_coll_interval:Exit' || 
                     ' collection interval is ' || l_coll_interval,
                      G_MODULE);
   END IF;

   return l_coll_interval;

END get_coll_interval;

--
--   Sets up a repository collection for the specified metric. The
--   collection will apply the eval_proc over the list of dependency
--   metrics to compute the metric. Duplicate dependencies are ignored.
--
PROCEDURE ADD_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                     v_eval_proc       IN VARCHAR2,
                                     v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                     v_coll_interval   IN NUMBER DEFAULT NULL,
                                     v_dep_coll_names IN 
                                        SMP_EMD_STRING_ARRAY DEFAULT NULL,
                                     v_min_dep_interval IN NUMBER DEFAULT NULL,
                                     v_opt_code IN NUMBER DEFAULT NULL)
IS
   l_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_table_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_event_metric      NUMBER(1);
   l_target_guid       MGMT_TARGETS.target_guid%TYPE;
   l_dep_metric_guid   MGMT_METRICS.metric_guid%TYPE;
   l_dep_target_guid   MGMT_TARGETS.target_guid%TYPE;
   l_target_tzrgn      MGMT_TARGETS.timezone_region%TYPE;
   l_key_value         MGMT_SEVERITY.key_value%TYPE;
   l_num_keys          MGMT_METRICS.num_keys%TYPE;
   l_start_ts      DATE;
   l_sysdate_trgn  DATE;
   l_members_ready     NUMBER := 0;
   l_coll_name         VARCHAR2(256);
   l_interval          NUMBER;
   l_min_dep_interval  NUMBER;
   l_rs_metric         NUMBER;
   l_opt_code          NUMBER;
   l_repo_metric_only NUMBER := 0;
BEGIN
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('add_repo_metric_collection:Enter' || 
                     '/' || v_metric.target_name ||
                     '/' || v_metric.target_type ||
                     '/' || v_metric.metric_name ||
                     '/' || v_metric.metric_column ||
                     '/' || v_metric.key_value,
                      G_MODULE);
   END IF;

   get_metric_info(v_metric, l_target_guid, l_metric_guid, 
                   l_target_tzrgn, l_event_metric);

   -- Don't allow adding multi-key column metrics for now. This requires
   -- code changes in metric helper functions.
   SELECT DISTINCT num_keys
     INTO l_num_keys
     FROM mgmt_metrics m, mgmt_targets t
    WHERE t.target_name = v_metric.target_name
      AND t.target_type = v_metric.target_type
      AND m.target_type = v_metric.target_type
      AND m.metric_name = v_metric.metric_name
      AND m.metric_column = v_metric.metric_column
      AND m.type_meta_ver = t.type_meta_ver
      AND (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ')
      AND (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ')
      AND (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ')
      AND (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ')
      AND (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ');

   IF (l_num_keys > 1) THEN
        IF EMDW_LOG.P_IS_ERROR_SET THEN
          EMDW_LOG.error('Multi-key column found - raising an exception', 
                         G_MODULE);
        END IF;

        raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Repository collections for Multi-key column metrics not supported ' ||
        '<target_name>/<metric_name>/<metric_column> ' || 
         v_metric.target_name || '/' || v_metric.metric_name || v_metric.metric_column);
   END IF;
   
   l_key_value := NVL(v_metric.key_value, ' ');

   IF (v_dep_metrics.COUNT > 0) THEN
     l_members_ready := 1;
   END IF;


   -- if this is response/status metric, mark this target - ping system
   -- should not update the avaialbility and markers if the response/status
   -- is calculated on the repository side
   IF (v_metric.metric_name = mgmt_global.G_AVAIL_METRIC_NAME AND
       v_metric.metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN) THEN
        UPDATE mgmt_targets
          SET rep_side_avail = 1
        WHERE target_guid = l_target_guid;
       
        l_rs_metric := 1;
        check_repo_metric_only(v_metric.target_name, v_metric.target_type,
                              l_repo_metric_only);

   END IF;

   check_callback_signature(l_event_metric,v_eval_proc) ;

   l_start_ts := mgmt_global.sysdate_tzrgn(l_target_tzrgn) - 5/(24*60);
   
   check_standard_eval(v_eval_proc, v_opt_code, l_opt_code);
   -- Add an entry into metric_dependency table
   BEGIN
     INSERT INTO mgmt_metric_dependency
          (target_guid, metric_guid, key_value, members_ready, 
           can_calculate, start_timestamp, force_calculate, 
           eval_func, event_metric, rs_metric, opt_code, repo_metric_only)
     VALUES
          (l_target_guid, l_metric_guid, l_key_value, l_members_ready,
           1, l_start_ts, 1, 
           v_eval_proc, l_event_metric, l_rs_metric, l_opt_code, l_repo_metric_only);
   EXCEPTION
       -- We should never get this in theory but the old API used to allow
       -- calling add_metric_sev_apis in re-entrant fashion
       WHEN DUP_VAL_ON_INDEX THEN
          -- Ignore duplicate entries
          NULL;
   END;


   -- Now add the metric dependencies to the details table   
   add_dependencies(l_target_guid, l_metric_guid, l_key_value, v_dep_metrics,
                    v_dep_coll_names);

   -- Set the eval-order
   compute_eval_order(l_target_guid, l_metric_guid, l_key_value);

   -- If this is a data collection, then register a repository collection
   IF (l_event_metric = G_NOT_DEFINED) THEN

     IF v_dep_metrics IS NULL OR v_dep_metrics.COUNT = 0 THEN
        raise_application_error(mgmt_global.INVALID_METRIC_DEP_ERR,
                                    'Metric has 0 dependency ');
     END IF;

     l_coll_name := get_collection_name(v_metric.target_type, 
                                         v_metric.metric_name,
                                         v_metric.metric_column,
                                         v_metric.key_value);
      check_existing_coll_name(v_metric.target_name,
                               v_metric.target_type,
                               l_coll_name);


      l_interval := get_coll_interval(l_target_guid,
                                      l_metric_guid,
                                      l_key_value,
                                      v_min_dep_interval,
                                      v_coll_interval);
  

      IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('coll_name = ' || l_coll_name ||
                        '; interval = ' || l_interval,
                        G_MODULE);
      END IF;

      mgmt_collection.start_collection(
                p_target_type   =>  v_metric.target_type,
                p_target_name   =>  v_metric.target_name,
                p_metric_name   =>  v_metric.metric_name,
                p_metric_column =>  ' ',
                p_coll_name     =>  l_coll_name,
                p_coll_schedule => 
                    mgmt_coll_schedule_obj.interval_schedule(l_interval, null, null));
      l_table_metric_guid := mgmt_target.get_metric_guid(v_metric.target_type,
                                                         v_metric.metric_name,
                                                         ' ');
      -- save column_guid and key value as collection properties
      EM_COLL_UTIL.add_coll_item_property(p_object_guid => l_target_guid,
                                          p_object_type => 
                                               MGMT_GLOBAL.G_OBJECT_TYPE_TARGET, 
                                          p_metric_guid => l_table_metric_guid,
                                          p_coll_name   => l_coll_name,
                                          p_property_name =>
                                                G_COLUME_GUID_PROP,
                                          p_property_value =>
                                                RAWTOHEX(l_metric_guid));

      EM_COLL_UTIL.add_coll_item_property(p_object_guid => l_target_guid,
                                          p_object_type => 
                                               MGMT_GLOBAL.G_OBJECT_TYPE_TARGET, 
                                          p_metric_guid => l_table_metric_guid,
                                          p_coll_name   => l_coll_name,
                                          p_property_name =>
                                                G_KEY_VALUE_PROP,
                                          p_property_value =>
                                                l_key_value);
   ELSE
     add_dummy_collection(v_metric.target_name,
                          v_metric.target_type,
                          v_metric.metric_name,
                          v_metric.metric_column,
                          l_key_value);
   END IF;
 
   check_for_null_dependencies(l_target_guid, l_metric_guid, l_key_value);

   -- Do a synchronous evaluation if this is a rs metric
   IF (l_rs_metric = 1) THEN
     IF EMDW_LOG.P_IS_DEBUG_SET THEN
        EMDW_LOG.debug('Synchronously evaluating availability', G_MODULE);
     END IF;

     l_start_ts := compute_start_time(l_target_guid, l_metric_guid);

     UPDATE mgmt_metric_dependency
        SET start_timestamp = l_start_ts
      WHERE target_guid = l_target_guid
        AND metric_guid = l_metric_guid;

    em_severity_repos.evaluate_target_severities(l_target_guid, TRUE);
    
   END IF; 

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('add_repo_metric_collection:Exit', G_MODULE);
   END IF;

END ADD_REPO_METRIC_COLLECTION;

--suspend a data collection and insert metric error
PROCEDURE SUSPEND_ONE_DATA_COLL(v_target_type IN VARCHAR2,
                                v_target_name IN VARCHAR2,
                                v_metric_name IN VARCHAR2,
                                v_metric_column IN VARCHAR2,
                                v_coll_name IN VARCHAR2)
IS
l_table_metric_guid mgmt_metrics.metric_guid%TYPE;
BEGIN
    IF EMDW_LOG.P_IS_DEBUG_SET
    THEN
        EMDW_LOG.DEBUG('Suspend metric collection Tgt='||
                 v_target_name || '/' || v_target_type || ' Metric= '
                ||v_metric_name|| '/' || v_metric_column ||
                 ' Coll='||v_coll_name,G_MODULE) ;
    END IF ;


    mgmt_collection.suspend_collection(p_target_type => v_target_type,
                                     p_target_name => v_target_name,
                                     p_metric_name => v_metric_name,
                                     p_metric_column => v_metric_column,
                                     p_coll_name => v_coll_name);

    -- call run_collection, it will log the metric error
    BEGIN
      mgmt_collection.run_collection
            (p_target_name => v_target_name,
             p_target_type => v_target_type,
             p_metric_name => v_metric_name,
             p_metric_column => ' ',
             p_coll_name => v_coll_name);
   EXCEPTION
     WHEN others THEN
        IF SQLCODE = MGMT_GLOBAL.COLLECTION_ERR THEN
          NULL;
        ELSE
          MGMT_LOG.log_error(
              v_module_name_in=>MGMT_COLLECTION.G_MODULE_NAME,
              v_error_code_in=>MGMT_GLOBAL.COLLECTION_ERR,
              v_error_msg_in=>'Fail to generate metric error for  ' 
                              || ' Target='||v_target_name||
                             ' Collection='|| v_coll_name ||
                             ' Error='|| substr(sqlerrm,1024),
              v_facility_in=>NULL,
              v_log_level_in=>MGMT_GLOBAL.G_ERROR) ;

          RAISE;
        END IF;
   END;
END SUSPEND_ONE_DATA_COLL;

-- resume  suspended data collection
-- check if the metric has dependency and if the collection is suspended
PROCEDURE RESUME_DATA_COLL(v_target_type IN VARCHAR2,
                                           v_target_name IN VARCHAR2,
                                           v_metric_name IN VARCHAR2,
                                           v_metric_column IN VARCHAR2,
                                           v_coll_name IN VARCHAR2,
                                           v_key_value IN VARCHAR2,
                                       v_target_guid mgmt_targets.target_guid%TYPE,
                                       v_metric_guid mgmt_metrics.metric_guid%TYPE)
IS
l_enabled mgmt_collections.is_enabled%TYPE;
l_count NUMBER;
l_table_metric_guid mgmt_metrics.metric_guid%TYPE;
BEGIN

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('resume_data_coll: enter ',  
                  G_MODULE);
  END IF;
  SELECT is_enabled 
    INTO l_enabled
   FROM mgmt_collections
   WHERE object_guid = v_target_guid
     AND coll_name = v_coll_name
     AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET;

  SELECT COUNT(*) 
    INTO l_count
   FROM mgmt_metric_dependency_details
  WHERE target_guid = v_target_guid
    AND metric_guid = v_metric_guid
    AND key_value = v_key_value;

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
    EMDW_LOG.debug('Dependency count is ' || l_count || 
                   ' collection is enabled ' || l_enabled, G_MODULE);
  END IF;
 

  IF l_enabled = MGMT_GLOBAL.G_FALSE AND l_count > 0 THEN
    mgmt_collection.resume_collection(p_target_type => v_target_type,
                                     p_target_name => v_target_name,
                                     p_metric_name => v_metric_name,
                                     p_metric_column => v_metric_column,
                                     p_coll_name => v_coll_name);
    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('Resume suspended collection for ' ||
                     '/' || v_target_name ||
                     '/' || v_target_type ||
                     '/' || v_metric_name ||
                     '/' || v_metric_column ||
                     '/' || v_key_value,
                      G_MODULE);
    END IF;
  END IF;

  IF l_count > 0 THEN
      mgmt_collection.run_collection
            (p_target_name => v_target_name,
             p_target_type => v_target_type,
             p_metric_name => v_metric_name,
             p_metric_column => ' ',
             p_coll_name => v_coll_name);
  END IF;

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('resume_data_coll: exit ',  
                  G_MODULE);
  END IF;
END RESUME_DATA_COLL;

-- after metric dependency detail is deleted, 
-- check if any data collection has 0 dependency
-- suspend those collection if needed
PROCEDURE SUSPEND_NULL_DEP_DATA_COLL
IS
l_enabled mgmt_collections.is_enabled%TYPE;
l_coll_name mgmt_collections.coll_name%TYPE;
l_target_type mgmt_targets.target_type%TYPE;
l_target_name mgmt_targets.target_name%TYPE;
l_metric_name mgmt_metrics.metric_name%TYPE;
l_metric_column mgmt_metrics.metric_column%TYPE;
BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('suspend_null_dep_data_coll: enter ',  
                  G_MODULE);
  END IF;
  FOR rec IN (SELECT target_guid, metric_guid, key_value, event_metric
                FROM mgmt_metric_dependency d
               WHERE NOT EXISTS (SELECT 1 
                                   FROM mgmt_metric_dependency_details
                                  WHERE target_guid = d.target_guid
                                    AND metric_guid = d.metric_guid
                                    AND key_value = d.key_value))
  LOOP
    IF rec.event_metric = G_NOT_DEFINED THEN
      SELECT target_type, target_name
        INTO l_target_type, l_target_name
       FROM mgmt_targets
      WHERE target_guid = rec.target_guid;

      SELECT  metric_name, metric_column
        INTO l_metric_name, l_metric_column
        FROM mgmt_metrics
       WHERE metric_guid = rec.metric_guid
         AND ROWNUM = 1;

      l_coll_name := get_collection_name(l_target_type, 
                                         l_metric_name,
                                         l_metric_column,
                                         rec.key_value);
      IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('suspend_null_dep_data_coll: metric has 0 dependency ' || 
                      l_target_name ||
                     '/' || l_target_type ||
                     '/' || l_metric_name ||
                     '/' || l_metric_column ||
                     '/' || rec.key_value,
                      G_MODULE);
       END IF;
      
      BEGIN
       SELECT is_enabled 
         INTO l_enabled
         FROM mgmt_collections
        WHERE object_guid = rec.target_guid
          AND coll_name = l_coll_name
          AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET;
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
         l_enabled := mgmt_global.G_FALSE;
      END; 

      IF l_enabled = mgmt_global.G_TRUE THEN
        SUSPEND_ONE_DATA_COLL(v_target_type => l_target_type,
                             v_target_name => l_target_name,
                             v_metric_name => l_metric_name,
                             v_metric_column => l_metric_column,
                             v_coll_name => l_coll_name);
      END IF;
   END IF; -- rec.event_metric = G_NOT_DEFINED
  END LOOP;            
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('suspend_null_dep_data_coll:  exit',
                  G_MODULE);
  END IF;
END SUSPEND_NULL_DEP_DATA_COLL;
--
--   Modifies repository collection details for the specified metric. 
--
PROCEDURE MODIFY_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                        v_eval_proc       IN VARCHAR2,
                                        v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                        v_coll_interval  IN NUMBER DEFAULT NULL,
                                        v_dep_coll_names IN 
                                            SMP_EMD_STRING_ARRAY DEFAULT NULL,
                                        v_min_dep_interval IN NUMBER 
                                                            DEFAULT NULL,
                                        v_opt_code IN NUMBER DEFAULT NULL)
IS
   l_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_target_guid       MGMT_TARGETS.target_guid%TYPE;
   l_dep_metric_guid   MGMT_METRICS.metric_guid%TYPE;
   l_dep_target_guid   MGMT_TARGETS.target_guid%TYPE;
   l_key_value         MGMT_SEVERITY.key_value%TYPE;
   l_dep_start_ts      DATE;
   l_event_metric      NUMBER(1);
   l_target_tzrgn      MGMT_TARGETS.timezone_region%TYPE;
   l_locked            BOOLEAN;
   l_rs_metric         NUMBER(1);
   l_coll_name         VARCHAR2(256);
   l_interval          NUMBER;
   l_opt_code          NUMBER;
BEGIN
   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('modify_repo_metric_collection:Enter' || 
                     '/' || v_metric.target_name ||
                     '/' || v_metric.target_type ||
                     '/' || v_metric.metric_name ||
                     '/' || v_metric.metric_column ||
                     '/' || v_metric.key_value,
                      G_MODULE);
   END IF;

   get_metric_info(v_metric, l_target_guid, l_metric_guid, 
                    l_target_tzrgn, l_event_metric);
    
   l_key_value := NVL(v_metric.key_value, ' ');
 
   IF NOT check_repo_metric_existence(l_target_guid, l_metric_guid, l_key_value) THEN
        IF EMDW_LOG.P_IS_DEBUG_SET THEN
           EMDW_LOG.debug('modify_repo_metric_collection:Exit. metric not existing',
                      G_MODULE);
        END IF;
        RETURN;
   END IF;

   check_callback_signature(l_event_metric,v_eval_proc) ;

   l_locked := em_rep_metric.lock_target_deps(l_target_guid);
 
   check_standard_eval(v_eval_proc, v_opt_code, l_opt_code);

   UPDATE mgmt_metric_dependency
      SET eval_func = v_eval_proc,
          opt_code  = l_opt_code
    WHERE target_guid = l_target_guid
      AND metric_guid = l_metric_guid
      AND key_value   = l_key_value;
   

   IF SQL%ROWCOUNT=0 THEN
      raise_application_error (MGMT_GLOBAL.INVALID_PARAMS_ERR,
       'No collection found for <target_name>/<metric_name>/<metric_column> ' || 
       v_metric.target_name || '/' || v_metric.metric_name || v_metric.metric_column);
   END IF;


   -- Delete all the dependency details for the metric
   DELETE FROM mgmt_metric_dependency_details
         WHERE metric_guid = l_metric_guid 
           AND target_guid = l_target_guid
           AND key_value   = l_key_value;
 

   -- Now add the metric dependencies to the details table   
   add_dependencies(l_target_guid, l_metric_guid, l_key_value, v_dep_metrics,
                    v_dep_coll_names);

   -- Recompute the eval-order
   compute_eval_order(l_target_guid, l_metric_guid, l_key_value);

   -- If this is a data collection 
   IF l_event_metric = G_NOT_DEFINED THEN

     IF v_dep_metrics IS NULL OR v_dep_metrics.COUNT = 0 THEN
        raise_application_error(mgmt_global.INVALID_METRIC_DEP_ERR,
                                    'Metric has 0 dependency ');
     END IF;
      l_coll_name := get_collection_name(v_metric.target_type, 
                                         v_metric.metric_name,
                                         v_metric.metric_column,
                                         v_metric.key_value);

      l_interval := get_coll_interval(l_target_guid,
                                      l_metric_guid,
                                      l_key_value,
                                      v_min_dep_interval,
                                      v_coll_interval);

      IF EMDW_LOG.P_IS_DEBUG_SET THEN
         EMDW_LOG.debug('coll_name = ' || l_coll_name ||
                        '; interval = ' || l_interval,
                        G_MODULE);
      END IF;

      mgmt_collection.modify_collection(
                p_target_type   =>  v_metric.target_type,
                p_target_name   =>  v_metric.target_name,
                p_metric_name   =>  v_metric.metric_name,
                p_metric_column =>  ' ',
                p_coll_name     =>  l_coll_name,
                p_coll_schedule => 
                    mgmt_coll_schedule_obj.interval_schedule(l_interval,
                                                             null, null));
     RESUME_DATA_COLL(v_target_type => v_metric.target_type,
                                      v_target_name => v_metric.target_name,
                                      v_metric_name => v_metric.metric_name,
                                      v_metric_column => v_metric.metric_column,
                                      v_coll_name => l_coll_name,
                                      v_key_value => v_metric.key_value,
                                      v_target_guid => l_target_guid,
                                      v_metric_guid => l_metric_guid);
   END IF;

   -- update the ready status
   check_for_null_dependencies(l_target_guid, l_metric_guid, l_key_value);

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('modify_repo_metric_collection:Exit', G_MODULE);
   END IF;
  

END MODIFY_REPO_METRIC_COLLECTION;


--
--   Modifies repository collection dependencies for the specified metric. 
--
PROCEDURE MODIFY_REPO_METRIC_DEPS(v_metric IN MGMT_METRIC_INSTANCE,
                                   v_dep_metrics_to_add IN 
                                        MGMT_METRIC_INSTANCE_ARRAY,
                                   v_dep_metrics_to_del IN 
                                        MGMT_METRIC_INSTANCE_ARRAY)
IS
   l_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_target_guid       MGMT_TARGETS.target_guid%TYPE;
   l_dep_metric_guid   MGMT_METRICS.metric_guid%TYPE;
   l_dep_target_guid   MGMT_TARGETS.target_guid%TYPE;
   l_key_value         MGMT_SEVERITY.key_value%TYPE;
   l_dep_start_ts      DATE;
   l_start_ts          DATE;
   l_count             NUMBER;
   l_event_metric      NUMBER(1);
   l_dep_event_metric  NUMBER(1);
   l_target_tzrgn      MGMT_TARGETS.timezone_region%TYPE;
   l_locked            BOOLEAN;
   l_coll_name mgmt_collections.coll_name%TYPE;
BEGIN

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('modify_repo_metric_deps:Enter' || 
                     '/' || v_metric.target_name ||
                     '/' || v_metric.target_type ||
                     '/' || v_metric.metric_name ||
                     '/' || v_metric.metric_column ||
                     '/' || v_metric.key_value,
                      G_MODULE);
   END IF;


   get_metric_info(v_metric, l_target_guid, l_metric_guid, 
                   l_target_tzrgn, l_event_metric);
   
   l_key_value := NVL(v_metric.key_value, ' ');

   l_locked := em_rep_metric.lock_target_deps(l_target_guid); 

   -- Delete the unwanted dependencies first 
   FOR i IN 1..v_dep_metrics_to_del.COUNT
   LOOP
      get_metric_info(v_dep_metrics_to_del(i), l_dep_target_guid, l_dep_metric_guid, 
                   l_target_tzrgn, l_dep_event_metric);

     DELETE FROM mgmt_metric_dependency_details
        WHERE target_guid = l_target_guid
          AND metric_guid = l_metric_guid 
          AND key_value   = l_key_value 
          AND dep_target_guid = l_dep_target_guid
          AND dep_metric_guid = l_dep_metric_guid
          AND dep_key_value = NVL(v_dep_metrics_to_del(i).key_value, ' ');
    END LOOP;

   -- Now add the metric dependencies to the details table   
   add_dependencies(l_target_guid, l_metric_guid, l_key_value, v_dep_metrics_to_add);

   -- resume suspended data collection
   IF l_event_metric = G_NOT_DEFINED THEN
     SELECT count(*) 
       INTO l_count
       FROM mgmt_metric_dependency_details
      WHERE target_guid = l_target_guid
        AND metric_guid = l_metric_guid
        AND key_value = l_key_value;

     IF l_count = 0  THEN
        raise_application_error(mgmt_global.INVALID_METRIC_DEP_ERR,
                                    'Metric has 0 dependency ');
     END IF;
     l_coll_name :=  get_collection_name(v_metric.target_type,
                                         v_metric.metric_name,
                                         v_metric.metric_column,
                                         v_metric.key_value);
     RESUME_DATA_COLL(v_target_type => v_metric.target_type,
                                      v_target_name => v_metric.target_name,
                                      v_metric_name => v_metric.metric_name,
                                      v_metric_column => v_metric.metric_column,
                                      v_coll_name => l_coll_name,
                                      v_key_value => v_metric.key_value,
                                      v_target_guid => l_target_guid,
                                      v_metric_guid => l_metric_guid);
 
   END IF;
   -- Recompute the eval-order
   compute_eval_order(l_target_guid, l_metric_guid, l_key_value);

   -- update the ready status
   check_for_null_dependencies(l_target_guid, l_metric_guid, l_key_value);

   -- Is this response/status metric
   IF (v_metric.metric_name = mgmt_global.G_AVAIL_METRIC_NAME AND
       v_metric.metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN) THEN

     IF EMDW_LOG.P_IS_DEBUG_SET THEN
        EMDW_LOG.debug('Synchronously evaluating availability', G_MODULE);
     END IF;

     l_start_ts := compute_start_time(l_target_guid, l_metric_guid);

     UPDATE mgmt_metric_dependency
        SET start_timestamp = l_start_ts
      WHERE target_guid = l_target_guid
        AND metric_guid = l_metric_guid;


     em_severity_repos.evaluate_target_severities(l_target_guid, TRUE);
   END IF;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('modify_repo_metric_deps:Exit',  G_MODULE);
   END IF;

END MODIFY_REPO_METRIC_DEPS;


--
--   Remove a repository metric collection. The metric data is not removed
--   as a result of deleting the collection.
-- 
PROCEDURE DELETE_REPO_METRIC_COLLECTION(v_metric IN MGMT_METRIC_INSTANCE,
                                        v_clear_dependency IN NUMBER
                                                 DEFAULT mgmt_global.G_TRUE) 
IS
   l_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_table_metric_guid       MGMT_METRICS.metric_guid%TYPE;
   l_target_guid       MGMT_TARGETS.target_guid%TYPE;
   l_key_value         MGMT_SEVERITY.key_value%TYPE;
   l_event_metric      NUMBER(1);
   l_target_tzrgn      MGMT_TARGETS.timezone_region%TYPE;
   l_locked            BOOLEAN;
   l_coll_name         VARCHAR2(256);
   l_rs_metric         NUMBER(1);
BEGIN

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('delete_repo_metric_collection:Enter' || 
                     '/' || v_metric.target_name ||
                     '/' || v_metric.target_type ||
                     '/' || v_metric.metric_name ||
                     '/' || v_metric.metric_column ||
                     '/' || v_metric.key_value,
                      G_MODULE);
   END IF;


   get_metric_info(v_metric, l_target_guid, l_metric_guid, 
                   l_target_tzrgn, l_event_metric);
   
   l_key_value := NVL(v_metric.key_value, ' ');

   IF NOT check_repo_metric_existence(l_target_guid, l_metric_guid, l_key_value) THEN
        IF EMDW_LOG.P_IS_DEBUG_SET THEN
           EMDW_LOG.debug('delete_repo_metric_collection:Exit. metric not existing',
                      G_MODULE);
        END IF;
        RETURN;
   END IF;

   l_locked := em_rep_metric.lock_target_deps(l_target_guid); 

   -- Remove the repo collection
   IF (l_event_metric = G_NOT_DEFINED) THEN

      l_coll_name := get_collection_name(v_metric.target_type, 
                                         v_metric.metric_name,
                                         v_metric.metric_column,
                                         v_metric.key_value);

      mgmt_collection.stop_collection(
                p_target_type   =>  v_metric.target_type,
                p_target_name   =>  v_metric.target_name,
                p_metric_name   =>  v_metric.metric_name,
                p_metric_column =>  ' ',
                p_coll_name     =>  l_coll_name);

      l_table_metric_guid := mgmt_target.get_metric_guid(v_metric.target_type,
                                                         v_metric.metric_name,
                                                         ' ');

      EM_COLL_UTIL.delete_coll_item_property(p_object_guid => l_target_guid,
                                          p_metric_guid => l_table_metric_guid,
                                          p_coll_name   => l_coll_name,
                                          p_property_name =>
                                                G_COLUME_GUID_PROP);

      EM_COLL_UTIL.delete_coll_item_property(p_object_guid => l_target_guid,
                                          p_metric_guid => l_table_metric_guid,
                                          p_coll_name   => l_coll_name,
                                          p_property_name =>
                                                G_KEY_VALUE_PROP);
      
   ELSE
     delete_dummy_collection(v_target_name => v_metric.target_name,
                             v_target_type => v_metric.target_type,
                             v_metric_name => v_metric.metric_name,
                             v_metric_column => v_metric.metric_column,
                             v_key_value => v_metric.key_value);
   END IF;

   -- delete the dependencies first
   DELETE FROM mgmt_metric_dependency_details
      WHERE target_guid = l_target_guid
        AND metric_guid = l_metric_guid 
        AND key_value   = l_key_value;

   -- now delete the dependency itself
   DELETE FROM mgmt_metric_dependency
      WHERE target_guid = l_target_guid
        AND metric_guid = l_metric_guid 
        AND key_value   = l_key_value
     RETURNING rs_metric INTO l_rs_metric;

   cleanup_metric(l_target_guid, l_metric_guid, l_key_value);

   -- recompute parent's eval orders before cleaning up the 
   -- metric dependencies
   IF (l_rs_metric = G_DEFINED) THEN
      compute_parent_eval_order(l_target_guid, l_metric_guid, l_key_value);
   END IF;

   -- when a service is switching from system based to test based,
   -- we will not clear the dependency of high level aggregate service.
   IF (v_clear_dependency = mgmt_global.G_TRUE) THEN
      remove_metric_dependency(l_target_guid, l_metric_guid, l_key_value);
   END IF;

   SUSPEND_NULL_DEP_DATA_COLL;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('del_repo_metric_collection:Exit',  G_MODULE);
   END IF;


END DELETE_REPO_METRIC_COLLECTION;


--
-- PURPOSE
--   Sets the eval proc for a repo collection
--
PROCEDURE SET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       IN VARCHAR2,
                                    v_opt_code IN NUMBER DEFAULT NULL)
IS
l_event_metric mgmt_metric_dependency.event_metric%type := 0 ;
l_opt_code NUMBER;
BEGIN
  SAVEPOINT set_repo_metric_eval_proc ;

  check_standard_eval(v_eval_proc, v_opt_code, l_opt_code);

   UPDATE mgmt_metric_dependency
     SET eval_func = v_eval_proc,
         opt_code = l_opt_code
   WHERE target_guid = mgmt_target.get_target_guid(
                                    v_metric.target_name, 
                                    v_metric.target_type)
     AND metric_guid = mgmt_metric.get_metric_guid(
                                     v_metric.target_type, 
                                     v_metric.metric_name,
                                     v_metric.metric_column)
     AND key_value   = NVL(v_metric.key_value, ' ')
    RETURNING event_metric INTO l_event_metric ;
   check_callback_signature(l_event_metric,v_eval_proc) ;
EXCEPTION
WHEN OTHERS THEN
  ROLLBACK TO SAVEPOINT set_repo_metric_eval_proc ;
  RAISE ;
END SET_REPO_METRIC_EVAL_PROC;

--
-- PURPOSE
--   Sets the eval proc for a repo collection
--
PROCEDURE GET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       OUT VARCHAR2)
IS
BEGIN
   SELECT eval_func 
     INTO v_eval_proc
    FROM mgmt_metric_dependency
   WHERE target_guid = mgmt_target.get_target_guid(
                                    v_metric.target_name, 
                                    v_metric.target_type)
     AND metric_guid = mgmt_metric.get_metric_guid(
                                     v_metric.target_type, 
                                     v_metric.metric_name,
                                     v_metric.metric_column)
     AND key_value   = NVL(v_metric.key_value, ' ');
EXCEPTION
   WHEN NO_DATA_FOUND THEN
      raise_application_error (MGMT_GLOBAL.NO_SUCH_METRIC_ERR,
       'No collection found for <target_name>/<metric_name>/<metric_column> ' || 
       v_metric.target_name || '/' || v_metric.metric_name || '/' 
       || v_metric.metric_column);

END GET_REPO_METRIC_EVAL_PROC;



----  END OF SDK IMPLEMENTATION ------

FUNCTION is_repo_side_availability
(
  v_target_type   IN mgmt_targets.target_type%TYPE,
  v_type_meta_ver IN mgmt_targets.type_meta_ver%TYPE
)RETURN BOOLEAN
IS
  l_rs_defined    BOOLEAN ;

  CURSOR metric_cursor IS
    SELECT d.metric_guid metric_guid, m.metric_name metric_name, 
           m.metric_column metric_column, m.source eval_func
      FROM mgmt_metric_dependency_def d, mgmt_metrics m
     WHERE d.metric_guid = m.metric_guid
       AND d.target_type = v_target_type
       AND d.type_meta_ver = v_type_meta_ver;
BEGIN
  IF EMDW_LOG.p_is_debug_set THEN
      EMDW_LOG.debug('is_repo_side_availablity:Enter' || 
                     v_target_type || '/' || v_type_meta_ver, G_MODULE);
  END IF;

  -- initialize response/status flag to false
  l_rs_defined := FALSE;

  FOR metric IN metric_cursor
  LOOP
    -- check for response/status metrics
    IF (metric.metric_name = mgmt_global.G_AVAIL_METRIC_NAME AND
        metric.metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN) 
    THEN
      l_rs_defined := TRUE;
    END IF;
  END LOOP;

  IF EMDW_LOG.p_is_debug_set THEN
      EMDW_LOG.debug('is_repo_side_availablity:Exit', G_MODULE);
  END IF;

  RETURN l_rs_defined ;
END is_repo_side_availability;

-- 
-- PURPOSE
--   Initializes metric dependency list for a target. This is called from
--   mgmt_targets BEFORE INSERT trigger.
-- 
PROCEDURE HANDLE_ADD_TARGET
(
  v_target_name IN mgmt_targets.target_name%TYPE,
  v_target_type IN mgmt_targets.target_type%TYPE,
  v_target_guid IN mgmt_targets.target_guid%TYPE
)
IS
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_target_tzrgn  mgmt_targets.timezone_region%TYPE;
  l_rs_defined    BOOLEAN ;
  l_rs_metric     NUMBER := 0;
  l_repo_metric_only NUMBER := 0;

  CURSOR metric_cursor(p_type_meta_ver IN mgmt_targets.type_meta_ver%TYPE)
  IS
    SELECT UNIQUE d.metric_guid metric_guid, m.metric_name metric_name, 
           m.metric_column metric_column, m.source eval_func, d.opt_code
      FROM mgmt_metric_dependency_def d, mgmt_metrics m
     WHERE d.metric_guid = m.metric_guid
       AND d.type_meta_ver = m.type_meta_ver
       AND d.target_type = v_target_type
       AND d.type_meta_ver = p_type_meta_ver;

  CURSOR member_cursor IS
    SELECT mem.assoc_target_guid member_target_guid, mt.target_type member_target_type
      FROM mgmt_target_assocs mem, mgmt_targets mt
     WHERE mem.source_target_guid = v_target_guid
       AND mem.assoc_guid = MGMT_ASSOC.g_contains_guid
       AND mt.target_guid = mem.assoc_target_guid;

BEGIN
  -- initialize response/status flag to false
  l_rs_defined := FALSE;

  SELECT timezone_region, type_meta_ver
    INTO l_target_tzrgn,l_type_meta_ver
    FROM mgmt_targets 
   WHERE target_guid = v_target_guid;
  
  -- Add a row in MGMT_METRIC_DEPENDENCY for each of the metrics
  -- whose severities (events) are calculated at the repository level.
  -- For example, if a target has three metrics (m1, m2, m3) which are
  -- of type RESPOSITORY_EVENT, then we add three rows in
  -- MGMT_METRIC_DEPENDENCY table.
  
  FOR metric IN metric_cursor(l_type_meta_ver)
  LOOP

    l_rs_metric := 0;
    -- check for response/status metrics
    IF (metric.metric_name = mgmt_global.G_AVAIL_METRIC_NAME AND
        metric.metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN) 
    THEN
      l_rs_defined := TRUE;
      l_rs_metric := 1;
      check_repo_metric_only(v_target_name, v_target_type, 
                             l_repo_metric_only);
    END IF;

    -- Not check for signature of eval_func here since it is coming from a 
    -- table which already has validated source

    BEGIN
      INSERT 
        INTO mgmt_metric_dependency
             (target_guid, metric_guid, force_calculate, event_metric, eval_func, rs_metric, opt_code, repo_metric_only)
      VALUES
             (v_target_guid, metric.metric_guid, 1, 1, metric.eval_func, l_rs_metric, metric.opt_code, l_repo_metric_only);

      add_dummy_collection(v_target_name,
                          v_target_type,
                          metric.metric_name,
                          metric.metric_column,
                          ' ');
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
         -- Ingore duplicate entries
        NULL;
    END;

  END LOOP;
  
  -- populate the dependency details if the target already has members
  FOR member IN member_cursor
  LOOP
    add_dependency_def_target(v_target_type, v_target_guid, l_target_tzrgn,
       l_type_meta_ver, member.member_target_type, member.member_target_guid);
  END LOOP;

  -- Set the eval-order
  IF (l_rs_defined) THEN
    compute_eval_order(v_target_guid);
  END IF;

  init_tgt_collection_timestamp(v_target_guid);
  init_collection_timestamp(v_target_guid);
  
END HANDLE_ADD_TARGET;


-- 
-- PURPOSE
--   Internal procedure to check whether at least one instance of each of
--   the dependency metric is avaialble to initiate severity calculations.
--
-- 
PROCEDURE UPDATE_DEPENDENCY_READINESS(v_target_guid IN RAW,
                                      v_metric_guid IN RAW,
                                      v_type_meta_ver IN VARCHAR2,
                                      v_target_tzrgn IN VARCHAR2)
IS
   l_dep_count NUMBER;
   l_actual_count NUMBER;
   l_members_ready NUMBER := 0;
BEGIN
  -- get the dependency metric count
  SELECT count(dep_metric_guid) INTO l_dep_count
    FROM mgmt_metric_dependency_def
   WHERE metric_guid = v_metric_guid
     AND type_meta_ver = v_type_meta_ver;

  -- get the actual dependency metric count
  SELECT count(unique dep_metric_guid) INTO l_actual_count
    FROM mgmt_metric_dependency_details
   WHERE metric_guid = v_metric_guid
     AND target_guid = v_target_guid;

  -- If the counts are same, then we can calculate severities 
  IF (l_dep_count = l_actual_count) THEN
    l_members_ready := 1;
  END IF;

  -- update the members_ready flag now
  UPDATE mgmt_metric_dependency
     SET members_ready = l_members_ready,
         start_timestamp = mgmt_global.sysdate_tzrgn(v_target_tzrgn)
   WHERE target_guid = v_target_guid
     AND metric_guid = v_metric_guid
     AND members_ready <> l_members_ready;

END UPDATE_DEPENDENCY_READINESS;


-- Adds a dependency target - This is called from the BEFORE
-- INSERT trigger of mgmt_target_memberships table as well
-- as BEFORE insert trigger of mgmt_targets table.
--
PROCEDURE ADD_DEPENDENCY_DEF_TARGET(v_target_type     IN VARCHAR2,
                                    v_target_guid     IN RAW,
                                    v_target_tzrgn    IN VARCHAR2,
                                    v_type_meta_ver   IN VARCHAR2,
                                    v_dep_target_type IN VARCHAR2,
                                    v_dep_target_guid IN RAW)
IS
  CURSOR metric_dep_cursor IS
    SELECT d.metric_guid metric_guid, d.dep_metric_guid dep_metric_guid,
           m.metric_name metric_name, m.metric_column metric_column 
      FROM mgmt_metric_dependency_def d, mgmt_metrics m
     WHERE d.target_type = v_target_type
       AND d.dep_target_type = v_dep_target_type
       AND d.metric_guid = m.metric_guid
       AND d.type_meta_ver = m.type_meta_ver
       AND d.type_meta_ver = v_type_meta_ver;

   l_count NUMBER := 0;
   l_agent_guid mgmt_targets.target_guid%TYPE;
   l_agent_rs_guid mgmt_targets.target_guid%TYPE;
   l_dep_start_ts DATE;
   l_locked BOOLEAN := FALSE;
BEGIN


  -- Make sure that an entry exists in the dependency table
  SELECT count(*) 
    INTO l_count
    FROM mgmt_metric_dependency
   WHERE target_guid = v_target_guid;

  IF l_count = 0 THEN
     RETURN;
  END IF;


  -- If dep-target-guid already exists in mgmt_metric_dependency_details,
  -- then simply return
  SELECT count(*) 
    INTO l_count
    FROM mgmt_metric_dependency_details
   WHERE target_guid = v_target_guid
     AND dep_target_guid = v_dep_target_guid;

  IF l_count > 0 THEN
     RETURN;
  END IF;

  --
  -- For each of the matching rows in mgmt_metric_dependency_def,
  -- add a row in mgmt_metric_dependency_details table
  --
  FOR metric IN metric_dep_cursor
  LOOP
     IF (not l_locked) THEN
       l_locked := em_rep_metric.lock_target_deps(v_target_guid); 
     END IF;

     -- If the dependency target type is host, then use agent's
     -- severities to drive composite r/s calculations
     IF (v_dep_target_type = mgmt_global.G_HOST_TARGET_TYPE) THEN

       SELECT t2.target_guid
         INTO l_agent_guid
         FROM mgmt_targets t1, mgmt_targets t2
        WHERE t1.target_guid = v_dep_target_guid
          AND t1.emd_url = t2.emd_url
          AND t2.target_type = mgmt_global.G_AGENT_TARGET_TYPE;


       l_agent_rs_guid :=  mgmt_target.generate_metric_column_guid(
                                         mgmt_global.G_AGENT_TARGET_TYPE,
                                         mgmt_global.G_AVAIL_METRIC_NAME,
                                         mgmt_global.G_AVAIL_METRIC_COLUMN);

       l_dep_start_ts := get_start_time_in_parent_tz(v_target_guid, l_agent_guid);

       -- update the mgmt_metric_dependency_details now
       INSERT INTO mgmt_metric_dependency_details
          (target_guid, metric_guid, 
           dep_target_guid, dep_metric_guid, 
           edep_target_guid, edep_metric_guid,
           start_timestamp)
       VALUES
          (v_target_guid, metric.metric_guid, 
           v_dep_target_guid, metric.dep_metric_guid,
           l_agent_guid, l_agent_rs_guid,
           l_dep_start_ts);

     ELSE
       l_dep_start_ts := get_start_time_in_parent_tz(v_target_guid, v_dep_target_guid);

       -- update the mgmt_metric_dependency_details now
       INSERT INTO mgmt_metric_dependency_details
          (target_guid, metric_guid, 
           dep_target_guid, dep_metric_guid, 
           edep_target_guid, edep_metric_guid,
           start_timestamp)
       VALUES
          (v_target_guid, metric.metric_guid, 
           v_dep_target_guid, metric.dep_metric_guid,
           v_dep_target_guid, metric.dep_metric_guid,
           l_dep_start_ts);
      END IF;

     -- set force evaluate flag to true so that this severity
     -- gets evaluated irrespective of changes in member severities
     UPDATE mgmt_metric_dependency
        SET force_calculate = 1
      WHERE target_guid = v_target_guid
        AND metric_guid = metric.metric_guid;

    -- update dependency readiness 
    update_dependency_readiness(v_target_guid, metric.metric_guid,
                                v_type_meta_ver, v_target_tzrgn);

    -- initialize start timestamps
    init_tgt_collection_timestamp(v_target_guid);
    init_collection_timestamp(v_target_guid);

  END LOOP;

END ADD_DEPENDENCY_DEF_TARGET;


--  Removes a def based dependency target from all dependency tables. This is called
--  from mgmt_target_membership table. 
PROCEDURE DELETE_DEPENDENCY_DEF_TARGET(v_target_type     IN VARCHAR2,
                                       v_target_guid     IN RAW,
                                       v_target_tzrgn    IN VARCHAR2,
                                       v_type_meta_ver   IN VARCHAR2,
                                       v_dep_target_type IN VARCHAR2,
                                       v_dep_target_guid IN RAW)
IS
  CURSOR metric_dep_cursor IS
    SELECT metric_guid, dep_metric_guid
      FROM mgmt_metric_dependency_def
     WHERE target_type = v_target_type
       AND dep_target_type = v_dep_target_type
       AND type_meta_ver = v_type_meta_ver;

BEGIN


  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('delete_dependency_def_target:Enter' || 
                     v_target_type || '/' || v_dep_target_type || '/' || 
                     v_dep_target_guid, G_MODULE);
  END IF;

  -- delete dependencies and update readiness
  FOR metric IN metric_dep_cursor LOOP
     -- delete the metric from the details 
     DELETE FROM mgmt_metric_dependency_details
       WHERE target_guid = v_target_guid AND
             metric_guid = metric.metric_guid AND
             dep_target_guid = v_dep_target_guid AND
             dep_metric_guid = metric.dep_metric_guid;

    -- update dependency readiness 
    update_dependency_readiness(v_target_guid, metric.metric_guid, 
                                v_type_meta_ver, v_target_tzrgn);
  END LOOP;
  SUSPEND_NULL_DEP_DATA_COLL;
END DELETE_DEPENDENCY_DEF_TARGET;


--  Removes a dependency target from all dependency tables which are created using
--  dependency_def definitions. This is called when a target is removed from the
--  repository
--
PROCEDURE DELETE_ALL_DEF_DEP_TARGETS(v_dep_target_guid IN RAW)
IS
  CURSOR metric_dep_cursor IS
    SELECT DISTINCT dep.target_guid target_guid,
                    def.metric_guid metric_guid
      FROM mgmt_metric_dependency_def def,
           mgmt_metric_dependency dep,
           mgmt_metric_dependency_details det
     WHERE det.dep_target_guid = v_dep_target_guid
       AND det.target_guid = dep.target_guid
       AND det.metric_guid = dep.metric_guid
       AND det.metric_guid = def.metric_guid
       AND det.dep_metric_guid = def.dep_metric_guid;

  l_tzrgn  MGMT_TARGETS.timezone_region%TYPE;
  l_type_meta_ver  MGMT_TARGETS.type_meta_ver%TYPE;
BEGIN
  -- delete dependencies and update readiness
  FOR metric IN metric_dep_cursor 
  LOOP
     -- delete the metric from the details 
     DELETE FROM mgmt_metric_dependency_details
       WHERE target_guid  = metric.target_guid
         AND metric_guid = metric.metric_guid
         AND dep_target_guid = v_dep_target_guid;

     SELECT timezone_region, type_meta_ver
       INTO l_tzrgn, l_type_meta_ver
       FROM MGMT_TARGETS
      WHERE target_guid = metric.target_guid;

     -- update dependency readiness 
     update_dependency_readiness(metric.target_guid, metric.metric_guid, 
                                 l_type_meta_ver, l_tzrgn);
  END LOOP;
  SUSPEND_NULL_DEP_DATA_COLL;

END DELETE_ALL_DEF_DEP_TARGETS;


--
-- PURPOSE
--   Initialize the start timestamp of all collections for which
--   availability calculations have started for all dependency targets
--
PROCEDURE INIT_COLLECTION_TIMESTAMP(v_dep_target_guid IN RAW)
IS
  CURSOR tgt_cursor IS
    SELECT distinct d.target_guid
      FROM mgmt_metric_dependency d,
           mgmt_metric_dependency_details t
     WHERE d.members_ready = 1
       AND d.can_calculate = 0
       AND d.target_guid = t.target_guid
       AND t.dep_target_guid = v_dep_target_guid;

BEGIN
  -- For each of the targets, enable the "can_calculate"
  -- flag as well as initialize the timestamp.
  FOR tgt IN tgt_cursor LOOP
    init_tgt_collection_timestamp(tgt.target_guid);
  END LOOP;

END INIT_COLLECTION_TIMESTAMP;

--
-- PURPOSE
--   Initialize the start timestamp of collections for the specified
--   target if availability calculations have started for all
--   dependency targets
--
PROCEDURE INIT_TGT_COLLECTION_TIMESTAMP(v_target_guid IN RAW)
IS
  CURSOR metric_cursor IS
    SELECT distinct metric_guid, key_value
      FROM mgmt_metric_dependency
     WHERE target_guid = v_target_guid
       AND can_calculate = 0
       AND members_ready = 1;

   l_type_min_timestamp DATE;
   l_start_timestamp DATE := NULL;
   l_curr_marker     DATE;
   l_dep_count       NUMBER;
   l_target_tz       mgmt_targets.timezone_region%TYPE;
BEGIN

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('init_tgt_collection_timestamp:Enter ' || v_target_guid,
                     G_MODULE);
  END IF;

  -- For each of the targets, enable the "can_calculate"
  -- flag as well as initialize the timestamp.
  <<metric_loop>>
  FOR metric IN metric_cursor LOOP

    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('Calculating start timestamp for ' ||
                      v_target_guid || ' ' || 
                      metric.metric_guid || ' ' || metric.key_value,
                      G_MODULE);
    END IF;

    SELECT timezone_region
      INTO l_target_tz
      FROM mgmt_targets
     WHERE target_guid = v_target_guid;

     -- Get the current marker timestamp for the target
     SELECT marker_timestamp
       INTO l_curr_marker
       FROM mgmt_availability_marker
      WHERE target_guid = v_target_guid;

     IF EMDW_LOG.P_IS_DEBUG_SET THEN
        EMDW_LOG.debug('Marker timestamp = ' || l_curr_marker, G_MODULE);
     END IF;

    -- Calculate the start timestamp
    -- Example: If a composite C metric M depends on metric M1
    -- of type T1 and M2 metric of type T2. Then, we need to
    -- get the minimum timestamp (ts1) of all the target instances
    -- of type T1 and minimum timestamps (ts2) of type T2 and then get
    -- the max of (ts1 and ts2) as the collection start timestamp.
    <<types_loop>>
    FOR types IN (SELECT DISTINCT target_type, timezone_region tz
                    FROM mgmt_targets t,
                         mgmt_metric_dependency_details d
                   WHERE t.target_guid = d.dep_target_guid
                     AND d.target_guid = v_target_guid
                     AND d.metric_guid = metric.metric_guid
                     AND d.key_value   = metric.key_value)
    LOOP                

       IF EMDW_LOG.P_IS_DEBUG_SET THEN
          EMDW_LOG.debug('Calculating min timestamp for ' ||
                                types.target_type, G_MODULE);
       END IF;

      -- Get the minimum of the first records of all 
      -- targets of this type.
         SELECT min(end_collection_timestamp)  end_time
           INTO l_type_min_timestamp
           FROM mgmt_availability a,
                mgmt_metric_dependency_details d,
                mgmt_targets t
          WHERE d.target_guid = v_target_guid
            AND d.dep_target_guid = t.target_guid
            AND t.target_type = types.target_type
            AND d.dep_target_guid = a.target_guid ;

      -- If the end collection timestamp is NULL, then it means that
      -- availability is not reported for this member target
      IF (l_type_min_timestamp IS NULL) THEN
         IF EMDW_LOG.P_IS_DEBUG_SET THEN
             EMDW_LOG.debug('Availability not initialized for ' ||
                            'instances of type ' || types.target_type,
                             G_MODULE);
       END IF;
       l_start_timestamp:= NULL;
       EXIT types_loop;
      END IF;

      IF (l_target_tz <> types.tz) THEN

         IF EMDW_LOG.P_IS_DEBUG_SET THEN
            EMDW_LOG.debug('timezone different - before conversion  ' || 
                        to_char(l_type_min_timestamp, 'MM/DD/YYYY HH24:MI:SS'),
                        G_MODULE);
         END IF;

         l_type_min_timestamp := MGMT_GLOBAL.ADJUST_TZ(l_type_min_timestamp, types.tz, l_target_tz);

         IF EMDW_LOG.P_IS_DEBUG_SET THEN
            EMDW_LOG.debug('timezone different - after conversion  ' || 
                        to_char(l_type_min_timestamp, 'MM/DD/YYYY HH24:MI:SS'),
                        G_MODULE);

         END IF;

      END IF;
  
      -- Get the max of the timestamps across types
      IF (l_start_timestamp IS NULL) THEN
        l_start_timestamp := l_type_min_timestamp;
      ELSIF (l_start_timestamp < l_type_min_timestamp) THEN
        l_start_timestamp := l_type_min_timestamp;
      END IF;

       IF EMDW_LOG.P_IS_DEBUG_SET THEN
          EMDW_LOG.debug('types timestamp  ' || 
                        to_char(l_type_min_timestamp, 'MM/DD/YYYY HH24:MI:SS'),
                        G_MODULE);
          EMDW_LOG.debug('New start timestamp  ' || 
                         to_char(l_start_timestamp, 'MM/DD/YYYY HH24:MI:SS'),
                         G_MODULE);
       END IF;

    END LOOP types_loop;

    IF (l_start_timestamp IS NOT NULL) THEN

      -- Set the start timestamp to one second behind the members timestamps
      l_start_timestamp := l_start_timestamp - 1/(24*60*60);

      -- Make sure we don't start calculations in past
      IF (l_start_timestamp < l_curr_marker) THEN
        l_start_timestamp := l_curr_marker;
      END IF;


      IF EMDW_LOG.P_IS_DEBUG_SET THEN
          EMDW_LOG.debug('Marker timestamp  ' || 
                         to_char(l_curr_marker, 'MM/DD/YYYY HH24:MI:SS'),
                         G_MODULE);
          EMDW_LOG.debug('Final start timestamp  ' || 
                         to_char(l_start_timestamp, 'MM/DD/YYYY HH24:MI:SS'),
                         G_MODULE);
      END IF;

      UPDATE mgmt_metric_dependency
         SET can_calculate = 1,
             start_timestamp = l_start_timestamp
       WHERE target_guid = v_target_guid
         AND metric_guid = metric.metric_guid
         AND key_value   = metric.key_value;

       -- COMEBACK: If same set of dependencies are used for all
       -- metrics, then we don't need to loop through for each
       -- metric individually. We can optimize here.
       <<next_metric>>
        NULL;
     END IF;
  END LOOP metric_loop;

 -- COMEBACK: This needs to be redesigned for composite targets
 -- that contain multiple target types with different roles



END INIT_TGT_COLLECTION_TIMESTAMP;

--
-- Locks all target dependencies
--
FUNCTION lock_target_deps(v_target_guid   IN RAW, 
                          v_nowait_mode   IN BOOLEAN default false)
  RETURN BOOLEAN
IS 
   l_tgt_array  t_guids_list;
   RESOURCE_BUSY EXCEPTION;
   PRAGMA EXCEPTION_INIT(RESOURCE_BUSY, -54);
BEGIN
   IF (v_nowait_mode) THEN
      SELECT target_guid
        BULK COLLECT INTO l_tgt_array
        FROM mgmt_metric_dependency
       WHERE target_guid = v_target_guid
         ORDER BY metric_guid, key_value
         FOR UPDATE NOWAIT;
   ELSE
      SELECT target_guid
        BULK COLLECT INTO l_tgt_array
        FROM mgmt_metric_dependency
       WHERE target_guid = v_target_guid
         ORDER BY metric_guid, key_value
         FOR UPDATE;
   END IF;
   return true;
EXCEPTION
   WHEN NO_DATA_FOUND OR
        RESOURCE_BUSY THEN
     return false;
END lock_target_deps;

--
-- Removes the specified target as a dependency
--
PROCEDURE delete_dependency_target(v_target_guid IN RAW DEFAULT NULL,
                                   v_dep_target_guid IN RAW,
                                   v_update_eval_order IN BOOLEAN DEFAULT TRUE)
IS
   l_tgt_array  t_guids_list;
BEGIN
   -- lock the parent rows and delete the dependencies
   IF (v_target_guid IS NOT NULL) THEN
      SELECT target_guid
        BULK COLLECT INTO l_tgt_array
        FROM mgmt_metric_dependency
       WHERE target_guid = v_target_guid
       ORDER BY metric_guid, key_value
         FOR UPDATE;

      IF (v_update_eval_order) THEN
         compute_eval_order(v_target_guid);
      END IF;

      DELETE FROM mgmt_metric_dependency_details
       WHERE target_guid = v_target_guid
         AND dep_target_guid = v_dep_target_guid;

   ELSE
      SELECT target_guid
        BULK COLLECT INTO l_tgt_array
        FROM mgmt_metric_dependency
       WHERE target_guid in
             (SELECT distinct target_guid 
                FROM mgmt_metric_dependency_details
               WHERE dep_target_guid = v_dep_target_guid)
        ORDER BY target_guid, metric_guid, key_value
          FOR UPDATE;


      IF (v_update_eval_order) THEN
         compute_parent_eval_order(v_dep_target_guid);
      END IF;

      DELETE FROM mgmt_metric_dependency_details
       WHERE dep_target_guid = v_dep_target_guid;

   END IF;
   SUSPEND_NULL_DEP_DATA_COLL;

END delete_dependency_target;



--
-- Callback to clean up deleted target state
--
PROCEDURE target_deleted_callback(v_target_name IN mgmt_targets.target_name%TYPE,
                                  v_target_type IN mgmt_targets.target_type%TYPE,
                                  v_target_guid IN mgmt_targets.target_guid%TYPE)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;
  l_locked BOOLEAN;
BEGIN
  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('target_deleted_callback:Enter ' || 
                      v_target_name || '/' || v_target_type, G_MODULE);
  END IF;

/*  SELECT target_guid
    INTO l_target_guid
    FROM mgmt_targets
   WHERE target_name = v_target_name
     AND target_type = v_target_type;
*/
  l_target_guid := v_target_guid ;

  --  Delete dependency entries for the target itself
  l_locked := em_rep_metric.lock_target_deps(l_target_guid);

  DELETE FROM MGMT_METRIC_DEPENDENCY
    WHERE target_guid = l_target_guid;

  -- recompute parent eval-order
  compute_parent_eval_order(l_target_guid);

  -- Remove this target as a dependency via defs mechanism first
  -- Note: we need to do this because we support the notion of
  -- "members_ready" and that needs to be updated.
  delete_all_def_dep_targets(l_target_guid);

  -- remove this target as a dependency of others now
  delete_dependency_target(null, l_target_guid, FALSE);


  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('target_deleted_callback:Exit ' || 
                      v_target_name || '/' || v_target_type, G_MODULE);
  END IF;


END target_deleted_callback;


-- it gets called everytime a member association is added
PROCEDURE member_added_callback
(
  p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
  p_source_target_name IN mgmt_targets.target_name%TYPE,
  p_source_target_type IN mgmt_targets.target_type%TYPE,
  p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
  p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
  p_scope_target_name  IN mgmt_targets.target_name%TYPE,
  p_scope_target_type  IN mgmt_targets.target_type%TYPE
)
IS
  l_tzrgn  MGMT_TARGETS.timezone_region%TYPE;
  l_type_meta_ver  MGMT_TARGETS.type_meta_ver%TYPE;
  l_source_target_guid MGMT_TARGETS.target_guid%TYPE;
  l_assoc_target_guid MGMT_TARGETS.target_guid%TYPE;
BEGIN

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('member_added_callback:Enter ' ||
                     'source name/type = ' || 
                     p_source_target_name || '/' ||
                     p_source_target_type || ';' ||
                     'assoc name/type = ' || 
                     p_assoc_target_name || '/' ||
                     p_assoc_target_type || ';' ||
                     'scope name/type = ' || 
                     p_scope_target_name || '/' ||
                     p_scope_target_type, G_MODULE);
  END IF;

  SELECT timezone_region, type_meta_ver, target_guid 
    INTO l_tzrgn, l_type_meta_ver,l_source_target_guid
    FROM MGMT_TARGETS
   WHERE target_name = p_source_target_name
     AND target_type = p_source_target_type;

  SELECT target_guid 
    INTO l_assoc_target_guid
    FROM MGMT_TARGETS
   WHERE target_name = p_assoc_target_name
     AND target_type = p_assoc_target_type;

  add_dependency_def_target(p_source_target_type,
                            l_source_target_guid,
                            l_tzrgn,
                            l_type_meta_ver,
                            p_assoc_target_type,
                            l_assoc_target_guid);

  -- recompute eval order
  compute_eval_order(l_source_target_guid);

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('member_added_callback:Exit ', G_MODULE);
  END IF;


END member_added_callback;

-- it gets called everytime a member association is deleted
PROCEDURE member_deleted_callback
(
  p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
  p_source_target_name IN mgmt_targets.target_name%TYPE,
  p_source_target_type IN mgmt_targets.target_type%TYPE,
  p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
  p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
  p_scope_target_name  IN mgmt_targets.target_name%TYPE,
  p_scope_target_type  IN mgmt_targets.target_type%TYPE
)
IS
  l_tzrgn  MGMT_TARGETS.timezone_region%TYPE;
  l_type_meta_ver  MGMT_TARGETS.type_meta_ver%TYPE;
  l_source_target_guid MGMT_TARGETS.target_guid%TYPE;
  l_assoc_target_guid MGMT_TARGETS.target_guid%TYPE;
BEGIN


  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('member_deleted_callback:Enter' || '/' ||
                     'source_target_type = ' ||  p_source_target_type || '/' || 
                     'source_target_name = ' ||  p_source_target_name || '/' || 
                     'assoc_target_type = ' ||  p_assoc_target_type || '/' || 
                     'scope_target_type = ' ||  p_scope_target_type || '/' || 
                     'scope_target_name = ' ||  p_scope_target_name,
                      G_MODULE);
  END IF;

  SELECT timezone_region, type_meta_ver, target_guid 
    INTO l_tzrgn, l_type_meta_ver,l_source_target_guid
    FROM MGMT_TARGETS
   WHERE target_name = p_source_target_name
     AND target_type = p_source_target_type;

  SELECT target_guid 
    INTO l_assoc_target_guid
    FROM MGMT_TARGETS
   WHERE target_name = p_assoc_target_name
     AND target_type = p_assoc_target_type;


  delete_dependency_def_target(p_source_target_type,
                               l_source_target_guid,
                               l_tzrgn,
                               l_type_meta_ver,
                               p_assoc_target_type,
                               l_assoc_target_guid);

  -- recompute the eval order 
  compute_eval_order(l_source_target_guid);

  IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.debug('member_deleted_callback:Exit', G_MODULE);
  END IF;

END member_deleted_callback;

PROCEDURE remove_metric_dependency(p_dep_target_guid IN RAW,
                                   p_dep_metric_guid IN RAW,
                                   p_dep_key_value IN VARCHAR2)
AS
l_lock_targets MGMT_TARGET_GUID_ARRAY;
BEGIN
    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Enter', G_MODULE);
    END IF;

    SELECT target_guid BULK COLLECT INTO l_lock_targets
      FROM mgmt_metric_dependency
      WHERE (target_guid, metric_guid, key_value) IN 
         (SELECT target_guid, metric_guid, key_value 
            FROM mgmt_metric_dependency_details
            WHERE dep_target_guid = p_dep_target_guid
               AND dep_metric_guid = p_dep_metric_guid
               AND dep_key_value = p_dep_key_value
         )
      ORDER BY target_guid, metric_guid, key_value
      FOR UPDATE;
     
    DELETE FROM mgmt_metric_dependency_details
      WHERE dep_target_guid = p_dep_target_guid
       AND dep_metric_guid = p_dep_metric_guid
       AND dep_key_value = p_dep_key_value;
    SUSPEND_NULL_DEP_DATA_COLL;

    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Exit', G_MODULE);
    END IF;

END remove_metric_dependency;


PROCEDURE remove_bcn_dependency(p_dep_target_guid IN RAW,
                                p_dep_key_values IN SMP_EMD_STRING_ARRAY)
AS
l_lock_targets MGMT_TARGET_GUID_ARRAY;
BEGIN
    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Enter', G_MODULE);
    END IF;

    SELECT target_guid BULK COLLECT INTO l_lock_targets
      FROM mgmt_metric_dependency
      WHERE (target_guid, metric_guid, key_value) IN 
         (SELECT target_guid, metric_guid, key_value 
            FROM mgmt_metric_dependency_details
            WHERE dep_target_guid = p_dep_target_guid
               AND dep_key_value IN (SELECT * 
                                       FROM TABLE(CAST(p_dep_key_values
                                                  AS SMP_EMD_STRING_ARRAY))
                                    )
         )
      ORDER BY target_guid, metric_guid, key_value
      FOR UPDATE;
     
    DELETE FROM mgmt_metric_dependency_details
      WHERE dep_target_guid = p_dep_target_guid
       AND dep_key_value IN (SELECT * 
                               FROM TABLE(CAST(p_dep_key_values
                                                  AS SMP_EMD_STRING_ARRAY))
                            );
    SUSPEND_NULL_DEP_DATA_COLL;

    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Exit', G_MODULE);
    END IF;
END remove_bcn_dependency;


PROCEDURE remove_bcn_dependency(p_dep_key_values IN SMP_EMD_STRING_ARRAY)
AS
l_lock_targets MGMT_TARGET_GUID_ARRAY;
BEGIN
    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Enter', G_MODULE);
    END IF;

    SELECT target_guid BULK COLLECT INTO l_lock_targets
      FROM mgmt_metric_dependency
      WHERE (target_guid, metric_guid, key_value) IN 
         (SELECT target_guid, metric_guid, key_value 
            FROM mgmt_metric_dependency_details
           WHERE dep_key_value IN (SELECT * 
                                     FROM TABLE(CAST(p_dep_key_values
                                                AS SMP_EMD_STRING_ARRAY))
                                  )
         )
      ORDER BY target_guid, metric_guid, key_value
      FOR UPDATE;
     
    DELETE FROM mgmt_metric_dependency_details
      WHERE dep_key_value IN (SELECT * 
                               FROM TABLE(CAST(p_dep_key_values
                                             AS SMP_EMD_STRING_ARRAY))
                             );

    SUSPEND_NULL_DEP_DATA_COLL;

    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('remove_metric_dependency:Exit', G_MODULE);
    END IF;
END remove_bcn_dependency;


PROCEDURE cleanup_member_assoc_dep(p_impacted_services OUT MGMT_GUID_ARRAY)
AS
l_services MGMT_TARGET_GUID_ARRAY;
l_lock_targets MGMT_TARGET_GUID_ARRAY;
l_dep_targets mgmt_target_guid_array;
l_services_ret MGMT_GUID_ARRAY;
l_service_name mgmt_targets.target_name%TYPE;
l_dep_target_name mgmt_targets.target_name%TYPE;
BEGIN
    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('cleanup_member_assoc_dep:Enter', G_MODULE);
    END IF;

    -- clean up dependency detail table
    SELECT UNIQUE m.target_guid, d.dep_target_guid  
      BULK COLLECT INTO l_services, l_dep_targets
    FROM mgmt_metric_dependency m, mgmt_metric_dependency_details d,
        mgmt_target_assocs a
    WHERE m.target_guid = d.target_guid
     AND m.metric_guid = d.metric_guid
     AND m.key_value = d.key_value
     AND m.target_guid = a.source_target_guid
     AND a.assoc_guid = mgmt_assoc.g_runs_on_guid
     AND d.dep_target_guid NOT IN (
        SELECT assoc_target_guid 
        FROM  mgmt_flat_target_assoc
        WHERE is_membership = 1 
          AND source_target_guid = a.assoc_target_guid
        )
     AND NOT EXISTS
        (SELECT 1 
           FROM mgmt_type_properties p, mgmt_targets t
           WHERE p.target_type = t.target_type
             AND p.property_name = mgmt_global.G_IS_AGGREGATE_SERVICE_PROP
             AND p.property_value = '1'
             AND t.target_guid = m.target_guid
        )
     AND m.target_guid <> d.dep_target_guid; -- test based promotion

 
    --lock dependency table
    SELECT target_guid
     BULK COLLECT INTO l_lock_targets
     FROM mgmt_metric_dependency
    WHERE target_guid IN (
         SELECT * 
         FROM TABLE(CAST(l_services AS MGMT_TARGET_GUID_ARRAY))
    )
    ORDER BY target_guid, metric_guid, key_value
    FOR UPDATE;

    FORALL indx IN 1..l_services.COUNT
      DELETE FROM mgmt_metric_dependency_details
       WHERE target_guid = l_services(indx)
      AND  dep_target_guid = l_dep_targets(indx);
      
    FOR indx IN 1..l_services.COUNT
    LOOP
      compute_eval_order(l_services(indx));
    END LOOP;

    SUSPEND_NULL_DEP_DATA_COLL;

   IF EMDW_LOG.P_IS_DEBUG_SET THEN
     FOR indx IN 1..l_services.COUNT
     LOOP
        SELECT target_name INTO l_service_name
        FROM mgmt_targets
        WHERE target_guid = l_services(indx);
        SELECT target_name INTO l_dep_target_name
        FROM mgmt_targets
        WHERE target_guid = l_dep_targets(indx);
     
        EMDW_LOG.debug('cleanup_member_assoc_dep:Impacted service ' 
                       || l_service_name 
                       || ' by target ' 
                       || l_dep_target_name,  G_MODULE);

     END LOOP;
    END IF;

    SELECT mgmt_guid_obj(target_guid, target_name)
      BULK COLLECT INTO l_services_ret
    FROM mgmt_targets
    WHERE target_guid IN ( 
       SELECT UNIQUE *
        FROM TABLE(CAST(l_services as MGMT_TARGET_GUID_ARRAY))
    );

    p_impacted_services := l_services_ret;

    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('cleanup_member_assoc_dep:Exit', G_MODULE);
    END IF;

END cleanup_member_assoc_dep;

PROCEDURE cleanup_runs_on_assoc_dep(p_service_guid IN RAW,
                                    p_system_guid IN RAW)
AS
l_lock_targets MGMT_TARGET_GUID_ARRAY;
l_service_name mgmt_targets.target_name%TYPE;
l_system_name mgmt_targets.target_name%TYPE;
BEGIN
   IF emdw_log.P_IS_DEBUG_SET THEN
      SELECT target_name INTO l_service_name
        FROM mgmt_targets
        where target_guid = p_service_guid;
      SELECT target_name INTO l_system_name
        FROM mgmt_targets
        where target_guid = p_system_guid;

      emdw_log.debug('cleanup_runs_on_assoc_dep:Enter. Service name '
                     || l_service_name
                     || ' system name ' || l_system_name, G_MODULE);
   END IF;
   SELECT target_guid
     BULK COLLECT INTO l_lock_targets
   FROM mgmt_metric_dependency
   WHERE (target_guid, metric_guid, key_value) IN 
        (SELECT target_guid, metric_guid, key_value
          FROM mgmt_metric_dependency_details
          WHERE target_guid = p_service_guid
            AND dep_target_guid IN (
                SELECT assoc_target_guid
                FROM  mgmt_flat_target_assoc
                WHERE source_target_guid = p_system_guid
                  AND is_membership = 1)
        )
    ORDER BY target_guid, metric_guid, key_value
    FOR UPDATE; 

   IF emdw_log.P_IS_DEBUG_SET THEN
     emdw_log.debug('cleanup_runs_on_assoc_dep: Delete dependency '
                || 'detail for service ' || l_service_name
                , G_MODULE);
   END IF;
   DELETE FROM mgmt_metric_dependency_details 
   WHERE target_guid = p_service_guid
     AND dep_target_guid IN (
            SELECT assoc_target_guid
             FROM mgmt_flat_target_assoc
             WHERE source_target_guid = p_system_guid
               AND is_membership = 1
         );

   IF (SQL%ROWCOUNT > 0) THEN
     compute_eval_order(p_service_guid);
     SUSPEND_NULL_DEP_DATA_COLL;
   END IF;
   
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('cleanup_runs_on_assoc_dep:Exit', G_MODULE);
   END IF;

END cleanup_runs_on_assoc_dep;

-- Internal procedure, called when a repo metric is deleted
-- close open severity,
-- remove notification rules, threshold, fault tests?? 
PROCEDURE cleanup_metric(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_key_value IN VARCHAR2)
AS
l_timezone_region mgmt_targets.timezone_region%TYPE;
BEGIN
    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('cleanup_metric:Enter', G_MODULE);
    END IF;

    -- clean open severity
    FOR rec IN (SELECT v.target_guid, v.policy_guid, v.key_value,
                       t.timezone_region
                FROM mgmt_current_violation v, mgmt_targets t
                WHERE v.target_guid = t.target_guid
                  AND v.target_guid = p_target_guid
                  AND v.policy_guid = p_metric_guid
                  AND v.key_value = p_key_value
                  AND v.violation_level NOT IN (mgmt_global.G_SEVERITY_CLEAR,
                                          mgmt_global.G_SEVERITY_UNKNOWN))
    LOOP
       IF emdw_log.P_IS_DEBUG_SET THEN
          emdw_log.debug('cleanup_metric:Close severity for '
                        || ' target ' || rec.target_guid
                        || ' metric ' || rec.policy_guid
                        || ' key value ' || rec.key_value, G_MODULE);
       END IF;
       
       BEGIN
          mgmt_violation.log_violation(rec.target_guid,
                                   rec.policy_guid,
                                   rec.key_value,
                                 mgmt_global.SYSDATE_TZRGN(rec.timezone_region),
                                 mgmt_global.G_SEVERITY_CLEAR);
      EXCEPTION
        WHEN OTHERS THEN
          emdw_log.error('cleanup_metric:Exception when log violation. '
                        || 'Message : ' || SQLERRM, G_MODULE);
      END;
    END LOOP; 

    -- [TODO] remove threshold and notification rule.
    -- [TODO] switch to super user for remove notificationrule??

    IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('cleanup_metric:Exit', G_MODULE);
    END IF;
END cleanup_metric;

--
-- Place holder for collections engine to call. Any name changes
-- has to be reflected in em_task package as well
--
PROCEDURE run_metric_eval(p_context IN mgmt_namevalue_array) 
IS
BEGIN
  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('rep_metric_eval:Enter',G_MODULE) ;
  END IF ;
  -- Evaluate code to go in here , right now tvmry081 calls this
  -- change/remove tvmry081 if this procedure is not to be called
  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('rep_metric_eval:Exit',G_MODULE) ;
  END IF ;
END run_metric_eval ;

PROCEDURE set_all_repo_coll_interval(v_interval IN NUMBER)
IS
 CURSOR repo_collections_cur IS
  SELECT UNIQUE t.target_type, t.target_name, m.metric_name,
         m.metric_column, d.key_value coll_name
    FROM mgmt_targets t, mgmt_metrics m, mgmt_metric_dependency d
   WHERE t.target_guid = d.target_guid
     AND m.metric_guid = d.metric_guid
     AND d.event_metric = 0;
BEGIN
    FOR rec in repo_collections_cur
    LOOP 
      mgmt_collection.modify_collection(
                p_target_type   =>  rec.target_type,
                p_target_name   =>  rec.target_name,
                p_metric_name   =>  rec.metric_name,
                p_metric_column =>  rec.metric_column,
                p_coll_name     =>  rec.coll_name,
                p_coll_schedule => 
                    mgmt_coll_schedule_obj.interval_schedule(v_interval,
                                                             null, null));
    END LOOP;       
END set_all_repo_coll_interval;

--
-- Compute the availability start time of a target
-- based on its member marker timestamps
--
FUNCTION COMPUTE_START_TIME(v_target_guid IN RAW,
                            v_metric_guid IN RAW)
  RETURN DATE
IS
  l_tgt_marker_ts DATE;
  l_min_marker_ts DATE;
  l_start_ts      DATE;
  l_tgt_tzr       MGMT_TARGETS.timezone_region%TYPE;
BEGIN
  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('get_start_time:Enter',G_MODULE) ;
  END IF ;

  -- Get the target's timezone region
  SELECT timezone_region
    INTO l_tgt_tzr
    FROM mgmt_targets
   WHERE target_guid = v_target_guid;

  -- Get the target's marker
  SELECT marker_timestamp
    INTO l_tgt_marker_ts
    FROM mgmt_availability_marker m
   WHERE target_guid = v_target_guid;
  
  -- Get the dependencies min and max markers
  -- excluding blacked out and unreachable targets. 
  SELECT NVL(MIN(MGMT_GLOBAL.ADJUST_TZ(
                      marker_timestamp,
                      t.timezone_region,
                      l_tgt_tzr)),
             l_tgt_marker_ts)
    INTO l_min_marker_ts
    FROM mgmt_metric_dependency_details d,
         mgmt_current_availability a,
         mgmt_availability_marker m,
         mgmt_targets t
   WHERE d.target_guid = v_target_guid
     AND d.dep_target_guid = a.target_guid
     AND (a.current_status <> mgmt_global.G_STATUS_BLACKOUT
          OR
          a.current_status <> mgmt_global.G_STATUS_UNREACHABLE)
     AND a.target_guid = m.target_guid
     AND a.target_guid = t.target_guid;
 
  IF EMDW_LOG.P_IS_DEBUG_SET
  THEN
    EMDW_LOG.DEBUG('target marker ts = ' ||
                   to_char(l_tgt_marker_ts, 'MM/DD/YYYY HH24:MI:SS'),
                   G_MODULE) ;
    EMDW_LOG.DEBUG('min dep ts = ' ||
                   to_char(l_min_marker_ts, 'MM/DD/YYYY HH24:MI:SS'),
                   G_MODULE) ;
  END IF ;


  --
  -- Pick up a meaningful start time for computations
  --
  -- [1] If the min_marker is more than 15 minutes ahead, then
  --     pick min_marker - 15;
  -- [2] If the min_marker is less than 15 minutes, then use
  --     it as it is.
  -- [3] Otherwise, just use the target's timestamp
  --
  IF (l_min_marker_ts > (l_tgt_marker_ts + 15/(24 * 60))) THEN
    l_start_ts := l_min_marker_ts - 15/(24 *60);
  ELSIF (l_min_marker_ts > l_tgt_marker_ts) THEN
    l_start_ts := l_min_marker_ts;
  ELSE
    l_start_ts := l_tgt_marker_ts;
  END IF;


  IF EMDW_LOG.P_IS_DEBUG_SET
  THEN
    EMDW_LOG.DEBUG('start ts = ' ||
                   to_char(l_start_ts, 'MM/DD/YYYY HH24:MI:SS'),
                   G_MODULE);
  END IF;

  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('get_start_time:Exit',G_MODULE) ;
  END IF ;

  RETURN l_start_ts;

END COMPUTE_START_TIME;

PROCEDURE handle_metric_keyval_deletion (
    v_target_guid  IN mgmt_targets.target_guid%TYPE,
    v_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    v_key_value    IN mgmt_metrics_raw.key_value%TYPE)
AS
BEGIN
  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('handle_metric_keyval_deletion:Enter' 
                  || v_target_guid 
                  || '/' || v_metric_guid 
                  || '/' || v_key_value, G_MODULE) ;
  END IF ;

    remove_metric_dependency(v_target_guid, v_metric_guid, v_key_value);

  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('get_start_time:Exit',G_MODULE) ;
  END IF ;

END handle_metric_keyval_deletion;

PROCEDURE handle_tgttype_addition(p_target_type   IN VARCHAR2,
                                  p_type_meta_ver IN VARCHAR2)
AS
l_metric_names MGMT_SHORT_STRING_TABLE;
l_start_meta_vers MGMT_SHORT_STRING_TABLE;

BEGIN
  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('handle_tgttype_addition:Enter' 
                  || p_target_type 
                  || '/' || p_type_meta_ver, G_MODULE) ;
  END IF ;

  SELECT metric_name, start_type_meta_ver
         BULK COLLECT INTO l_metric_names, l_start_meta_vers
    FROM mgmt_metric_versions
   WHERE target_type = p_target_type
     AND (em_target.compare_type_meta_vers(start_type_meta_ver, p_type_meta_ver) <= 0)
     AND ( (end_type_meta_ver IS NULL) OR
           (em_target.compare_type_meta_vers(p_type_meta_ver, end_type_meta_ver) <= 0) );

  IF ( (l_metric_names IS NOT NULL) AND (l_metric_names.COUNT > 0) ) THEN
      FOR l_ctr IN l_metric_names.FIRST..l_metric_names.LAST
      LOOP
        --- for each metric, check mgmt_metric_dependency_def table
        FOR rec IN (SELECT d.metric_guid,
                           d.dep_target_type,
                           d.dep_metric_guid,
                           d.opt_code
                      FROM mgmt_metrics m, 
                           mgmt_metric_dependency_def d
                     WHERE m.target_type = d.target_type
                       AND m.metric_guid = d.metric_guid
                       AND d.target_type = p_target_type
                       AND m.metric_name = l_metric_names(l_ctr)
                       AND m.type_meta_ver = l_start_meta_vers(l_ctr))
        LOOP
         BEGIN
          INSERT INTO mgmt_metric_dependency_def
                      (target_type, type_meta_ver, metric_guid,
                       dep_target_type, dep_metric_guid, opt_code)
                 VALUES(p_target_type, p_type_meta_ver, 
                        rec.metric_guid, rec.dep_target_type,
                        rec.dep_metric_guid, rec.opt_code);

         EXCEPTION
          WHEN DUP_VAL_ON_INDEX THEN
            NULL;
         END;
        END LOOP;
      END LOOP;
  END IF;

  IF EMDW_LOG.P_IS_INFO_SET
  THEN
    EMDW_LOG.INFO('handle_tgttype_addition:exit', G_MODULE) ;
  END IF ;

END handle_tgttype_addition;


-- add a  dummy metric collection for cluster/rac avail metric created in 10R1
PROCEDURE upgrade10R1Collection
AS
l_coll_name mgmt_collections.COLL_NAME%TYPE;

CURSOR promoted_metrics 
IS
 SELECT t.target_name, t.target_type, m.metric_name, m.metric_column
   FROM mgmt_targets t, mgmt_metrics m, mgmt_metric_dependency d
  WHERE t.target_type = m.target_type
    AND t.type_meta_ver = m.type_meta_ver
    AND (t.category_prop_1 = m.category_prop_1 OR m.category_prop_1 = ' ')
    AND (t.category_prop_2 = m.category_prop_2 OR m.category_prop_2 = ' ')
    AND (t.category_prop_3 = m.category_prop_3 OR m.category_prop_3 = ' ')
    AND (t.category_prop_4 = m.category_prop_4 OR m.category_prop_4 = ' ')
    AND (t.category_prop_5 = m.category_prop_5 OR m.category_prop_5 = ' ')
    AND t.target_guid = d.target_guid
    AND m.metric_guid = d.metric_guid
    AND d.rs_metric = 1; 

BEGIN
  FOR rec in promoted_metrics
  LOOP
     l_coll_name := GET_COLLECTION_NAME(rec.target_type,
                             rec.metric_name,
                             rec.metric_column,
                             ' ');
     BEGIN
        check_existing_coll_name(rec.target_name,
                          rec.target_type,
                          l_coll_name);
        add_dummy_collection(rec.target_name,
                             rec.target_type,
                             rec.metric_name,
                             rec.metric_column,
                             ' ');
       
     EXCEPTION
      WHEN mgmt_global.key_already_exists THEN
           NULL; -- ignore if the collection exists.
     END;
  END LOOP;

END upgrade10R1Collection;

end em_rep_metric;
/

show errors;

