Rem drv: <create type="pkgdefs" pos="log/log_pkgdefs.sql+"/>
rEM
Rem $Header: rep_metric_pkgdef.sql 07-sep-2007.14:13:31 gan Exp $
Rem
Rem rep_metric_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_metric_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         09/07/07 - Backport gan_bug-6336199 from main
Rem    gan         06/01/07 - Backport gan_bug-4523381 from main
Rem    gan         03/21/06 - Backport gan_bug-5049342 from main 
Rem    gan         08/15/05 - add opt code for api 
Rem    gan         07/01/05 - add auto-copy for new meta ver 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gan         06/21/05 - add cb for key deletion 
Rem    mfidanbo    06/09/05 - make add/remove dummy collection public 
Rem    gan         04/01/05 - Expose get_collection_name for testing 
Rem    gan         03/17/05 - add collection prop names 
Rem    gan         03/01/05 - take dep collection names 
Rem    gan         02/22/05 - 
Rem    ramalhot    02/23/05 - added proc handle_add_target 
Rem    rmarripa    02/17/05 - add beacon dependency deletion API 
Rem    ramalhot    02/02/05 - changed signature for target_deleted_callback 
Rem    gan         01/25/05 - add interval parameter 
Rem    jsadras     11/25/04 - task type constant 
Rem    jsadras     11/09/04 - run_metric_eval
Rem    streddy     10/24/04 - Remove l_rs_metric checks 
Rem    streddy     10/20/04 - Evaluation order support 
Rem    gan         10/13/04 - add bcn metric functions 
Rem    gan         10/12/04 - add delete_metric 
Rem    streddy     10/08/04 - Modify delete_dependency API
Rem    ramalhot    08/31/04 - cutover to new assoc tables 
Rem    streddy     08/17/04 - Added target_deleted_callback 
Rem    streddy     08/10/04 - Add data metric collections 
Rem    streddy     07/14/04 - Fix out-of-order target registrations problem
Rem    streddy     10/07/03 - Added can_calculate flag 
Rem    streddy     09/25/03 - Added type_meta_ver support 
Rem    streddy     04/09/03 - streddy_composite_target_availability
Rem    streddy     04/05/03 - Created
Rem    

CREATE OR REPLACE PACKAGE em_rep_metric AS
-- 
-- task type used when creating tasks for tasking engine
--
G_TASK_TYPE CONSTANT NUMBER := 2;
--

-- collection property columan_guid
G_COLUME_GUID_PROP constant varchar(64) := 'column_guid';
-- collection property key_value
G_KEY_VALUE_PROP constant mgmt_metric_dependency.key_value%TYPE
                                   := 'key_value';

-- PURPOSE
--   To add a list of dependencies that affects the severity state
--   of a metric. The dependencies themselves are metrics. These dependencies
--   are used by the repository to trigger the execution of metric's
--   severity_eval_proc.
--
--   This method allows specifying dependencies at a target type
--   level and meant to be used only for composite target types.
--   
-- PARAMTERS
--
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
--
--   v_dependency_list: A list of MGMT_METRIC_DESC objects containing
--                      the metric dependencies. 
--                     
-- ERROR CODES
--    NO_SUCH_METRIC_ERR: If the metric in metric_desc is not defined.
--    ALREADY_EXISTS_ERR: If dependencies are already defined for this
--                        metric -or- there are duplicate entries in the
--                        v_dependency_list. Call DELETE_METRIC_SEVERITY_DEPS
--                        to delete existing dependencies.
--
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC,
                                   v_dependency_list IN 
                                             MGMT_METRIC_DESC_ARRAY,
                                   v_opt_code IN NUMBER
                                             DEFAULT NULL);

--
-- PURPOSE
--   To add a list of dependencies that affects the severity state
--   of a metric for a specific target instance. The dependencies 
--   themselves are metrics. These dependencies are used by the repository
--   to trigger the execution of metric's severity_eval_proc. If 
--   dependency metrics already exist for this metric, then the new
--   dependencies are appended. Duplicate dependencies are ignored.
--
-- PARAMTERS
--
--   v_metric_instance: A MGMT_METRIC_INSTANCE object defining the metric. The
--                   'key_value' attribute is optional.
--
--   v_dependency_list: A list of MGMT_METRIC_INSTANCE objects containing
--                      the metric dependencies.  The 'key_value' attribute
--                      is optional.
--
-- ERROR
--   NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--   TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_instance IN MGMT_METRIC_INSTANCE,
                                   v_dependency_list IN 
                                        MGMT_METRIC_INSTANCE_ARRAY); 



--
-- PURPOSE
--     Remove the dependency list for a metric for an entire target
--     type.
-- PARAMTERS
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
-- ERROR CODES
--    NO_SUCH_METRIC_ERR  - If there is no such metric 
-- 
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC);


--
-- PURPOSE
--     Remove the dependency list for a metric of a specific target
--     instance.
-- PARAMTERS
--   v_metric_instance:  A metric instance object.
--
--   v_dependency_list: If NULL, all dependencies are removed for this
--              metric. If not NULL, only the specified depenendecies
--              are removed.
-- 
-- ERROR CODES
--    NO_SUCH_METRIC_ERR  - If there is no such metric 
-- 
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_instance IN
                                            MGMT_METRIC_INSTANCE,
                                      v_dependency_list IN 
                                            MGMT_METRIC_INSTANCE_ARRAY); 



--
-- PURPOSE
--   Sets up a repository collection for the specified metric. The
--   collection will apply the eval_proc over the list of dependency
--   metrics to compute the metric. Duplicate dependencies are ignored.
--
-- PARAMTERS
--      v_metric         : The repository metric.
--
--      v_eval_proc      : Name of the eval func that computes the metric;
--                         mgmt_metric_helper package provides evaluation functions
--                         for MIN, MAX, AVG, SUM, MEDIAN cases
--
--      v_dep_metrics    : A list of metric dependencies.
--      v_coll_interval  : collection interval, if it is NULL, interval 
--                         is calculated from the dependents. 
--      v_dep_coll_names : Dependent metric collection names, for test based
--                         promotion, the index should match v_dep_metrics
--      v_min_dep_interval: the minimum collection interval of all dependent
--                          metrics, for test based promotion.
--      v_opt_code       : avail optimization code 
--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE ADD_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                     v_eval_proc       IN VARCHAR2,
                                     v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                     v_coll_interval   IN NUMBER DEFAULT NULL,
                                     v_dep_coll_names IN 
                                            SMP_EMD_STRING_ARRAY DEFAULT NULL,
                                     v_min_dep_interval IN NUMBER DEFAULT NULL,
                                     v_opt_code  IN NUMBER DEFAULT NULL); 


--
-- PURPOSE
--   Modifies repository collection details for the specified metric. 
--
-- PARAMTERS
--      v_metric     : The repository metric.
--
--      v_eval_proc  : Name of the eval func that computes the metric. The
--                     existing eval-proc will be replaced by this.
--
--      v_dep_metrics : Set of metric dependencies. The existing dependencies
--                      will be replaced by this list.
--      v_coll_interval  : collection interval, if it is NULL, no change.
--
--      v_dep_coll_names : Dependent metric collection names, for test based
--                         promotion, the index should match v_dep_metrics
--      v_min_dep_interval: the minimum collection interval of all dependent
--                          metrics, for test based promotion. 

--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE MODIFY_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                        v_eval_proc       IN VARCHAR2,
                                        v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                     v_coll_interval   IN NUMBER DEFAULT NULL,
                                     v_dep_coll_names IN 
                                            SMP_EMD_STRING_ARRAY DEFAULT NULL,
                                     v_min_dep_interval IN NUMBER DEFAULT NULL,
                                     v_opt_code  IN NUMBER DEFAULT NULL);


--
-- PURPOSE
--   Modifies repository collection dependencies for the specified metric. 
--
-- PARAMTERS
--      v_metric : The repository metric.
--
--      v_dep_metrics_to_add : Metric dependencies to be added.
--
--      v_dep_metrics_to_del : Metric dependencies to be deleted.
--
--
--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE MODIFY_REPO_METRIC_DEPS(v_metric IN MGMT_METRIC_INSTANCE,
                                   v_dep_metrics_to_add IN 
                                        MGMT_METRIC_INSTANCE_ARRAY,
                                   v_dep_metrics_to_del IN 
                                        MGMT_METRIC_INSTANCE_ARRAY);

--
-- PURPOSE
--   Remove a repository metric collection. The metric data is not removed
--   as a result of deleting the collection.
-- PARAMETERS
--   v_metric : The repository metric
--   v_clear_dependency: whether to clear dependency on this metric
-- 
PROCEDURE DELETE_REPO_METRIC_COLLECTION(v_metric IN MGMT_METRIC_INSTANCE,
                                        v_clear_dependency IN NUMBER
                                                 DEFAULT mgmt_global.G_TRUE);


--
-- PURPOSE
--   Sets the eval proc for a repo collection
--
PROCEDURE SET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       IN VARCHAR2,
                                    v_opt_code  IN NUMBER DEFAULT NULL);


--
-- PURPOSE
--   Sets the eval proc for a repo collection
--
PROCEDURE GET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       OUT VARCHAR2);


-- 
-- PURPOSE
--   Initializes metric dependency list for a target. This is not for
--   SDK consumption. This proc should be called whenever a target is
--   added to the repository. If the target type has any metrics of
--   type REPOSITORY_EVENTS defined, it will initialize the necessary
--   state in the dependency tables.
--
--   NOTE: *** This is a add target callback
--   
-- PARAMETERS
--    v_target_type:  Target type
--    v_target_guid:  Target guid
--    v_target_name:  Target Name
-- 
PROCEDURE HANDLE_ADD_TARGET
(
  v_target_name IN mgmt_targets.target_name%TYPE,
  v_target_type IN mgmt_targets.target_type%TYPE,
  v_target_guid IN mgmt_targets.target_guid%TYPE
);
--
-- PURPOSE
--   Removes a target as a dependency. This is not part of SDK.
-- PARAMETERS
--    v_target_guid: [Optional] Target for which the dependency to
--                   be removed. If null, the dependency is removed
--                   from all existing targets.
--    v_dep_target_guid: Target to be removed
--
--    v_update_eval_order: Update the evaluation order of the
--                     availability compuations
-- 
PROCEDURE DELETE_DEPENDENCY_TARGET(v_target_guid IN RAW DEFAULT NULL,
                                   v_dep_target_guid IN RAW,
                                   v_update_eval_order IN BOOLEAN DEFAULT TRUE);


--
-- PURPOSE
--  Initialize the collections that are pending on the specified
--  target becoming available
--
PROCEDURE INIT_COLLECTION_TIMESTAMP(v_dep_target_guid IN RAW);

--
-- Initialize the start timestamp of a specific collection
--
PROCEDURE INIT_TGT_COLLECTION_TIMESTAMP(v_target_guid IN RAW);

--
-- Lock the target dependency definition. This should be called
-- from the following places:
--  o whenever dependency list changes
--  o whenever metric computation is performed
-- PARAMETERS
--   v_nowait_mode
--           TRUE  -> Do not wait for the lock
--           FALSE -> Wait for the lock
--
--  RETURNS
--     true - if the lock is acquired
--     false - if the lock is not acquired
--
FUNCTION lock_target_deps(v_target_guid   IN RAW, 
                          v_nowait_mode   IN BOOLEAN default false)
                           
  RETURN BOOLEAN;

--
-- Callback to clean up deleted target state
--
PROCEDURE target_deleted_callback(v_target_name IN mgmt_targets.target_name%TYPE,
                                  v_target_type IN mgmt_targets.target_type%TYPE,
                                  v_target_guid IN mgmt_targets.target_guid%TYPE);

PROCEDURE member_added_callback
(
  p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
  p_source_target_name IN mgmt_targets.target_name%TYPE,
  p_source_target_type IN mgmt_targets.target_type%TYPE,
  p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
  p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
  p_scope_target_name  IN mgmt_targets.target_name%TYPE,
  p_scope_target_type  IN mgmt_targets.target_type%TYPE
);

PROCEDURE member_deleted_callback
(
  p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
  p_source_target_name IN mgmt_targets.target_name%TYPE,
  p_source_target_type IN mgmt_targets.target_type%TYPE,
  p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
  p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
  p_scope_target_name  IN mgmt_targets.target_name%TYPE,
  p_scope_target_type  IN mgmt_targets.target_type%TYPE
);

--PURPOSE: Remove metric dependency detail when a beacon is disassociated
-- with a target
--PARAMETERS:
-- p_dep_target_guid : the target the beacon test is for
-- p_dep_key_values : the compoiste keys of beacon tests for a given target
PROCEDURE remove_bcn_dependency(p_dep_target_guid IN RAW,
                                p_dep_key_values IN SMP_EMD_STRING_ARRAY);


--PURPOSE: Remove metric dependency detail when a beacon is deleted
-- from the repository. This API will delete all dependencies from 
-- all promoted metrics for all targets.
--PARAMETERS:
-- p_dep_key_values : the compoiste key of beacon
PROCEDURE remove_bcn_dependency(p_dep_key_values IN SMP_EMD_STRING_ARRAY);

--PROCEDURE: cleanup metic dependency detail when system member association
-- changes
--OUT PARAMETER:
--  p_impacted_services: service affected by the membership change
PROCEDURE cleanup_member_assoc_dep(p_impacted_services OUT MGMT_GUID_ARRAY);

--PROCEDURE: cleanup metic dependency detail when system runs on association
-- changes
--OUT PARAMETER:
--  p_service_guid: service was running on the system
--  p_system_guid:
PROCEDURE cleanup_runs_on_assoc_dep(p_service_guid IN RAW,
                                    p_system_guid IN RAW);


--
-- Internal procedures - added here for unit testing purposes. These should
-- not be directly from outside packages.
--

-- Computes the evaluation for the specified target
-- and all its ancestors
PROCEDURE COMPUTE_EVAL_ORDER(v_target_guid IN RAW,
                             v_metric_guid IN RAW,
                             v_key_value IN VARCHAR2);

--
-- Computes the evaluation order for the 
-- rs/metric of the specified target
-- 
PROCEDURE COMPUTE_EVAL_ORDER(v_target_guid IN RAW);


-- Computes the eval-order for the direct dependents of
-- the specified (target-guid, metric-guid, key-value)
PROCEDURE COMPUTE_PARENT_EVAL_ORDER(v_target_guid IN RAW,
                                    v_metric_guid IN RAW,
                                    v_key_value IN VARCHAR2);


-- Computes the eval-order for the direct dependents of
-- the specified target guid
PROCEDURE COMPUTE_PARENT_EVAL_ORDER(v_target_guid IN RAW);
--
-- Place holder for collections engine to call. Any name changes
-- has to be reflected in em_task package as well
--
PROCEDURE run_metric_eval(p_context IN mgmt_namevalue_array) ;

--
-- Backdoor method to set interval for all repo collections configured through
-- this package. 
--
PROCEDURE set_all_repo_coll_interval(v_interval IN NUMBER);

FUNCTION is_repo_side_availability
(
  v_target_type   IN mgmt_targets.target_type%TYPE,
  v_type_meta_ver IN mgmt_targets.type_meta_ver%TYPE
)RETURN BOOLEAN;


-- Get the generated collection name
FUNCTION GET_COLLECTION_NAME(v_target_type IN VARCHAR2,
                             v_metric_name IN VARCHAR2,
                             v_metric_column IN VARCHAR2, 
                             v_key_value IN VARCHAR2)
 RETURN VARCHAR2;

-- Add dummy collection for event-based rep metrics
PROCEDURE add_dummy_collection(v_target_name IN VARCHAR2,
                               v_target_type IN VARCHAR2,
                               v_metric_name IN VARCHAR2,
                               v_metric_column IN VARCHAR2,
                               v_key_value IN VARCHAR2);

-- Remove dummy collection
PROCEDURE delete_dummy_collection(v_target_name IN VARCHAR2,
                                  v_target_type IN VARCHAR2,
                                  v_metric_name IN VARCHAR2,
                                  v_metric_column IN VARCHAR2,
                                  v_key_value IN VARCHAR2);

  --
  -- PROCEDURE: handle_metric_keyval_deletion
  --
  -- PURPOSE
  --   callback when a key-value of a metric is permanently removed
  --
  -- IN Parameters:
  --   v_target_guids : 
  --      target guid for which key value of metric to be deleted
  --   v_metric_guid
  --     Metric guid
  --   v_key_value
  --     Key value of metric 
  --
  -- OUT Parameters:
  --
PROCEDURE handle_metric_keyval_deletion
(
    v_target_guid  IN mgmt_targets.target_guid%TYPE,
    v_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    v_key_value    IN mgmt_metrics_raw.key_value%TYPE
) ;


-- Callback to handle the addition of new target type version
PROCEDURE handle_tgttype_addition(p_target_type   IN VARCHAR2,
                                  p_type_meta_ver IN VARCHAR2);

-- Helper function to add a collection for cluster/rac availability created
-- prior to 10R2, see bug 4523381
PROCEDURE upgrade10R1Collection;


-- Helper function to suspend collection to metric promotion with 0 dependency
PROCEDURE SUSPEND_NULL_DEP_DATA_COLL;

end em_rep_metric;

/

show errors;

