Rem
Rem $Header: sdk_admin_pkgdef.sql 21-feb-2007.09:54:25 aptrived Exp $
Rem
Rem sdk_admin_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_admin_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      The sql procs used by the admin ui.  Only administrators have access.  
Rem      These are part of the SDK
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aptrived    04/18/06 - Bug#5152908, Adding delete_target_metrics_1day,
Rem                           delete_target_metrics_1dayhour
Rem    aholser     06/08/05 - add api to return oms/oc4j/ias 
Rem    rkpandey    01/06/05 - Added delete_target_metrics_raw/delete_target_metrics_1hour
Rem    vkhizder    10/14/04 - adding function to determine OMS status 
Rem    rzazueta    11/13/03 - Add procs to enable/disable/verify metric deletion
Rem    streddy     04/21/03 - Target added callback support
Rem    aholser     04/02/03 - add get_oms_urls
Rem    aholser     03/15/03 - 4.1 changes
Rem    aholser     03/06/03 - move set_inactive_time to sdk
Rem    rpinnama    02/14/03 - Add del_completion_time_in to delete_target_internal
Rem    rpinnama    11/25/02 - Add cleanup agent API
Rem    rpinnama    09/18/02 - Remove authid current_user clause from create package
Rem    skini       07/05/02 - Add synchronous and force options to deleteTarget
Rem    skini       07/02/02 - Make delete_target asynchronous
Rem    tjaiswal    05/17/02 - Move notif plsql to notification_ui_pkgbody
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    rpatti      04/26/02 - allow grp dlt if user has manage target grp priv
Rem    rpatti      04/17/02 - update grp avail on target deletion
Rem    tjaiswal    03/20/02 - Add support for pl sql notif device
Rem    rpatti      02/25/02 - use function to get current user
Rem    skini       02/03/02 - Add permission info to delete_target
Rem    skini       01/21/02 - Introduce target deletion callbacks, exceptions
Rem    skini       01/02/02 - Remove reference to security packages
Rem    aholser     11/28/01 - make targets case-sensitive.
Rem    aholser     10/30/01 - role_target_map changes.
Rem    aholser     10/17/01 - fix counter
Rem    aholser     10/12/01 - delete_target changes
Rem    aholser     10/08/01 - throw dup user
Rem    aholser     10/09/01 - fix delete-target with target_guid in view
Rem    tjaiswal    10/09/01 - Add test_snmp_host procedure
Rem    aholser     10/12/01 - remove ability for user to retry delete_target
Rem    tjaiswal    09/07/01 - Move notif plsql
Rem    aholser     08/09/01 - review changes
Rem    aholser     07/17/01 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_admin
AS

--
-- CONSTANT definitions
--
-- USER_ROLE:  The rolename assigned to all em users
-- MGMT_ROLE:  The rolename assigned to all administrators
-- TARGET_ROLE_PREDICATE:  The predicate attached to roles to mark them
--   as target roles.  These roles are mapped in the mgmt_role_target_map
--   and generate selection predicates through our accesss control.  The predicate
--   is always manipulated internally in these procedures and not exposed to the
--   user.
-- ROLE_ALL_TARGETS:  The special role allowing access to all targets.
--   selection predicates are not generated for those assigned this role.
--

USER_ROLE CONSTANT VARCHAR2(30) := 'MGM_USER';
MGMT_ROLE CONSTANT VARCHAR2(30) := 'MGM_ADMIN_REPOSITORY';
TARGET_ROLE_PREDICATE CONSTANT VARCHAR2(30) := 'MGMT_';
ROLE_ALL_TARGETS CONSTANT VARCHAR2(30) := 'MGMT_ACCESS_ANY_TARGET';
USER_NAME_MAX NUMBER := 30;
PASSWORD_MAX NUMBER := 30;
ROLE_NAME_MAX NUMBER := 30;
USER_NAME_MIN NUMBER := 1;
PASSWORD_MIN NUMBER := 1;
PASSWORD_UPDATE_MIN NUMBER := 0;
ROLE_NAME_MIN NUMBER := 6;
METRIC_DELETION CONSTANT VARCHAR2(32) := 'metric_deletion_enabled';
METRIC_DELETION_CMT CONSTANT VARCHAR2(128) := 
     'Property that defines whether metric data should be deleted or not when a target is deleted';

TYPE CURSORTYPE IS REF CURSOR;


--
-- Procedure DELETE_TARGET
--
-- PURPOSE: To remove the specified target from the repository.  This
--   procedure is non-recoverable - if an error occurs during processing,
--   table data may be in an inconsistent state, since we are committing
--   after each table or 1000 rows.  
-- IN parameters:
--   target_name_in: VARCHAR2 The name of the target to be deleted
--   target_type_in: VARCHAR2 The type of the target to be deleted
--   delete_members_in: NUMBER Set to 1 for a composite target if you
--     want all its members to be deleted as well. Defaults to 0.     
--   delete_hosts_in: NUMBER This is relevant only when delete_members
--      is set to true (1). By default, if a host is part of a 
--      composite target, it is not deleted; if you want the host to
--      be deleted as well, set this to 1.
--   force_delete_in: NUMBER If this is set to 1, the target will be
--    deleted from the repository even if it cannot be deleted from
--    the emd for any reason. By default, this is set to 0 (false);
--    the background delete target job will wait until the target
--    can be deleted from the agent before it is deleted from the
--    repository.
--
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   20206: Target does not exist
--   INVALID_PARAMS_ERR: If specified target is not composite and
--      delete_members_in is set to 1.
--   

PROCEDURE delete_target
  (target_name_in IN VARCHAR2,
  target_type_in IN VARCHAR2,
  delete_members_in NUMBER DEFAULT 0,
  delete_hosts_in NUMBER DEFAULT 0,
  force_delete_in NUMBER DEFAULT 0);


-- This should never be called externally! Only called from
-- the system job that backgrounds the deletion
PROCEDURE delete_target_internal(target_name_in IN VARCHAR2,
                                 target_type_in IN VARCHAR2,
				 del_complete_time_in IN VARCHAR2 DEFAULT NULL);

-- Procedure ADD_TARGET_DELETION_CALLBACK
--
-- PURPOSE: To add a callback that will be called when a target is 
--   deleted (when delete_target() is called).

-- IN parameters:
--   p_procedure_name_in: The name of the callback procedure. This must
--      have the following signature: 
--      PROCEDURE PROC(p_target_name VARCHAR2, p_target_type VARCHAR2,
--                       p_target_guid RAW);
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None
PROCEDURE add_target_deletion_callback
  (p_procedure_name_in IN VARCHAR2);

--   Procedure: DELETE_TARGET_METRICS_RAW
--   Procedure: DELETE_TARGET_METRICS_1HOUR
--   Procedure: DELETE_TARGET_METRICS_1DAY
--   PURPOSE  : Procedures to delete the rows of a target from the following tables
--   MGMT_METRICS_RAW
--   MGMT_METRICS_1HOUR
--   MGMT_METRICS_1DAY
--
-- IN parameters:
--   p_target_guids: List of the target_guids that should be deleted.
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None

PROCEDURE delete_target_metrics_raw(p_target_guids IN MGMT_TARGET_GUID_ARRAY);
PROCEDURE delete_target_metrics_1hour(p_target_guids IN MGMT_TARGET_GUID_ARRAY);
PROCEDURE delete_target_metrics_1day(p_target_guids IN MGMT_TARGET_GUID_ARRAY);

-- Procedure ADD_TARGET_ADDITION_CALLBACK
--
-- PURPOSE: To add a callback that will be called when a target is 
--   added to the repository. 
--   Note 1: The callback cannot query MGMT_TARGETS table from within the
--   callback code. 
--   Note 2: All the exceptions raised by the callback are ignored by the repository
-- IN parameters:
--   p_procedure_name_in: The name of the callback procedure. This must
--      have the following signature: 
--      PROCEDURE PROC(p_target_name VARCHAR2, p_target_type VARCHAR2,
--                     p_target_guid RAW);
--   p_target_type : Target type for which this callback should be called (optional).
--                   If target type is not specified, then the callback is called
--                   for targets of all types.
--                   
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None
PROCEDURE add_target_addition_callback
   (p_procedure_name_in IN VARCHAR2,
    p_target_type_in    IN VARCHAR2 DEFAULT ' ');


-- Procedure DEL_TARGET_ADDITION_CALLBACK
--
-- PURPOSE: To remove a callback that will be called when a target is 
--   added to the repository.
-- IN parameters:
--   p_procedure_name_in: The name of the callback procedure.
--   p_target_type : Target type for which this callback should be removed (optional)
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None
PROCEDURE del_target_addition_callback
   (p_procedure_name_in IN VARCHAR2,
    p_target_type_in    IN VARCHAR2 DEFAULT ' ');



-- Procedure ADD_TARGET_DELETION_EXCEPTIONS
--
-- PURPOSE: Specify a set of tables that will be used as exceptions
--   during target deletion. The target deletion routine will not
--   attempt to delete any data from these tables, even if they have
--   a target_guid column. 
--
-- IN parameters:
--   p_exceptions_in: A string array that contains the name of the
--       tables to be exempted
-- 
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None
PROCEDURE add_target_deletion_exceptions(p_exceptions_in SMP_EMD_STRING_ARRAY);

-- FOR INTERNAL USE ONLY: overloaded delete_target
PROCEDURE delete_target(target_name_in VARCHAR2,
                        target_type_in VARCHAR2,
                        raise_composite_error_in BOOLEAN,
                        submit_job_in BOOLEAN,
                        delete_members_in BOOLEAN,
                        delete_hosts_in BOOLEAN,
                        force_delete_in BOOLEAN,
                        delete_sync_in BOOLEAN DEFAULT false);

-- This version of delete_target is for repository regression
-- use ONLY. This will synchronously delete the target from
-- the repository (with repository regressions, no emd's are
-- involved, so there is no need to delete the target from the
-- emd).
PROCEDURE delete_target_sync(target_name_in VARCHAR2,
                             target_type_in VARCHAR2,
                             delete_members_in NUMBER DEFAULT 0,
                             delete_hosts_in NUMBER DEFAULT 0);

--
-- This will synchronously delete the agent and all the targets on 
-- that agent.
-- This API should be used with exterme care.
-- 
PROCEDURE cleanup_agent(v_agent_name_in IN VARCHAR2);

--
-- PURPOSE 
--   Procedure to set the ping interval for an agent
-- 
PROCEDURE set_inactive_time(p_agent_guid IN RAW,
                              p_max_inactive_time IN NUMBER);

PROCEDURE set_inactive_time(p_agent_name IN VARCHAR2,
                              p_max_inactive_time IN NUMBER);

--
-- PURPOSE 
--   Procedure to set the logging level for system errors.
--   Valid values are: 'ERROR', 'WARN', 'INFO' and 'DEBUG'
--   The default level is 'ERROR'.  Set this if additional
--   system level error logging is needed.  
-- 
PROCEDURE set_log_level(level_in IN VARCHAR2);

--
-- PURPOSE 
--   Procedure to set the purge window for system errors.  Positive numbers only,
--   rounded to integers.  The default is 168 hours (7 days).  A value of '0' causes 
--   errors to be purged hourly.  
-- 
PROCEDURE set_log_purge(hours_in IN NUMBER DEFAULT 168);

--
-- PURPOSE 
--   Procedure to delete an oms from the repository
-- 
PROCEDURE delete_oms(omsname_in IN VARCHAR2);

-- 
-- PURPOSE 
--  Returns the Management System name  
-- 
FUNCTION get_ms_name RETURN VARCHAR2;

-- 
-- PURPOSE 
--  Returns a cursor containing: oms_name, url_name, url_value.
--  url_names include:
--     upload_url
--     secure_upload_url
--     console_url
--     secure_console_url
--  There will be at most one upload_url and optionally one secure_upload_url per oms.  There may be
--  any number of either flavor of console url
-- 
FUNCTION get_oms_urls RETURN CURSORTYPE;

--
-- PURPOSE
--  Returns up/down status of a given OMS, or if no parameter passed,
--  number of OMSes that are up. If parameter is passed and not null,
--  MGMT_GLOBAL.G_STATUS_UP or MGMT_GLOBAL.G_STATUS_DOWN are returned
--  if matching registered OMS is found. If there is no registered 
--  OMS with submitted non-null p_oms_host_url, MGMT_GLOBAL.G_STATUS_UNKNOWN 
--  is returned.
-- 
--  Parameter p_oms_host_url, if not null, comes from 
--  host_url column of MGMT_OMS_PARAMETERS table.
--   
FUNCTION get_oms_status(p_oms_host_url IN VARCHAR2 DEFAULT NULL) RETURN NUMBER;

--
-- PURPOSE 
--   Procedure(s) to enable/disable/verify metric deletion
-- 
PROCEDURE enable_metric_deletion;

PROCEDURE disable_metric_deletion;

FUNCTION  is_metric_deletion_enabled RETURN INTEGER;

--
-- PURPOSE
--  Returns a cursor containing: oms_name, host_name, oc4j_name, ias_name
--
--  0 or 1 input parameters may be provided.  
--
--  If 0 input parameters are provided:
--     the function will return all omss with their associated host, oc4j and ias.
-- 
--  If 1 input parameter is provided:
--     the function will return the missing target names, if there is an associated oms.  If there
--     is no associate oms, the function will return null.  If more than one input parameter is
--     provided, all but the first one encountered will be ignored.  If a host_name is provided,
--     all omss on the host will be returned as individual rows in the cursor.  All others return
--     a cursor with one row.
--
FUNCTION get_oms_data (p_oms_name IN VARCHAR2 DEFAULT NULL,
                   p_host_name IN VARCHAR2 DEFAULT NULL,
                   p_oc4j_name IN VARCHAR2 DEFAULT NULL,
                   p_ias_name IN VARCHAR2 DEFAULT NULL) RETURN CURSORTYPE;

END mgmt_admin;
/

SHOW ERRORS;


