Rem
Rem $Header: sdk_assoc_pkgbody.sql 14-apr-2005.23:33:02 pmodi Exp $
Rem
Rem sdk_assoc_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_assoc_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot    04/08/05  - View porpagation related change in 
Rem                            create_target_assoc_def
Rem    neearora    03/17/05  - Add check to validate callback name during 
Rem                            registration of assoc_addition_callback and 
Rem                            assoc_deletion_callback, to prevent SQL injection 
Rem    ramalhot    01/17/05 -  assoc name changed from member to contains 
Rem    ramalhot    12/07/04 - xxx_assoc_property API changes 
Rem    ramalhot    10/06/04 - bulk apis added 
Rem    ramalhot    08/27/04 - properties added 
Rem    rmarripa    09/10/04 - remotely_monitored_by should have oracle_beacon 
Rem                           as assoc target type 
Rem    rmarripa    08/30/04 - Add remotely monitored by association for Beacon 
Rem                           monitoring 
Rem    ramalhot    08/18/04 - column name changed 
Rem    ramalhot    07/31/04 - constant name changed 
Rem    ramalhot    07/09/04 - create assoc def modified 
Rem    ramalhot    07/07/04 - ramalhot_assoc_object_creation
Rem    ramalhot    07/06/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_assoc IS

  FUNCTION generate_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
    RETURN mgmt_target_assoc_defs.assoc_guid%TYPE
  IS
  BEGIN

    RETURN em_assoc.generate_assoc_def_guid(p_assoc_name,
                                            p_source_target_type,
                                            p_scope_target_type);
  END generate_assoc_def_guid;

    --   This function returns the guid for a given target.
  FUNCTION get_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
    RETURN mgmt_target_assoc_defs.assoc_guid%TYPE
  IS
  BEGIN
    RETURN em_assoc.get_assoc_def_guid(p_assoc_name,
                                       p_source_target_type,
                                       p_scope_target_type);
  END get_assoc_def_guid;

  PROCEDURE create_target_assoc_def
  (
    p_assoc_name           IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE,
    p_assoc_name_nlsid     IN mgmt_target_assoc_defs.name_nlsid%TYPE
                              DEFAULT NULL,
    p_description          IN mgmt_target_assoc_defs.description%TYPE
                              DEFAULT NULL,
    p_description_nlsid    IN mgmt_target_assoc_defs.description_nlsid%TYPE
                              DEFAULT NULL,
    p_assoc_type           IN mgmt_target_assoc_defs.association_type%TYPE
                              DEFAULT ASSOC_TYPE_RELATES_TO,
    p_cardinality          IN mgmt_target_assoc_defs.cardinality%TYPE
                              DEFAULT OPTIONAL_MULTI_CARDINAL,
    p_prop_view_priv       IN mgmt_target_assoc_defs.prop_view_priv%type
                              DEFAULT NO_VIEW_PROPAGATION

  )
  IS

  BEGIN

    IF (emdw_log.p_is_debug_set)THEN
         emdw_log.debug('sdk_create_target_assoc_def:Entry',MODULE_NAME);
    END IF;

    em_assoc.create_target_assoc_def( p_assoc_name,
                                      p_source_target_type,
                                      p_assoc_target_type,
                                      p_scope_target_type,
                                      p_assoc_name_nlsid,
                                      p_description,
                                      p_description_nlsid,
                                      p_assoc_type,
                                      p_cardinality,
                                      p_prop_view_priv
                                    );

    IF (emdw_log.p_is_debug_set)THEN
      emdw_log.debug('sdk_create_target_assoc_def:Exit',MODULE_NAME);
    END IF;

  END create_target_assoc_def;


  PROCEDURE delete_target_assoc_def
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
  IS
  BEGIN
    IF (emdw_log.p_is_debug_set)THEN
      emdw_log.debug('SDK_DELETE_TARGET_ASSOC_DEF:Entry',MODULE_NAME);
    END IF;

    em_assoc.delete_target_assoc_def( p_assoc_name,
                                      p_source_target_type,
                                      p_scope_target_type);

    IF (emdw_log.p_is_debug_set)THEN
      emdw_log.debug('SDK_DELETE_TARGET_ASSOC:Exit',MODULE_NAME);
    END IF;

  END delete_target_assoc_def;

  PROCEDURE create_target_assoc
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name    IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE
                                DEFAULT ' ',
    p_scope_target_type    IN mgmt_targets.target_type%TYPE
                                DEFAULT GLOBAL_SCOPE_TARGET_TYPE,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                              DEFAULT ASSOC_NOT_EDITABLE
  )
  IS
  BEGIN
    IF (emdw_log.p_is_debug_set)THEN
      emdw_log.debug('SDK_CREATE_TARGET_ASSOC:Entry',MODULE_NAME);
    END IF;

    em_assoc.create_target_assoc( p_assoc_def_name,
                                  p_source_target_name,
                                  p_source_target_type,
                                  p_assoc_target_name,
                                  p_assoc_target_type,
                                  p_scope_target_name,
                                  p_scope_target_type,
                                  p_is_editable
                                );

    IF (emdw_log.p_is_debug_set)THEN
      emdw_log.debug('SDK_CREATE_TARGET_ASSOC:Exit',MODULE_NAME);
    END IF;
  END create_target_assoc;

  PROCEDURE delete_target_assoc
  (
    p_assoc_def_name      IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name  IN mgmt_targets.target_name%TYPE,
    p_source_target_type  IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name   IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type   IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name   IN mgmt_targets.target_name%TYPE
                               DEFAULT ' ',
    p_scope_target_type   IN mgmt_targets.target_type%TYPE
                               DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
  IS
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('SDK_DELETE_TARGET_ASSOC_INSTANCE:Entry',MODULE_NAME);
    END IF;

    em_assoc.delete_target_assoc ( p_assoc_def_name,
                                   p_source_target_name,
                                   p_source_target_type,
                                   p_assoc_target_name,
                                   p_assoc_target_type,
                                   p_scope_target_name,
                                   p_scope_target_type
                                 );

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('DELETE_TARGET_ASSOC:Exit',MODULE_NAME);
    END IF;

  END delete_target_assoc; --DELETE_TARGET_ASSOC

  PROCEDURE add_assoc_addition_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  )
  IS
  l_error_message VARCHAR2(1000);
  BEGIN
    EM_CHECK.check_not_null(p_procedure_name,'p_procedure_name');

    IF NOT EM_CHECK.is_valid_signature(p_procedure_name,
                      mgmt_short_string_array('VARCHAR2','VARCHAR2','VARCHAR2',
                         'VARCHAR2','VARCHAR2','VARCHAR2','VARCHAR2'),
                      l_error_message)
    THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,l_error_message) ;
    END IF ;

    INSERT
      INTO mgmt_callbacks
           (callback_type,callback_name,selector_1,selector_2)
    VALUES (mgmt_global.G_ASSOC_ADD_CALLBACK,
            p_procedure_name,
            p_assoc_def_name,
            p_source_target_type);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      raise_application_error(mgmt_global.invalid_params_err,
                              'callback  already exist');
  END add_assoc_addition_callback;

  PROCEDURE add_assoc_deletion_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  )
  IS
  l_error_message VARCHAR2(1000);
  BEGIN
    EM_CHECK.check_not_null(p_procedure_name,'p_procedure_name');

    IF NOT EM_CHECK.is_valid_signature(p_procedure_name,
                      mgmt_short_string_array('VARCHAR2','VARCHAR2','VARCHAR2',
                        'VARCHAR2','VARCHAR2','VARCHAR2','VARCHAR2'),
                      l_error_message)
    THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,l_error_message) ;
    END IF ;

    INSERT
      INTO mgmt_callbacks
           (callback_type,callback_name,selector_1,selector_2)
    VALUES (mgmt_global.G_ASSOC_DELETE_CALLBACK,
            p_procedure_name,
            p_assoc_def_name,
            p_source_target_type);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      raise_application_error(mgmt_global.invalid_params_err,
                              'callback  already exist');
  END add_assoc_deletion_callback;

  PROCEDURE del_assoc_addition_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  )
  IS
  BEGIN
    DELETE
      FROM mgmt_callbacks
     WHERE callback_type = mgmt_global.G_ASSOC_ADD_CALLBACK
       AND callback_name = p_procedure_name
       AND selector_1 = p_assoc_def_name
       AND selector_2 = p_source_target_type;

  END del_assoc_addition_callback;

  PROCEDURE del_assoc_deletion_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  )
  IS
  BEGIN
    DELETE
      FROM mgmt_callbacks
     WHERE callback_type = mgmt_global.G_ASSOC_DELETE_CALLBACK
       AND callback_name = p_procedure_name
       AND selector_1 = p_assoc_def_name
       AND selector_2 = p_source_target_type;

  END del_assoc_deletion_callback;


  PROCEDURE add_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  )
  IS
  BEGIN
    em_assoc.add_assoc_property(p_assoc_def_name,
                                p_source_target_name,
                                p_source_target_type,
                                p_assoc_target_name,
                                p_assoc_target_type,
                                p_scope_target_name,
                                p_scope_target_type,
                                p_property_name,
                                p_property_value);

  END add_assoc_property;

  PROCEDURE modify_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  )
  IS
  BEGIN
    em_assoc.modify_assoc_property(p_assoc_def_name,
                                   p_source_target_name,
                                   p_source_target_type,
                                   p_assoc_target_name,
                                   p_assoc_target_type,
                                   p_scope_target_name,
                                   p_scope_target_type,
                                   p_property_name,
                                   p_property_value);
  END modify_assoc_property;

  PROCEDURE delete_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE
  )
  IS
  BEGIN
    em_assoc.delete_assoc_property(p_assoc_def_name,
                                   p_source_target_name,
                                   p_source_target_type,
                                   p_assoc_target_name,
                                   p_assoc_target_type,
                                   p_scope_target_name,
                                   p_scope_target_type,
                                   p_property_name);
  END delete_assoc_property;

 -- Creates a list of associations of the specified association type.
   PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT mgmt_assoc.ASSOC_NOT_EDITABLE
  )
  IS

  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('create_target_assocs BULK WITHOUT SCOPE: Entry',MODULE_NAME);
    END IF;
    
    em_assoc.create_target_assocs(p_assoc_def_name,    
                                  p_source_target_name,
                                  p_source_target_type,
                                  p_assoc_targets_list,
                                  p_is_editable);       

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('create_target_assocs:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
  END create_target_assocs;

  PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  )
  IS

  BEGIN
   IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('create_target_assocs:BULK WITH SCOPE: Entry',MODULE_NAME);
    END IF;
    
    em_assoc.create_target_assocs(p_assoc_def_name,   
                                  p_scope_target_name,
                                  p_scope_target_type,
                                  p_assoc_list,       
                                  p_is_editable);      
    
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('create_target_assocs:BULK WITH SCOPE: Exit',MODULE_NAME);
    END IF;

  END create_target_assocs;
    
  PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  )
  IS

  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('set_target_assocs:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
    
    em_assoc.set_target_assocs(p_assoc_def_name,     
                               p_source_target_name, 
                               p_source_target_type, 
                               p_assoc_targets_list, 
                               p_is_editable);        
    
    
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('set_target_assocs:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
  END set_target_assocs;


  PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  )
  IS
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('set_target_assocs:BULK WITH SCOPE: Exit',MODULE_NAME);
    END IF;
    
    em_assoc.set_target_assocs(p_assoc_def_name,   
                               p_scope_target_name,
                               p_scope_target_type,
                               p_assoc_list,       
                               p_is_editable);      
    
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('set_target_assocs:BULK WITH SCOPE: Exit',MODULE_NAME);
    END IF;
  END set_target_assocs;


  PROCEDURE delete_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE
  )
  IS
    l_affected_targets MGMT_TARGET_ASSOC_LIST := MGMT_TARGET_ASSOC_LIST();
    l_assoc_guid mgmt_target_assoc_defs.assoc_guid%TYPE ;
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_target_assoc:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;

    em_assoc.delete_target_assocs(p_assoc_def_name,       
                                  p_source_target_name, 
                                  p_source_target_type); 

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_target_assoc:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
  END delete_target_assocs;
  
  
  PROCEDURE delete_assocs_in_scope
  (
    p_assoc_def_name      IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name   IN mgmt_targets.target_name%TYPE,
    p_scope_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE
  )
  IS
    l_affected_targets MGMT_TARGET_ASSOC_LIST := MGMT_TARGET_ASSOC_LIST();
    l_assoc_guid mgmt_target_assoc_defs.assoc_guid%TYPE ;
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_target_assoc:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
    
    em_assoc.delete_assocs_in_scope(p_assoc_def_name,   
                                    p_scope_target_name,
                                    p_scope_target_type);

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_target_assoc:BULK WITHOUT SCOPE: Exit',MODULE_NAME);
    END IF;
  END delete_assocs_in_scope;
    
BEGIN
  -- get the guids for out-of-the-box associations
  BEGIN
    g_depends_on_guid  := get_assoc_def_guid(ASSOC_DEF_DEPENDS_ON,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_DEPENDS_ON,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_DEPENDS_ON,
                              p_prop_view_priv => ALL_LEVEL_VIEW_PROPAGATION );

      g_depends_on_guid  := get_assoc_def_guid(ASSOC_DEF_DEPENDS_ON,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_connects_to_guid := get_assoc_def_guid(ASSOC_DEF_CONNECTS_TO,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_CONNECTS_TO,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_CONNECTS_TO);

      g_connects_to_guid := get_assoc_def_guid(ASSOC_DEF_CONNECTS_TO,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_hosted_by_guid := get_assoc_def_guid(ASSOC_DEF_HOSTED_BY,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_HOSTED_BY,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>MGMT_GLOBAL.G_HOST_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_HOSTED_BY,
                              p_cardinality =>OPTIONAL_SINGLE_CARDINAL,
                              p_prop_view_priv => ALL_LEVEL_VIEW_PROPAGATION );
  
    g_hosted_by_guid := get_assoc_def_guid(ASSOC_DEF_HOSTED_BY,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_monitored_by_guid := get_assoc_def_guid(ASSOC_DEF_MONITORED_BY,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_MONITORED_BY,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>MGMT_GLOBAL.G_AGENT_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_MONITORED_BY,
                              p_cardinality =>OPTIONAL_SINGLE_CARDINAL);

      g_monitored_by_guid := get_assoc_def_guid(ASSOC_DEF_MONITORED_BY,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_relates_to_guid   := get_assoc_def_guid(ASSOC_DEF_RELATES_TO,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_RELATES_TO,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_RELATES_TO);

      g_relates_to_guid   := get_assoc_def_guid(ASSOC_DEF_RELATES_TO,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_contains_guid    := get_assoc_def_guid(ASSOC_DEF_CONTAINS,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_CONTAINS,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_CONTAINS,
                              p_prop_view_priv => ALL_LEVEL_VIEW_PROPAGATION );
      
      g_contains_guid    := get_assoc_def_guid(ASSOC_DEF_CONTAINS,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_opt_connects_to_guid := get_assoc_def_guid(ASSOC_DEF_OPT_CONNECTS_TO,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_OPT_CONNECTS_TO,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_OPT_CONNECTS_TO);

      g_opt_connects_to_guid := get_assoc_def_guid(ASSOC_DEF_OPT_CONNECTS_TO,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_service_access_point_guid := get_assoc_def_guid(ASSOC_DEF_SERVICE_ACS_POINT,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_SERVICE_ACS_POINT,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_SERVICE_ACS_POINT);

      g_service_access_point_guid := get_assoc_def_guid(ASSOC_DEF_SERVICE_ACS_POINT,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_runs_on_guid := get_assoc_def_guid(ASSOC_DEF_RUNS_ON,ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_RUNS_ON,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_RUNS_ON,
                              p_cardinality =>OPTIONAL_SINGLE_CARDINAL,
                              p_prop_view_priv => ALL_LEVEL_VIEW_PROPAGATION );

      g_runs_on_guid := get_assoc_def_guid(ASSOC_DEF_RUNS_ON,ANY_TARGET_TYPE);
  END;

  BEGIN
    g_remotely_monitored_by_guid := get_assoc_def_guid(ASSOC_DEF_REMOTELY_MNTRD_BY, ANY_TARGET_TYPE);
  EXCEPTION
    WHEN mgmt_global.assoc_def_does_not_exist THEN
      create_target_assoc_def(p_assoc_name =>ASSOC_DEF_REMOTELY_MNTRD_BY,
                              p_source_target_type =>ANY_TARGET_TYPE,
                              p_assoc_target_type =>ANY_TARGET_TYPE,
                              p_assoc_type => ASSOC_TYPE_REMOTELY_MNTRD_BY,
                              p_prop_view_priv => ALL_LEVEL_VIEW_PROPAGATION );

      g_remotely_monitored_by_guid := get_assoc_def_guid(ASSOC_DEF_REMOTELY_MNTRD_BY, ANY_TARGET_TYPE);
  END;
END mgmt_assoc;
/
show errors;
