Rem
Rem $Header: sdk_assoc_pkgdef.sql 14-apr-2005.23:30:49 pmodi Exp $
Rem
Rem sdk_assoc_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_assoc_pkgdef.sql - SDK for Target Associations
Rem
Rem    DESCRIPTION
Rem      PL/SQL APIs to manipulate both association def and association  
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot    04/08/05 - View porpagation related const added 
Rem    ramalhot    01/17/05 -  assoc name changed from member to contains 
Rem    ramalhot    12/07/04 - xxx_assoc_property API changes 
Rem    ramalhot    10/06/04 - bulk apis added 
Rem    ramalhot    09/12/04 - GLOBAl_SCOPE_TARGET_NAME added 
Rem    rmarripa    08/30/04 - add remotely monitored by association 
Rem    ramalhot    08/18/04 - column name changed 
Rem    ramalhot    07/31/04 - constant name changed 
Rem    ramalhot    07/09/04 - create assoc def modified 
Rem    ramalhot    07/07/04 - ramalhot_assoc_object_creation
Rem    ramalhot    07/06/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_assoc IS

  -- Module name used for logging
  MODULE_NAME CONSTANT VARCHAR2(15) := 'MGMT.assoc';

  -- Default target types
  ANY_TARGET_TYPE              CONSTANT VARCHAR2(1)  := '*';
  GLOBAL_SCOPE_TARGET_NAME     CONSTANT VARCHAR2(1)  := ' ';
  GLOBAL_SCOPE_TARGET_TYPE     CONSTANT VARCHAR2(1)  := ' ';
  GLOBAL_SCOPE_TARGET_GUID     CONSTANT RAW(16)  := '0000000000000000';

  -- Association Types
  ASSOC_TYPE_DEPENDS_ON             CONSTANT VARCHAR2(10) := 'depends_on';
  ASSOC_TYPE_CONNECTS_TO            CONSTANT VARCHAR2(11) := 'connects_to';
  ASSOC_TYPE_SERVICE_ACS_POINT      CONSTANT VARCHAR2(20) := 'service_access_point';
  ASSOC_TYPE_HOSTED_BY              CONSTANT VARCHAR2(9)  := 'hosted_by';
  ASSOC_TYPE_MONITORED_BY           CONSTANT VARCHAR2(12) := 'monitored_by';
  ASSOC_TYPE_OPT_CONNECTS_TO        CONSTANT VARCHAR2(22) := 'optionally_connects_to';
  ASSOC_TYPE_RELATES_TO             CONSTANT VARCHAR2(10) := 'relates_to';
  ASSOC_TYPE_CONTAINS               CONSTANT VARCHAR2(9)  := 'contains';
  ASSOC_TYPE_RUNS_ON                CONSTANT VARCHAR2(7)  := 'runs_on';
  ASSOC_TYPE_REMOTELY_MNTRD_BY      CONSTANT VARCHAR2(22)  := 'remotely_monitored_by';

  -- Association Defs
  ASSOC_DEF_DEPENDS_ON             CONSTANT VARCHAR2(10) := 'depends_on';
  ASSOC_DEF_CONNECTS_TO            CONSTANT VARCHAR2(11) := 'connects_to';
  ASSOC_DEF_SERVICE_ACS_POINT      CONSTANT VARCHAR2(20) := 'service_access_point';
  ASSOC_DEF_HOSTED_BY              CONSTANT VARCHAR2(9)  := 'hosted_by';
  ASSOC_DEF_MONITORED_BY           CONSTANT VARCHAR2(12) := 'monitored_by';
  ASSOC_DEF_OPT_CONNECTS_TO        CONSTANT VARCHAR2(22) := 'optionally_connects_to';
  ASSOC_DEF_RELATES_TO             CONSTANT VARCHAR2(10) := 'relates_to';
  ASSOC_DEF_CONTAINS               CONSTANT VARCHAR2(9)  := 'contains';
  ASSOC_DEF_RUNS_ON                CONSTANT VARCHAR2(7)  := 'runs_on';
  ASSOC_DEF_REMOTELY_MNTRD_BY      CONSTANT VARCHAR2(22)  := 'remotely_monitored_by';

  -- Constants for different cardinalities
  OPTIONAL_SINGLE_CARDINAL   CONSTANT NUMBER := 0;
  REQUIRED_SINGLE_CARDINAL   CONSTANT NUMBER := 1;
  OPTIONAL_MULTI_CARDINAL    CONSTANT NUMBER := 2;
  REQUIRED_MULTI_CARDINAL    CONSTANT NUMBER := 3;

  -- Constants that tells whether association can be edited or not
  ASSOC_EDITABLE             CONSTANT NUMBER := 1 ;
  ASSOC_NOT_EDITABLE         CONSTANT NUMBER := 0 ;

  -- constants that controls the association ownership
  CREATED_BY_SYSTEM          CONSTANT NUMBER := 0;
  CREATED_INFERRED           CONSTANT NUMBER := 1;
  CREATED_BY_AGENT           CONSTANT NUMBER := 2;
  CREATED_BY_END_USER        CONSTANT NUMBER := 3;

  -- constants that controls the view propagation
  NO_VIEW_PROPAGATION          CONSTANT NUMBER := 0;
  ONE_LEVEL_VIEW_PROPAGATION   CONSTANT NUMBER := 1;
  ALL_LEVEL_VIEW_PROPAGATION   CONSTANT NUMBER := 2;

  -- Public variable declarations
  g_depends_on_guid            mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_connects_to_guid           mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_hosted_by_guid             mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_monitored_by_guid          mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_relates_to_guid            mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_contains_guid              mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_opt_connects_to_guid       mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_service_access_point_guid  mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_runs_on_guid               mgmt_target_assoc_defs.assoc_guid%TYPE;
  g_remotely_monitored_by_guid mgmt_target_assoc_defs.assoc_guid%TYPE;

  --
  -- PROCEDURE: CREATE_TARGET_ASSOC_DEF
  --
  -- PURPOSE
  --   Creates a new association def
  -- IN Parameters:
  --   p_assoc_def_name  : VARCHAR2
  --       The name of the association def to be added
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_description : VARCHAR2
  --       The display name of the association to be added.
  --       If NULL defaults to association type itself
  --   p_description_nlsid  : VARCHAR2
  --       The NLS ID of the display name of the association to be added.
  --       If NULL, <association>_name is used
  --   p_assoc_type : VARCHAR2
  --       The type of the association
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid. This is required only for
  --       non-global associations.
  --   p_cardinality : NUMBER
  --       The cardinality of the association,
  --           where OPTIONAL_SINGLE_CARDINAL means 0..1 (optional)
  --                 REQUIRED_SINGLE_CARDINAL means "1" (required)
  --                 OPTIONAL_MULTI_CARDINAL  means 0..* (optional, multicardinal)
  --                 REQUIRED_MULTI_CARDINAL  means "1..*" (required, multicardinal)
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DEF_ALREADY_EXIST : for already existing association

  PROCEDURE create_target_assoc_def
  (
    p_assoc_name           IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE,
    p_assoc_name_nlsid     IN mgmt_target_assoc_defs.name_nlsid%TYPE
                              DEFAULT NULL,
    p_description          IN mgmt_target_assoc_defs.description%TYPE
                              DEFAULT NULL,
    p_description_nlsid    IN mgmt_target_assoc_defs.description_nlsid%TYPE
                              DEFAULT NULL,
    p_assoc_type           IN mgmt_target_assoc_defs.association_type%TYPE
                              DEFAULT ASSOC_TYPE_RELATES_TO,
    p_cardinality          IN mgmt_target_assoc_defs.cardinality%TYPE
                              DEFAULT OPTIONAL_MULTI_CARDINAL,
    p_prop_view_priv       IN mgmt_target_assoc_defs.prop_view_priv%type 
                              DEFAULT NO_VIEW_PROPAGATION
  );

  --
  -- PROCEDURE: DELETE_TARGET_ASSOC_DEF
  --
  -- PURPOSE
  --   deletes an association def.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --     The name of the association to be deleted
  --   p_source_target_type : VARCHAR2
  --     The type of source target
  --   p_scope_target_type  : VARCHAR2
  --     The type of the target in whose context this association has to be deleted.
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition type was found.
  --

  PROCEDURE delete_target_assoc_def
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  );

  --
  -- PROCEDURE: CREATE_TARGET_ASSOC
  --
  -- PURPOSE
  --   Creates a new association
  -- IN Parameters:
  --   p_assoc_def_name  : VARCHAR2
  --       The name of the association def
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid. This is required only for
  --       non-global associations.
  --   p_is_editable : NUMBER
  --       The property that controls the association ownership
  --           where ASSOC_EDITABLE means end user can edit this association
  --                 ASSOC_NOT_EDITABLE means end-user can't edit this association
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_ALREADY_EXIST : for already existing association
  PROCEDURE create_target_assoc
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name    IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_scope_target_type    IN mgmt_targets.target_type%TYPE
                                DEFAULT GLOBAL_SCOPE_TARGET_TYPE,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT ASSOC_NOT_EDITABLE
  );
  --
  -- PROCEDURE: DELETE_TARGET_ASSOC
  --
  -- PURPOSE
  --   deletes an association
  -- IN Parameters:
  --   p_assoc_def_name  : VARCHAR2
  --       The name of the association def
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid. This is required only for
  --       non-global associations.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid. This is required only for
  --       non-global associations.
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE delete_target_assoc
  (
    p_assoc_def_name      IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name  IN mgmt_targets.target_name%TYPE,
    p_source_target_type  IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name   IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type   IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name   IN mgmt_targets.target_name%TYPE
                               DEFAULT ' ',
    p_scope_target_type   IN mgmt_targets.target_type%TYPE
                               DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  );

  --
  -- FUNCTION: generate_assoc_def_guid
  --
  -- PURPOSE:
  --   The association defs in the repository are identified by a globally unique
  --   identifier (guid). This function generates the guid for a given association def.
  --
  -- IN Parameters:
  --   p_source_target_type: The type of the source target
  --   p_assoc_name: The name of the assocition
  --
  -- OUT Parameters:
  --   The GUID for the given association def.
  --
  -- ERROR CODES:
  --
  --
  FUNCTION generate_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
  RETURN mgmt_target_assoc_defs.assoc_guid%TYPE;

  --
  -- FUNCTION: get_assoc_def_guid
  --
  -- PURPOSE:
  --   The association defs in the repository are identified by a globally unique
  --   identifier (guid). This function returns the guid for a given association def.
  --
  -- IN Parameters:
  --   p_source_target_type: The type of the source target
  --   p_assoc_name: The name of the assocition
  --
  -- OUT Parameters:
  --   The GUID for the given association def.
  --
  -- ERROR CODES:
  --   ASSOCIATION_DEF_DOES_NOT_EXIST: No such association def was found.
  --
  FUNCTION get_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT GLOBAL_SCOPE_TARGET_TYPE
  )
    RETURN mgmt_target_assoc_defs.assoc_guid%TYPE;
  --
  -- PROCEDURE: add_assoc_property_def
  --
  -- PURPOSE:
  --   Adds a property to the given association
  --   If the property already exists for this association, its throws
  --   an exception.
  --
  -- IN Parameters:
  --   p_source_target_type : The type of the source target
  --   p_assoc_name: The name of the assocition
  --   p_scope_target_type: The type of the scoped target
  --   p_property_name : name of property to be added
  --   is_required : is the property required for the association
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   ASSOCIATION_DEF_DOES_NOT_EXIST: No such association was found.
  --   PROPERTY_ALREADY_EXIST : Specified property already exist for the given association
 /* PROCEDURE add_assoc_property_def
  (
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_def_name     IN mgmt_target_assoc_defs.name%TYPE,
    p_scope_target_type  IN mgmt_targets.target_type%TYPE,
    p_property_name      IN mgmt_target_prop_defs.property_name%TYPE,
    is_required          IN NUMBER
  );
*/
  --
  -- PROCEDURE: delete_assoc_property_def
  --
  -- PURPOSE:
  --   deletes a property to the given association def
  --   If the property already exists for this association def, its throws
  --   an exception.
  --
  -- IN Parameters:
  --   p_source_target_type : VARCHAR2
  --      The type of the source target
  --   p_assoc_name: VARCHAR2
  --      The name of the assocition
  --   p_scope_target_type: VARCHAR2
  --      The type of the scoped target
  --   p_property_name : VARCHAR2
  --      The name of property to be added
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   ASSOCIATION_DOES_NOT_EXIST: No such association was found.
  --   PROPERTY_DOES_NOT_EXIST : Specified property already exist for the given association
  /*PROCEDURE delete_assoc_property_def
  (
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_def_name     IN mgmt_target_assoc_defs.name%TYPE,
    p_scope_target_type  IN mgmt_targets.target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs .property_name%TYPE
  );
*/
  --
  -- PROCEDURE: add_assoc_property
  --
  -- PURPOSE
  --   adds a property to an association. If the property already exists, it will update the value.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_property_name : VARCHAR2
  --       the name of the property
  --   p_property_value : VARCHAR2
  --       The value of the property
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.

  PROCEDURE add_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  );
  --
  -- PROCEDURE: modify_assoc_property
  --
  -- PURPOSE
  --   modifies a property of the association. If the property doen't exists, it will create it.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_property_name : VARCHAR2
  --       the name of the property
  --   p_property_value : VARCHAR2
  --       The value of the property
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE modify_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  );

  --
  -- PROCEDURE: delete_assoc_property 
  --
  -- PURPOSE
  --   modifies a property of the association. If the property doen't exists, it will create it.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2 
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2 
  --       The name of the source target
  --   p_source_target_type : VARCHAR2 
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2 
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2 
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2 
  --       The name of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_property_name : VARCHAR2 
  --       the name of the property 
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE delete_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE
  );
  -- Procedure ADD_ASSOC_DELETION_CALLBACK
  --
  -- PURPOSE: To add a callback that will bw called when an association is
  --   deleted.
  --   Note: All the exceptions raised by the callback are ignored by the repository
  --
  -- IN parameters:
  --   p_procedure_name: The name of the callback procedure. This must
  --      have the following signature:
  --      PROCEDURE PROC(p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2);
  --   p_assoc_def_name : Association def name for which this callback should be called (optional).
  --                      If assoc def name is not specified, then the callback is called
  --                      for associations of all types.
  --   p_source_target_type : Target type for which this callback should be called (optional).
  --                      If target type is not specified, then the callback is called
  --                      for targets of all types.
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE add_assoc_deletion_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  );

  -- Procedure ADD_ASSOC_ADDITION_CALLBACK
  --
  -- PURPOSE: To add a callback that will be called when a association is
  --   added to the repository.
  --   Note: All the exceptions raised by the callback are ignored by the repository
  -- IN parameters:
  --   p_procedure_name_in: The name of the callback procedure. This must
  --      have the following signature:
  --      PROCEDURE PROC(p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2);
  --   p_assoc_def_name : Association def name for which this callback should be called (optional).
  --                      If assoc def name is not specified, then the callback is called
  --                      for associations of all types.
  --   p_source_target_type : Target type for which this callback should be called (optional).
  --                      If target type is not specified, then the callback is called
  --                      for targets of all types.
  --
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE add_assoc_addition_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  );

  -- Procedure DEL_ASSOC_ADDITION_CALLBACK
  --
  -- PURPOSE: To remove a callback that will be called when an association is
  --   added to the repository.
  -- IN parameters:
  --   p_procedure_name: The name of the callback procedure.
  --   p_assoc_def_name : Assoc def name for which this callback should be removed (optional)
  --   p_target_type : Target type for which this callback should be removed (optional)
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE del_assoc_addition_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  );

  -- Procedure DEL_ASSOC_ADDITION_CALLBACK
  --
  -- PURPOSE: To remove a callback that will be called when an association is
  --   deleted from the repository.
  -- IN parameters:
  --   p_procedure_name: The name of the callback procedure.
  --   p_assoc_def_name : Assoc def name for which this callback should be removed (optional)
  --   p_target_type : Target type for which this callback should be removed (optional)
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE del_assoc_deletion_callback
  (
    p_procedure_name     IN VARCHAR2,
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE DEFAULT ' ',
    p_source_target_type IN mgmt_targets.target_type%TYPE    DEFAULT '*'
  );

  -- Creates a list of associations of the specified association type.
  -- This flavor does not support taking scope target as an argument. 
  -- Example: When a group is created or modified, this API will be used
  PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  --
  -- Creates a list of associations of the specified association type
  -- with in a given scope target.
  -- Example: When system association is created, this API will be used
  -- to instantiate all the scoped associations. 
  --
  PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  --
  -- Replaces the existing associations of type "p_assoc_def_name" with the
  -- the new list.  If the new list is null, should remove all the existing assocs. 
  -- This is again for the groups case.
  --
 PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  --
  -- Replaces the existing associations of type "p_assoc_def_name" with the
  -- the new list. If the new list is null, should remove all the existing assocs.
  --  This corresponds to systems case.
  --
  PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  -- 
  -- Deletes all the associations of the specified assoc type
  -- for the given source target. This also allow deleting
  -- assocs of all types, by taking NULL for assocdefname
  -- parameter  
  -- 
  PROCEDURE delete_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE
  );

  -- 
  -- Deletes all the associations with the specified scope target type.
  -- his also allow deleting assocs of all types, by taking NULL for assocdefname 
  -- parameter  
  PROCEDURE delete_assocs_in_scope
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name   IN mgmt_targets.target_name%TYPE,
    p_scope_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE
  );

END mgmt_assoc;
/
