Rem drv: <create type="pkgdefs" pos="audit/audit_admin_pkgdef.sql+"/>
Rem
Rem $Header: sdk_audit_log_pkgdef.sql 30-may-2007.11:19:33 pshishir Exp $
Rem
Rem audit_log_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      audit_log_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pshishir    05/30/07 - 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    shianand    03/02/05 - 
Rem    shianand    02/10/05 - 
Rem    shianand    02/03/05 - shianand_audit
Rem    shianand    12/17/04 - Created
Rem



CREATE OR REPLACE PACKAGE MGMT_AUDIT_LOG IS

audit_dir constant VARCHAR2(30) := 'AUDIT_DIR';

--OPERATION CODES CONSTANT
CHANGE_PASSWORD    constant NUMBER(2) :=1; 
CREATE_USER        constant NUMBER(2) :=2;
DELETE_USER        constant NUMBER(2) :=3; 
LOGON              constant NUMBER(2) :=4;
LOGOFF             constant NUMBER(2) :=5; 
GRANT_ROLE         constant NUMBER(2) :=6;
GRANT_TARGET_PRIV  constant NUMBER(2) :=7;
REVOKE_ROLE        constant NUMBER(2) :=8;
REVOKE_TARGET_PRIV constant NUMBER(2) :=9; 
SUBMIT_JOB         constant NUMBER(2) :=10;
EDIT_JOB           constant NUMBER(2) :=11;
DELETE_JOB         constant NUMBER(2) :=12; 
MODIFY_USER        constant NUMBER(2) :=14;
GRANT_SYSTEM_PRIV  constant NUMBER(2) :=15;
GRANT_JOB_PRIV     constant NUMBER(2) :=16;
REVOKE_SYSTEM_PRIV constant NUMBER(2) :=17;
REVOKE_JOB_PRIV    constant NUMBER(2) :=18;
REMOTE_OP          constant NUMBER(2) :=19;
GET_FILE           constant NUMBER(2) :=20;
PUT_FILE           constant NUMBER(2) :=21;
FILE_TRANSFER      constant NUMBER(2) :=22;
CREATE_ROLE        constant NUMBER(2) :=23;
DROP_ROLE          constant NUMBER(2) :=24;
MODIFY_ROLE        constant NUMBER(2) :=25;

--This procedure is called when ever a data is audited.
PROCEDURE audit_log (p_op_code              IN  NUMBER,
                     p_object_name          IN  VARCHAR2 DEFAULT NULL,
                     p_object_type          IN  VARCHAR2 DEFAULT NULL,
                     p_object_owner         IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value1  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value2  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value3  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value4  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value5  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value6  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value7  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value8  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value9  IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value10 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value11 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value12 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value13 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value14 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_column_value15 IN  VARCHAR2 DEFAULT NULL,
                     p_audit_clob_value1    IN  CLOB     DEFAULT NULL,
                     p_user_session_id_guid IN  RAW      DEFAULT NULL);


--This procedure is called when ever a data is audited.
PROCEDURE audit_log (p_op_code        IN  NUMBER,
                     p_audit_records  IN  AUDIT_ARRAY);



--Converts the step_status constant into character strings
--SCHEDULED_STATUS constant NUMBER(2) := 1;
--EXECUTING_STATUS constant NUMBER(2) := 2;
--ABORTED_STATUS constant NUMBER(2) := 3;
--FAILED_STATUS constant NUMBER(2) := 4;
--COMPLETED_STATUS constant NUMBER(2) := 5;
--SUSPENDED_STATUS constant NUMBER(2) := 6;
--AGENTDOWN_STATUS constant NUMBER(2) := 7;
--STOPPED_STATUS constant NUMBER(2) := 8;
PROCEDURE get_em_user_type (p_user_name  IN VARCHAR2,
                            p_user_type  OUT VARCHAR2);


--This updates the MGMT_AUDIT_LOGS Table which has the remote_op, get_file, put_file,
--file_transfer entry corresponding to the specified job step_id.
PROCEDURE update_job_step_info(p_output_id   IN RAW,
                               p_step_id     IN NUMBER,
                               p_step_status IN NUMBER);


--Gives the job_name and job_type and job_owner after querying the MGMT_JOB
--with specified job_id
PROCEDURE get_job_step_info (p_job_id    IN RAW,
                             p_job_name  OUT VARCHAR2,
                             p_job_type  OUT VARCHAR2,
                             p_job_owner OUT VARCHAR2);

END MGMT_AUDIT_LOG;

/
show errors;




