Rem
Rem $Header: sdk_blackouts_pkgdef.sql 27-dec-2007.01:42:41 smudumba Exp $
Rem
Rem sdk_blackouts_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_blackouts_pkgdef.sql - Blackouts SDK
Rem
Rem    DESCRIPTION
Rem      This is the publicly callable sdk component that deals
Rem      with creating, editing and deleting blackouts
Rem
Rem    NOTES
Rem
Rem    MODIFIED
Rem    smudumb 12/27/07 - Bug: 6430179 Blackout Reasons NLS
Rem    vkgarg  10/21/04 - moving reasons procs to mgmt_blackout_ui pkg 
Rem    mbhalla 10/05/04 - grabtrans 'vkgarg_botrans' 
Rem    mbhalla 10/05/04 - 
Rem    skini   12/14/03 - Expose TIMEZONE_RGN_SPECIFIED 
Rem    skini   12/03/02 - Introduce modificationFailed, and 
Rem                             partialModifyFailed states
Rem    skini   09/18/02 - blackout windows
Rem    skini   08/26/02 - Introduce START_PROCESSING
Rem    skini   08/26/02 - ENDED state
Rem    skini   08/20/02 - New blackout states
Rem    skini   08/13/02 - Continue development, finish edit
Rem    skini   08/02/02 - 
Rem    skini   07/26/02 - Change schedule table to refer to blackouts
Rem    skini   07/22/02 - 
Rem    skini   07/19/02 - Continue blackout implementation
Rem    skini   07/17/02 - Continue blackout development
Rem    skini   06/20/02 - skini_blackouts
Rem    skini   06/14/02 - Continue SDK implementation
Rem    skini   06/12/02 - MGMT_BLACKOUTS=>MGMT_BLACKOUT
Rem    skini   06/07/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_BLACKOUT AS

-- Constants for timezone values
TIMEZONE_REPOSITORY constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.TIMEZONE_REPOSITORY;
TIMEZONE_SPECIFIED constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.TIMEZONE_SPECIFIED;
TIMEZONE_RGN_SPECIFIED constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.TIMEZONE_RGN_SPECIFIED;

-- Constants for blackout states
BLK_STATE_START_PENDING constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_START_PENDING;
BLK_STATE_START_PROCESSING constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_START_PROCESSING;
BLK_STATE_START_PARTIAL constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_START_PARTIAL;
BLK_STATE_START_FAILED constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_START_FAILED;
BLK_STATE_STARTED constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_STARTED;
BLK_STATE_STOP_PENDING constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_STOP_PENDING;
BLK_STATE_STOP_FAILED constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_STOP_FAILED;
BLK_STATE_STOP_PARTIAL constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_STOP_PARTIAL;
BLK_STATE_EDIT_PARTIAL constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_EDIT_PARTIAL;
BLK_STATE_EDIT_FAILED constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_EDIT_FAILED;
BLK_STATE_STOPPED constant NUMBER(2) :=
      MGMT_BLACKOUT_ENGINE.BLK_STATE_STOPPED;
BLK_STATE_ENDED constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_ENDED;
BLK_STATE_END_PARTIAL constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_END_PARTIAL;
BLK_STATE_MODIFY_PENDING constant NUMBER(2) := 
      MGMT_BLACKOUT_ENGINE.BLK_STATE_MODIFY_PENDING;

-- Constants for frequency codes
ONE_TIME_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.ONE_TIME_FREQUENCY_CODE;
INTERVAL_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.INTERVAL_FREQUENCY_CODE;
DAILY_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.DAILY_FREQUENCY_CODE;
WEEK_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.WEEK_FREQUENCY_CODE;
MONTH_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.MONTH_FREQUENCY_CODE;
YEAR_FREQUENCY_CODE constant NUMBER(1) := MGMT_BLACKOUT_ENGINE.YEAR_FREQUENCY_CODE;

--Module Name to be used for log4plSql
MODULE_NAME CONSTANT VARCHAR2(15) := 'EM.Blackout.SDK';

--Constant for Blackout Reasons System Property
REASON_REQUIRED_PARAMETER_NAME CONSTANT VARCHAR2(25) := 'BLACKOUT_REASONS_REQUIRED';

--
-- CREATE_BLACKOUT
--     Create a new blackout
--  INPUT PARAMETERS
-- 
--  p_blackout_name The name of the blackout
--  p_description The blackout description
--  p_schedule The blackout schedule
--  p_reason The "reason" field for the blackout
--  p_job_flag Should we run jobs during blackout or not
--  p_targets The targets over which the blackout is to be applied
-- 
--  RETURNS The unique id for the blackout on success
--
--  EXCEPTIONS THROWN
--
--  TARGET_DOES_NOT_EXIST One or more targets in the list do not exist
--  INSUFFICIENT_PRIVILEGES The caller does not have sufficient 
--       privileges over one or more targets passed in
--  INVALID_SCHEDULE The schedule passed in is invalid
--  BLACKOUT_EXISTS Another blackout with the specified name already
--     exists
--  INVALID_REASON The blackout reason id is invalid
--
FUNCTION create_blackout(p_blackout_name IN VARCHAR2,
                         p_description IN VARCHAR2,
                         p_schedule IN MGMT_BLACKOUT_SCHEDULE_RECORD,
                         p_reason IN VARCHAR2,
                         p_job_flag IN NUMBER,
                         p_targets IN MGMT_BLACKOUT_TARGET_LIST) RETURN RAW;
                         


--
-- EDIT_BLACKOUT
--     Edit an existing blackout. In the description below, if any of
--     the parameters passed in is null, then the existing value is unchanged
--     Note that some attributes cannot be changed when a blackout is active,
--     for example, the target list, shortening the duration.
-- 
--  INPUT PARAMETERS
-- 
--  p_blackout_id The blackout id, from create_blackout()
--  p_description The blackout description
--  p_schedule The blackout schedule
--  p_reason The "reason" field for the blackout
--  p_job_flag Specified whether jobs must be run during the 
--      blackout or not
--  p_targets_add The targets over which the blackout is to be added
--  p_targets_remove The targets over which the blackout is to be removed
-- 
--  RETURNS The unique id for the blackout on success
--
--  EXCEPTIONS THROWN
--
--  BLACKOUT_DOES_NOT_EXIST The specified blackout does not exist
--  TARGET_DOES_NOT_EXIST One or more targets in the list do not exist
--  INSUFFICIENT_PRIVILEGES The caller does not have sufficient privileges over
--       one or more targets passed in, or currently in the blackout 
--       definition.
--       Or, the blackout was not created by this user
--  INVALID_SCHEDULE The schedule passed in is invalid
--  BLACKOUT_ACTIVE The blackout is currently in effect, and the specified
--    edits cannot be performed.
--  BLACKOUT_EDIT_PENDING The blackout has already been edited once, and the 
--    changes have not been propogated. 
--  INVALID_REASON The blackout reason id is invalid
--
PROCEDURE edit_blackout(p_blackout_id IN RAW,
                        p_description IN VARCHAR2,
                        p_schedule IN MGMT_BLACKOUT_SCHEDULE_RECORD,
                        p_reason IN VARCHAR2,
                        p_job_flag IN NUMBER,
                        p_targets_add IN MGMT_BLACKOUT_TARGET_LIST,
                        p_targets_remove IN MGMT_BLACKOUT_TARGET_LIST);

--
-- STOP_BLACKOUT
--     Stop an existing blackout. If the targets list is empty, the stop
--     is applied to all targets in the blackout
--  p_targets The targets for which the blackout is to be stopped
-- 
--  RETURNS The unique id for the blackout on success
--
--  EXCEPTIONS THROWN
--
--  TARGET_DOES_NOT_EXIST One or more targets in the list do not exist
--  INSUFFICIENT_PRIVILEGES The caller does not have sufficient privileges 
--       over one or more targets passed in, or currently in the 
--       blackout definition.
--
PROCEDURE stop_blackout(p_blackout_id IN RAW,
                        p_targets IN MGMT_BLACKOUT_TARGET_LIST);


--
-- DELETE_BLACKOUT
--    The DELETE_BLACKOUT procedure deletes an existing blackout. Note that
--    deletion may not be a synchronous operation. The application must
--    check the state of the blackout in the blackout table to ensure that
--    it was deleted
--  
-- INPUT PARAMETERS
--  p_blackout_id The blackout id, from create_blackout()
--  
-- EXCEPTIONS
-- BLACKOUT_DOES_NOT_EXIST The specified blackout does not exist
-- INSUFFICIENT_PRIVILEGES The caller does not have sufficient privileges over
--       one or more targets in the blackout
--       Or, the blackout was not created by this user
--
PROCEDURE delete_blackout(p_blackout_id IN RAW);


--
-- ADD_REASON
--    The ADD_REASON procedure adds a new blackout reason
--  
-- INPUT PARAMETERS
--  p_reason The reason
--  p_reason_nlsid   The reason nls id
--  
-- RETURNS
--   The reason-id for the newly added reason
--
FUNCTION add_reason(p_reason VARCHAR2,
                    p_reason_nlsid VARCHAR2 DEFAULT NULL) RETURN NUMBER;


--
-- PROCEDURE: get_reason_required
--
-- PURPOSE:
--  Fetches the BLACKOUT_REASONS_REQUIRED property from the
--  MGMT_PARAMETERS table.
--
-- Returns:
--  VARCHAR2 A string representing the
--  BLACKOUT_REASONS_REQUIRED property.
--
FUNCTION get_reason_required RETURN VARCHAR2;


END MGMT_BLACKOUT;
/
