Rem
Rem $Header: sdk_ca_pkgdef.sql 21-nov-2004.09:32:17 skini Exp $
Rem
Rem sdk_ca_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_ca_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem     This is the PL/SQL SDK interface to the corrective action
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  (MM/DD/YY)
Rem    skini      11/21/04 - Moce CA scope constants to job engine 
Rem    pshishir   09/23/04 - 
Rem    pshishir   09/15/04 - pshishir_ca_trans
Rem    pshishir   06/12/04 - created


CREATE OR REPLACE PACKAGE MGMT_CA
AS
-- Constants for CORRECTICE ACTION SCOPE 
CA_SCOPE_TARGET constant NUMBER(1) := MGMT_JOB_ENGINE.CA_SCOPE_TARGET;
CA_SCOPE_TEMPLATE constant NUMBER(1) := MGMT_JOB_ENGINE.CA_SCOPE_TEMPLATE;
CA_SCOPE_TARGET_TYPE constant NUMBER(1) := MGMT_JOB_ENGINE.CA_SCOPE_TARGET_TYPE;
CA_SCOPE_USER constant NUMBER(1) := MGMT_JOB_ENGINE.CA_SCOPE_USER;
CA_SCOPE_TEMPLATE_COPY constant NUMBER(1) := MGMT_JOB_ENGINE.CA_SCOPE_TEMPLATE_COPY;


-- Insert a Corrective action with the specified name, type, description,
-- targets and owner. This call returns the job id that is created from these attributes,
-- via the out parameters. Each Corrective action has a unique values in 
-- corrective_action_target_guid(Which is a combination of target_name and target_type)
-- and MGMT_JOB.job_name.

PROCEDURE create_target_ca(p_ca_name IN VARCHAR2, 
			   p_target IN VARCHAR2, 
			   p_target_type VARCHAR2, 
			   p_description IN VARCHAR2, 
			   p_job_type IN VARCHAR2, 
			   p_job_params IN MGMT_JOB_PARAM_LIST, 
			   p_owner VARCHAR2, 
			   p_job_creds MGMT_JOB_CRED_ARRAY, 
			   p_job_id_out OUT RAW); 

-- Create a corrective action as a template. It should not have any schedule.
-- It takes the Corrective action name, template name, target type, description,
-- owner and job credentials and it returns job id via output parameter.Each 
-- Corrective action has a unique values in corrective_action_template_guid
-- (Which is a combination of template_name and target_type)
-- and MGMT_JOB.job_name.

PROCEDURE create_template_ca(p_ca_name IN VARCHAR2, 
			     p_template IN VARCHAR2, 
			     p_target_type VARCHAR2, 
			     p_description IN VARCHAR2, 
			     p_job_type IN VARCHAR2, 
			     p_job_params IN MGMT_JOB_PARAM_LIST, 
			     p_owner VARCHAR2, 
			     p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL, 
			     p_job_id_out OUT RAW); 

-- Create corrective action for a particular target type. It takes inputs as corrective action name, 
-- target type, description, job type, job parameters, and job credentials and it returns job id via
-- output parameter. Each Corrective Action has a unique pair of values in MGMT_JOB.target_type and 
-- MGMT_JOB.job_name

PROCEDURE create_policy_rule_default_ca(p_ca_name IN VARCHAR2, 
			                p_target_type VARCHAR2, 
					p_description IN VARCHAR2, 
					p_job_type IN VARCHAR2, 
					p_job_params IN MGMT_JOB_PARAM_LIST, 
					p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL, 
					p_job_id_out OUT RAW);

-- Create user defined Corrective action. It takes inputs as corrective action name, 
-- owner's name, target_type, description, job_type, job parameters and job credentials 
-- and return job id via output parameter. Each Corrective action has a unique pair of values
-- in MGMT_JOB.job_owner and MGMT_JOB.job_name
 
PROCEDURE create_user_ca(p_ca_name IN VARCHAR2, 
			 p_owner IN VARCHAR2, 
			 p_target_type VARCHAR2, 
			 p_description IN VARCHAR2, 
			 p_job_type IN VARCHAR2, 
			 p_job_params IN MGMT_JOB_PARAM_LIST, 
			 p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL, 
			 p_job_id_out OUT RAW);

-- Edit the specified Corrective action, using the specified name,
-- target, target_type, description, parameters and credentials.

PROCEDURE edit_target_ca(p_ca_name VARCHAR2, 
			 p_target VARCHAR2, 
			 p_target_type VARCHAR2, 
			 p_description VARCHAR2, 
			 p_params MGMT_JOB_PARAM_LIST, 
			 p_job_creds MGMT_JOB_CRED_ARRAY);

-- Edit the specified Corrective action for a template, using the specified name,
-- template name, target_type, description, parameters and credentials.

 PROCEDURE edit_template_ca(p_ca_name VARCHAR2, 
			    p_template VARCHAR2, 
			    p_target_type VARCHAR2, 
			    p_description VARCHAR2, 
			    p_params MGMT_JOB_PARAM_LIST, 
			    p_job_creds MGMT_JOB_CRED_ARRAY); 

-- Edit the specified Corrective action for a target type, using the specified name,
-- target type, description, parameters and credentials.

PROCEDURE edit_policy_rule_default_ca(p_ca_name VARCHAR2, 
				      p_target_type VARCHAR2, 
				      p_description VARCHAR2, 
				      p_params MGMT_JOB_PARAM_LIST, 
				      p_job_creds MGMT_JOB_CRED_ARRAY); 
  
-- Edit the specified user craeted Corrective action, using the specified name,
-- owner, description, parameters and credentials.

PROCEDURE edit_user_ca(p_ca_name VARCHAR2, 
        	       p_owner VARCHAR2, 
		       p_description VARCHAR2, 
		       p_params MGMT_JOB_PARAM_LIST, 
		       p_job_creds MGMT_JOB_CRED_ARRAY); 

-- Delete the specified Corrective action for a target, using the specified name,
-- target name and target_type.

PROCEDURE delete_target_ca(p_ca_name VARCHAR2, 
		           p_target VARCHAR2, 
			   p_target_type VARCHAR2, 
			   p_commit NUMBER DEFAULT 0); 

-- Delete the specified Corrective action for a template, using the specified name,
-- template name and target_type.

PROCEDURE delete_template_ca(p_ca_name VARCHAR2, 
			     p_template VARCHAR2, 
			     p_target_type VARCHAR2, 
			     p_commit NUMBER DEFAULT 0); 

-- Delete the specified Corrective action for a target type, using the specified name,
-- and target_type.

PROCEDURE delete_target_type_ca(p_ca_name VARCHAR2, 
			        p_target_type VARCHAR2, 
				p_commit NUMBER DEFAULT 0); 

-- Delete the specified user created Corrective action , using the specified name,
-- and owner name.

PROCEDURE delete_user_ca(p_ca_name VARCHAR2, 
			 p_owner VARCHAR2, 
			 p_commit NUMBER DEFAULT 0); 

-- While executing, the following procedure takes
-- execution_id and stop the execution of the corrective action.
 
PROCEDURE stop_ca_execution(p_execution_id IN RAW); 

-- The following function takes execution_id and restart the execution 
-- of the corrective action and return new execution id.

FUNCTION restart_ca_execution(p_exec_id IN RAW) RETURN RAW;

-- Get target scoped job id

FUNCTION get_target_scoped_job_id( p_ca_name VARCHAR2,
                                   p_target VARCHAR2,
                                   p_target_type VARCHAR2) RETURN RAW;

-- Get job id for template scoped corrective action

FUNCTION get_template_scoped_job_id( p_ca_name VARCHAR2,
                                     p_template VARCHAR2,
                                     p_target_type VARCHAR2) RETURN RAW; 
 
END MGMT_CA;
/

show errors;

