Rem
Rem $Header: sdk_cimviews.sql 30-dec-2004.19:22:43 gbhat Exp $
Rem
Rem sdk_cimviews.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_cimviews.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gbhat       12/30/04 - Comment out all the views. 
Rem    jsadras     09/21/04 - eval_func replaced 
Rem    rpinnama    06/12/04 - Remove SET ECHO 
Rem    gbhat       06/03/04 - Addition of Association views. Changes to 
Rem                           Oracle_TypeFlavor. 
Rem    gbhat       05/27/04 - gbhat_newcimviews
Rem    gbhat       05/27/04 - Corrections to comment column names in 
Rem                           Oracle_Metric1Day etc 
Rem    gbhat       05/17/04 - Added COMMENT ON statements to views and 
Rem                           columns 
Rem    gbhat       05/10/04 - Created
Rem
Rem


Rem
Rem View definition for Oracle_ManagedTarget
Rem

-- CREATE OR REPLACE VIEW Oracle_ManagedTarget
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name
--      FROM
--         MGMT_TARGETS t
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_ManagedTarget IS 
-- 'Oracle_ManagedTarget contains information about the managed targets that are
-- known to the central management repository.  A target represents a separately
-- manageable entity within the enterprise.  For example, a database or an
-- application server would have individual entries.  Some managed targets, such
-- as an application server, are composed of several interdependent manageable
-- parts.  Each separately manageable component of the application server will
-- also have entries in Oracle_ManagedTarget.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_ManagedTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- Rem
-- Rem View definition for Oracle_Metric
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_Metric
--      (TargetGUID, MetricGUID, KeyValue, CollectionTimestamp,
--       MetricValue, StringValue)
--    AS
--      SELECT
--          m.target_guid, m.metric_guid,
--          m.key_value, m.collection_timestamp, m.value, m.string_value
--        FROM
--            MGMT_METRICS_RAW m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_Metric IS 
-- 'Oracle_Metric contains the individual metric data samples that were collected
-- for the managed target.  This is where the most detailed metric information
-- that is known to the central repository is stored.  Metrics in Oracle_Metric
-- include the most recent sample collected, along with older samples that have
-- not been aggregated.  If only the most recent metric is needed,
-- Oracle_MetricCurrent should be used.  Oracle_Metric is aggregated at regular
-- intervals.  The aggregation process combines individual samples for a metric
-- into hourly averages.  The individual samples that have been aggregated are
-- purged from Oracle_Metric.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_Metric.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- collected for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_Metric.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_Metric.MetricValue IS 
-- 'The value of the metric if the metric is numeric.  Metrics that are strings are
-- stored in StringValue.';
-- 
-- COMMENT ON COLUMN Oracle_Metric.StringValue IS 
-- 'The value of the metric if the metric is a string.  Metrics that are numeric
-- are stored in MetricValue.';
-- 
-- COMMENT ON COLUMN Oracle_Metric.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- Rem
-- Rem View definition for Oracle_Metric1Day
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_Metric1Day
--      (TargetGUID, MetricGUID, KeyValue, RollupTimestamp, SampleCount,
--       AverageValue, MinimumValue, MaximumValue, StdDevValue)
--    AS
--      SELECT
--          m.target_guid, m.metric_guid,
--          m.key_value, m.rollup_timestamp, m.sample_count,
--          m.value_average,
--          m.value_minimum, m.value_maximum, m.value_sdev
--        FROM
--            MGMT_METRICS_1DAY m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_Metric1Day IS 
-- 'Oracle_Metric1Day contains the daily metric rollup information that is an
-- aggregation of the hourly metric statistics.  Rollup metrics are aggregations
-- of individual metric samples for a managed target for a specified rollup
-- interval.  Over time, the central repository metric rollup mechanism aggregates
-- individual metric samples into fewer, less granular statistics.  For example,
-- individual metric samples might aggregate into hourly rollups, then the hourly
-- rollups might aggregate into daily rollups.  Metric rollup avoids maintenance
-- issues with the long term storage of metric data.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.AverageValue IS 
-- 'The average value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same RollupTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.MaximumValue IS 
-- 'The maximum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.MinimumValue IS 
-- 'The minimum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.RollupTimestamp IS 
-- 'The date/time that identifies the start of the rollup period.  For example, if
-- the rollup is daily, the RollupTimestamps will be on daily boundaries starting
-- at 12 A.M.  Metric samples included in the rollup period are greater than or
-- equal to the RollupTimestamp, using the timezone of the agent where the metric
-- was collected.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.SampleCount IS 
-- 'The number of metric samples that were aggregated for the metric during the day
-- starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.StdDevValue IS 
-- 'The standard deviation of the metric samples that were aggregated for the
-- metric during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Day.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- Rem
-- Rem View definition for Oracle_Metric1Hour
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_Metric1Hour
--      (TargetGUID, MetricGUID, KeyValue, RollupTimestamp, SampleCount,
--       AverageValue, MinimumValue, MaximumValue, StdDevValue)
--    AS
--      SELECT
--          m.target_guid, m.metric_guid,
--          m.key_value, m.rollup_timestamp, m.sample_count,
--          m.value_average,
--          m.value_minimum, m.value_maximum, m.value_sdev
--        FROM
--            MGMT_METRICS_1HOUR m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_Metric1Hour IS 
-- 'Oracle_Metric1Hour contains the hourly metric rollup information that is an
-- aggregation of the individual metric samples from Oracle_Metric.  Rollup
-- metrics are aggregations of individual metric samples for a managed target for
-- a specified rollup interval.  Over time, the central repository metric rollup
-- mechanism aggregates individual metric samples into fewer, less granular
-- statistics.  For example, individual metric samples might aggregate into hourly
-- rollups, then the hourly rollups might aggregate into daily rollups.  Metric
-- rollup avoids maintenance issues with the long term storage of metric data.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.AverageValue IS 
-- 'The average value of the metric samples that were aggregated for the metric
-- during the hour starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same RollupTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.MaximumValue IS 
-- 'The maximum value of the metric samples that were aggregated for the metric
-- during the hour starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.MinimumValue IS 
-- 'The minimum value of the metric samples that were aggregated for the metric
-- during the hour starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.RollupTimestamp IS 
-- 'The date/time that identifies the start of the rollup period.  For example, if
-- the rollup is hourly, the RollupTimestamps will be on hourly boundaries based
-- on the 24 hour clock.  Metric samples included in the rollup period are greater
-- than or equal to the RollupTimestamp, using the timezone of the agent where the
-- metric was collected.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.SampleCount IS 
-- 'The number of metric samples that were aggregated for the metric during the
-- hour starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.StdDevValue IS 
-- 'The standard deviation of the metric samples that were aggregated for the
-- metric during the hour starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_Metric1Hour.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricCompositeKey
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricCompositeKey
--      (KeyGUID, TargetGUID, Key1, Key2, Key3, Key4, Key5)
--    AS
--      SELECT
--          m.composite_key, m.target_guid,
--          m.key_part1_value, m.key_part2_value, m.key_part3_value,
--          m.key_part4_value, m.key_part5_value
--        FROM
--            MGMT_METRICS_COMPOSITE_KEYS m, MGMT_TARGETS t
--      WHERE m.target_guid = t.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricCompositeKey IS 
-- 'Oracle_MetricCompositeKey contains the composite keys that have been collected
-- for a managed target.  Composite keys define up to five additional columns in a
-- table metric that can be used to constrain the set of information that is
-- returned to a client application.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.Key1 IS 
-- 'The first of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.Key2 IS 
-- 'The second of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.Key3 IS 
-- 'The third of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.Key4 IS 
-- 'The fourth of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.Key5 IS 
-- 'The fifth of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.KeyGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies a
-- metric composite key.  The key GUID MUST be constructed from an MD5 digest of
-- the string concatenation of Key1 + Key2 + Key3 + Key4 + Key5.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCompositeKey.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target that the composite key is associated with.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricCurrent
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricCurrent
--      (TargetGUID, MetricGUID, KeyValue, CollectionTimestamp,
--       MetricValue, StringValue)
--    AS
--      SELECT
--          m.target_guid, m.metric_guid,
--          m.key_value, m.collection_timestamp, m.value, m.string_value
--        FROM
--            MGMT_CURRENT_METRICS m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricCurrent IS 
-- 'Oracle_MetricCurrent contains the most recent metric data sample that has been
-- collected for the managed target and loaded into the central repository.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- collected for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.MetricValue IS 
-- 'The value of the metric if the metric is numeric.  Metrics that are strings are
-- stored in StringValue.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.StringValue IS 
-- 'The value of the metric if the metric is a string.  Metrics that are numeric
-- are stored in MetricValue.';
-- 
-- COMMENT ON COLUMN Oracle_MetricCurrent.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricDefinition
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricDefinition
--      (TargetType, TypeVersion, MetricName, MetricColumn,
--       MetricCategory1, MetricCategory2, MetricCategory3,
--       MetricCategory4, MetricCategory5, MetricGUID, ColumnLabel,
--       KeyColumn, KeyOrder, NumberOfKeys, ShortCaption, Caption,
--       Description, MetricType, EvaluationProcedureName, CreationTime,
--       Units, SummaryMetric, IsDynamic, AgentCleared)
--    AS
--      SELECT
--        m.target_type, m.type_meta_ver, m.metric_name,
--        m.metric_column, m.category_prop_1, m.category_prop_2,
--        m.category_prop_3, m.category_prop_4, m.category_prop_5,
--        m.metric_guid, m.column_label, m.key_column,
--        m.key_order, m.num_keys, m.short_name, m.metric_label,
--        m.description,
--        DECODE (m.metric_type,
--                0, 'Number', 1, 'String', 2, 'Table',
--                3, 'Raw', 4, 'External', 5, 'RepositoryTable',
--                6, 'RepositoryNumber', 7, 'RepositoryString'),
--        m.source, m.load_timestamp, m.unit,
--        DECODE (m.is_for_summary, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m.keys_from_mult_colls, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m.statefull, 0, 'FALSE', 1, 'TRUE')
--      FROM
--         MGMT_METRICS m
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricDefinition IS 
-- 'Oracle_MetricDefinition identifies the metrics that have been defined for a
-- target type.  Metric definitions are available in the central repository for
-- the managed targets that have been discovered by an Oracle agent once the
-- target metadata has been loaded into the repository.  Metrics are defined as
-- either simple or table metrics.  Simple metrics are single valued measurements
-- for the managed target.  For example, the number of active processes on a host.
--  Table metrics are a collection of simple metrics that are are identified
-- through a key value.  The key value groups the metrics that are defined by the
-- table metric definition to each other.  The metric selected as the key value
-- provides the context for associating the remaining metrics.  For example, the
-- disk information that is collected for a host with multiple file systems is
-- defined as a table metric.  The key value in this example is the file system
-- name, since it establishes the context for disk information metrics, such as
-- space used and utilization, which are defined as part of the table metric
-- definition.  Metric definitions are versioned so that a target type can contain
-- managed target version specific variations.  Hosts, databases, or application
-- servers may collect different metrics depending on the product version. 
-- Another way to change a metric definition is through metric categories.  Metric
-- categories restrict the applicability of a metric to specific configurations. 
-- If a metric category is not specified, the metric is applicable to all
-- configurations.  For example, certain metrics may only be applicable for a RAC
-- configuration.  RAC specific metrics that are part of the database metric
-- definition would be identified using metric categories.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.AgentCleared IS 
-- 'This flag indicates whether alerts generated for this metric are cleared by the
-- Oracle agent.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.Caption IS 
-- 'A descriptive label for the metric.  The caption contains a name that can be
-- used in a client application to display the metric name in an understandable
-- way.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.ColumnLabel IS 
-- 'For table metrics, the ColumnLabel provides a short descriptive name for the
-- column in the table.  The ColumnLabel defines a name that can be used in a
-- client application to display the information represented by this column in the
-- context of the table metric in an understandable way.  The ColumnLabel is null
-- if the definition is for a simple metric or if the ColumnLable was not defined.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.CreationTime IS 
-- 'The date/time in the timezone of the central repository when the metric was
-- first loaded into the repository.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.Description IS 
-- 'The Description contains more detailed information about the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.EvaluationProcedureName IS 
-- 'The name of the PL/SQL procedure that will be executed for repository metrics. 
-- The PL/SQL procedure provides the value for the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.IsDynamic IS 
-- 'This flag indicates whether the metric is dynamic.  A value of TRUE means that
-- the metric is dynamic.  Dynamic metrics are defined at runtime instead of when
-- the managed target is discovered.  Dynamic metrics use the key of the metric as
-- the metric name.  Only table metrics can be dynamic.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.KeyColumn IS 
-- 'The KeyColumn identifies the name of the column in a table metric that contains
-- the key value for the metric.  This is the column that includes the value that
-- establishes the context for the remaining columns that are defined by the table
-- metric and identifies a row in the table.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.KeyOrder IS 
-- 'The KeyOrder provides an ordering for the KeyColumns in a table metric.  It
-- defaults to 0, which indicates that the column is not part of the key.  Table
-- metric definitions support up to three key columns.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricCategory1 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricCategory2 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricCategory3 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricCategory4 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricCategory5 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricColumn IS 
-- 'For table metrics, MetricColumn contains a name for the column in the table
-- that is represented by this metric.  The MetricColumn uniquely identifies an
-- individual metric that is defined within a table metric definition.  For
-- example, if a DiskInformation table metric is defined, one metric that is part
-- of the definition might represent disk utilization.  The MetricColumn for disk
-- utilization in this example might be DiskUtilization.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricName IS 
-- 'The name of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.MetricType IS 
-- 'The MetricType identifies the data type of the information that the metric
-- represents.  The MetricType is used during the rollup process to determine
-- whether the metric can be aggregated.  The MetricType is also used by client
-- applications to determine the best way to display the contents of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.NumberOfKeys IS 
-- 'The number of key columns that have been defined for the table metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.ShortCaption IS 
-- 'The ShortCaption provides a condensed version of the display name that is
-- provided by the Caption.  It is used in UIs where displaying the full caption
-- is not possible.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.SummaryMetric IS 
-- 'This flag indicates whether the metric should be displayed on a summary page
-- within the user interface.  A value of TRUE means that the metric should be
-- displayed.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.TargetType IS 
-- 'The name of the target type.  The target type determines the set of metrics
-- that are defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- COMMENT ON COLUMN Oracle_MetricDefinition.Units IS 
-- 'The unit by which the metric has been measured.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricStringHistory
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricStringHistory
--      (TargetGUID, MetricGUID, KeyValue, CollectionTimestamp,
--       StringValue)
--    AS
--      SELECT
--          m.target_guid, m.metric_guid,
--          m.key_value, m.collection_timestamp, m.string_value
--        FROM
--            MGMT_STRING_METRIC_HISTORY m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricStringHistory IS 
-- 'Oracle_MetricStringHistory contains a history of string metric values over
-- time.  For example, a string metric that collects relevant information from a
-- database alert log would be stored in Oracle_MetricStringHistory once it has
-- been purged from Oracle_Metric.  Multiple occurences in sequence of the same
-- string metric for a managed target are not saved in Oracle_MetricStringHistory
-- in order to minimize the space consumed in the central repository.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricStringHistory.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when the string was
-- collected at the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricStringHistory.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_MetricStringHistory.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricStringHistory.StringValue IS 
-- 'The value of the string metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricStringHistory.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the string metric.';
-- 
-- Rem
-- Rem View definition for Oracle_TargetProperty
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_TargetProperty
--      (TargetGUID, PropertyName, PropertyType, PropertyValue,
--       Caption)
--    AS
--      SELECT
--        p.target_guid, p.property_name, p.property_type,
--        p.property_value, p.property_name
--      FROM
--         MGMT_TARGET_PROPERTIES p, MGMT_TARGETS t
--        WHERE p.target_guid = t.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_TargetProperty IS 
-- 'Oracle_TargetProperty contains information about any target specific properties
-- that have been defined for a managed target.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_TargetProperty.Caption IS 
-- 'A short descriptive name for the property.  The caption contains a name that
-- can be used in a client application to display the property name in an
-- understandable way.';
-- 
-- COMMENT ON COLUMN Oracle_TargetProperty.PropertyName IS 
-- 'The name of the target property.';
-- 
-- COMMENT ON COLUMN Oracle_TargetProperty.PropertyType IS 
-- 'The type of the target property.  If the type is not specified, it defaults to
-- INSTANCE.';
-- 
-- COMMENT ON COLUMN Oracle_TargetProperty.PropertyValue IS 
-- 'The value of the target property, represented as a string.';
-- 
-- COMMENT ON COLUMN Oracle_TargetProperty.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies a
-- particular Managed Target.';
-- 
-- Rem
-- Rem View definition for Oracle_TargetType
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_TargetType
--      (TargetType, TypeVersion, Caption)
--    AS
--      SELECT
--          DISTINCT tt.target_type, t.type_meta_ver,
--                     tt.type_display_name
--        FROM
--            MGMT_TARGET_TYPES  tt, MGMT_TARGETS t
--        WHERE tt.target_type = t.target_type
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_TargetType IS 
-- 'The Oracle_TargetType identifies the valid types for a Managed Target.  The
-- target type defines the metrics that will be collected for the Managed Target. 
-- Oracle_TargetType also provides details about the versions for a type that are
-- known to the central repository.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_TargetType.Caption IS 
-- 'A short descriptive name for the Target Type.  The caption defines a name that
-- can be used in a client application to display the target type in an
-- understandable way.  The caption defaults to the name of the target type.';
-- 
-- COMMENT ON COLUMN Oracle_TargetType.TargetType IS 
-- 'The name of the target type.  The target type determines the set of metrics
-- that are defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TargetType.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- Rem
-- Rem View definition for Oracle_TypeFlavor
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_TypeFlavor
--  (TargetType, TypeVersion, TypeCategory1, TypeCategory2, TypeCategory3, 
--   TypeCategory4, TypeCategory5)
--  AS
--  SELECT
--         DISTINCT  m.target_type, m.type_meta_ver, m.category_prop_1, 
-- 		          m.category_prop_2, m.category_prop_3, m.category_prop_4, 
-- 				  m.category_prop_5
--        FROM
--            MGMT_METRICS  m
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_TypeFlavor IS 
-- 'The Oracle_TypeFlavor identifies the valid type categories for a Managed
-- Target. A type category implies the existence of certain metrics. This is
-- captured in associations between Oracle_TypeFlavor and Oracle_ManagedTarget and
-- Oracle_MetricDefinition.';
-- 
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeCategory1 IS 
-- 'Type Category 1.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeCategory2 IS 
-- 'Type Category 2.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeCategory3 IS 
-- 'Type Category 3.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeCategory4 IS 
-- 'Type Category 4.';
-- 
-- COMMENT ON COLUMN Oracle_TypeFlavor.TypeCategory5 IS 
-- 'Type Category 5.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricsForTypeFlavor
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricsForTypeFlavor
--  (TargetType, TypeVersion, MetricName, MetricGuid, MetricColumn,
--       TypeCategory1, TypeCategory2,
--       TypeCategory3, TypeCategory4, TypeCategory5,
--       ColumnLabel, KeyColumn, KeyOrder, NumberOfKeys,
--       ShortCaption, Caption, Description, MetricType,
--       EvaluationProcedureName, CreationTime, Units, SummaryMetric,
--       IsDynamic, AgentCleared)
--  AS
--  SELECT
--         DISTINCT m1.target_type, m1.type_meta_ver, m1.metric_name,
--         m1.metric_guid, m1.metric_column,  m1.category_prop_1,
--         m1.category_prop_2, m1.category_prop_3, m1.category_prop_4,
--         m1.category_prop_5,
--        m2.column_label, m2.key_column,
--        m2.key_order, m2.num_keys, m2.short_name, m2.metric_label,
--        m2.description,
--        DECODE (m2.metric_type,
--                0, 'Number', 1, 'String', 2, 'Table',
--                3, 'Raw', 4, 'External', 5, 'RepositoryTable',
--                6, 'RepositoryNumber', 7, 'RepositoryString'),
--        m2.source, m2.load_timestamp, m2.unit,
--        DECODE (m2.is_for_summary, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m2.keys_from_mult_colls, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m2.statefull, 0, 'FALSE', 1, 'TRUE')
--      FROM
--         MGMT_METRICS m1, MGMT_METRICS m2
--        WHERE m1.metric_guid = m2.metric_guid
--     AND m1.type_meta_ver = m2.type_meta_ver
--          AND (m1.category_prop_1 = m2.category_prop_1
--                         OR  m1.category_prop_1 = ' ')
--          AND (m1.category_prop_2 = m2.category_prop_2
--                         OR  m1.category_prop_2 = ' ')
--          AND (m1.category_prop_3 = m2.category_prop_3
--                         OR  m1.category_prop_3 = ' ')
--          AND (m1.category_prop_4 = m2.category_prop_4
--                         OR  m1.category_prop_4 = ' ')
--          AND (m1.category_prop_5 = m2.category_prop_5
--                         OR  m1.category_prop_5 = ' ')
--    WITH READ ONLY;
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeCategory1 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeCategory2 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeCategory3 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeCategory4 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.TypeCategory5 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.AgentCleared IS 
-- 'This flag indicates whether alerts generated for this metric are cleared by the
-- Oracle agent.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.Caption IS 
-- 'A descriptive label for the metric.  The caption contains a name that can be
-- used in a client application to display the metric name in an understandable
-- way.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.ColumnLabel IS 
-- 'For table metrics, the ColumnLabel provides a short descriptive name for the
-- column in the table.  The ColumnLabel defines a name that can be used in a
-- client application to display the information represented by this column in the
-- context of the table metric in an understandable way.  The ColumnLabel is null
-- if the definition is for a simple metric or if the ColumnLable was not defined.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.CreationTime IS 
-- 'The date/time in the timezone of the central repository when the metric was
-- first loaded into the repository.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.Description IS 
-- 'The Description contains more detailed information about the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.EvaluationProcedureName IS 
-- 'The name of the PL/SQL procedure that will be executed for repository metrics. 
-- The PL/SQL procedure provides the value for the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.IsDynamic IS 
-- 'This flag indicates whether the metric is dynamic.  A value of TRUE means that
-- the metric is dynamic.  Dynamic metrics are defined at runtime instead of when
-- the managed target is discovered.  Dynamic metrics use the key of the metric as
-- the metric name.  Only table metrics can be dynamic.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.KeyColumn IS 
-- 'The KeyColumn identifies the name of the column in a table metric that contains
-- the key value for the metric.  This is the column that includes the value that
-- establishes the context for the remaining columns that are defined by the table
-- metric and identifies a row in the table.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.KeyOrder IS 
-- 'The KeyOrder provides an ordering for the KeyColumns in a table metric.  It
-- defaults to 0, which indicates that the column is not part of the key.  Table
-- metric definitions support up to three key columns.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.MetricColumn IS 
-- 'For table metrics, MetricColumn contains a name for the column in the table
-- that is represented by this metric.  The MetricColumn uniquely identifies an
-- individual metric that is defined within a table metric definition.  For
-- example, if a DiskInformation table metric is defined, one metric that is part
-- of the definition might represent disk utilization.  The MetricColumn for disk
-- utilization in this example might be DiskUtilization.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.MetricName IS 
-- 'The name of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.MetricType IS 
-- 'The MetricType identifies the data type of the information that the metric
-- represents.  The MetricType is used during the rollup process to determine
-- whether the metric can be aggregated.  The MetricType is also used by client
-- applications to determine the best way to display the contents of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.NumberOfKeys IS 
-- 'The number of key columns that have been defined for the table metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.ShortCaption IS 
-- 'The ShortCaption provides a condensed version of the display name that is
-- provided by the Caption.  It is used in UIs where displaying the full caption
-- is not possible.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.SummaryMetric IS 
-- 'This flag indicates whether the metric should be displayed on a summary page
-- within the user interface.  A value of TRUE means that the metric should be
-- displayed.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsForTypeFlavor.Units IS 
-- 'The unit by which the metric has been measured.';
-- 
-- Rem
-- Rem View definition for Oracle_CurrentMetricForTarget
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_CurrentMetricForTarget
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     MetricGUID, KeyValue, CollectionTimestamp,
--     MetricValue, StringValue)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, m.metric_guid,
--          m.key_value, m.collection_timestamp, m.value, m.string_value
--        FROM
--            MGMT_CURRENT_METRICS m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_CurrentMetricForTarget IS 
-- 'Oracle_CurrentMetricForTarget associates the most recent metric sample that was
-- collected for the managed target and loaded into the central repository with
-- its managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- collected for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.MetricValue IS 
-- 'The value of the metric if the metric is numeric.  Metrics that are strings are
-- stored in StringValue.';
-- 
-- COMMENT ON COLUMN Oracle_CurrentMetricForTarget.StringValue IS 
-- 'The value of the metric if the metric is a string.  Metrics that are numeric
-- are stored in MetricValue.';
-- 
-- Rem
-- Rem View definition for Oracle_DailyMetricRollup
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_DailyMetricRollup
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     MetricGUID, KeyValue, RollupTimestamp, SampleCount,
--     AverageValue, MinimumValue, MaximumValue, StdDevValue)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, m.metric_guid,
--          m.key_value, m.rollup_timestamp, m.sample_count,
--          m.value_average,
--          m.value_minimum, m.value_maximum, m.value_sdev
--        FROM
--            MGMT_METRICS_1DAY m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_DailyMetricRollup IS 
-- 'Oracle_DailyMetricRollup associates daily metric rollup statistics with the
-- managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.AverageValue IS 
-- 'The average value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same RollupTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.MaximumValue IS 
-- 'The maximum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.MinimumValue IS 
-- 'The minimum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.RollupTimestamp IS 
-- 'The date/time that identifies the start of the rollup period.  For example, if
-- the rollup is daily, the RollupTimestamps will be on daily boundaries starting
-- at 12 A.M.  Metric samples included in the rollup period are greater than or
-- equal to the RollupTimestamp, using the timezone of the agent where the metric
-- was collected.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.SampleCount IS 
-- 'The number of metric samples that were aggregated for the metric during the day
-- starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.StdDevValue IS 
-- 'The standard deviation of the metric samples that were aggregated for the
-- metric during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_DailyMetricRollup.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- Rem
-- Rem View definition for Oracle_HourlyMetricRollup
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_HourlyMetricRollup
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     MetricGUID, KeyValue, RollupTimestamp, SampleCount,
--     AverageValue, MinimumValue, MaximumValue, StdDevValue)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, m.metric_guid,
--          m.key_value, m.rollup_timestamp, m.sample_count,
--          m.value_average,
--          m.value_minimum, m.value_maximum, m.value_sdev
--        FROM
--            MGMT_METRICS_1HOUR m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_HourlyMetricRollup IS 
-- 'Oracle_HourlyMetricRollup associates hourly metric rollup statistics with the
-- managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.AverageValue IS 
-- 'The average value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same RollupTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.MaximumValue IS 
-- 'The maximum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.MinimumValue IS 
-- 'The minimum value of the metric samples that were aggregated for the metric
-- during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.RollupTimestamp IS 
-- 'The date/time that identifies the start of the rollup period.  For example, if
-- the rollup is daily, the RollupTimestamps will be on daily boundaries starting
-- at 12 A.M.  Metric samples included in the rollup period are greater than or
-- equal to the RollupTimestamp, using the timezone of the agent where the metric
-- was collected.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.SampleCount IS 
-- 'The number of metric samples that were aggregated for the metric during the day
-- starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.StdDevValue IS 
-- 'The standard deviation of the metric samples that were aggregated for the
-- metric during the day starting at RollupTimeStamp.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- the Managed Target for the metric.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_HourlyMetricRollup.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- 
-- Rem
-- Rem View definition for Oracle_CompositeKeyForTarget
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_CompositeKeyForTarget
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     KeyGUID, Key1, Key2, Key3, Key4, Key5)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, m.composite_key,
--          m.key_part1_value, m.key_part2_value, m.key_part3_value,
--          m.key_part4_value, m.key_part5_value
--        FROM
--            MGMT_METRICS_COMPOSITE_KEYS m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_CompositeKeyForTarget IS 
-- 'Oracle_CompositeKeyForTarget associates composite key information with
-- the managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Key1 IS 
-- 'The first of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Key2 IS 
-- 'The second of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Key3 IS 
-- 'The third of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Key4 IS 
-- 'The fourth of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.Key5 IS 
-- 'The fifth of up to five additional keys that can be used to identify a
-- collection of metrics.';
-- 
-- COMMENT ON COLUMN Oracle_CompositeKeyForTarget.KeyGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies a
-- metric composite key.  The key GUID MUST be constructed from an MD5 digest of
-- the string concatenation of Key1 + Key2 + Key3 + Key4 + Key5.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricForTarget
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_MetricForTarget
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     MetricGUID, KeyValue, CollectionTimestamp,
--     MetricValue, StringValue)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name,  m.metric_guid,
--          m.key_value, m.collection_timestamp, m.value, m.string_value
--        FROM
--            MGMT_METRICS_RAW m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricForTarget IS 
-- 'Oracle_MetricForTarget associates detailed metric data with its managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- collected for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.MetricValue IS 
-- 'The value of the metric if the metric is numeric.  Metrics that are strings are
-- stored in StringValue.';
-- 
-- COMMENT ON COLUMN Oracle_MetricForTarget.StringValue IS 
-- 'The value of the metric if the metric is a string.  Metrics that are numeric
-- are stored in MetricValue.';
-- 
-- Rem
-- Rem View definition for Oracle_MetricsDefinedForType
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_MetricsDefinedForType
--      (TargetType, TypeVersion, TargetTypeCaption, MetricName,
--      MetricColumn,
--       MetricCategory1, MetricCategory2, MetricCategory3,
--       MetricCategory4, MetricCategory5, MetricGUID, ColumnLabel,
--       KeyColumn, KeyOrder, NumberOfKeys, ShortCaption, MetricCaption,
--       Description, MetricType, EvaluationProcedureName, CreationTime,
--       Units, SummaryMetric, IsDynamic, AgentCleared)
--    AS
--      SELECT
--        tt.target_type, tt.type_meta_ver,
--        tt.display_name, m.metric_name,
--        m.metric_column, m.category_prop_1, m.category_prop_2,
--        m.category_prop_3, m.category_prop_4, m.category_prop_5,
--        m.metric_guid, m.column_label, m.key_column,
--        m.key_order, m.num_keys, m.short_name, m.metric_label,
--        m.description,
--        DECODE (m.metric_type,
--                0, 'Number', 1, 'String', 2, 'Table',
--                3, 'Raw', 4, 'External', 5, 'RepositoryTable',
--                6, 'RepositoryNumber', 7, 'RepositoryString'),
--        m.source, m.load_timestamp, m.unit,
--        DECODE (m.is_for_summary, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m.keys_from_mult_colls, 0, 'FALSE', 1, 'TRUE'),
--        DECODE (m.statefull, 0, 'FALSE', 1, 'TRUE')
--      FROM
--         MGMT_TARGETS tt, MGMT_TARGET_TYPES t, MGMT_METRICS m
--      WHERE t.target_type = tt.target_type
--          AND t.target_type = m.target_type
--          AND tt.type_meta_ver = m.type_meta_ver
--          AND (tt.category_prop_1 = m.category_prop_1
--               OR m.category_prop_1 = ' ')
--          AND (tt.category_prop_2 = m.category_prop_2
--               OR m.category_prop_2 = ' ')
--          AND (tt.category_prop_3 = m.category_prop_3
--               OR m.category_prop_3 = ' ')
--          AND (tt.category_prop_4 = m.category_prop_4
--               OR m.category_prop_4 = ' ')
--          AND (tt.category_prop_5 = m.category_prop_5
--               OR m.category_prop_5 = ' ')
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_MetricsDefinedForType IS 
-- 'Oracle_MetricsDefinedForType identifies the metrics that have been defined for
-- a target type.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.AgentCleared IS 
-- 'This flag indicates whether alerts generated for this metric are cleared by the
-- Oracle agent.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCaption IS 
-- 'A descriptive label for the metric.  The caption contains a name that can be
-- used in a client application to display the metric name in an understandable
-- way.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.ColumnLabel IS 
-- 'For table metrics, the ColumnLabel provides a short descriptive name for the
-- column in the table.  The ColumnLabel defines a name that can be used in a
-- client application to display the information represented by this column in the
-- context of the table metric in an understandable way.  The ColumnLabel is null
-- if the definition is for a simple metric or if the ColumnLable was not defined.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.CreationTime IS 
-- 'The date/time in the timezone of the central repository when the metric was
-- first loaded into the repository.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.Description IS 
-- 'The Description contains more detailed information about the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.EvaluationProcedureName IS 
-- 'The name of the PL/SQL procedure that will be executed for repository metrics. 
-- The PL/SQL procedure provides the value for the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.IsDynamic IS 
-- 'This flag indicates whether the metric is dynamic.  A value of TRUE means that
-- the metric is dynamic.  Dynamic metrics are defined at runtime instead of when
-- the managed target is discovered.  Dynamic metrics use the key of the metric as
-- the metric name.  Only table metrics can be dynamic.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.KeyColumn IS 
-- 'The KeyColumn identifies the name of the column in a table metric that contains
-- the key value for the metric.  This is the column that includes the value that
-- establishes the context for the remaining columns that are defined by the table
-- metric and identifies a row in the table.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.KeyOrder IS 
-- 'The KeyOrder provides an ordering for the KeyColumns in a table metric.  It
-- defaults to 0, which indicates that the column is not part of the key.  Table
-- metric definitions support up to three key columns.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCategory1 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCategory2 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCategory3 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCategory4 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricCategory5 IS 
-- 'MetricCategories are used to restrict the use of the metric to a particular
-- product configuration.  When a MetricCategory is not specified, the metric is
-- applicable to all configurations.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricColumn IS 
-- 'For table metrics, MetricColumn contains a name for the column in the table
-- that is represented by this metric.  The MetricColumn uniquely identifies an
-- individual metric that is defined within a table metric definition.  For
-- example, if a DiskInformation table metric is defined, one metric that is part
-- of the definition might represent disk utilization.  The MetricColumn for disk
-- utilization in this example might be DiskUtilization.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricName IS 
-- 'The name of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.MetricType IS 
-- 'The MetricType identifies the data type of the information that the metric
-- represents.  The MetricType is used during the rollup process to determine
-- whether the metric can be aggregated.  The MetricType is also used by client
-- applications to determine the best way to display the contents of the metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.NumberOfKeys IS 
-- 'The number of key columns that have been defined for the table metric.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.ShortCaption IS 
-- 'The ShortCaption provides a condensed version of the display name that is
-- provided by the Caption.  It is used in UIs where displaying the full caption
-- is not possible.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.SummaryMetric IS 
-- 'This flag indicates whether the metric should be displayed on a summary page
-- within the user interface.  A value of TRUE means that the metric should be
-- displayed.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.TargetType IS 
-- 'The name of the target type.  The target type determines the set of metrics
-- that are defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.Units IS 
-- 'The unit by which the metric has been measured.';
-- 
-- COMMENT ON COLUMN Oracle_MetricsDefinedForType.TargetTypeCaption IS 
-- 'A short descriptive name for the Target Type.  The caption defines a name that
-- can be used in a client application to display the target type in an
-- understandable way.  The targettypecaption defaults to the name of the 
-- target type.';
-- 
-- Rem
-- Rem View definition for Oracle_PropertiesForTarget
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_PropertiesForTarget
--      (TargetName, TargetType, TargetGUID, AgentUrl, HostName,
--      LastLoadTime,
--       TimezoneRegion, ServiceType, BrokenReason,
--       BrokenString,
--       MonitoringMode, ManagedTargetCaption, PropertyName,
--       PropertyType,
--       PropertyValue, PropertyCaption)
--    AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, p.property_name, p.property_type,
--        p.property_value, p.property_name
--      FROM
--         MGMT_TARGET_PROPERTIES p, MGMT_TARGETS t
--      WHERE t.target_guid = p.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_PropertiesForTarget IS 
-- 'Oracle_PropertiesForTarget identifies the properties that belong to a Managed
-- Target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.ManagedTargetCaption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.PropertyCaption IS 
-- 'A short descriptive name for the property.  The caption contains a name that
-- can be used in a client application to display the property name in an
-- understandable way.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.PropertyName IS 
-- 'The name of the target property.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.PropertyType IS 
-- 'The type of the target property.  If the type is not specified, it defaults to
-- INSTANCE.';
-- 
-- COMMENT ON COLUMN Oracle_PropertiesForTarget.PropertyValue IS 
-- 'The value of the target property, represented as a string.';
-- 
-- Rem
-- Rem View definition for Oracle_StringHistoryForTarget
-- Rem
-- 
-- CREATE OR REPLACE VIEW Oracle_StringHistoryForTarget
--    (TargetName, TargetType, TargetGUID, AgentUrl,
--     HostName, LastLoadTime, TimezoneRegion, ServiceType,
--     BrokenReason, BrokenString, MonitoringMode, Caption,
--     MetricGUID, KeyValue, CollectionTimestamp,
--     StringValue)
--  AS
--    SELECT
--        t.target_name, t.target_type, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        t.display_name, m.metric_guid,
--          m.key_value, m.collection_timestamp, m.string_value
--        FROM
--            MGMT_STRING_METRIC_HISTORY m, MGMT_TARGETS t
--      WHERE t.target_guid = m.target_guid
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_StringHistoryForTarget IS 
-- 'Oracle_StringHistoryForTarget associates historical string metric samples
-- with the managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.Caption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.CollectionTimestamp IS 
-- 'The date/time in the timezone of the managing agent when the string was
-- collected at the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.KeyValue IS 
-- 'The KeyValue is used to uniquely identify individual rows within a table
-- metric.  The value of KeyValue MUST be unique for each row in the table metric
-- with the same CollectionTimestamp.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.MetricGUID IS 
-- 'The octet string representation of an internal GUID that identifies a metric
-- definition.  Since metric GUIDs are created from the target type and metric
-- name, different versions of a metric definition will have the same GUID.';
-- 
-- COMMENT ON COLUMN Oracle_StringHistoryForTarget.StringValue IS 
-- 'The value of the string metric.';
-- 
-- Rem
-- Rem View definition for Oracle_TypeOfTarget
-- Rem
-- 
--  CREATE OR REPLACE VIEW Oracle_TypeOfTarget
--      (TargetName, TargetType, TypeVersion, ManagedTargetCaption,
--       TargetGUID, AgentUrl, HostName, LastLoadTime, TimezoneRegion,
--       ServiceType, BrokenReason, BrokenString,
--       MonitoringMode,  TargetTypeCaption, TypeCategory1,
--       TypeCategory2, TypeCategory3, TypeCategory4, TypeCategory5)
--    AS
--      SELECT
--        t.target_name, t.target_type, t.type_meta_ver,
--        t.display_name, t.target_guid,
--        t.emd_url, t.host_name, t.last_load_time,
--        t.timezone_region, t.service_type,
--        DECODE (t.broken_reason, 0, 'Not Broken',
--                1, 'Missing Required Properties',
--                2, 'Metadata Not Found',
--                4, 'Error Computing Dynamic Properties',
--                8, 'Dynamic Properties Missing in Result',
--               16, 'Target Name Not Specified',
--               32, 'Target Could Not Be Saved',
--               64, 'Errors In Target Test Metrics'), t.broken_str,
--        DECODE (t.monitoring_mode,
--                0, 'Single agent, Vanilla monitoring mode',
--                1, 'Multiple Agent, OMS mediated monitoring mode',
--                2, 'Multiple Agent, Agent mediated monitoring mode'),
--        tt.type_display_name, t.category_prop_1, t.category_prop_2,
--        t.category_prop_3, t.category_prop_4, t.category_prop_5
--      FROM
--         MGMT_TARGETS t, MGMT_TARGET_TYPES tt
--      WHERE t.target_type = tt.target_type
--    WITH READ ONLY;
-- 
-- 
-- COMMENT ON TABLE Oracle_TypeOfTarget IS 
-- 'Oracle_TypeOfTarget associates a target type and any type categories that have
-- been specified for the Managed Target to a Managed Target.  Type categories are
-- used to identify additional metrics that pertain to a specific managed target
-- configuration.  For example, a host target could use a type category to include
-- any platform specific metrics that were defined as part of the host target type
-- definition.  A target type supports up to five optional type categories.  If a
-- category is not specified, this means that only the common metrics for the
-- target type are applicable for this managed target.';
-- 
-- 
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.AgentUrl IS 
-- 'The URL for the Agent that is managing the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.BrokenReason IS 
-- 'This BrokenReason indicates the reason that metric collection for the Managed
-- Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.BrokenString IS 
-- 'This BrokenString contains additional details on why the metric collection for
-- the Managed Target is not working.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.ManagedTargetCaption IS 
-- 'A short descriptive name for the Managed Target.  The caption defines a name
-- that can be used in a client application to display the managed target name in
-- an understandable way.  The caption defaults to the name of the managed target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.HostName IS 
-- 'The name of the Host where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.LastLoadTime IS 
-- 'The date/time in the timezone of the managing agent when metric information was
-- last loaded for the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.MonitoringMode IS 
-- 'The MonitoringMode indicates how the Managed Target is being monitored.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.ServiceType IS 
-- 'ServiceType represents the target type as defined by agents prior to Enterprise
-- Manager V4.0, in the form oracle_sysman_xxx.  This property is used for
-- response time metric reporting.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TargetGUID IS 
-- 'The octet string representation of an internal GUID that uniquely identifies
-- this particular Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TargetName IS 
-- 'The name of the Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TargetType IS 
-- 'The name of the target type.  A managed target is identified by its target
-- name and target type.  The target type determines the set of metrics that are
-- defined for a Managed Target.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TimezoneRegion IS 
-- 'The timezone region name where the Managed Target resides.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TargetTypeCaption IS 
-- 'A short descriptive name for the Target Type.  The caption defines a name that
-- can be used in a client application to display the target type in an
-- understandable way.  The caption defaults to the name of the target type.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeVersion IS 
-- 'Target types are versioned to allow for version specific variations in the
-- metrics that are collected, or to account for changes in behavior/functionality
-- across versions.  For example, a database may have additional metrics that are
-- collected for a newer version.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeCategory1 IS 
-- 'Type Category 1.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeCategory2 IS 
-- 'Type Category 2.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeCategory3 IS 
-- 'Type Category 3.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeCategory4 IS 
-- 'Type Category 4.';
-- 
-- COMMENT ON COLUMN Oracle_TypeOfTarget.TypeCategory5 IS 
-- 'Type Category 5.';
