Rem
Rem $Header: sdk_collections_pkgdef.sql 31-jul-2006.21:07:53 sthiruna Exp $
Rem
Rem sdk_collections_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_collections_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sthiruna    07/31/06 - Copying 10.2.0.3 Config Standard changes from EMCORE_MAIN_LINUX
Rem    jsadras     07/17/06 - Backport jsadras_bug-5002887 from main 
Rem    jsadras     02/27/06 - Add support for external metric evaluation 
Rem    kchiasso    02/23/06 - change owner to author
Rem    niramach    01/31/06 - Modify the run_collection params 
Rem    niramach    01/09/06 - 10.3 Work start: Add optional parameters to run_collection to 
Rem                           identify configuration standard being evaluated. 
Rem    jsadras     08/31/05 - add bulk batching support 
Rem    jsadras     08/23/05 - Bug:4550781, Add auto_enable for default 
Rem                           collections 
Rem    jsadras     04/26/05 - default worker support 
Rem    rpinnama    05/09/05 - Add delete collection API 
Rem    jsadras     03/24/05 - add transient support 
Rem    ancheng     01/17/05 - make default_object_guid public temporarily 
Rem    jsadras     12/17/04 - bulk_collection
Rem    jsadras     11/26/04 - add task_type to worker apis 
Rem    jsadras     11/25/04 - repo task_type 
Rem    jsadras     11/01/04 - param changes 
Rem    jsadras     10/28/04 - comments
Rem    jsadras     10/27/04 - add_default_collection
Rem    jsadras     10/20/04 - signature_change
Rem    jsadras     09/28/04 - format_constants
Rem    jsadras     09/07/04 - metric_column
Rem    jsadras     09/03/04 - note
Rem    jsadras     08/27/04 - collection_worker
Rem    jsadras     08/18/04 - more features 
Rem    jsadras     07/26/04 - 
Rem    jsadras     07/24/04 - jsadras_repocollect1
Rem    jsadras     07/06/04 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_COLLECTION
IS

-- The module name for error and performance logging
G_MODULE_NAME constant varchar2(40) := 'MGMT_COLLECTION.Collection Subsystem';
-- Modes of stopping a worker
G_NORMAL_STOP    CONSTANT NUMBER(1) := 1 ;
G_IMMEDIATE_STOP CONSTANT NUMBER(1) := 2 ;
G_DEFAULT_WORKER_COUNT CONSTANT NUMBER := 1 ;
G_WORKER_COUNT_PARAM CONSTANT VARCHAR2(30) := 'mgmt_worker_count' ;
G_TARGET_ADD_CALLBACK     CONSTANT VARCHAR2(50) :=
                 'mgmt_collection.start_default_collection' ;
--
--Formatting constants for message template
-- The % is not here so it can be used to compare.
--
G_FORMAT_VALUE          CONSTANT VARCHAR2(10) := 'value' ;
G_FORMAT_TARGET         CONSTANT VARCHAR2(10) := 'target' ;
G_FORMAT_METRIC         CONSTANT VARCHAR2(10) := 'metric_id' ;
G_FORMAT_CRIT_THRESHOLD CONSTANT VARCHAR2(20) := 'critical_threshold' ;
G_FORMAT_WARN_THRESHOLD CONSTANT VARCHAR2(20) := 'warning_threshold' ;
G_FORMAT_INFO_THRESHOLD CONSTANT VARCHAR2(20) := 'info_threshold' ;
G_FORMAT_NUM_OCCUR      CONSTANT VARCHAR2(20) := 'num_of_occur' ;
G_FORMAT_SEVERITY       CONSTANT VARCHAR2(10) := 'severity' ;
G_FORMAT_THRESHOLD      CONSTANT VARCHAR2(10) := 'threshold' ;
G_FORMAT_COLUMN         CONSTANT VARCHAR2(10) := 'columnName' ;
G_FORMAT_KEY_VALUE      CONSTANT VARCHAR2(10) := 'keyValue' ;
--
-- PURPOSE
--
-- To start a repository collection  for a bunch of metrics
--
-- Parameters
-- p_target_type : Target Type
-- p_target_name : Name of the target
-- p_metrics_list :contains the list of metrics for which collection needs
-- to be started. The list is an array of (metric_name,metric_column) pairs
--
-- p_coll_name: Name of the collection item
-- 
-- p_schedule_ex : Schedule for Agent side collections, will only be stored, 
--                 will not be used.
--
-- p_coll_schedule is the new scheduling object for repository collections
--
-- p_store_metric: Whether the result of metric evaluation needs to be stored 
--                 or not. 1=Store, 0=Do not Store
-- Example Call:
--   mgmt_collection.start_collection
--        (p_target_type=>'oracle_emrep',
--         p_target_name=>'Management Services...',
--         p_metrics_list=>mgmt_metric_name_array(
--                           mgmt_metric_name_obj.new('GroupStorage',' '),
--                           mgmt_metric_name_obj.new('HostStorage','DiskUsed')),
--         p_coll_name=>'Storage Collection',
--         p_coll_schedule=>mgmt_coll_schedule_obj.new(1440,null,null),
--         p_store_metric=>mgmt_global.G_TRUE);
--


PROCEDURE start_collection
                (p_target_type      IN VARCHAR2,
                 p_target_name      IN VARCHAR2,
                 p_metrics_list     IN mgmt_metric_name_array,
                 p_coll_name        IN VARCHAR2 DEFAULT NULL,
                 p_schedule_ex      IN VARCHAR2 DEFAULT ' ',
                 p_coll_schedule    IN mgmt_coll_schedule_obj DEFAULT NULL,
                 p_store_metric     IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
                 p_is_transient     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE) ;
--
-- Same as above except that metrics_list is a collection of metric names
-- and metric column will be defaulted to ' '
--
-- Example Call:
--   mgmt_collection.start_collection
--        (p_target_type=>'oracle_emrep',
--         p_target_name=>'Management Services...',
--         p_metrics_list=>mgmt_short_string_array('GroupStorage','HostStorage'),
--         p_coll_name=>'Storage Collection',
--         p_coll_schedule=>mgmt_coll_schedule_obj.new(1440,null,null),
--         p_store_metric=>mgmt_global.G_TRUE);
--

PROCEDURE start_collection
                (p_target_type      IN VARCHAR2,
                 p_target_name      IN VARCHAR2,
                 p_metrics_list     IN mgmt_short_string_array,
                 p_coll_name        IN VARCHAR2 DEFAULT NULL,
                 p_schedule_ex      IN VARCHAR2 DEFAULT ' ',
                 p_coll_schedule    IN mgmt_coll_schedule_obj DEFAULT NULL,
                 p_store_metric     IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
                 p_is_transient     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE) ;
--
-- PURPOSE
-- To start a repository collection for a metric
-- Parameters
-- Same as for previous start_collection
-- p_coll_schedule is the new scheduling object for repository collections

PROCEDURE start_collection
                (p_target_type     IN VARCHAR2,
                 p_target_name     IN VARCHAR2,
                 p_metric_name     IN VARCHAR2, 
                 p_metric_column   IN VARCHAR2 DEFAULT ' ', 
                 p_coll_name       IN VARCHAR2 DEFAULT NULL,
                 p_schedule_ex     IN VARCHAR2 DEFAULT ' ',
                 p_coll_schedule   IN mgmt_coll_schedule_obj DEFAULT NULL,
                 p_store_metric    IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
                 p_is_transient     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE) ;
--
-- PURPOSE
-- Procedure to modify a agent or repository collection
-- only schedule or store_metric can be modified
-- This will only store the modified information in the repository
-- Agent will not be using this information
--
PROCEDURE modify_collection
              (p_target_type     IN VARCHAR2,
               p_target_name     IN VARCHAR2,
               p_metric_name     IN VARCHAR2, 
               p_metric_column   IN VARCHAR2 DEFAULT ' ', 
               p_coll_name       IN VARCHAR2 DEFAULT NULL,
               p_schedule_ex     IN VARCHAR2 DEFAULT ' ',
               p_coll_schedule   IN mgmt_coll_schedule_obj DEFAULT NULL,
               p_store_metric    IN NUMBER DEFAULT NULL,
               p_is_transient    IN NUMBER DEFAULT NULL) ;


-- PURPOSE
-- Stop the collection for the target/metric
-- if metric name/collection name is not given
-- then all collections for target would be stopped
--
PROCEDURE stop_collection(p_target_name     IN VARCHAR2, 
                          p_target_type     IN VARCHAR2,
                          p_metric_name     IN VARCHAR2 DEFAULT NULL,
                          p_metric_column   IN VARCHAR2 DEFAULT ' ',
                          p_coll_name       IN VARCHAR2 DEFAULT NULL) ;

-- PURPOSE
-- Deletes the collection for the target/metric
-- Also deletes any thresholds, policy setup for the target/metric
-- if metric name/collection name is not given
-- then all collections for target would be stopped
--
PROCEDURE delete_collection(p_target_type     IN VARCHAR2, 
                            p_target_name     IN VARCHAR2,
                            p_coll_name       IN VARCHAR2 DEFAULT NULL) ;
--
-- PURPOSE
-- Suspend the specified collection
--If metric name/collection name is not specified then all
--collections for the target would be suspended
-- 
PROCEDURE suspend_collection(p_target_type     IN VARCHAR2,
                             p_target_name     IN VARCHAR2,
                             p_metric_name     IN VARCHAR2 DEFAULT NULL,
                             p_metric_column   IN VARCHAR2 DEFAULT ' ',
                             p_coll_name       IN VARCHAR2 DEFAULT NULL) ;
--
-- PURPOSE
-- Resume the repository collections for the specified target
--If metric name/collection name is not specified then all
--collections for the target would be resumed
--
PROCEDURE resume_collection(p_target_type     IN VARCHAR2,
                            p_target_name     IN VARCHAR2,
                            p_metric_name     IN VARCHAR2 DEFAULT NULL,
                            p_metric_column   IN VARCHAR2 DEFAULT ' ',
                            p_coll_name       IN VARCHAR2 DEFAULT NULL) ;

--
-- PURPOSE
-- Do a on-demand collection of the metric
--
-- This will typically be called from UI to get the latest metric values
-- This will only pick up the latest values from the repository
--
-- target_name/target_type,metric name has to be specified
--
-- The collection name if specified will be validated, error will be
-- returned if collection name does not exist.
-- If collection_name is not specified, it will
-- default to existing collection. If more than one collection exists
-- and collection name is not specified then error will be returned.
-- if collection_name passed in = ' ' then the metric evaluation procedure
-- will be called with ' ' as collection name.
--
-- if key_value is specified then the collection will be run normally
-- but only the results matching the key value will be returned.
--
-- If p_store_metric is 1, the metric values will be
-- stored in the repository and policy evaluations done
--
-- If p_evaluate_policy=1 then policy will be evaluated for all results 
-- The metric values collected will be returned through p_metric_values
--
-- p_metric_values will contain the results of metric evaluation
--
PROCEDURE run_collection
           (p_target_name     IN VARCHAR2,
            p_target_type     IN VARCHAR2,
            p_metric_name     IN VARCHAR2,
            p_metric_column   IN VARCHAR2 DEFAULT ' ',
            p_coll_name       IN VARCHAR2 DEFAULT NULL,
            p_key_value       IN VARCHAR2 DEFAULT NULL,
            p_store_metric    IN NUMBER   DEFAULT MGMT_GLOBAL.G_TRUE,
            p_evaluate_policy IN NUMBER   DEFAULT MGMT_GLOBAL.G_TRUE,
            p_metric_values   OUT mgmt_metric_value_array
           ) ;
--
-- PURPOSE
-- Same as above only that metric values are not returned. 
-- This will generally be called after snapshots are done 
-- and policy will always be evaluated
--
PROCEDURE run_collection
            (p_target_name         IN VARCHAR2,
             p_target_type         IN VARCHAR2,
             p_metric_name         IN VARCHAR2,
             p_metric_column       IN VARCHAR2 DEFAULT ' ',
             p_coll_name           IN VARCHAR2 DEFAULT NULL,
             p_store_metric        IN NUMBER   DEFAULT MGMT_GLOBAL.G_TRUE,
             p_store_metric_errors IN NUMBER   DEFAULT MGMT_GLOBAL.G_TRUE
            ) ;

--
-- Run all the collections with collection name = p_coll_name
--
PROCEDURE run_collection(p_coll_name IN VARCHAR2) ;
--
-- Run the collection for all the targets in the array
--
PROCEDURE run_collection
             (p_targets_list        IN MGMT_TARGET_ARRAY,
              p_metric_name         IN VARCHAR2,
              p_metric_column       IN VARCHAR2 DEFAULT ' ',
              p_coll_name           IN VARCHAR2 DEFAULT NULL,
              p_store_metric        IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE, 
              p_store_metric_errors IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
              p_config_std_name     IN VARCHAR2 DEFAULT NULL,
              p_config_std_author   IN VARCHAR2 DEFAULT NULL,
              p_config_std_version  IN NUMBER DEFAULT 1       
             );
--
-- Set the bulk batch size for run_collection.
-- This will be used internally split the targets passed to 
-- run_collections ( which accepts p_targets_list above) into batches
-- for performance, since huge pl/sql tables can cause performance issues 
--
PROCEDURE set_bulk_batch_size(p_limit IN NUMBER) ;
--
-- get the current bulk batch size limit
--
FUNCTION  get_bulk_batch_size RETURN NUMBER  ;
--
-- PURPOSE
-- Function to find out if the target/metric has a collection
--
FUNCTION has_collection(p_target_name IN VARCHAR2,
                        p_target_type IN VARCHAR2,
                        p_metric_name IN VARCHAR2,
                        p_metric_column IN VARCHAR2 DEFAULT ' ')
RETURN BOOLEAN;

--
-- PURPOSE
-- Function to find out the collection name for a target/metric
--
FUNCTION get_collection_name(p_target_name IN VARCHAR2,
                             p_target_type IN VARCHAR2,
                             p_metric_name IN VARCHAR2,
                             p_metric_column IN VARCHAR2 DEFAULT ' ')
RETURN VARCHAR2;

--
--
-- PURPOSE
-- Add a default collection item for the target_type
-- with the specified metrics and schedule
-- p_metrics_list: List of metrics associated with the collection
-- p_coll_name: default null will be set to ' '
-- p_valid_if_list: List of valid -ifs for which the 
--                  default collection applies, for example.
--                  validonly if 9i
-- p_coll_schedule: schedule of the collection
-- p_store_metric : if the metric values evaluated have to be stored.
-- p_is_enabled: 1 = this collection will be started for the target
--                  when the target is added
--               0 = This collection will not be started for target
-- p_auto_enable: 1 = Start the default collection for existing targets
--                0 = Do not start default collection for existing targets
--
PROCEDURE add_default_collection
             (p_target_type        IN VARCHAR2,
              p_type_meta_ver      IN VARCHAR2,
              p_metrics_list       IN mgmt_metric_name_array,
              p_coll_name          IN VARCHAR2 DEFAULT NULL,
              p_valid_if_list      IN mgmt_validif_array DEFAULT NULL,
              p_coll_schedule      IN mgmt_coll_schedule_obj DEFAULT NULL,
              p_coll_properties    IN mgmt_namevalue_array DEFAULT NULL,
              p_store_metric       IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
              p_is_enabled         IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
              p_auto_enable        IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE
             ) ;

PROCEDURE add_default_collection
             (p_target_type        IN VARCHAR2,
              p_type_meta_ver      IN VARCHAR2,
              p_metrics_list       IN mgmt_short_string_array,
              p_coll_name          IN VARCHAR2 DEFAULT NULL,
              p_valid_if_list      IN mgmt_validif_array DEFAULT NULL,
              p_coll_schedule      IN mgmt_coll_schedule_obj DEFAULT NULL,
              p_coll_properties    IN mgmt_namevalue_array DEFAULT NULL,
              p_store_metric       IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
              p_is_enabled         IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
              p_auto_enable        IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE
             ) ;
--
-- PURPOSE
-- modify the default collection
-- if metric names are given, then it replaces current metrics
-- If schedule is specified then it replaces current schedule
-- If category prop list is specified then it replaces current category props(Valid Ifs)
-- If collection properties is specified then it replaces current properties
--
PROCEDURE modify_default_collection
           (p_target_type        IN VARCHAR2,
            p_type_meta_ver      IN VARCHAR2,
            p_metrics_list       IN mgmt_metric_name_array,
            p_coll_name          IN VARCHAR2 DEFAULT NULL,
            p_valid_if_list      IN mgmt_validif_array DEFAULT NULL,
            p_coll_schedule      IN mgmt_coll_schedule_obj DEFAULT NULL,
            p_coll_properties    IN mgmt_namevalue_array DEFAULT NULL,
            p_store_metric       IN NUMBER DEFAULT NULL,
            p_is_enabled         IN NUMBER DEFAULT NULL
           ) ;

PROCEDURE modify_default_collection
           (p_target_type        IN VARCHAR2,
            p_type_meta_ver      IN VARCHAR2,
            p_metrics_list       IN mgmt_short_string_array,
            p_coll_name          IN VARCHAR2 DEFAULT NULL,
            p_valid_if_list      IN mgmt_validif_array DEFAULT NULL,
            p_coll_schedule      IN mgmt_coll_schedule_obj DEFAULT NULL,
            p_coll_properties    IN mgmt_namevalue_array DEFAULT NULL,
            p_store_metric       IN NUMBER DEFAULT NULL,
            p_is_enabled         IN NUMBER DEFAULT NULL
           ) ;
--
-- Enable the default collection to be picked up when a target is added.
--
PROCEDURE enable_default_collection
           (p_target_type        IN VARCHAR2,
            p_type_meta_ver      IN VARCHAR2,
            p_coll_name          IN VARCHAR2 DEFAULT NULL,
            p_valid_if_list      IN mgmt_validif_array DEFAULT NULL) ;

--
-- Disable the default collection from getting picked up when a target is added.
--
PROCEDURE disable_default_collection
           (p_target_type        IN VARCHAR2,
            p_type_meta_ver      IN VARCHAR2,
            p_coll_name          IN VARCHAR2 DEFAULT NULL,
            p_valid_if_list      IN mgmt_validif_array DEFAULT NULL) ;
--
-- PURPOSE
-- Delete the default collection for the target type
--
PROCEDURE delete_default_collection
            (p_target_type        IN VARCHAR2,
             p_type_meta_ver      IN VARCHAR2,
             p_coll_name          IN VARCHAR2 DEFAULT NULL,
             p_valid_if_list      IN mgmt_validif_array) ;
--
-- PURPOSE
-- procedure to start the default collection for the target
-- existing collections are deleted. This is to be called from
-- target add callback
--
PROCEDURE start_default_collection(p_target_name IN VARCHAR2,
                                   p_target_type IN VARCHAR2,
                                   p_target_guid IN RAW DEFAULT NULL) ;
--
-- Start default collection for all existing targets for 
-- The target type version. 
--
PROCEDURE start_default_collection(p_target_type   IN VARCHAR2,
                                   p_type_meta_ver IN VARCHAR2) ;
-- 
-- Procedure to store metric data returned by external 
-- metric evaluation procedures directly and to evaluate thresholds on it
-- Parameters
--
-- if p_store_metric = MGMT_GLOBAL.G_TRUE then data will be stored in 
--    mgmt_metrics_raw
--
-- if p_check_thresholds =MGMT_GLOBAL.G_TRUE is specified then metric thresholds 
-- defined for the target/metric will be checked and alert will be raised as
-- appropriate
--
-- p_coll_name(collection name) has to be specified if thresholds have to be
-- checked, since thresholds are defined on collection name
--
-- p_collection_timestamp: if not specified will default to the system 
-- date in the target's timezone

PROCEDURE store_metric_data
           (p_target_type          IN VARCHAR2,
            p_target_name          IN VARCHAR2,
            p_metric_name          IN VARCHAR2,
            p_metric_results       IN mgmt_metric_results_table,
            p_store_metric         IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_coll_name            IN VARCHAR2 DEFAULT ' ',
            p_check_thresholds     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE,
            p_collection_timestamp IN DATE   DEFAULT NULL
           ) ;

--
-- PURPOSE
--
-- Set the default workers to startup for each task class
-- Values for task class
-- 0  - Short running tasks
-- 1  - Long running tasks
-- Values for worker count
-- 0 to 100. if Set to 0 the workers will not be started for the task class
--
-- Example: To set default number of workers for task class 0 to 2 workers
-- mgmt_collection.set_worker_count(0,2)
-- 
PROCEDURE set_worker_count(p_task_class   IN VARCHAR2,
                           p_worker_count IN NUMBER) ;
--
-- Procedure to start the default number of workers at startup
-- 
-- It will start as many workers as defined by calls to set_worker_count
-- It will first remove all workers before creating new workers
--
PROCEDURE start_workers ;
--
-- PURPOSE
-- Increase the number of workers by worker_count
-- Workers can only be added up to job_queue_processes
-- If worker count is not specified one additional
-- worker is added.
--
PROCEDURE add_workers(p_worker_count  IN NUMBER   DEFAULT 1,
                      p_task_class    IN VARCHAR2 DEFAULT NULL) ;

--
-- PURPOSE
-- Decrease the number of workers by worker_count
-- IF p_stop_mode = G_NORMAL_STOP Then the worker would
-- complete all pending tasks and when it does not find any more
-- tasks it will stop
-- IF p_stop_mode= G_IMMEDIATE_STOP then the worker would
-- complete its current task and then exit
--
PROCEDURE remove_workers(p_worker_count IN NUMBER,
                         p_stop_mode    IN NUMBER := G_NORMAL_STOP,
                         p_task_class   IN VARCHAR2 DEFAULT NULL) ;
--
-- PURPOSE
-- Stop all workers
-- 
PROCEDURE remove_all_workers(p_stop_mode IN NUMBER := G_NORMAL_STOP) ;
--
-- PURPOSE
-- Stop the worker associated with the dbms_job and drop the job
--
PROCEDURE stop_dbms_job(p_job_id    IN NUMBER,
                        p_stop_mode IN NUMBER := G_NORMAL_STOP) ;

--
-- PURPOSE
-- Run a collection worker in current session syncronously
-- A new worker would be created and run in current session
-- Caution: ****Issues a COMMIT *****
--
PROCEDURE run_worker(p_task_class IN VARCHAR2 DEFAULT NULL)  ;

--
-- Generate the object guid for the specified target type
--
FUNCTION default_object_guid(p_target_type   IN VARCHAR2,
                             p_type_meta_ver IN VARCHAR2)
RETURN RAW;

END mgmt_collection;
/

show errors



