Rem
Rem $Header: sdk_config_std_pkgdef.sql 12-jul-2006.02:32:24 aragarwa Exp $
Rem
Rem sdk_config_std_pkgdef.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_config_std_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aragarwa    06/28/06   - finding severity value from rule importance 
Rem                             for event settings. 
Rem    sthiruna    06/08/06   - Fix for bug 5263883. Adding few constants 
Rem    aragarwa    06/01/06   - Adding standard export functionality. 
Rem    aragarwa    05/17/06   - removing dname from hierarchy table. 
Rem    aragarwa    05/01/06  -  Adding support for reusable queries and cs 
Rem                            inclusion. 
Rem    niramach    04/11/06  - Add cs delete eval results api. 
Rem    aragarwa    04/06/06  - Adding keyword list as parameter to create 
Rem                            standard. 
Rem    groyal      03/31/06  - Add job related procedures
Rem    aragarwa    02/28/06 -  reflecting XSD and table changes. 
Rem    kchiasso    02/22/06 - change owner to author 
Rem    niramach    01/31/06 - Add the cs evaluation procedures. 
Rem    aragarwa    01/27/06 - Adding methods for creating compliance repos. 
Rem    niramach    01/13/06 - mgmt_config_std package definition
Rem    niramach    01/13/06 - Created
Rem

Rem ****************************************************************************
Rem MGMT_CONFIG_STD package definition 
Rem ****************************************************************************
CREATE OR REPLACE PACKAGE mgmt_config_std
IS
  G_MODULE_NAME CONSTANT VARCHAR2(30) := 'MGMT_CONFIG_STD';
  G_EMDW_LOG_CTX CONSTANT VARCHAR2(30) := 'COMPLIANCE_EVALUATION';
  G_COMPLIANCE_JOBTYPE CONSTANT VARCHAR2(32) := 'ComplianceEvaluation';
  G_DELETE_EVAL_RESULTS CONSTANT VARCHAR2(32) := 'DeleteEvalResults'; 

  G_ELEMENT_CS               	  CONSTANT NUMBER(1) := 1;
  G_ELEMENT_RULEFOLDER       	  CONSTANT NUMBER(1) := 2;
  G_ELEMENT_RULE             	  CONSTANT NUMBER(1) := 3;
  G_ELEMENT_INCLUSION       	  CONSTANT NUMBER(1) := 4;
	
  G_TEST_TYPE_DMQL           	  CONSTANT NUMBER(1) := 1;  
  G_TEST_TYPE_POLICY         	  CONSTANT NUMBER(1) := 2;

  G_IMPORTANCE_NOT_SCORED    	  CONSTANT NUMBER(1) := 0;
  G_IMPORTANCE_EXTREMELY_LOW 	  CONSTANT NUMBER(1) := 1;
  G_IMPORTANCE_LOW           	  CONSTANT NUMBER(1) := 2; 
  G_IMPORTANCE_NORMAL        	  CONSTANT NUMBER(1) := 3;
  G_IMPORTANCE_HIGH          	  CONSTANT NUMBER(1) := 4;
  G_IMPORTANCE_EXTREMELY_HIGH  	  CONSTANT NUMBER(1) := 5;

  G_LIFECYCLE_DEVELOPMENT 	  CONSTANT NUMBER(1) := 1;
  G_LIFECYCLE_PRODUCTION          CONSTANT NUMBER(1) := 2; 
  G_LIFECYCLE_RETIRED        	  CONSTANT NUMBER(1) := 3;

  G_USAGE_TYPE_CON   	          CONSTANT NUMBER(1) := 1;
  G_USAGE_TYPE_MON   	          CONSTANT NUMBER(1) := 2;

  G_UNLOCKED                      CONSTANT NUMBER(1) := 0;
  G_LOCKED                        CONSTANT NUMBER(1) := 1;

  G_STD_PARAM_NUMTYPE             CONSTANT NUMBER(1) := 1;
  G_STD_PARAM_STRTYPE             CONSTANT NUMBER(1) := 2;

  G_STD_PARAM_PROCHANGE_FALSE     CONSTANT NUMBER(1) := 0;
  G_STD_PARAM_PROCHANGE_TRUE      CONSTANT NUMBER(1) := 1;

  G_VIOL_SEVERITY_INFO 	          CONSTANT NUMBER(1) := 1;
  G_VIOL_SEVERITY_WARNING         CONSTANT NUMBER(1) := 2; 
  G_VIOL_SEVERITY_CRITICAL        CONSTANT NUMBER(1) := 3;

  G_ERROR_RULES			              CONSTANT NUMBER(1) := 0;
  G_COMPLIANT_RULES               CONSTANT NUMBER(1) := 1;
  G_NONCOMPLIANT_RULES            CONSTANT NUMBER(1) := 2;
  G_UNKNOWN_RULES                 CONSTANT NUMBER(1) := 3;

-- Generates the config standard guid
FUNCTION generate_cs_guid(
  p_cs_author    VARCHAR2,
  p_cs_iname     VARCHAR2,
  p_cs_version   VARCHAR2
 ) RETURN RAW;

-- Looks up the config standard guid from the config standard table
FUNCTION get_config_std_guid(
  p_config_std_name     VARCHAR2,
  p_config_std_author    VARCHAR2,
  p_version   NUMBER
 ) RETURN RAW;

-- Create a configuration standard   
FUNCTION create_config_standard(
  p_cs_iname                 VARCHAR2,
  p_cs_dname                 VARCHAR2,
  p_version                  NUMBER,
  p_target_type              VARCHAR2,
  p_author                   VARCHAR2 DEFAULT 'ORACLE',
  p_lifecycle_status         NUMBER DEFAULT MGMT_CONFIG_STD.G_LIFECYCLE_PRODUCTION,
  p_description              VARCHAR2 DEFAULT NULL,
  p_reference_url            VARCHAR2 DEFAULT NULL,
  p_front_matter             VARCHAR2 DEFAULT NULL,
  p_rear_matter              VARCHAR2 DEFAULT NULL,
  p_notice                   VARCHAR2 DEFAULT NULL,
  p_is_hidden                NUMBER DEFAULT MGMT_GLOBAL.G_FALSE,
  p_is_locked                NUMBER DEFAULT MGMT_GLOBAL.G_FALSE,
  p_usage_type               NUMBER DEFAULT MGMT_CONFIG_STD.G_USAGE_TYPE_CON,
  p_keyword_list             MGMT_SHORT_STRING_TABLE DEFAULT NULL,
  p_param_list               MGMT_CS_PARAM_ARRAY DEFAULT NULL,
  p_reusable_query_list      MGMT_CS_REUSABLE_QUERY_ARRAY DEFAULT NULL
  /*
  p_access_list              MGMT_CS_ACCESS_ARRAY DEFAULT NULL
  */
  ) RETURN RAW;


-- Add a rule folder to a configuration standard.
FUNCTION add_rulefolder(
  p_cs_guid                 VARCHAR2,
  p_rulefolder_iname        VARCHAR2,
  p_rulefolder_dname        VARCHAR2,
  p_parent_guid             VARCHAR2,
  p_child_position          NUMBER,
  p_description             VARCHAR2 DEFAULT NULL,
  p_reference_url           VARCHAR2 DEFAULT NULL
  ) RETURN RAW;
  

-- Add a rule to a configuration standard.
FUNCTION add_rule(
  p_cs_guid                  VARCHAR2,
  p_rule_iname               VARCHAR2, 
  p_rule_dname               VARCHAR2,
  p_parent_guid              VARCHAR2,
  p_child_position           NUMBER,
  p_test                     VARCHAR2 DEFAULT NULL,
  p_importance_level         NUMBER   DEFAULT MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
  p_test_type                NUMBER   DEFAULT NULL,
  p_reference_url            VARCHAR2 DEFAULT NULL,
  p_description              VARCHAR2 DEFAULT NULL,
  p_rationale                VARCHAR2 DEFAULT NULL,
  p_fixtext                  VARCHAR2 DEFAULT NULL,
  p_warning                  VARCHAR2 DEFAULT NULL,
  p_message                  VARCHAR2 DEFAULT NULL,
  p_clear_message            VARCHAR2 DEFAULT NULL,
  p_violctx_list             MGMT_CS_VIOL_COLUMN_ARRAY DEFAULT NULL,
  p_fixlink_list             MGMT_CS_FIX_LINK_ARRAY DEFAULT NULL,
  p_change_advisor_tag       MGMT_CS_CHANGE_ADVISOR_ARRAY DEFAULT NULL,
  p_simple_test_list         MGMT_CS_SIMPLE_TEST_ARRAY DEFAULT NULL,
  p_simple_test_condition    NUMBER DEFAULT NULL
  ) RETURN RAW;

-- Add an inclusion to a configuration standard.
PROCEDURE add_include_std(
     p_cs_guid                  VARCHAR2,
     p_cs_iname                 VARCHAR2,
     p_cs_author                VARCHAR2,
     p_cs_version               NUMBER,
     p_context_query            VARCHAR2 DEFAULT NULL,
     p_override_params          MGMT_CS_PARAM_OVER_ARRAY DEFAULT NULL,
     p_parent_guid              VARCHAR2,
     p_child_position           NUMBER
  );

-- Delete a configuration standard
PROCEDURE delete_config_standard(
      p_cs_iname              VARCHAR2,
      p_version               NUMBER,
      p_author                VARCHAR2 DEFAULT 'ORACLE');
  
--
-- PURPOSE
--
-- To evaluate the given configuration standard for bunch of targets.
--
-- Parameters
-- p_config_std_namee : Configuration Standard Name
-- p_config_std_owner : Configuration Standard Owner
-- p_version : Version of the configuration standard
-- p_targets_list : MGMT_TARGET_ARRAY having the list of MGMT_TARGET_OBJ
--
PROCEDURE evaluate_config_std(              
              p_config_std_name     IN VARCHAR2,
              p_config_std_author   IN VARCHAR2,
              p_version             IN NUMBER DEFAULT 1,              
              p_targets_list        IN MGMT_TARGET_ARRAY);            

-- Submit the evaluation of a configuration standard.    
PROCEDURE submit_job(
    p_cs_guid          IN RAW,
    p_eval_name        IN VARCHAR2,
    p_description      IN VARCHAR2,
    p_params           IN MGMT_JOB_PARAM_LIST,
    p_schedule         IN OUT MGMT_JOB_SCHEDULE_RECORD,
    p_job_id_out       OUT RAW,
    p_execution_id_out OUT RAW);
  
-- Retrieve settings of a scheduled evaluation.
PROCEDURE get_job_info(
    p_job_id           IN  VARCHAR2,
    p_eval_name_out    OUT VARCHAR2,
    p_description_out  OUT VARCHAR2,
    p_params_out       OUT MGMT_JOB_PARAM_LIST,
    p_schedule_out     OUT MGMT_JOB_SCHEDULE_RECORD);
    
-- Update settings of a scheduled evaluation.
PROCEDURE edit_job(  
    p_job_id           IN VARCHAR2,
    p_description      IN VARCHAR2,
    p_params           IN MGMT_JOB_PARAM_LIST,
    p_schedule         IN MGMT_JOB_SCHEDULE_RECORD);
      
-- Delete a scheduled evaluation.
PROCEDURE delete_job(    
    p_job_id           IN VARCHAR2);                     

-- Callback procedure for cleaning up of the saved schedule evaluations associated with
-- the evaluation job being deleted.    
PROCEDURE on_comp_job_delete_callback(
    p_reason NUMBER, 
    p_status NUMBER, 
    p_job_id RAW, 
    p_execution_id RAW);
              
--
-- PURPOSE
--
-- To delete the evaluation results of the given configuration standard for all
-- the targets for which the user has the operator target privileges.
--
-- Parameters
-- p_config_std_namee : Configuration Standard Name
-- p_config_std_owner : Configuration Standard Owner
-- p_version : Version of the configuration standard
--
PROCEDURE delete_cs_eval_results (
              p_config_std_name VARCHAR2,
              p_config_std_author VARCHAR2,
              p_config_std_version  NUMBER);
         
              
--
-- PURPOSE
--
-- To delete the evaluation results of the given configuration standard for all targets 
-- for which the user has operator target privileges.
--
-- Parameters
-- p_config_std_guid : Configuration Standard GUID
--
PROCEDURE delete_cs_eval_results (p_config_std_guid RAW);               

              
--
-- PURPOSE
--
-- To export the standard specified by standard name, author and version
-- returns an object of standard type and this will be read in java to 
-- create xml file out of this.
--
-- Parameters
-- p_cs_iname   : Configuration Standard Name
-- p_cs_author  : Configuration Standard Author
-- p_cs_version : Configuration Standard Version
--
FUNCTION export_config_standard(
   p_cs_iname		 VARCHAR2,
   p_cs_author		 VARCHAR2,
   p_cs_version		 VARCHAR2
   ) RETURN MGMT_CS_STANDARD_DEF;

--
-- PURPOSE
--
-- To export the standard rules specified by standard guid
-- returns an object of rule type and this will be read in java to 
-- create xml file out of this.
--
-- Parameters
-- p_cs_guid : Configuration Standard Guid
--
FUNCTION export_cs_rules(
   p_cs_guid		 RAW
   ) RETURN MGMT_CS_RULE_ARRAY;

--
-- PURPOSE
--
-- To export the standard rulefolder specified by standard guid
-- returns an object of standard rulefolder type and this will be read in java to 
-- create xml file out of this.
--
-- Parameters
-- p_cs_guid   : Configuration Standard Guid
--
FUNCTION export_cs_rulefolders(
   p_cs_guid		 RAW
   ) RETURN MGMT_CS_RULEFOLDER_ARRAY;

-- PURPOSE
--
-- To export the standard inclusions specified by standard guid
-- returns an object of standard inclusions type and this will be read in java to 
-- create xml file out of this.
--
-- Parameters
-- p_cs_guid   : Configuration Standard guid
--
FUNCTION export_cs_inclusions(
   p_cs_guid		 RAW
   ) RETURN MGMT_CS_INCLUSION_ARRAY;

-- PURPOSE
--
-- To export the standard hierarchy specified by standard guid
-- returns an object of standard hierarchy type and this will be read in java to 
-- create xml file out of this.
--
-- Parameters
-- p_cs_guid   : Configuration Standard guid
--
FUNCTION export_cs_hierarchy(
   p_cs_guid		 RAW
   ) RETURN MGMT_CS_HIERARCHY_ARRAY;
              
END mgmt_config_std;
/

show errors;
