Rem
Rem $Header: sdk_console_page_custmzn_pkgdef.sql 04-aug-2005.12:31:16 vesriniv Exp $
Rem
Rem sdk_console_page_custmzn_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_console_page_custmzn_pkgdef.sql - This sql has delcarion for SDK API to access 
Rem                                             customization framework.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vesriniv    08/04/05 - vesriniv_custtxn
Rem    vesriniv    06/06/05 - created
Rem    

CREATE OR REPLACE PACKAGE mgmt_page_custmzn AS

TYPE cursorType IS REF CURSOR;

--
-- PROCEDURE: add_page_customzn_conditions 
-- PURPOSE: To add the page to customization data
--
-- PARAMETERS :
--   p_page_name : Name of the UI page which supports customization
--
--   p_conditions: A list of name/value pairs containing condition data.
--                         Example: type, ocs_email_system
--
--   p_customizations:   A list of customization for the condition and given page
--                         Example: disallow_member_target, true
--
-- ERROR CODES:
--       NO_SUCH_PAGE_EXISTS : The requested page name doesnt exists in the metadata table 
--       INVALID_CUSTOMIZATION_NAME : The customization name doesnt exists in the metadata table
--       INVALID_CONDITION_NAME : The condtion name doesnt exists in the metadata table
--
PROCEDURE add_page_customzn_conditions (
	p_page_name IN VARCHAR2,
	p_customizations IN SMP_EMD_NVPAIR_ARRAY,
	p_conditions IN SMP_EMD_NVPAIR_ARRAY
);

--
-- PROCEDURE: remove_page_customzn_condns 
-- PURPOSE: To remove the page to customization data
--
-- PARAMETERS :
--   p_page_name : Name of the UI page which supports customization
--
--   p_conditions: A list of name/value pairs containing condition data.
--                         Example: type, ocs_email_system
--
--   p_customizations:   A list of customization for the condition and given page
--                         Example: disallow_member_target, true
--
-- ERROR CODES:
--       NO_SUCH_PAGE_EXISTS : The requested page name doesnt exists in the metadata table 
--       INVALID_CONDITION_NAME : The given condition name doesnt exist for the page in 
--                                in metadata table
--       INVALID_CUSTOMIZATION_NAME : The given customization name doesnt exist for the page in 
--                                in metadata table
--

PROCEDURE remove_page_customzn_condns (
	p_page_name IN VARCHAR2,
	p_customizations IN SMP_EMD_NVPAIR_ARRAY,
	p_conditions IN SMP_EMD_NVPAIR_ARRAY
);

END mgmt_page_custmzn;
/
show errors;

