Rem
Rem $Header: sdk_group_pkgbody.sql 16-may-2005.11:33:42 dtsao Exp $
Rem
Rem sdk_group_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_group_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dtsao       05/16/05 - continue
Rem    dtsao       05/12/05 - continue
Rem    dtsao       05/11/05 - add type and instance initialization APIs 
Rem    dtsao       05/02/05 - Add APPLY_TARGET_UI_CUSTOMIZATIONS proc 
Rem    ramalhot    03/15/05 - Red group can't be empty 
Rem    ramalhot    03/11/05 - add group and modify_group now refers to 
Rem                           em_target pkg 
Rem    pmodi       02/23/05 - set default p_timezone_rgn to NULL in 
Rem                           create_group 
Rem    gan         12/01/04 - add is_group 
Rem    streddy     11/08/04 - Added redundancy group APIs 
Rem    streddy     11/04/04 - streddy_sdk_groups_api
Rem    streddy     11/04/04 - Created
Rem


CREATE OR REPLACE PACKAGE BODY mgmt_group AS


-- API to create a group
PROCEDURE create_group(p_group_name IN VARCHAR2,
                       p_group_type IN VARCHAR2,
                       p_member_targets IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                       p_group_owner       IN VARCHAR2 DEFAULT NULL,
                       p_timezone_rgn IN VARCHAR2 DEFAULT NULL )
IS
BEGIN
   em_group.create_group(p_group_name, p_group_type,
                      p_member_targets, p_group_owner,
                      p_timezone_rgn);
END create_group;

-- API to modify a group
PROCEDURE modify_group(p_group_name IN VARCHAR2,
                       p_group_type IN VARCHAR2,
                       p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                       p_group_owner       IN VARCHAR2 DEFAULT NULL)
IS
BEGIN
   em_group.modify_group(p_group_name, p_group_type,
                         p_targets_to_add, p_targets_to_remove,
                         p_group_owner);
END modify_group;

-- Default chart API implementation
PROCEDURE add_default_chart(p_target_type   IN VARCHAR2,
                            p_chart_type    IN NUMBER,
                            p_member_type   IN VARCHAR2,
                            p_member_metric IN VARCHAR2,
                            p_member_column IN VARCHAR2,
                            p_targets_count IN NUMBER DEFAULT 2,
                            p_min_column    IN NUMBER DEFAULT 0,
                            p_max_column    IN NUMBER DEFAULT 0,
                            p_avg_column    IN NUMBER DEFAULT 0,
                            p_sum_column    IN NUMBER DEFAULT 0,
                            p_stdev_column  IN NUMBER DEFAULT 0
)
IS
BEGIN
   em_groups_ui.add_default_chart(p_target_type,
                                  p_chart_type,
                                  p_member_type,
                                  p_member_metric,
                                  p_member_column,
                                  p_targets_count,
                                  p_min_column,
                                  p_max_column,
                                  p_avg_column,
                                  p_sum_column,
                                  p_stdev_column);
END  add_default_chart;



-- Create a new redundancy group
PROCEDURE create_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY
                                              DEFAULT NULL,
                                  p_rgroup_owner IN VARCHAR2
                                              DEFAULT NULL,
                                  p_timezone_rgn IN VARCHAR2 DEFAULT
                                        TO_CHAR(SYSTIMESTAMP,'TZR'))
IS
BEGIN
  --
  -- Make sure all member types are of the same type
  -- 
  IF (p_member_targets IS NULL OR p_member_targets.COUNT = 0) THEN
    raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
          'Empty members list passed to create_redundancy_group');
  END IF;
  emd_redundancy_group.create_redundancy_group(p_rgroup_name,
                                               p_rgroup_type,
                                               p_member_targets,
                                               p_rgroup_owner,
                                               p_timezone_rgn);
END create_redundancy_group;

			       
-- Modifies an existing redundancy group
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL)
IS
BEGIN
  emd_redundancy_group.modify_redundancy_group(p_rgroup_name,
                                               p_rgroup_type,
                                               p_member_targets,
                                               p_rgroup_owner);
END modify_redundancy_group;

-- Modifies an existing redundancy group
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                                  p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL)

IS
BEGIN
  emd_redundancy_group.modify_redundancy_group(p_rgroup_name,
                                               p_rgroup_type,
                                               p_targets_to_add,
                                               p_targets_to_remove,
                                               p_rgroup_owner);

END modify_redundancy_group;

-- Returns the list of member target types eligible for
-- creating generic redundancy group types
FUNCTION get_rgroup_eligible_mtypes(p_exclude_empty_types IN NUMBER DEFAULT 1)
   RETURN MGMT_SHORT_STRING_ARRAY
IS
  l_types_array MGMT_SHORT_STRING_ARRAY;
BEGIN
  IF (p_exclude_empty_types = 1) THEN
    SELECT target_type
      BULK COLLECT INTO l_types_array
      FROM (
       SELECT DISTINCT target_type
         FROM mgmt_metrics
        WHERE metric_name = mgmt_global.G_AVAIL_METRIC_NAME
          AND metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN
       MINUS
       SELECT DISTINCT target_type
         FROM mgmt_type_properties
        WHERE property_name  = mgmt_global.G_DISALLOW_REDUNDANCY_GROUP 
          AND property_value = mgmt_global.G_TRUE
       INTERSECT
       SELECT DISTINCT target_type
         FROM mgmt_targets
      );
  ELSE
    SELECT target_type
      BULK COLLECT INTO l_types_array
      FROM (
       SELECT DISTINCT target_type
         FROM mgmt_metrics
        WHERE metric_name = mgmt_global.G_AVAIL_METRIC_NAME
          AND metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN
       MINUS
       SELECT DISTINCT target_type
         FROM mgmt_type_properties
        WHERE property_name  = mgmt_global.G_DISALLOW_REDUNDANCY_GROUP 
          AND property_value = mgmt_global.G_TRUE
       );
  END IF;
  RETURN l_types_array;

END get_rgroup_eligible_mtypes;

FUNCTION is_group(p_type_name IN VARCHAR2) RETURN NUMBER
AS
l_ret NUMBER;
BEGIN
  l_ret := mgmt_target.get_type_property(p_type_name, 
                                         MGMT_GLOBAL.G_IS_GROUP_PROP,
                                         '0');
  RETURN l_ret;
END is_group;

FUNCTION is_redundancy_group(p_type_name IN VARCHAR2) RETURN NUMBER
AS
l_ret NUMBER;
BEGIN
  l_ret := mgmt_target.get_type_property(p_type_name, 
                                         MGMT_GLOBAL.G_IS_REDUNDANCY_GROUP_PROP,
                                         '0');
  RETURN l_ret;
END is_redundancy_group;

PROCEDURE apply_target_ui_defaults(
                       p_target_name        IN mgmt_targets.target_name%TYPE,
                       p_target_type        IN mgmt_targets.target_type%TYPE,
                       p_targets_to_add     IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove  IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL
)
IS
BEGIN
    em_groups_ui.apply_target_ui_defaults(p_target_name,
                                  p_target_type,
                                  p_targets_to_add,
                                  p_targets_to_remove);
END apply_target_ui_defaults;


PROCEDURE setup_type_ui_metadata(
                       p_target_type_in         IN mgmt_targets.target_type%TYPE
)
IS
BEGIN
    em_groups_ui.setup_type_ui_metadata(p_target_type_in);
END setup_type_ui_metadata;

END mgmt_group;

/
show errors;
