Rem
Rem $Header: sdk_group_pkgdef.sql 16-may-2005.11:35:06 dtsao Exp $
Rem
Rem sdk_group_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_group_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dtsao       05/16/05 - continue
Rem    dtsao       05/12/05 - continue
Rem    dtsao       05/12/05 - continue
Rem    dtsao       05/11/05 - add type and instance ui initialization APIs 
Rem    dtsao       05/02/05 - Add APPLY_TARGET_UI_CUSTOMIZATIONS proc 
Rem    dtsao       03/02/05 - Add comment for add_default_chart 
Rem    pmodi       02/23/05 - set default p_timezone_rgn to NULL in 
Rem                           create_group 
Rem    ramalhot    12/29/04 - chart constants added 
Rem    gan         12/01/04 - add is_group 
Rem    streddy     11/08/04 - Added redundancy group APIs 
Rem    streddy     11/04/04 - streddy_sdk_groups_api
Rem    streddy     11/04/04 - Created
Rem


--
-- This package provides APIs to create, modify, and
-- delete groups.
--

CREATE OR REPLACE PACKAGE mgmt_group
AS

  --Supported Chart Types
  CHART_SELECTED_TARGETS CONSTANT NUMBER(1) := 1;
  CHART_PEAK_TARGETS     CONSTANT NUMBER(1) := 2;
  CHART_HIGHEST_TARGETS  CONSTANT NUMBER(1) := 3;
  CHART_LOWEST_TARGETS   CONSTANT NUMBER(1) := 4;
  CHART_SUMMARY_METRIC   CONSTANT NUMBER(1) := 5;

-- Supported default chart types. 
G_CHART_PEAK_TARGETS        NUMBER(1) := 2;
G_CHART_HIGHEST_TARGETS     NUMBER(1) := 3;
G_CHART_LOWEST_TARGETS      NUMBER(1) := 4;
G_CHART_SUMMARY_METRIC      NUMBER(1) := 5;

--
-- PROCEDURE: create_group
--
-- PURPOSE:
--   Create a new group with the specified name and member targets. The
--   valid target types that can be passed to this call are types that
--   have the type property is_group set to 1.
--
-- IN Parameters:
--   p_group_name: The name of the group
--   p_group_type: The type of the group
--   p_member_targets: The member targets to add to the group
--   p_group_owner : the owner of the group if not specified it is 
--                   default to G_DEFAULT_TARGET_OWNER <SYSTEM>
--   p_timezone_rgn : Default value of this parameter should not be set as timezone of SYSTIMESTAMP 
--                    because if there is no time zone set for repository DB then SYSTIMESTAMP would 
--                    return only offset value and not the correct timezone of repositoty.
--                    And hence if p_timezone_rgn is NULL, at the time of adding group then system will 
--                    read default time zone defined for EM repository in MGMT_PARAMETERS. 
--                    It is always desirable that user should pass correct value of timezone, for group which is being added. 
--
-- OUT Parameters:
--    NONE
--
PROCEDURE create_group(p_group_name IN VARCHAR2,
                       p_group_type IN VARCHAR2,
                       p_member_targets IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                       p_group_owner       IN VARCHAR2 DEFAULT NULL,
                       p_timezone_rgn IN VARCHAR2 DEFAULT NULL ) ;


--
-- PROCEDURE: modify_group
--
-- PURPOSE:
--   Modify the specified group with a set of targets to add and/or
--   delete. 
--
-- IN Parameters:
--   p_group_name: The name of the group
--   p_group_type: The type of the group
--   p_targets_to_add: The member targets to add to the group
--   p_targets_to_remove: The member targets to remove from the group
--   p_group_owner : the new owner of the group. If NULL, the owner of
--                   the group is unchanged.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_group(p_group_name IN VARCHAR2,
                       p_group_type IN VARCHAR2,
                       p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                       p_group_owner       IN VARCHAR2 DEFAULT NULL);


--
-- PURPOSE:
--  Add a default custom chart
--    applies to any aggregate type that uses the groups admin UIs, for eg.,
--    composite, generic_system, generic_redundancy_group, ocs system
--
-- INPUT:
--   p_target_type: The target type (of the aggregate). 
--      Specify MGMT_GLOBAL.ANY_TARGET_TYPE to register the default chart 
--      to all applicable aggregate types 
--   p_chart_type: chart type can be:
--      mgmt_group.G_CHART_PEAK_TARGETS
--      mgmt_group.G_CHART_HIGHEST_TARGETS
--      mgmt_group.G_CHART_LOWEST_TARGETS
--      mgmt_group.G_CHART_SUMMARY_METRIC
--   p_member_type: The member target type
--   p_member_metric: The member metric
--   p_member_column: The member column
--   p_targets_count: number of targets to be shown in the chart
--    ONLY applicable if chart type is 
--      mgmt_group.G_CHART_PEAK_TARGETS
--      mgmt_group.G_CHART_HIGHEST_TARGETS
--      mgmt_group.G_CHART_LOWEST_TARGETS
--   The following parameters only apply to:
--     chart type : mgmt_group.G_CHART_SUMMARY_METRIC
--   p_min_column: should we show Minimum column
--   p_max_column: should we show Maximum column
--   p_avg_column: should we show Average column
--   p_sum_column: should we show Sum column
--   p_stdev_column: should we show Standard Deviation column
--
-- OUT Parameters:
--   NONE.
--
PROCEDURE add_default_chart(p_target_type   IN VARCHAR2,
                            p_chart_type    IN NUMBER,
                            p_member_type   IN VARCHAR2,
                            p_member_metric IN VARCHAR2,
                            p_member_column IN VARCHAR2,
                            p_targets_count IN NUMBER DEFAULT 2,
                            p_min_column    IN NUMBER DEFAULT 0,
                            p_max_column    IN NUMBER DEFAULT 0,
                            p_avg_column    IN NUMBER DEFAULT 0,
                            p_sum_column    IN NUMBER DEFAULT 0,
                            p_stdev_column  IN NUMBER DEFAULT 0);

--
-- PROCEDURE: create_redundancy_group
--
-- PURPOSE:
--   Create a new redundancy group with the specified name and member
--   targets. The valid target types that can be passed to this call
--   are types that have the type property is_cluster set to 1 and
--   is_group set to 1. In addition, all the member targets must be
--   of the same type. 
--
-- IN Parameters:
--   p_rgroup_name: The name of the redundancy group
--   p_rgroup_type: The type of the redundancy group
--   p_member_targets: The member targets to add to the group
--   p_group_owner : the owner of the group if not specified it is 
--                   default to G_DEFAULT_TARGET_OWNER <SYSTEM>
--  p_timezone_rgn: timezone region
--
-- OUT Parameters:
--    NONE
-- EXCEPTIONS:
--    NOT_SAME_TARGET_TYPE_ERR_M : If the members are not of the same
--                                 type
--
PROCEDURE create_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY
                                             DEFAULT NULL,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL,
                                  p_timezone_rgn IN VARCHAR2 DEFAULT
                                        TO_CHAR(SYSTIMESTAMP,'TZR'));

--
-- PROCEDURE: modify_redundancy_group
--
-- PURPOSE:
--   Modify the specified redundancy group with a set of targets to 
--   add and/or delete. 
--
-- IN Parameters:
--   p_rgroup_name: The name of the group
--   p_rgroup_type: The type of the group
--   p_member_targets: The member targets to add to the group
--   p_rgroup_owner : the new owner of the group
--
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL);

--
-- PROCEDURE: modify_redundancy_group
--
-- PURPOSE:
--   Modify the specified redundancy group with a set of targets 
--   to add and/or delete. 
--
-- IN Parameters:
--   p_group_name: The name of the group
--   p_group_type: The type of the group
--   p_targets_to_add: The member targets to add to the group
--   p_targets_to_remove: The member targets to remove from the group
--   p_group_owner : the new owner of the group. If NULL, the owner of
--                   the group is unchanged.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                                  p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL);


--
-- FUNCTION: get_rgroup_eligible_mtypes
--
-- PURPOSE:
--  Returns the list of member target types that are 
--  valid when creating an instance of the generic
--  redundancy (mgmt_global.G_REDUNDANCY_GROUP_TARGET_TYPE)
--  group type.
--
-- IN Parameters
--     p_exclude_empty_types:  '1' - to exclude types that don't have
--                              any instances
--                             '0' - not to include
--
--
FUNCTION get_rgroup_eligible_mtypes(p_exclude_empty_types IN NUMBER DEFAULT 1)
   RETURN MGMT_SHORT_STRING_ARRAY;


-- 
-- PURPOSE: check given type is a group type
-- PARAM IN:
--  p_type_name
-- RETURN:
--   1 for yes, 0 for no
--
FUNCTION is_group(p_type_name IN VARCHAR2) RETURN NUMBER;

-- 
-- PURPOSE: check given type is a redundancy group type
-- PARAM IN:
--  p_type_name
-- RETURN:
--   1 for yes, 0 for no
--
FUNCTION is_redundancy_group(p_type_name IN VARCHAR2) RETURN NUMBER;

--
-- PROCEDURE: SETUP_TYPE_UI_METADATA
--
-- PURPOSE:
--   Sets up type specific UI metadata for the types with is_group/
--   is_redundancy type property set.
--   This API must be called  immediately after the type is registered.
--
-- IN Parameters:
--   p_target_type_in: The type of the target for which ui metadata needs
--                     to be setup.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE setup_type_ui_metadata(p_target_type_in IN mgmt_targets.target_type%TYPE);

--
-- PROCEDURE: APPLY_TARGET_UI_DEFAULTS
--
-- PURPOSE:
--   Applies UI specific customizations to the specified target instance.
--   The API in this package supports target instances of types with
--   is_group/is_redundancy type property set.
--
-- IN Parameters:
--   p_target_name: The name of the target
--   p_target_type: The type of the target
--   p_targets_to_add: If called after creation, use the same value
--                     specified in the p_member_targets param during creation.
--                     If called after modification, use the same value
--                     specified in p_targets_to_add param during modification
--   p_targets_to_remove: only applicable after modification, use the same
--                    value specified in p_targets_to_remove param during
--                    modification
--
-- OUT Parameters:
--    NONE
--
PROCEDURE apply_target_ui_defaults(
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
    p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL);

END mgmt_group;
/

show errors;
