Rem
Rem $Header: sdk_jobs_pkgdef.sql 24-may-2007.02:27:00 kmanicka Exp $
Rem
Rem sdk_jobs_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_jobs_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
rem     This is the PL/SQL SDK interface to the job system
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  (MM/DD/YY)
Rem    kmanicka   05/24/07 - Implement 10.2.0.4 Trusted RemoteOp
Rem    rdabbott   05/22/07 - bug 5714960b: desupport user suspend with timeout
Rem    dcawley    08/30/05 - Add job grants 
Rem    dsahrawa   07/05/05 - bug 4148622, command block rewrite 
Rem    rdabbott   04/26/05 - Fix 4316792: stop job run 
Rem    pkantawa   03/28/05 - Add reassigned exec status 
Rem    skini      04/13/05 - Broken CAs 
Rem    pkantawa   03/07/05 - add delete pending status 
Rem    kmanicka   03/07/05 - Impl IMMEDIATE Schedule
Rem    skini      08/14/04 - Add constants for uri use 
Rem    kmanicka   07/20/04 - Added support for retry Callback and new restart APIs
Rem    skini      07/19/04 - Add notification support 
Rem    dsahrawa   06/08/04 - skipped executions implementation 
Rem    rdabbott   02/23/04 - don't expose status2 
Rem    rdabbott   01/30/04 - Fix 3256113: create 'active' bucket 
Rem    rdabbott   10/28/03 - bug 3209093: fix buckets 
Rem    tzimmerm   10/24/03 - 
Rem    tzimmerm   10/23/03 - \042Add 
Rem    skini      10/02/03 - Add delete_job_run 
Rem    skini      10/01/03 - Return the execution ids 
Rem    skini      09/30/03 - Submit job to queue 
Rem    skini      09/30/03 - Add status bucket column 
Rem    skini      09/10/03 - Implement suspend job 
Rem    skini      09/09/03 - Add timezone_rgn_specified 
Rem    skini      09/08/03 - Add target type to submit_job API 
Rem    skini      09/02/03 - Add overridden credentials to create_library_job 
Rem    skini      08/31/03 - Add overridden creds to edit_job 
Rem    skini      08/25/03 - Continue with groups impl 
Rem    skini      08/23/03 - Changes to make job name/owner unique 
Rem    skini      08/18/03 - Add override credentials support 
Rem    skini      07/16/03 - Job library support
Rem    skini      06/20/03 - Add edit_job
Rem    skini      06/11/03 - Large parameter support
Rem    skini      11/22/02 - Blackout windows
Rem    rdabbott   09/30/02 - restart job by execid
Rem    skini      09/16/02 - Remove references to suspended serialized status
Rem    skini      08/28/02 - Implement suspend timeout
Rem    skini      08/27/02 - Implement event-based suspends
Rem    skini      06/07/02 - Changes to support TIMEZONE_SPECIFIED
Rem    rpinnama   05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama   05/15/02 - Created
rem    skini      04/18/02 - SMP_MGMT_JOB=>MGMT_JOB
rem    rpatti     02/25/02 - use function to get current user
rem    skini      02/27/02 - Implement option to nuke system jobs
rem    skini      01/29/02 - Change signature of schedule_job
rem    skini      01/31/02 - history table
rem    skini      01/29/02 - Change signature of schedule_job
rem    skini      01/24/02 - Schedules, contd
rem    skini      01/18/02 - Implement security info, purging, schedules
rem    rpinnama   01/17/02 - Add pingCfmEMDDown command
rem    skini      01/16/02 - Encryption, system jobs
rem    skini      12/28/01 - Fix restart_job to return value
rem    skini      12/26/01 - Catch incorrectly specified parameters
rem    rpinnama   12/12/01 - Add support for switch step set.
rem    shuberma   12/07/01 - Adding a new command for downloading a patch zip file..
rem    mgoodric   11/29/01 - Add PatchEMD job type
rem    skini      11/21/01 - Fix restart param copy
rem    skini      11/20/01 - Resubmit
rem    skini      11/18/01 - Add repSQL command
rem    skini      11/14/01 - Add parameter to registerCommand
rem    mgoodric   11/09/01 - Create a new PatchOneOff job type
rem    vkhizder   11/06/01 - adding snapshot collection job command
rem    skini      11/04/01 - Implement restart
rem    skini      10/31/01 - Register fileTransfer command
rem    tjaiswal   10/25/01 - Fix raise error
rem    skini      10/22/01 - Introduce suspendJob
rem    skini      10/15/01 - Ensure all targets are genuine
rem    skini      10/04/01 - Register email command
rem    shuberma   09/28/01 - Adding ecm patch notify command type..
rem    skini      09/24/01 - Add echoParams command
rem    skini      09/14/01 - Handle error cases
Rem

CREATE OR REPLACE  PACKAGE MGMT_JOBS
AS

-- Constants for frequency codes
IMMEDIATE_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.IMMEDIATE_FREQUENCY_CODE;
ONE_TIME_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.ONE_TIME_FREQUENCY_CODE;
INTERVAL_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.INTERVAL_FREQUENCY_CODE;
DAILY_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.DAILY_FREQUENCY_CODE;
WEEK_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.WEEK_FREQUENCY_CODE;
MONTH_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.MONTH_FREQUENCY_CODE;
YEAR_FREQUENCY_CODE constant NUMBER(1) := MGMT_JOB_ENGINE.YEAR_FREQUENCY_CODE;

-- Constants for timezone values
TIMEZONE_REPOSITORY constant NUMBER(1) := MGMT_JOB_ENGINE.TIMEZONE_REPOSITORY;
TIMEZONE_TARGET constant NUMBER(1) := MGMT_JOB_ENGINE.TIMEZONE_TARGET;
TIMEZONE_SPECIFIED constant NUMBER(1) := MGMT_JOB_ENGINE.TIMEZONE_SPECIFIED;
TIMEZONE_RGN_SPECIFIED constant NUMBER(1) := MGMT_JOB_ENGINE.TIMEZONE_RGN_SPECIFIED;

-- Constants for job status
JOB_STATUS_ACTIVE constant NUMBER(2) := MGMT_JOB_ENGINE.JOB_STATUS_ACTIVE;
JOB_STATUS_SUSPENDED constant NUMBER(2) := MGMT_JOB_ENGINE.JOB_STATUS_SUSPENDED;
JOB_STATUS_STOPPED constant NUMBER(2) := MGMT_JOB_ENGINE.JOB_STATUS_STOPPED;
JOB_STATUS_REASSIGNED constant NUMBER(2) := MGMT_JOB_ENGINE.JOB_STATUS_REASSIGNED;
JOB_STATUS_EXPIRED constant NUMBER(2) := MGMT_JOB_ENGINE.JOB_STATUS_EXPIRED;
JOB_STATUS_DELETE_PENDING   constant NUMBER(2)  := MGMT_JOB_ENGINE.JOB_STATUS_DELETE_PENDING;


-- Constants for status
SCHEDULED_STATUS            constant NUMBER(2) := MGMT_JOB_ENGINE.SCHEDULED_STATUS;
EXECUTING_STATUS            constant NUMBER(2) := MGMT_JOB_ENGINE.EXECUTING_STATUS;
ABORTED_STATUS              constant NUMBER(2) := MGMT_JOB_ENGINE.ABORTED_STATUS;
FAILED_STATUS               constant NUMBER(2) := MGMT_JOB_ENGINE.FAILED_STATUS;
COMPLETED_STATUS            constant NUMBER(2) := MGMT_JOB_ENGINE.COMPLETED_STATUS;
SUSPENDED_STATUS            constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPENDED_STATUS;
AGENTDOWN_STATUS            constant NUMBER(2) := MGMT_JOB_ENGINE.AGENTDOWN_STATUS;
STOPPED_STATUS              constant NUMBER(2) := MGMT_JOB_ENGINE.STOPPED_STATUS;
SUSPENDED_LOCK_STATUS       constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPENDED_LOCK_STATUS;
SUSPENDED_EVENT_STATUS      constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPENDED_EVENT_STATUS;
SUSPENDED_BLACKOUT_STATUS   constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPENDED_BLACKOUT_STATUS;
STOP_PENDING_STATUS         constant NUMBER(2) := MGMT_JOB_ENGINE.STOP_PENDING_STATUS;
SUSPEND_PENDING_STATUS      constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPEND_PENDING_STATUS;
INACTIVE_STATUS             constant NUMBER(2) := MGMT_JOB_ENGINE.INACTIVE_STATUS;
QUEUED_STATUS               constant NUMBER(2) := MGMT_JOB_ENGINE.QUEUED_STATUS;
FAILED_RETRIED_STATUS       constant NUMBER(2) := MGMT_JOB_ENGINE.FAILED_RETRIED_STATUS;
WAITING_STATUS              constant NUMBER(2) := MGMT_JOB_ENGINE.WAITING_STATUS;
SKIPPED_STATUS              constant NUMBER(2) := MGMT_JOB_ENGINE.SKIPPED_STATUS;
DELETE_PENDING_STATUS       constant NUMBER(2) := MGMT_JOB_ENGINE.DELETE_PENDING_STATUS;
REASSIGNED_STATUS           constant NUMBER(2) := MGMT_JOB_ENGINE.REASSIGNED_STATUS;
SUSPENDED_CREDS_STATUS      constant NUMBER(2) := MGMT_JOB_ENGINE.SUSPENDED_CREDS_STATUS;

-- Constants for status buckets
STATUS_BUCKET_SCHEDULED     CONSTANT NUMBER(3) := MGMT_JOB_ENGINE.STATUS_BUCKET_SCHEDULED;
STATUS_BUCKET_RUNNING       CONSTANT NUMBER(3) := MGMT_JOB_ENGINE.STATUS_BUCKET_RUNNING; 
STATUS_BUCKET_SUSPENDED     CONSTANT NUMBER(3) := MGMT_JOB_ENGINE.STATUS_BUCKET_SUSPENDED;
STATUS_BUCKET_OK            CONSTANT NUMBER(3) := MGMT_JOB_ENGINE.STATUS_BUCKET_OK;
STATUS_BUCKET_PROBLEM       CONSTANT NUMBER(3) := MGMT_JOB_ENGINE.STATUS_BUCKET_PROBLEM; 

STATUS_BUCKET_ACTIVE        CONSTANT NUMBER(4) := MGMT_JOB_ENGINE.STATUS_BUCKET_ACTIVE;
STATUS_BUCKET_ALL           CONSTANT NUMBER(4) := MGMT_JOB_ENGINE.STATUS_BUCKET_ALL; 

-- Constants for command type
SHORT_RUNNING_COMMAND constant NUMBER(1) :=
    MGMT_JOB_ENGINE.SHORT_RUNNING_COMMAND;
LONG_RUNNING_COMMAND constant NUMBER(1) :=
    MGMT_JOB_ENGINE.LONG_RUNNING_COMMAND;
SYSTEM_COMMAND constant NUMBER(1) :=
    MGMT_JOB_ENGINE.SYSTEM_COMMAND;
WAIT_COMMAND constant NUMBER(1) :=
    MGMT_JOB_ENGINE.WAIT_COMMAND;

-- Constants for purge criteria
TARGET_CRITERION constant NUMBER(1) := MGMT_JOB_ENGINE.TARGET_CRITERION;
JOBTYPE_CRITERION constant NUMBER(1) := MGMT_JOB_ENGINE.JOBTYPE_CRITERION;
USER_CRITERION constant NUMBER(1) := MGMT_JOB_ENGINE.USER_CRITERION;
JOBNAME_CRITERION constant NUMBER(1) := MGMT_JOB_ENGINE.JOBNAME_CRITERION;

-- Constants for callback types
EXECUTION_SUSPENDED_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.EXECUTION_SUSPENDED_CALLBACK;
EXECUTION_RESUMED_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.EXECUTION_RESUMED_CALLBACK;
EXECUTION_STOPPED_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.EXECUTION_STOPPED_CALLBACK;
EXECUTION_DELETED_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.EXECUTION_DELETED_CALLBACK;
JOB_DELETED_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.JOB_DELETED_CALLBACK;
JOB_RETRY_CALLBACK constant NUMBER(1) := 
          MGMT_JOB_ENGINE.JOB_RETRY_CALLBACK;

-- Constants for parameter types
PARAM_TYPE_VECTOR constant NUMBER(1) := MGMT_JOB_ENGINE.PARAM_TYPE_VECTOR;
PARAM_TYPE_SCALAR constant NUMBER(1) := MGMT_JOB_ENGINE.PARAM_TYPE_SCALAR;
PARAM_TYPE_LARGE constant NUMBER(1) := MGMT_JOB_ENGINE.PARAM_TYPE_LARGE;

-- Constants for URI use
URI_USE_PARAMETERS_INCLUDE CONSTANT NUMBER(2) := 0;
URI_USE_RESULTS_INCLUDE CONSTANT NUMBER(2) := 1;
URI_USE_SUMMARY_INCLUDE CONSTANT NUMBER(2) := 2;
URI_USE_LOGS_INCLUDE    CONSTANT NUMBER(2) := 3;
URI_USE_RESULTS_PAGE    CONSTANT NUMBER(2) := 4;
URI_USE_SUMMARY_PAGE    CONSTANT NUMBER(2) := 5;
URI_USE_LOGS_PAGE       CONSTANT NUMBER(2) := 6;
URI_USE_CREATE          CONSTANT NUMBER(2) := 7;
URI_USE_CREATE_LIKE     CONSTANT NUMBER(2) := 8;
URI_USE_EDIT            CONSTANT NUMBER(2) := 9;
URI_USE_VIEW            CONSTANT NUMBER(2) := 10;
URI_USE_MAX_NUM         CONSTANT NUMBER(2) := 11;


-- Constants for Trustable Command
NON_TRUSTABLE_COMMAND constant INTEGER := MGMT_JOB_ENGINE.NON_TRUSTABLE_COMMAND;
TRUSTABLE_COMMAND     constant INTEGER := MGMT_JOB_ENGINE.TRUSTABLE_COMMAND;


TYPE GRANT_CURSOR IS REF CURSOR;

-- static constructor for MGMT_JOB_SCHEDULE_RECORD
FUNCTION get_job_schedule_record(p_frequency_code NUMBER,
                                p_start_time DATE,
                                p_end_time DATE,
                                p_execution_hours NUMBER,
                                p_execution_minutes NUMBER,
                                p_interval NUMBER,
                                p_months MGMT_JOB_INT_ARRAY,
                                p_days MGMT_JOB_INT_ARRAY,
                                p_timezone_info NUMBER,
                                p_timezone_target_index NUMBER,
                                p_timezone_offset NUMBER,
                                p_timezone_region VARCHAR2,
                                p_start_grace_period NUMBER DEFAULT -1) RETURN MGMT_JOB_SCHEDULE_RECORD;

-- constructor for immediate job schedule
FUNCTION get_immediate_schedule_record RETURN MGMT_JOB_SCHEDULE_RECORD;

-- Insert a job with the specified name, type, description,
-- targets and parameters. This call returns the job id and the
-- execution id of the execution that is created from these attributes,
-- via the out parameters
PROCEDURE submit_job(p_job_name IN VARCHAR2,
                     p_description IN VARCHAR2,
                     p_job_type IN VARCHAR2,
                     p_job_targets IN MGMT_JOB_TARGET_LIST,
                     p_job_params IN MGMT_JOB_PARAM_LIST,
                     p_schedule IN OUT MGMT_JOB_SCHEDULE_RECORD,
                     p_job_id_out OUT RAW,
                     p_execution_id_out OUT RAW,
                     p_owner IN VARCHAR2 DEFAULT NULL,
                     p_system_job IN INTEGER DEFAULT 0,
                     p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                     p_job_target_type VARCHAR2 DEFAULT NULL,
                     p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);


-- Save the specified job to the library.
PROCEDURE create_library_job(p_job_name IN VARCHAR2,
                             p_description IN VARCHAR2,
                             p_job_type IN VARCHAR2,
                             p_job_targets IN MGMT_JOB_TARGET_LIST,
                             p_job_params IN MGMT_JOB_PARAM_LIST,
                             p_schedule IN OUT MGMT_JOB_SCHEDULE_RECORD,
                             p_job_id_out OUT RAW,
                             p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                             p_job_target_type VARCHAR2 DEFAULT NULL,
                             p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);

-- Submit a job from the library. 
-- 
-- p_lib_job_name, p_lib_job_owner are the name and owner of the library
-- job. 
-- p_new_job_name is the name of the job to be submitted. If set to null,
--   it will be set to the same name as the library job. Note that the
--   submitter will always be the owner of the new job.
-- If p_job_description is non-null, it will replace the description stored
--  in the library job. Otherwise, the description of the library job
--  is used.
-- If p_replace_targets is false, then the targets specified in 
-- p_job_targets will replace the existing list in the library job.
-- If p_replace_params is false, then the parameters specified in 
-- p_job_params will replace the existing list in the library job.
-- If not, they will be added to the existing list
-- p_targets and p_params represent the targets and parameters of the
-- job. If these are set to null, the targets and/or parameters
-- associated with the library job will be picked up, provided
-- p_replace_params and p_replace_targets are also set to false (0).
-- p_job_creds represents the overridden credentials of the job.
-- If provided, they will override any overridden creds in the
-- library job
PROCEDURE submit_job_from_library(p_lib_job_name IN VARCHAR2,
                                  p_lib_job_owner IN VARCHAR2,
                                  p_new_job_name IN VARCHAR2,
                                  p_job_description IN VARCHAR2,
                                  p_job_targets IN MGMT_JOB_TARGET_LIST,
                                  p_job_params IN MGMT_JOB_PARAM_LIST,
                                  p_replace_targets NUMBER,
                                  p_replace_params NUMBER,
                                  p_schedule IN MGMT_JOB_SCHEDULE_RECORD,
                                  p_job_id_out OUT RAW,
                                  p_execution_id_out OUT RAW,
                                  p_system_job NUMBER DEFAULT 0,
                                  p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                                  p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);


-- Create and schedule a job with the specified name and parameters, and
-- the specified target lists. This call results in multiple executions
-- being scheduled (one for each target list), and returns an array of
-- execution Ids, as well as the job id of the newly created job. The
-- parameter p_execution_timeout is ignored if the job type is not
-- agent bound, or if it set to a negative number. If it is a non-zero,
-- positive number, it refers to the number of hours that the job system
-- will wait for any down emd(s) to come back up before it gives up
-- and aborts the job.
-- If p_is_library is set to 1, then the job will be saved as
-- a library job. In this case, the p_execution_ids_out parameter
-- will not be touched.
PROCEDURE submit_job(p_job_name IN VARCHAR2,
                     p_description IN VARCHAR2,
                     p_is_library NUMBER,
                     p_job_type IN VARCHAR2,
                     p_job_targets IN MGMT_JOB_TARGET_LIST_ARRAY,
                     p_job_params IN MGMT_JOB_PARAM_LIST,
                     p_schedule IN OUT MGMT_JOB_SCHEDULE_RECORD,
                     p_execution_timeout NUMBER,
                     p_job_id_out OUT RAW,
                     p_execution_ids_out OUT MGMT_JOB_GUID_ARRAY,
                     p_owner VARCHAR2 DEFAULT NULL,
                     p_system_job IN INTEGER DEFAULT 0,
                     p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                     p_job_target_type VARCHAR2 DEFAULT NULL,
                     p_queue_names SMP_EMD_STRING_ARRAY DEFAULT NULL,
                     p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);

-- Submit a job to the specified set of queues. Each execution is
-- submitted to the queue with the corresponding index
PROCEDURE submit_job_to_queue(p_job_name IN VARCHAR2,
                              p_queue_names IN SMP_EMD_STRING_ARRAY,
                              p_description IN VARCHAR2,
                              p_job_type IN VARCHAR2,
                              p_job_targets IN MGMT_JOB_TARGET_LIST,
                              p_job_params IN MGMT_JOB_PARAM_LIST,
                              p_owner IN VARCHAR2 DEFAULT NULL,
                              p_system_job IN INTEGER DEFAULT 0,
                              p_job_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                              p_job_target_type VARCHAR2 DEFAULT NULL,
                              p_job_id_out OUT RAW,
                              p_execution_ids_out OUT MGMT_JOB_GUID_ARRAY);


-- Suspend the currently executing job given by execution_id
PROCEDURE suspend_job_execution(p_execution_id IN RAW);

-- Suspend the currently executing job which the step
-- given by step_id is part of. If p_suspend_step is
-- true (1), then the step is suspended as well.
PROCEDURE suspend_job_execution(p_step_id IN NUMBER,
                                p_suspend_step IN NUMBER);

-- Suspend the specified job, and all its executions
PROCEDURE suspend_job(p_job_name IN VARCHAR2,
                      p_job_owner IN VARCHAR2);
                      
-- Resume the specified job
PROCEDURE resume_job(p_job_name IN VARCHAR2,
                     p_job_owner IN VARCHAR2);
                      
-- Resume a suspended job. If the job is already resumed,
-- does nothing.
PROCEDURE resume_job_execution(p_execution_id IN RAW);

-- Restart a job that had earlier failed. This method throws
-- an exception if the job had earlier succeeded. This returns
-- a new execution id, which represents the execution id of the
-- restart execution. The execution that is restarted is always
-- the latest execution of the job.
FUNCTION restart_job(p_job_id IN RAW,
                     p_target_list_index INTEGER,
                     p_params MGMT_JOB_PARAM_LIST DEFAULT NULL) RETURN RAW;

-- Same as restart_job(p_job_id, 1); suitable for jobs with just one
-- target list
FUNCTION restart_job(p_job_id RAW,
                    p_params MGMT_JOB_PARAM_LIST DEFAULT NULL) RETURN RAW;
                    
-- Retart job, using the job name and owner
FUNCTION restart_job(p_job_name IN VARCHAR2,
                     p_job_owner IN VARCHAR2,
                     p_target_list_index IN INTEGER DEFAULT 1,
                     p_params MGMT_JOB_PARAM_LIST DEFAULT NULL) RETURN RAW;

-- Restart a job execution that had earlier failed. This method throws
-- an exception if the job execution had earlier succeeded. This returns
-- a new execution id, which represents the execution id of the
-- restart execution. The execution that is restarted is always
-- the latest execution of the job.
FUNCTION restart_job_execution(p_exec_id IN RAW,
                               p_params MGMT_JOB_PARAM_LIST DEFAULT NULL) RETURN RAW;

-- Resubmit a job. The job is restarted against all the target sets it
-- was originally submitted against. Returns a set of execution ids
FUNCTION resubmit_job(p_job_id RAW) RETURN MGMT_JOB_GUID_ARRAY;

-- Resubmit a job, using the job name and owner
FUNCTION resubmit_job(p_job_name VARCHAR2,
                      p_job_owner VARCHAR2 DEFAULT NULL)
        RETURN MGMT_JOB_GUID_ARRAY;

-- Delete the job specified by p_job_name and owner by p_job_owner,
-- If p_commit is true (1), then a commit is performed after each 
-- execution is deleted. This will be useful when deleting a bunch of 
-- executions, so that they do not cause rollback segments to blow. 
-- Deletion of a job causes all executions in the job to be deleted.
-- An exception is thrown if there are active executions.
PROCEDURE delete_job(p_job_name IN VARCHAR2,
                     p_job_owner IN VARCHAR2,
                     p_commit NUMBER DEFAULT 0,
                     p_is_library NUMBER DEFAULT 0);

-- Like delete_job(name, owner, commit, islibrary). The owner
-- is assumed to be the caller (ie the job is assumed to be
-- owned by the caller)
PROCEDURE delete_job(p_job_name IN VARCHAR2,
                     p_commit NUMBER DEFAULT 0,
                     p_is_library NUMBER DEFAULT 0);

-- Delete a job using the job id
PROCEDURE delete_job(p_job_id IN RAW,
                     p_commit NUMBER DEFAULT 0);

-- Delete the execution with the specified execution id
PROCEDURE delete_job_execution(p_execution_id IN RAW );

-- Delete the specified job run
PROCEDURE delete_job_run(p_job_name VARCHAR2, p_job_owner VARCHAR2,
                         p_scheduled_time DATE);

-- Delete the specified executions. If p_commit is true (1), then 
-- a commit is performed after each execution is deleted. This will
-- be useful when deleting a bunch of executions, so that they do
-- not cause rollback segments to blow. 
PROCEDURE delete_job_executions(p_execution_ids IN MGMT_JOB_GUID_ARRAY,
                                p_commit NUMBER DEFAULT 0);

-- Delete all non-active executions in a job. 
PROCEDURE delete_all_executions(p_job_name VARCHAR2,
                                p_job_owner VARCHAR2 DEFAULT NULL,
                                p_commit NUMBER DEFAULT 0,
                                p_is_library NUMBER DEFAULT 0);

-- Stop the execution, and all other executions in the job,
-- if currently active. Nothing is done if
-- the execution is not currently active (ie is stopped, aborted,
-- completed, or failed).
-- *NOTE* stop_execution is now deprecated, use stop_all_executions 
-- instead
PROCEDURE stop_execution(p_execution_id RAW);

-- Stop the specified set of executions.
-- *NOTE* This is deprecated, use stop_all_executions instead
PROCEDURE stop_executions(p_execution_ids MGMT_JOB_GUID_ARRAY);

-- Stop all active executions in the specified job. If the owner is
-- not specified, it is assumed to be the caller
PROCEDURE stop_all_executions(p_job_name VARCHAR2,
                              p_job_owner VARCHAR2 DEFAULT NULL);

-- Stop the specified job run
PROCEDURE stop_job_run(p_job_name VARCHAR2, p_job_owner VARCHAR2,
                       p_scheduled_time DATE);

-- Edit the specified job, using the specified description,
-- parameters, targets and schedule
PROCEDURE edit_job(p_job_name VARCHAR2,
                   p_owner VARCHAR2,
                   p_is_library NUMBER,
                   p_description VARCHAR2, 
                   p_params MGMT_JOB_PARAM_LIST,
                   p_targets MGMT_JOB_TARGET_LIST,
                   p_schedule MGMT_JOB_SCHEDULE_RECORD,
                   p_overridden_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                   p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);

-- Edit the current job; multiple target lists
PROCEDURE edit_job(p_job_name VARCHAR2,
                   p_owner VARCHAR2,
                   p_is_library NUMBER,
                   p_description VARCHAR2, 
                   p_params MGMT_JOB_PARAM_LIST,
                   p_targets MGMT_JOB_TARGET_LIST_ARRAY,
                   p_schedule MGMT_JOB_SCHEDULE_RECORD,
                   p_overridden_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                   p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);

-- Register a command.
-- p_command_type must be set to SHORT_RUNNING_COMMAND or
-- LONG_RUNNING_COMMAND
PROCEDURE register_command(p_command_name VARCHAR2,
                           p_class_name VARCHAR2,
                           p_command_type NUMBER  DEFAULT SHORT_RUNNING_COMMAND,
                           p_is_trustable NUMBER DEFAULT NON_TRUSTABLE_COMMAND);

-- Register a command block procedure i.e. a procedure
-- that can be called from command block xml.
PROCEDURE register_command_block_proc(p_proc_name VARCHAR2,
                                      p_param_types MGMT_SHORT_STRING_ARRAY);

-- Deregister a command block procedure
PROCEDURE deregister_command_block_proc(p_proc_name VARCHAR2);

-- Update the specified job parameters. If a parameter exists,
-- it is updated; else, it is inserted
PROCEDURE add_job_parameters(p_job_id RAW,
                             p_execution_id RAW,
                             p_param_list MGMT_JOB_PARAM_LIST);

-- Insert an error message for a step.
PROCEDURE insert_step_error_message(p_step_id NUMBER,
                                    p_error_message VARCHAR2);

PROCEDURE register_purge_policy(p_policy_name VARCHAR2, 
                            p_timeframe NUMBER,
                            p_purge_criteria MGMT_JOB_PURGE_CRITERION_LIST);

-- Drop a purge policy that has the specified name
PROCEDURE drop_purge_policy(p_policy_name VARCHAR2);

-- 
-- The following procedures deal with registering events
--

-- Register a new event
-- The event callback function must have the following 
-- signature:
-- PROCEDURE callback(p_event_name VARCHAR2, 
--                    p_event_params SMP_EMD_NVPAIR_ARRAY);
-- The event callback is called when the event is "raised". The
-- callback can do additional processing outside the scope of the
-- job system, if required.
-- The event callback is optional, but is useful for validating
-- the parameters to the raise_event() call, for example.
PROCEDURE add_event(p_event_name VARCHAR2, p_event_callback VARCHAR2);

-- Raise an already registered event with the specified params
PROCEDURE raise_event(p_event_name VARCHAR2, 
                      p_event_params SMP_EMD_NVPAIR_ARRAY);

-- Suspend the job execution (excluding the current step) on
-- the specified event, having the specified parameters
PROCEDURE suspend_job_execution_on_event(p_execution_id RAW,
                                         p_event_name VARCHAR2,
                                         p_event_params SMP_EMD_NVPAIR_ARRAY,
                                         p_suspend_timeout NUMBER DEFAULT 0);

-- "Associate" an event with the specified execution, without
-- actually suspending it. This generally indicates an intention
-- to eventually suspend the execution based on that event.
PROCEDURE associate_event_with_execution(p_execution_id RAW,
                                         p_event_name VARCHAR2,
                                         p_event_params SMP_EMD_NVPAIR_ARRAY);

--
-- Return the large paremeter having the specified name
-- corresponding to the specified job and execution.
-- This will return an empty clob if the parameter has not
-- yet been initialized.
--
FUNCTION get_large_param(p_job_id RAW,
                         p_execution_id RAW,
                         p_parameter_name VARCHAR2) RETURN CLOB;

--
-- Given a job status, return the appropriate status bucket value
--
FUNCTION get_status_bucket(p_status IN NUMBER) RETURN NUMBER
DETERMINISTIC;

-- PURPOSE
--
-- To return a list of users and roles assigned privileges to a particular job.
--
-- PARAMETERS
--  job_id_in - IN the jobid
--  owner_out - the name of the job owner
--  grantees_out - a cursor - user/role name, type (ROLE,ADMIN,SUPER) and 
--  privilege OWNER, FULL_JOB or VIEW_JOB
--
PROCEDURE GET_JOB_GRANTS (job_id_in IN RAW,
                          owner_out OUT VARCHAR2,
                          grantees_out OUT GRANT_CURSOR);

-- PURPOSE
--
-- To return a list of users and roles assigned privileges to a particular job for a set of users/roles.
--
-- PARAMETERS
--  job_id_in - IN the jobid
--  names_in - an array of names for the cursor
--  owner_out - the name of the job owner if in the set, else ''
--  grantees_out - a cursor - user/role name, type (ROLE,ADMIN,SUPER) and 
--  privilege
--
PROCEDURE GET_JOB_GRANTS_FOR_SET (job_id_in IN RAW,
                          names_in IN SMP_EMD_STRING_ARRAY,
                          owner_out OUT VARCHAR2,
                          grantees_out OUT GRANT_CURSOR);

END MGMT_JOBS;
/

show errors;

