Rem
Rem $Header: sdk_loader_pkgbody.sql 28-jul-2006.00:03:57 neearora Exp $
Rem
Rem sdk_loader_pkgbody.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_loader_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    07/24/06 - project 21470. added API to register callback 
Rem                           for CRS event 
Rem    neearora    07/25/05 - neearora_bug-4500972
Rem    neearora    07/20/05 - Created
Rem

-- 
-- Package: mgmt_loader
--
-- PURPOSE: 
--   This package provides access to the loader API .
--
CREATE OR REPLACE PACKAGE BODY MGMT_LOADER
AS

  --
  -- PROCEDURE: register_pre_load_callback
  --
  -- PURPOSE: 
  --   Registers the given pre_load_proc to the repository.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  PROCEDURE register_pre_load_callback
  (
    p_pre_load_callback   IN VARCHAR2
  )
  AS
  l_error_message VARCHAR2(1000);
  l_callback_name mgmt_callbacks.callback_name%TYPE;
  BEGIN
    EM_CHECK.check_not_null(p_pre_load_callback,'p_pre_load_callback');

    l_callback_name := EM_CHECK.qualified_sql_name(p_pre_load_callback);  

    IF NOT EM_CHECK.is_valid_signature(p_pre_load_callback,
                      mgmt_short_string_array('SMP_EMD_NVPAIR_ARRAY','SMP_EMD_NVPAIR_ARRAY'),
                      l_error_message)
    THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,l_error_message) ;
    END IF ;

    EMD_LOADER.register_load_callback(p_pre_load_callback, 
                                      MGMT_GLOBAL.G_PRE_UPLOAD_CALLBACK);
  END register_pre_load_callback;

  --
  -- PROCEDURE: deregister_pre_load_callback
  --
  -- PURPOSE: 
  --   Deregisters the given pre_load_proc from the repository.
  PROCEDURE deregister_pre_load_callback
  (
    p_pre_load_callback   IN VARCHAR2
  )
  AS
  BEGIN
    EM_CHECK.check_not_null(p_pre_load_callback,'p_pre_load_callback');
    EMD_LOADER.deregister_load_callback(p_pre_load_callback, 
                                            MGMT_GLOBAL.G_PRE_UPLOAD_CALLBACK);
  END deregister_pre_load_callback;

  --
  -- PROCEDURE: register_post_load_callback
  --
  -- PURPOSE: 
  --   Registers the given post_load_proc to the repository.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  PROCEDURE register_post_load_callback
  (
    p_post_load_callback  IN VARCHAR2
  )
  AS
  l_error_message VARCHAR2(1000);
  l_callback_name mgmt_callbacks.callback_name%TYPE;
  BEGIN
    EM_CHECK.check_not_null(p_post_load_callback,'p_post_load_callback');

   l_callback_name := EM_CHECK.qualified_sql_name(p_post_load_callback);

    IF NOT EM_CHECK.is_valid_signature(p_post_load_callback,
                      mgmt_short_string_array('SMP_EMD_NVPAIR_ARRAY','SMP_EMD_NVPAIR_ARRAY'),
                      l_error_message)
    THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,l_error_message) ;
    END IF ;
    
    EMD_LOADER.register_load_callback(p_post_load_callback,
                                      MGMT_GLOBAL.G_POST_UPLOAD_CALLBACK);
  END register_post_load_callback;   

  --
  -- PROCEDURE: deregister_post_load_callback
  --
  -- PURPOSE: 
  --   Deregisters the given post_load_proc from the repository.
  PROCEDURE deregister_post_load_callback
  (
    p_post_load_callback  IN VARCHAR2
  )
  AS
  BEGIN
    EM_CHECK.check_not_null(p_post_load_callback,'p_post_load_callback');
    EMD_LOADER.deregister_load_callback(p_post_load_callback,
                                             MGMT_GLOBAL.G_POST_UPLOAD_CALLBACK);
 END deregister_post_load_callback; 

  --
  -- PROCEDURE: register_cluster_crs_event_cbk
  --
  -- PURPOSE: 
  --   Registers the given cluster_crs_event_cbk with the repository.
  --   This callback will be invoked when ever any severity for 
  --   cluster target type , crs_event metric is received.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  --
  -- PARAMETERS:
  -- p_cluster_crs_event_cbk : Name of the callback procedure
  --
  -- EXCEPTIONS  
  --   InvaildParams: If callback name is null or signature of the callback procedure is not valid 
  --   InvaildParams: If any callback is already registered
  -- 
  PROCEDURE register_cluster_crs_event_cbk
  (
    p_cluster_crs_event_cbk   IN VARCHAR2
  )
  AS
  BEGIN
    EMD_LOADER.register_cluster_crs_event_cbk(p_cluster_crs_event_cbk);
  END register_cluster_crs_event_cbk;

  --
  -- PROCEDURE: dereg_cluster_crs_event_cbk
  --
  -- PURPOSE: 
  --   Deregisters the given cluster_crs_event_cbk from the repository.
  --
  -- PARAMETERS:
  -- p_cluster_crs_event_cbk : Name of the callback procedure
  --
  -- EXCEPTIONS  
  --   InvaildParams: If callback name is null 
  --   InvaildParams: If no such callback is registered
  -- 
  PROCEDURE dereg_cluster_crs_event_cbk
  (
    p_cluster_crs_event_cbk   IN VARCHAR2
  )
  AS
  BEGIN
    EMD_LOADER.dereg_cluster_crs_event_cbk(p_cluster_crs_event_cbk);
  END dereg_cluster_crs_event_cbk;

END MGMT_LOADER;
/

show errors;


