Rem
Rem $Header: sdk_loader_pkgdef.sql 28-jul-2006.00:03:57 neearora Exp $
Rem
Rem sdk_loader_pkgdef.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_loader_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    07/24/06 - project 21470. added API to register callback 
Rem                           for CRS event 
Rem    neearora    07/25/05 - neearora_bug-4500972
Rem    neearora    07/20/05 - Created
Rem

-- 
-- Package: mgmt_loader
--
-- PURPOSE: 
--   This package provides access to the loader API.
--
CREATE OR REPLACE PACKAGE MGMT_LOADER
AS

  --
  -- PROCEDURE: register_pre_load_callback
  --
  -- PURPOSE: 
  --   Registers the given pre_load_proc to the repository.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  PROCEDURE register_pre_load_callback
  (
    p_pre_load_callback   IN VARCHAR2
  );

  --
  -- PROCEDURE: deregister_pre_load_callback
  --
  -- PURPOSE: 
  --   Deregisters the given pre_load_proc from the repository.
  PROCEDURE deregister_pre_load_callback
  (
    p_pre_load_callback   IN VARCHAR2
  );

  --
  -- PROCEDURE: register_post_load_callback
  --
  -- PURPOSE: 
  --   Registers the given post_load_proc to the repository.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  PROCEDURE register_post_load_callback
  (
    p_post_load_callback  IN VARCHAR2
  );

  --
  -- PROCEDURE: deregister_post_load_callback
  --
  -- PURPOSE: 
  --   Deregisters the given post_load_proc from the repository.
  PROCEDURE deregister_post_load_callback
  (
    p_post_load_callback  IN VARCHAR2
  );
  --
  -- PROCEDURE: register_cluster_crs_event_cbk
  --
  -- PURPOSE: 
  --   Registers the given cluster_crs_event_cbk with the repository.
  --   This callback will be invoked when ever any severity for 
  --   cluster target type , crs_event metric is received.
  --   During registration some basic validations like 
  --   NOT NULL and valid signature are also done.
  --
  -- PARAMETERS:
  -- p_cluster_crs_event_cbk : Name of the callback procedure
  --
  -- EXCEPTIONS  
  --   InvaildParams: If callback name is null or signature of the callback procedure is not valid 
  --   InvaildParams: If any callback is already registered
  -- 
  PROCEDURE register_cluster_crs_event_cbk 
  (
    p_cluster_crs_event_cbk   IN VARCHAR2
  );

  --
  -- PROCEDURE: dereg_cluster_crs_event_cbk
  --
  -- PURPOSE: 
  --   Deregisters the given cluster_crs_event_cbk from the repository.
  --
  -- PARAMETERS:
  -- p_cluster_crs_event_cbk : Name of the callback procedure
  --
  -- EXCEPTIONS  
  --   InvaildParams: If callback name is null 
  --   InvaildParams: If no such callback is registered
  -- 
  PROCEDURE dereg_cluster_crs_event_cbk
  (
    p_cluster_crs_event_cbk   IN VARCHAR2
  );

END MGMT_LOADER;
/

show errors;


