Rem
Rem $Header: sdk_message_pkgbody.sql 15-sep-2004.12:53:58 groyal Exp $
Rem
Rem sdk_message_pkgbody.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_message_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      09/15/04 - Change l_message to NVARCHAR2 
Rem    groyal      09/14/04 - groyal_message_0913
Rem    groyal      09/13/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_message AS

FUNCTION get_message(
  p_message_id      IN VARCHAR2,
  p_subsystem       IN VARCHAR2,
  p_language_code   IN VARCHAR2,
  p_country_code    IN VARCHAR2,
  p_default_message IN VARCHAR2 DEFAULT NULL)
RETURN NVARCHAR2 IS
  l_country_code VARCHAR2(2) := p_country_code;
  l_message      NVARCHAR2(1000) := p_default_message;
  
BEGIN
  IF (p_message_id IS NULL OR
      p_subsystem IS NULL OR
      p_language_code IS NULL)
  THEN
      RETURN l_message;
  END IF;
  
  IF l_country_code IS NULL
  THEN  
      l_country_code := ' ';
  END IF;
    
  BEGIN
      SELECT MESSAGE INTO l_message
      FROM MGMT_MESSAGES
      WHERE MESSAGE_ID = p_message_id
        AND SUBSYSTEM = p_subsystem
        AND LANGUAGE_CODE = p_language_code
        AND COUNTRY_CODE = l_country_code;
  EXCEPTION
  WHEN OTHERS THEN 
      BEGIN
          SELECT MESSAGE INTO l_message
          FROM MGMT_MESSAGES
          WHERE MESSAGE_ID = p_message_id
            AND SUBSYSTEM = p_subsystem
            AND LANGUAGE_CODE = 'en'
            AND COUNTRY_CODE = ' ';
      EXCEPTION
      WHEN OTHERS THEN NULL;
      END;
  END;

  RETURN l_message;
END;

END mgmt_message;
/

SHOW ERRORS;


