Rem
Rem $Header: sdk_metric_external_pkgdef.sql 01-aug-2006.02:58:16 hbadheka Exp $
Rem
Rem sdk_metric_external_pkgdef.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_metric_external_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hbadheka    08/01/06 - Backport hbadheka_bug_5050958_3 from main
Rem    mgoswami    02/27/06 - RFI Bug 5061055 
Rem    bkolloju    02/14/06 - 10.2.0.3
Rem    hbadheka    01/03/06 - APIs for external metrics 
Rem    hbadheka    01/03/06 - Created
Rem


CREATE OR REPLACE PACKAGE mgmt_metric_external
AS

  G_MODULE_NAME CONSTANT VARCHAR2(30) := 'mgmt_metric_external';

  --
  -- Wrapper  around mgmt_metrics to create integrator metrics
  --
  PROCEDURE create_metric
             (p_producer_id        IN VARCHAR2,
              p_target_type        IN VARCHAR2,
              p_metric_name        IN VARCHAR2,
              p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY,
              p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
              p_usage_type         IN NUMBER   DEFAULT 0,
              p_metric_label       IN VARCHAR2 DEFAULT NULL,
              p_description        IN VARCHAR2 DEFAULT ' ',
              p_unit               IN VARCHAR2 DEFAULT ' ',
              p_short_name         IN VARCHAR2 DEFAULT NULL
             ) ;
  --
  -- Create the genericAlertExternal Metric for the target type
  -- External alerts will be logged against this metric if
  -- integrators have not defined the metric for the alert
  --
  PROCEDURE create_generic_metric
              ( p_target_type        IN VARCHAR2,
                p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0'
              ) ;


--
-- get active blackouts for a given targetGUID
--
PROCEDURE get_target_blackout_windows
( 
  target_guid IN VARCHAR2,
  startTimeListOut OUT MGMT_DATE_TABLE,
  endTimeListOut OUT MGMT_DATE_TABLE,
  timeZoneOffsetListOut OUT MGMT_INTEGER_TABLE
);

TYPE CURSOR_TYPE IS REF CURSOR;

END mgmt_metric_external ;



/

show errors

