CREATE OR REPLACE PACKAGE MGMT_METRIC_HELPER AS

-- CONSTANTS for help function name
G_EVAL_MIN_VALUE_FUNC CONSTANT VARCHAR2(100) 
                    := 'MGMT_METRIC_HELPER.eval_min_value';
G_EVAL_MAX_VALUE_FUNC CONSTANT VARCHAR2(100) 
                    := 'MGMT_METRIC_HELPER.eval_max_value';
G_EVAL_AVG_VALUE_FUNC CONSTANT VARCHAR2(100)
                    := 'MGMT_METRIC_HELPER.eval_avg_value';
G_EVAL_SUM_VALUE_FUNC CONSTANT VARCHAR2(100)
                    := 'MGMT_METRIC_HELPER.eval_sum_value';
G_COPY_VALUE_FUNC CONSTANT VARCHAR2(100)
                    := 'MGMT_METRIC_HELPER.copy_value';
G_EVAL_STDDEV_VALUE_FUNC CONSTANT VARCHAR2(100)
                    := 'MGMT_METRIC_HELPER.eval_stddev_value';
G_WRAPPER_EVAL_FUNC CONSTANT VARCHAR2(100)
                    := 'MGMT_METRIC_HELPER.wrapper_eval_func';


G_MODULE constant VARCHAR2(100) := 'mgmt_metric_helper';

G_DEP_ALL_KEY_VALUE VARCHAR2(128) :='mgmt_metric_helper_all_key';


--
-- PROCEDURE: copy_value
-- PURPOSE: copy the sole dependent's metric 
--       for the aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--      p_values, caculated metric values
PROCEDURE copy_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);


--
-- PROCEDURE: eval_min_value
-- PURPOSE: calculate the min value of dependent metrics 
--       for the aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--      p_values, caculated metric values
PROCEDURE eval_min_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);

--
-- PROCEDURE: eval_max_value
-- PURPOSE: calculate the mav value of dependent metrics for the aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--       p_values, caculated metric values
PROCEDURE eval_max_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);

--
-- PROCEDURE: eval_avg_value
-- PURPOSE: calculate the avg value of dependent metrics 
--   for the aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--       p_values, caculated metric values
PROCEDURE eval_avg_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);

--
-- PROCEDURE: eval_sum_value
-- PURPOSE: calculate the sum value of dependent metrics for the aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--       p_values, caculated metric values
PROCEDURE eval_sum_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);


--
-- PROCEDURE: eval_stddev_value
-- PURPOSE: calculate the stddev value of dependent metrics for the 
--               aggregate service's metric
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, metric guid
--     p_coll_name: key_value
-- OUT PARAMETER:
--       p_values, caculated metric values
PROCEDURE eval_stddev_value(p_target_guid IN RAW,
                         p_metric_guid IN RAW,
                         p_coll_name IN VARCHAR2,
                         p_values OUT MGMT_METRIC_VALUE_ARRAY);

--
-- PROCEDURE: wrapper_eval_func
-- PURPOSE: 
--        This eval-func is registered with the repository
--        collections. When invoked, this internally invokes
--        the appropriate eval proc for the collection based
--        on the entry in MGMT_METRIC_DEPENDENCY table.
-- IN PARAMETER:
--     p_target_guid; service guid
--     p_metrics_guid, table metric guid
--     p_coll_name, collection name
-- OUT PARAMETER:
--      p_values, caculated metric values
PROCEDURE wrapper_eval_func(p_target_guid IN RAW,
                            p_metric_guid IN RAW,
                            p_coll_name IN VARCHAR2,
                            p_values OUT MGMT_METRIC_VALUE_ARRAY);


END;
/
show errors;
