Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/sdk/sdk_metric_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/1 2009/04/27 22:10:50 bram Exp $
Rem
Rem sdk_metric_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdk_metric_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bram        04/24/09 - Backport jsadras_rfi_backport_6686041_10.2.0.5
Rem                           from st_emcore_10.2.0.1.0
Rem    gan         04/16/07 - Backport gan_bug-5931915 from main
Rem    neearora    03/28/07 - Backport neearora_bug-5916549 from main
Rem    neearora    03/26/07 - bug 5916549
Rem    rpinnama    09/30/05 - 
Rem    rpinnama    08/31/05 - Change the type_meta_ver default for delete_metric
Rem    rpinnama    07/27/05 - Fix 4496511 : Handle start and end type meta 
Rem                           vers in modify_metric 
Rem    jsadras     07/21/05 - check number of key columns <=5 
Rem    pmodi       06/09/05 - Bug:4378893 - Use UNION, in add_metrics to get 
Rem                           current meta ver too 
Rem    rpinnama    05/17/05 - Add is_renderable column to mgmt_metrics 
Rem    jsadras     05/02/05 - add is_long_running 
Rem    rpinnama    02/25/05 - Bug 3924067: Add non_thresholded_alerts and 
Rem                           keyonly_thresholds columns 
Rem    rpinnama    01/07/05 - Add support for start/end type_meta_vers 
Rem    rpinnama    01/06/05 - Populate mgmt_metric_versions for rep metrics 
Rem    rpinnama    11/18/04 - Add plsql signature validations 
Rem    rpinnama    10/05/04 - Support source at metric column level 
Rem    rpinnama    09/23/04 - Modify the calculationof is_repository 
Rem    gan         09/14/04 - add remote parameter 
Rem    rpinnama    08/30/04 - Throw metric_does_not exist error 
Rem    rpinnama    08/19/04 - Add has_push, has_pull attributes 
Rem    rpinnama    08/18/04 - Add is_test_metric to create_metric API 
Rem    streddy     08/10/04 - Add is_transposed to create_metric 
Rem    rpinnama    08/02/04 - Fix the is_valid_sql call 
Rem    rpinnama    07/28/04 - Use em_metric.add_metric_row 
Rem    rpinnama    07/23/04 - Add get_metric_guid API 
Rem    rpinnama    07/07/04 - rpinnama_add_metric_api
Rem    rpinnama    06/29/04 - Created
Rem


CREATE OR REPLACE PACKAGE BODY mgmt_metric AS

  TYPE_META_VER_DEF_VAL constant varchar2(8) := '9999.999';   

  -- Generate the metric guid for the specified metric
  FUNCTION generate_metric_guid(p_target_type   IN VARCHAR2,
                                p_metric_name   IN VARCHAR2,
                                p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE IS
    l_metric_col MGMT_METRICS.metric_column%TYPE;
    l_metric_guid MGMT_METRICS.metric_guid%TYPE;
  BEGIN

    l_metric_col := NVL(p_metric_column, ' ');

    IF (l_metric_col = ' ') THEN
      l_metric_guid := DBMS_OBFUSCATION_TOOLKIT.md5(
                         input => UTL_RAW.cast_to_raw(p_target_type ||
                            ';'|| p_metric_name));
    ELSE
      -- Generate metric GUID for metric column
      l_metric_guid := DBMS_OBFUSCATION_TOOLKIT.md5(
                         input => UTL_RAW.cast_to_raw(p_target_type ||
                            ';'|| p_metric_name || ';' || l_metric_col));
    END IF;

    RETURN l_metric_guid;
  END;

  FUNCTION get_metric_guid(p_target_type   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE
  IS
    l_metric_guid mgmt_metrics.metric_guid%TYPE;
  BEGIN

    BEGIN

      SELECT metric_guid  INTO l_metric_guid
        FROM mgmt_metrics
       WHERE target_type   = p_target_type
         AND metric_name   = p_metric_name
         AND metric_column = p_metric_column
         AND ROWNUM = 1 ;

    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.NO_SUCH_METRIC_ERR,
                  'Metric not found. target_type ' || p_target_type || 
		  ' metric_name = ' || p_metric_name || 
		  ' metric_column = ' || p_metric_column);
    END;

    RETURN l_metric_guid;

  END get_metric_guid;


  FUNCTION get_metric_guid_for_target(
                           p_target_type   IN VARCHAR2,
                           p_target_name   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE
  IS
    l_metric_guid mgmt_metrics.metric_guid%TYPE;
  BEGIN
    BEGIN
      SELECT m.metric_guid INTO l_metric_guid
        FROM mgmt_targets t, mgmt_metrics m
       WHERE t.target_type = p_target_type
         AND t.target_name = p_target_name
         AND m.target_type = p_target_type
         AND m.metric_name = p_metric_name
         AND m.metric_column = p_metric_column
         AND m.type_meta_ver = t.type_meta_ver
         AND (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ')
         AND (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ')
         AND (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ')
         AND (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ')
         AND (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ');
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise MGMT_GLOBAL.no_such_metric_found;
        raise_application_error(MGMT_GLOBAL.NO_SUCH_METRIC_ERR,
                  'Metric not found. target_type ' || p_target_type || 
		  ' target_name = ' || p_target_name || 
		  ' metric_name = ' || p_metric_name || 
		  ' metric_column = ' || p_metric_column);
    END;

    RETURN l_metric_guid;

  END get_metric_guid_for_target;

  FUNCTION get_metric_guid_for_props(
                           p_target_type   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ',
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ')

    RETURN mgmt_metrics.metric_guid%TYPE
  IS
    l_metric_guid mgmt_metrics.metric_guid%TYPE;
  BEGIN

    BEGIN
      SELECT m.metric_guid INTO l_metric_guid
        FROM mgmt_metrics m
       WHERE m.target_type = p_target_type
         AND m.metric_name = p_metric_name
         AND m.metric_column = p_metric_column
         AND m.type_meta_ver = p_type_meta_ver
         AND (m.category_prop_1 = p_category_prop_1 OR m.category_prop_1 = ' ')
         AND (m.category_prop_2 = p_category_prop_2 OR m.category_prop_2 = ' ')
         AND (m.category_prop_3 = p_category_prop_3 OR m.category_prop_3 = ' ')
         AND (m.category_prop_4 = p_category_prop_4 OR m.category_prop_4 = ' ')
         AND (m.category_prop_5 = p_category_prop_5 OR m.category_prop_5 = ' ');
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise MGMT_GLOBAL.no_such_metric_found;
    END;

    RETURN l_metric_guid;
  END get_metric_guid_for_props;


  -- Create metric with the given details
  PROCEDURE create_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                          p_valid_if_list      IN MGMT_VALIDIF_ARRAY DEFAULT NULL,
                          p_metric_type        IN NUMBER   DEFAULT 0,
                          p_usage_type         IN NUMBER   DEFAULT 0,
                          p_metric_label       IN VARCHAR2 DEFAULT NULL,
                          p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
                          p_description        IN VARCHAR2 DEFAULT ' ',
                          p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
                          p_unit               IN VARCHAR2 DEFAULT ' ',
                          p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
                          p_short_name         IN VARCHAR2 DEFAULT NULL,
                          p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
                          p_is_repository      IN NUMBER   DEFAULT 0,
                          p_author             IN VARCHAR2 DEFAULT 'ORACLE',
                          p_source_type        IN NUMBER   DEFAULT 0,
                          p_source             IN VARCHAR2 DEFAULT NULL,
                          p_keys_from_mult_colls IN NUMBER DEFAULT 0 ,
                          p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL,
                          p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
                          p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY DEFAULT NULL,
	                  p_is_transposed      IN NUMBER   DEFAULT 0,
			  p_is_test_metric     IN NUMBER   DEFAULT 0,
	                  p_has_push           IN NUMBER   DEFAULT 0,
	                  p_has_pull           IN NUMBER   DEFAULT 0,
	                  p_remote             IN NUMBER   DEFAULT 0,
	                  p_non_thresholded_alerts IN NUMBER DEFAULT 0,
	                  p_keyonly_thresholds IN NUMBER   DEFAULT 0,
			  p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
                          p_is_long_running    IN NUMBER   DEFAULT 0,
                          p_is_renderable      IN NUMBER   DEFAULT 1)
  IS
    l_metric_guid        MGMT_METRICS.metric_guid%TYPE;
    l_column_guid        MGMT_METRICS.metric_guid%TYPE;
    l_key_column         MGMT_METRICS.key_column%TYPE;
    l_all_columns        MGMT_SHORT_STRING_ARRAY;
    l_meta_ver_list      MGMT_SHORT_STRING_ARRAY;
    l_valid_if_list      MGMT_VALIDIF_ARRAY;
    l_dflt_valid_if_list MGMT_VALIDIF_ARRAY;
    l_catprop_1_choices  MGMT_CATEGORY_PROP_ARRAY;
    l_catprop_2_choices  MGMT_CATEGORY_PROP_ARRAY;
    l_catprop_3_choices  MGMT_CATEGORY_PROP_ARRAY;
    l_catprop_4_choices  MGMT_CATEGORY_PROP_ARRAY;
    l_catprop_5_choices  MGMT_CATEGORY_PROP_ARRAY;
    l_dflt_catprop_choices MGMT_CATEGORY_PROP_ARRAY;
    l_is_repository      mgmt_metrics.is_repository%TYPE;
    l_first_key          NUMBER;
    l_key_count          NUMBER;
    l_key_order          NUMBER;
    l_col                MGMT_METRIC_COLUMN_OBJ;
    l_column_guid_list   MGMT_USER_GUID_ARRAY;
    l_key_order_list     MGMT_INTEGER_ARRAY;
    l_category           MGMT_CATEGORY_OBJ;
    l_category_list      MGMT_CATEGORY_ARRAY;
    l_source_type        MGMT_METRICS.source_type%TYPE;
    l_source             MGMT_METRICS.source%TYPE;
    l_err_msg            VARCHAR2(4096);
    l_arg_type_list      MGMT_SHORT_STRING_ARRAY;
  BEGIN

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('create_metric:Enter', G_MODULE_NAME) ; 
    END IF ;

    -- TODO: Perform the following checks
    --      Check if the table metric has any columns
    --      Check if column names list has any duplicates
    --      Check if category list has any duplicates

    -- Check for Super user privilege.
    EM_CHECK.check_super_user_priv;

    -- Validate inputs
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');
    EM_CHECK.check_not_null(p_metric_type, 'p_metric_type');

    -- Verify that the metric_type is a valid metric_type.
    EM_CHECK.check_range(p_metric_type, MGMT_GLOBAL.G_METRIC_TYPE_MIN, 
       MGMT_GLOBAL.G_METRIC_TYPE_MAX, 'p_metric_type');

    -- Verify that the usage type is a valid usage type.
    EM_CHECK.check_not_null(p_usage_type, 'p_usage_type');
    EM_CHECK.check_range(p_usage_type, MGMT_GLOBAL.G_USAGE_MIN, 
       MGMT_GLOBAL.G_USAGE_MAX, 'p_usage_type');

    -- Calculate is_repository flag
    l_is_repository := MGMT_GLOBAL.G_FALSE;
    IF ( (p_is_repository = MGMT_GLOBAL.G_TRUE) OR
         (p_metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE) OR 
         (p_metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_NUMBER) OR 
         (p_metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_STRING) OR 
         (p_metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_EVENT) )
    THEN
      l_is_repository := MGMT_GLOBAL.G_TRUE;
    END IF;

    IF (l_is_repository = MGMT_GLOBAL.G_TRUE) THEN

      -- For repsoitory metrics check source_type
      EM_CHECK.check_not_null(p_source_type, 'p_source_type');

      EM_CHECK.check_range(p_source_type, MGMT_GLOBAL.G_METRIC_SOURCE_MIN, 
         MGMT_GLOBAL.G_METRIC_SOURCE_MAX, 'p_source_type');

      EM_CHECK.check_not_null(p_source, 'p_source');

      EM_CHECK.check_not_null(p_source, 'p_is_long_running');
      EM_CHECK.check_range(p_is_long_running, EM_TASK.G_TASK_CLASS_MIN, 
       EM_TASK.G_TASK_CLASS_MAX, 'p_is_long_running');

    END IF;

    -- Get key column list
    l_key_column := ' ';
    l_first_key  := 1;
    l_key_count  := 0;
    l_all_columns := MGMT_SHORT_STRING_ARRAY();
    l_column_guid_list := MGMT_USER_GUID_ARRAY();
    l_key_order_list := MGMT_INTEGER_ARRAY();
    IF ( (p_metric_column_list IS NOT NULL) AND (p_metric_column_list.COUNT > 0) )
    THEN

      l_column_guid_list.extend(p_metric_column_list.COUNT);
      l_key_order_list.extend(p_metric_column_list.COUNT);
      l_all_columns.extend(p_metric_column_list.COUNT);

      FOR col_ctr IN p_metric_column_list.FIRST..p_metric_column_list.LAST
      LOOP

        l_col := p_metric_column_list(col_ctr);
        l_column_guid_list(col_ctr) := generate_metric_guid(p_target_type, 
                                             p_metric_name, l_col.column_name);

        l_all_columns(col_ctr) := l_col.column_name;

        IF (l_col.is_key > 0)
        THEN

          l_key_count := l_key_count + 1;
          IF (l_first_key > 0)
          THEN
            l_key_column := l_col.column_name;
            l_first_key := 0;
          ELSE
            l_key_column := l_key_column || ';' || l_col.column_name;
          END IF;

          l_key_order := l_key_count;

        ELSE

          l_key_order := 0;

        END IF;

        l_key_order_list(col_ctr) := l_key_order;

      END LOOP;

    ELSE
      -- No columns
      l_key_column := ' ';

    END IF;

    -- Do not allow more than 5 key columns
    IF p_metric_type NOT IN (MGMT_GLOBAL.G_METRIC_TYPE_RAW,
                             MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
    THEN
      EM_CHECK.check_range(l_key_count,0,5,' key columns list ') ;
    END IF ;

    -- Validate the source
    IF (l_is_repository = MGMT_GLOBAL.G_TRUE) THEN

      IF (p_source_type = MGMT_GLOBAL.G_METRIC_SOURCE_QUERY) THEN

        IF (EM_METRIC_EVAL.is_valid_sql(p_source, l_all_columns, l_err_msg) = FALSE)
	THEN
          raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'Invalid SQL source. Error = ' || l_err_msg);
	END IF;

      ELSIF (p_source_type = MGMT_GLOBAL.G_METRIC_SOURCE_OLD_PLSQL) THEN

        l_arg_type_list := MGMT_SHORT_STRING_ARRAY('RAW', 'RAW', 'MGMT_METRIC_RESULTS');
        IF (EM_CHECK.is_valid_signature(p_source, l_arg_type_list, l_err_msg) = FALSE) 
	THEN
          raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'Invalid old style PLSQL source '  || p_source || ' . Error = ' || l_err_msg);
	END IF;

      ELSIF (p_source_type = MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL) THEN

        l_arg_type_list := MGMT_SHORT_STRING_ARRAY('RAW', 'RAW', 'VARCHAR2', 'MGMT_METRIC_VALUE_ARRAY');
        IF (EM_CHECK.is_valid_signature(p_source, l_arg_type_list, l_err_msg) = FALSE) 
	THEN
          raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'Invalid PLSQL source. Error = ' || l_err_msg);
	END IF;

      ELSIF (p_source_type = MGMT_GLOBAL.G_METRIC_SOURCE_BULK_PLSQL) THEN

        l_arg_type_list := MGMT_SHORT_STRING_ARRAY('MGMT_TARGET_GUID_ARRAY', 'RAW', 
	                                           'VARCHAR2', 'MGMT_METRIC_VALUE_ARRAY');
        IF (EM_CHECK.is_valid_signature(p_source, l_arg_type_list, l_err_msg) = FALSE) 
	THEN
          raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'Invalid Bulk PLSQL source. Error = ' || l_err_msg);
	END IF;

      END IF;

    ELSE
      -- For non-repository type metrics, source is not supported
      IF (p_source IS NOT NULL) THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'Source is not supported for non-repository metrics.');
      END IF;

    END IF;

    -- Get the list of meta versions for which metric has to be created.
    IF (l_is_repository = MGMT_GLOBAL.G_TRUE) THEN

      SELECT type_meta_ver
             BULK COLLECT INTO l_meta_ver_list
        FROM mgmt_target_type_versions
       WHERE target_type = p_target_type
         AND (em_target.compare_type_meta_vers(p_type_meta_ver, type_meta_ver) <= 0)
         AND ( (p_end_type_meta_ver IS NULL) OR
               (em_target.compare_type_meta_vers(type_meta_ver, p_end_type_meta_ver) <= 0) )
      UNION
      SELECT p_type_meta_ver
        FROM DUAL ;


      IF ( (l_meta_ver_list IS NULL) OR (l_meta_ver_list.COUNT = 0) ) THEN
        l_meta_ver_list := MGMT_SHORT_STRING_ARRAY();
        l_meta_ver_list.extend(1);
        l_meta_ver_list(1) := p_type_meta_ver;
      END IF;
         
    ELSE
      -- For non-repository metrics, create the metric for only one meta version
      l_meta_ver_list := MGMT_SHORT_STRING_ARRAY();
      l_meta_ver_list.extend(1);
      l_meta_ver_list(1) := p_type_meta_ver;
    END IF;


    l_dflt_catprop_choices := MGMT_CATEGORY_PROP_ARRAY(' ');
    l_dflt_valid_if_list := MGMT_VALIDIF_ARRAY(MGMT_VALIDIF_OBJ.NEW());

    l_metric_guid := generate_metric_guid(p_target_type, p_metric_name);

    l_valid_if_list := NVL(p_valid_if_list, l_dflt_valid_if_list);


    -- Iterate through the metric versions to be created
    FOR mv_ctr IN l_meta_ver_list.FIRST..l_meta_ver_List.LAST
    LOOP

      -- Iterate through valid if list
      FOR vi_ctr IN l_valid_if_list.FIRST..l_valid_if_list.LAST
      LOOP
        l_catprop_1_choices := NVL(l_valid_if_list(vi_ctr).catprop_1_choices, 
            l_dflt_catprop_choices);
        l_catprop_2_choices := NVL(l_valid_if_list(vi_ctr).catprop_2_choices, 
            l_dflt_catprop_choices);
        l_catprop_3_choices := NVL(l_valid_if_list(vi_ctr).catprop_3_choices, 
            l_dflt_catprop_choices);
        l_catprop_4_choices := NVL(l_valid_if_list(vi_ctr).catprop_4_choices, 
            l_dflt_catprop_choices);
        l_catprop_5_choices := NVL(l_valid_if_list(vi_ctr).catprop_5_choices, 
            l_dflt_catprop_choices);

        FOR cp1_ctr IN l_catprop_1_choices.FIRST..l_catprop_1_choices.LAST
        LOOP

          FOR cp2_ctr IN l_catprop_2_choices.FIRST..l_catprop_2_choices.LAST
          LOOP

            FOR cp3_ctr IN l_catprop_3_choices.FIRST..l_catprop_3_choices.LAST
            LOOP

              FOR cp4_ctr IN l_catprop_4_choices.FIRST..l_catprop_4_choices.LAST
              LOOP

                FOR cp5_ctr IN l_catprop_5_choices.FIRST..l_catprop_5_choices.LAST
                LOOP

                  -- Insert metric record 
                  EM_METRIC.add_metric_row(
                    p_metric_guid => l_metric_guid,
                    p_target_type => p_target_type,
                    p_metric_name => p_metric_name,
                    p_metric_column => ' ',
                    p_type_meta_ver => l_meta_ver_list(mv_ctr),
                    p_category_prop_1 => NVL(l_catprop_1_choices(cp1_ctr), ' '),
                    p_category_prop_2 => NVL(l_catprop_2_choices(cp2_ctr), ' '),
                    p_category_prop_3 => NVL(l_catprop_3_choices(cp3_ctr), ' '),
                    p_category_prop_4 => NVL(l_catprop_4_choices(cp4_ctr), ' '),
                    p_category_prop_5 => NVL(l_catprop_5_choices(cp5_ctr), ' '),
                    p_metric_type => p_metric_type,
                    p_usage_type  => p_usage_type,
                    p_metric_label => p_metric_label,
                    p_metric_label_nlsid => p_metric_label_nlsid,
                    p_column_label => NULL,
                    p_column_label_nlsid => NULL,
                    p_key_column => l_key_column,
                    p_key_order  => 0,
                    p_num_keys   => l_key_count,
                    p_description => p_description,
                    p_description_nlsid => p_description_nlsid, 
                    p_unit => p_unit,
                    p_unit_nlsid => p_unit_nlsid,
                    p_short_name => p_short_name,
                    p_short_name_nlsid => p_short_name_nlsid,
                    p_is_repository => l_is_repository,
                    p_author => p_author,
                    p_source_type => p_source_type, 
                    p_source => p_source,
                    p_keys_from_mult_colls => p_keys_from_mult_colls,
                    p_is_for_summary => 0,
                    p_statefull => 1,
	            p_is_transposed => p_is_transposed,
		    p_is_test_metric => p_is_test_metric,
		    p_has_push => p_has_push,
		    p_has_pull => p_has_pull,
		    p_remote => p_remote,
		    p_non_thresholded_alerts => p_non_thresholded_alerts,
		    p_keyonly_thresholds => p_keyonly_thresholds,
                    p_is_long_running    => p_is_long_running,
                    p_is_renderable      => p_is_renderable);


                  IF ((p_metric_column_list IS NOT NULL) AND (p_metric_column_list.COUNT > 0))
                  THEN 

                    FOR col_ctr IN p_metric_column_list.FIRST..p_metric_column_list.LAST
                    LOOP

                      l_col := p_metric_column_list(col_ctr);

                      -- Insert metric column record
                      EM_METRIC.add_metric_row(
                        p_metric_guid => l_column_guid_list(col_ctr),
                        p_target_type => p_target_type,
                        p_metric_name => p_metric_name,
                        p_metric_column => l_col.column_name,
                        p_type_meta_ver => l_meta_ver_list(mv_ctr),
                        p_category_prop_1 => NVL(l_catprop_1_choices(cp1_ctr), ' '),
                        p_category_prop_2 => NVL(l_catprop_2_choices(cp2_ctr), ' '),
                        p_category_prop_3 => NVL(l_catprop_3_choices(cp3_ctr), ' '),
                        p_category_prop_4 => NVL(l_catprop_4_choices(cp4_ctr), ' '),
                        p_category_prop_5 => NVL(l_catprop_5_choices(cp5_ctr), ' '),
                        p_metric_type => l_col.column_type,
                        p_usage_type  => p_usage_type,
                        p_metric_label => p_metric_label,
                        p_metric_label_nlsid => NULL,  -- NULL is passed as Agent was not populating this
                        p_column_label =>  l_col.column_label,
                        p_column_label_nlsid =>  l_col.column_label_nlsid,
                        p_key_column => l_key_column,
                        p_key_order  => l_key_order_list(col_ctr),
                        p_num_keys   => l_key_count,
                        p_description => l_col.description,
                        p_description_nlsid => l_col.description_nlsid,
                        p_unit => l_col.unit,
                        p_unit_nlsid => l_col.unit_nlsid,
                        p_short_name => l_col.short_name,
                        p_short_name_nlsid => l_col.short_name_nlsid,
                        p_is_repository => l_is_repository,
                        p_author => p_author,
                        p_source_type => l_col.source_type,
                        p_source => l_col.source,
                        p_keys_from_mult_colls => p_keys_from_mult_colls,
                        p_is_for_summary =>  l_col.is_for_summary,
                        p_statefull => l_col.statefull,
     	                p_is_transposed => p_is_transposed,
		        p_is_test_metric => p_is_test_metric,
		        p_has_push => p_has_push,
		        p_has_pull => p_has_pull,
		        p_remote => p_remote,
		        p_non_thresholded_alerts => l_col.non_thresholded_alerts,
		        p_keyonly_thresholds => l_col.keyonly_thresholds,
                        p_is_long_running    => p_is_long_running,
                        p_is_renderable      => l_col.is_renderable);

                    END LOOP;

                  END IF;

                END LOOP;

              END LOOP;

            END LOOP;

          END LOOP;

        END LOOP;

      END LOOP;

    END LOOP; -- l_meta_ver_list LOOP


    em_metric.add_object_categories(l_metric_guid, MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
       p_target_type, p_type_meta_ver, p_category_list);

    IF ((p_metric_column_list IS NOT NULL) AND (p_metric_column_list.COUNT > 0))
    THEN 
      -- Add categories for the metric columns
      FOR col_ctr IN p_metric_column_list.FIRST..p_metric_column_list.LAST
      LOOP

        l_col := p_metric_column_list(col_ctr);

        em_metric.add_object_categories(l_column_guid_list(col_ctr), 
               MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
               p_target_type, 
               p_type_meta_ver, 
               p_category_list);
  
        -- Add object categories for column overrides
        em_metric.add_object_categories(l_column_guid_list(col_ctr), 
               MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
               p_target_type, 
               p_type_meta_ver, 
               l_col.category_list);

      END LOOP;

    END IF;

    EM_METRIC.add_metric_snapshot_assocs(l_metric_guid, p_snapshot_name_list);

    -- Add a metric version row for the metric, only for repository metrics
    IF (l_is_repository = MGMT_GLOBAL.G_TRUE) THEN

      EM_METRIC.add_metric_version_row(
              p_target_type         => p_target_type,
              p_metric_name         => p_metric_name,
              p_start_type_meta_ver => p_type_meta_ver,
              p_end_type_meta_ver   => p_end_type_meta_ver);

    END IF;

  END create_metric;


  -- NOTES : Implementation not complete. Do not use.
  PROCEDURE modify_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                          p_valid_if_list      IN MGMT_VALIDIF_ARRAY DEFAULT NULL,
                          p_metric_type        IN NUMBER   DEFAULT 0,
                          p_usage_type         IN NUMBER   DEFAULT 0,
                          p_metric_label       IN VARCHAR2 DEFAULT NULL,
                          p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
                          p_description        IN VARCHAR2 DEFAULT ' ',
                          p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
                          p_unit               IN VARCHAR2 DEFAULT ' ',
                          p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
                          p_short_name         IN VARCHAR2 DEFAULT NULL,
                          p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
                          p_is_repository      IN NUMBER   DEFAULT 0,
                          p_author             IN VARCHAR2 DEFAULT 'ORACLE',
                          p_source_type        IN NUMBER   DEFAULT 0,
                          p_source             IN VARCHAR2 DEFAULT NULL,
                          p_keys_from_mult_colls IN NUMBER DEFAULT 0 ,
                          p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL,
                          p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
                          p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY DEFAULT NULL,
	                  p_is_transposed      IN NUMBER   DEFAULT NULL,
			  p_is_test_metric     IN NUMBER   DEFAULT NULL,
	                  p_has_push           IN NUMBER   DEFAULT NULL,
	                  p_has_pull           IN NUMBER   DEFAULT NULL,
	                  p_remote             IN NUMBER   DEFAULT NULL,
	                  p_non_thresholded_alerts IN NUMBER DEFAULT NULL,
	                  p_keyonly_thresholds IN NUMBER   DEFAULT NULL,
			  p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
                          p_is_long_running    IN NUMBER   DEFAULT NULL,
                          p_is_renderable      IN NUMBER   DEFAULT NULL)
  IS
    l_metric_guid        MGMT_METRICS.metric_guid%TYPE;
    l_old_start_tmv      mgmt_metrics.type_meta_ver%TYPE;
    l_old_end_tmv        mgmt_metrics.type_meta_ver%TYPE;
    l_metric_type        mgmt_metrics.metric_type%TYPE;
    l_is_repository      mgmt_metrics.is_repository%TYPE;
    l_col                MGMT_METRIC_COLUMN_OBJ;
    l_column_guid_list   MGMT_USER_GUID_ARRAY;
  BEGIN
    -- TODO: Remove the non-editable parameters from this list
    -- They are p_metric_type, p_sourec_type, p_source, p_keys_from_mult_colls, 
    --  p_is_transposed,, p_is_test_metric, p_remote, p_non_thresholded_alerts, 
    --  p_key_only_thresholds, p_is_renderable.
    --  Also need to verify num_keys and key_order.
    -- Any modifications to these should be done through delete and create

    raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 
          'Modify metric API is not implemented yet. This API name is reserved for future use. ');

    -- Check for Super user privilege.
    EM_CHECK.check_super_user_priv;

    -- Validate inputs
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');

    -- Raises metric does not exit if metric is missing
    l_metric_guid := get_metric_guid(p_target_type, p_metric_name);

    BEGIN
      SELECT start_type_meta_ver, end_type_meta_ver
        INTO l_old_start_tmv, l_old_end_tmv
        FROM mgmt_metric_versions
       WHERE target_type = p_target_type
         AND metric_name = p_metric_name;
    EXCEPTION
      WHEN OTHERS THEN
        -- For non-repository metrics, this table is not populated
        l_old_start_tmv := p_type_meta_ver;
    END;

    -- Get metric info from the start_meta_ver, which always exists
    -- like metric_type, is_repository etc
    SELECT metric_type, is_repository
      INTO l_metric_type, l_is_repository
      FROM mgmt_metrics
     WHERE target_type = p_target_type
       AND metric_name = p_metric_name
       AND metric_column = ' '
       AND type_meta_ver = l_old_start_tmv;

    -- Validate metric_type, is_repository 


    IF (l_is_repository = 1) THEN
      -- Get existing metric row details
      -- Generate add list, delete list

      -- Update metric_version_row table
      EM_METRIC.add_metric_version_row(
              p_target_type         => p_target_type,
              p_metric_name         => p_metric_name,
              p_start_type_meta_ver => p_type_meta_ver,
              p_end_type_meta_ver   => p_end_type_meta_ver);
      

    END IF;
   

    -- Snapshot list shoule be modified
    IF (p_snapshot_name_list IS NOT NULL) AND (p_snapshot_name_list.COUNT > 0) THEN
      EM_METRIC.remove_metric_snapshot_assocs(l_metric_guid);
      EM_METRIC.add_metric_snapshot_assocs(l_metric_guid, p_snapshot_name_list);
    END IF;

    -- Delete metric categorization
    FOR crec IN (SELECT DISTINCT(metric_guid) FROM MGMT_METRICS
                  WHERE target_type = p_target_type
                    AND metric_name = p_metric_name
                    AND type_meta_ver = NVL(p_type_meta_ver, type_meta_ver))
    LOOP
      EM_METRIC.remove_object_categories(crec.metric_guid, 
                                       MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
                                       p_target_type, p_type_meta_ver);
    END LOOP;

    em_metric.add_object_categories(l_metric_guid, MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
       p_target_type, p_type_meta_ver, p_category_list);

    IF ((p_metric_column_list IS NOT NULL) AND (p_metric_column_list.COUNT > 0))
    THEN 
      -- Add categories for the metric columns
      FOR col_ctr IN p_metric_column_list.FIRST..p_metric_column_list.LAST
      LOOP

        l_col := p_metric_column_list(col_ctr);

        em_metric.add_object_categories(l_column_guid_list(col_ctr), 
               MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
               p_target_type, 
               p_type_meta_ver, 
               p_category_list);
  
        -- Add object categories for column overrides
        em_metric.add_object_categories(l_column_guid_list(col_ctr), 
               MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
               p_target_type, 
               p_type_meta_ver, 
               l_col.category_list);

      END LOOP;

    END IF;

  END modify_metric;

  PROCEDURE delete_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT NULL)
  IS
    l_metric_guid mgmt_metrics.metric_guid%TYPE;
    l_pol_cnt     NUMBER := 0;
    l_proc_name          VARCHAR2(32) := 'delete_metric ';
  BEGIN
    --      Check for Super user privilege.
    EM_CHECK.check_super_user_priv;

    --      Validate inputs
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');

    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.DEBUG(l_proc_name || ' Enter ttype  = ' || p_target_type  ||
          ' (metric_name = ' || p_metric_name || ')' ||
          ' (meta_ver = ' || p_type_meta_ver || ')',
          G_MODULE_NAME) ; 
    END IF ;

    l_metric_guid := get_metric_guid(p_target_type, p_metric_name);

    -- Check if there are any policies (type 2) and fail the delete
    SELECT count(*) INTO l_pol_cnt
      FROM mgmt_policies
     WHERE metric_guid = l_metric_guid
       AND policy_type = MGMT_GLOBAL.G_TYPE_POLICY;

    IF (l_pol_cnt > 0) THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 
          'Cannot delete the metric with existing policies. ' ||
          'All the policies have to be removed before removing the metric.');
    END IF;

    EM_METRIC.delete_metric_data(p_target_type, p_metric_name, p_type_meta_ver);

    delete_metric_metadata(p_target_type, p_metric_name, p_type_meta_ver);

    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.DEBUG(l_proc_name || ' Exit ttype  = ' || p_target_type  ||
          ' (metric_name = ' || p_metric_name || ')' ||
          ' (meta_ver = ' || p_type_meta_ver || ')',
          G_MODULE_NAME) ; 
    END IF ;

  END delete_metric;

  PROCEDURE delete_metric_metadata(
              p_target_type        IN VARCHAR2, 
              p_metric_name        IN VARCHAR2,  
              p_type_meta_ver      IN VARCHAR2 DEFAULT NULL)
  IS
    l_metric_guid mgmt_metrics.metric_guid%TYPE;
    l_metric_cnt  INTEGER;
    l_pol_cnt     NUMBER := 0;
    l_proc_name   VARCHAR2(32) := 'delete_metric_metadata ';
  BEGIN

    --      Check for Super user privilege.
    EM_CHECK.check_super_user_priv;

    --      Validate inputs
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');

    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.DEBUG(l_proc_name || ' Enter ttype  = ' || p_target_type  ||
          ' (metric_name = ' || p_metric_name || ')' ||
          ' (meta_ver = ' || p_type_meta_ver || ')',
          G_MODULE_NAME) ; 
    END IF ;

    l_metric_guid := get_metric_guid(p_target_type, p_metric_name);

    -- Check if there are any policies (type 2) and fail the delete
    SELECT count(*) INTO l_pol_cnt
      FROM mgmt_policies
     WHERE metric_guid = l_metric_guid
       AND policy_type = MGMT_GLOBAL.G_TYPE_POLICY;

    IF (l_pol_cnt > 0) THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 
          'Cannot delete the metric with existing policies. ' ||
          'All the policies have to be removed before removing the metric.');
    END IF;

    -- Delete snapshot metric map
    EM_METRIC.remove_metric_snapshot_assocs(l_metric_guid);

    -- Delete metric categorization and metric promotion subsystem
    FOR crec IN (SELECT DISTINCT metric_guid, metric_column, type_meta_ver
                   FROM MGMT_METRICS
                  WHERE target_type = p_target_type
                    AND metric_name = p_metric_name
                    AND type_meta_ver = NVL(p_type_meta_ver, type_meta_ver))
    LOOP
      EM_METRIC.remove_object_categories(crec.metric_guid, 
                                       MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
                                       p_target_type, p_type_meta_ver);
      mgmt_target.delete_metric_severity_deps(MGMT_METRIC_DESC.NEW(p_target_type,
                                         p_metric_name, crec.metric_column,
                                         crec.type_meta_ver));

    END LOOP;

    -- Delete metric rows
    DELETE FROM MGMT_METRICS
     WHERE target_type = p_target_type
       AND metric_name = p_metric_name
       AND type_meta_ver = NVL(p_type_meta_ver, type_meta_ver);

    -- Remove details from metric versions table, if the last of the metric is deleted
    -- Also, remove the threshold policies created for this metric.
    SELECT COUNT(1) INTO l_metric_cnt
      FROM mgmt_metrics
     WHERE metric_guid = l_metric_guid;

    IF (l_metric_cnt = 0) THEN

      -- Delete threshold policies created for this metric
      DELETE FROM MGMT_POLICIES
       WHERE metric_guid = l_metric_guid
         AND policy_type = MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC;

      -- Delete the metric version row 
      EM_METRIC.remove_metric_version_row(p_target_type, p_metric_name);

    END IF;

    IF EMDW_LOG.P_IS_DEBUG_SET THEN
      EMDW_LOG.DEBUG(l_proc_name || ' Exit ttype  = ' || p_target_type  ||
          ' (metric_name = ' || p_metric_name || ')' ||
          ' (meta_ver = ' || p_type_meta_ver || ')',
          G_MODULE_NAME) ; 
    END IF ;

  END delete_metric_metadata;


  -- Sets the end type meta ver for a give repository metric
  PROCEDURE set_end_type_meta_ver(
              p_target_type        IN VARCHAR2, 
              p_metric_name        IN VARCHAR2,  
              p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL)
  IS
    l_old_start_tmv mgmt_metrics.type_meta_ver%TYPE;
    l_old_end_tmv   mgmt_metrics.type_meta_ver%TYPE;
    l_meta_ver_list      MGMT_SHORT_STRING_ARRAY := MGMT_SHORT_STRING_ARRAY();
    l_metric_guid   mgmt_metrics.metric_guid%TYPE;
    l_comp          NUMBER := 0;
  BEGIN
    --      Check for Super user privilege.
    EM_CHECK.check_super_user_priv;

    --      Validate inputs
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');

    l_metric_guid := get_metric_guid(p_target_type, p_metric_name);

    BEGIN
      SELECT start_type_meta_ver, end_type_meta_ver
        INTO l_old_start_tmv, l_old_end_tmv
        FROM mgmt_metric_versions
       WHERE target_type = p_target_type
         AND metric_name = p_metric_name;
    EXCEPTION
      WHEN OTHERS THEN
        -- For non-repository metrics, this table is not populated
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
          'Invalid parameters : ' ||
          ' End type meta version can be set only for repository metrics.');
    END;

    -- Update metric_version_row table
    EM_METRIC.update_metric_version_row(
              p_target_type         => p_target_type,
              p_metric_name         => p_metric_name,
              p_end_type_meta_ver   => p_end_type_meta_ver);

    l_comp := EM_TARGET.compare_type_meta_vers(
                 p_type_meta_ver_1 => NVL(l_old_end_tmv, TYPE_META_VER_DEF_VAL),
                 p_type_meta_ver_2 => NVL(p_end_type_meta_ver, TYPE_META_VER_DEF_VAL) );
   
    IF (l_comp > 0) THEN
      -- old_tmv > new_tmv
      -- Delete any outscoped metric versions

      SELECT DISTINCT type_meta_ver
             BULK COLLECT INTO l_meta_ver_list
        FROM mgmt_metrics
       WHERE target_type = p_target_type
         AND metric_name = p_metric_name
         AND metric_column = ' '
         AND (em_target.compare_type_meta_vers(type_meta_ver, 
                        NVL(p_end_type_meta_ver, TYPE_META_VER_DEF_VAL)) > 0);

      -- TODO: Perf fix, use a arary version of delete_metric
      IF l_meta_ver_list IS NOT NULL AND l_meta_ver_list.COUNT > 0
      THEN
        FOR mv_ctr IN l_meta_ver_list.FIRST..l_meta_ver_List.LAST
        LOOP
          MGMT_METRIC.delete_metric(
              p_target_type => p_target_type,
              p_metric_name => p_metric_name,
              p_type_meta_ver => l_meta_ver_list(mv_ctr));
        END LOOP;
      END IF;
    ELSIF (l_comp < 0) THEN
      -- old_tmv < new_tmv
      -- Copy the metric to new versions
      SELECT type_meta_ver
             BULK COLLECT INTO l_meta_ver_list
        FROM mgmt_target_type_versions
       WHERE target_type = p_target_type
         AND (em_target.compare_type_meta_vers(type_meta_ver, 
                        NVL(l_old_end_tmv, TYPE_META_VER_DEF_VAL)) >= 0);

      IF (l_old_end_tmv IS NOT NULL) THEN
        l_meta_ver_list.extend(1);
        l_meta_ver_list(l_meta_ver_list.COUNT) := l_old_end_tmv;
      END IF;

      IF l_meta_ver_list IS NOT NULL AND l_meta_ver_list.COUNT > 0
      THEN
        FOR mv_ctr IN l_meta_ver_list.FIRST..l_meta_ver_List.LAST
        LOOP
          EM_METRIC.copy_metric(
              p_target_type => p_target_type,
              p_metric_name => p_metric_name,
              p_from_type_meta_ver => l_old_start_tmv,
              p_to_type_meta_ver => l_meta_ver_list(mv_ctr));
        END LOOP;
      END IF;
    END IF;

  END set_end_type_meta_ver;



  -- Category Class API
  PROCEDURE create_category_class(
              p_class_name        IN VARCHAR2, 
              p_class_name_nlsid  IN VARCHAR2 DEFAULT NULL,
              p_category_def_list IN MGMT_CATEGORY_DEF_ARRAY DEFAULT NULL)
  IS
  BEGIN

    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_class_name, 'p_class_name');

    EM_METRIC.add_category_class(p_class_name, p_class_name_nlsid);

    EM_METRIC.add_categories(p_class_name,  p_category_def_list);

  END create_category_class;


  PROCEDURE delete_category_class(
              p_class_name        IN VARCHAR2)
  IS
  BEGIN

    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_class_name, 'p_class_name');

    -- TODO: Disable removing category class if it is being used.

    -- Delete all categories, first
    EM_METRIC.remove_category(p_class_name);

    -- And, delete the class itself.
    EM_METRIC.remove_category_class(p_class_name);

  END delete_category_class;


  -- Category API
  PROCEDURE create_categories(
              p_class_name        IN VARCHAR2, 
              p_category_def_list IN MGMT_CATEGORY_DEF_ARRAY DEFAULT NULL)
  IS 
  BEGIN

    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_class_name, 'p_class_name');

    IF ( (p_category_def_list IS NULL) OR (p_category_def_list.COUNT = 0) ) THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Invalid parameters : NULL or empty category definition list');
    END IF;

    EM_METRIC.add_categories(p_class_name, p_category_def_list);

  END create_categories;

  PROCEDURE create_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2,  
              p_category_name_nlsid IN VARCHAR2 DEFAULT NULL)
  IS
  BEGIN

    -- TODO: Enforce the size limits.
    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_class_name, 'p_class_name');
    EM_CHECK.check_not_null(p_category_name, 'p_category_name');

    EM_METRIC.add_category(p_class_name, p_category_name, p_category_name_nlsid);

  END create_category;

  PROCEDURE delete_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2)
  IS
  BEGIN

    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_class_name, 'p_class_name');
    EM_CHECK.check_not_null(p_category_name, 'p_category_name');

    -- TODO: Check to see if this category is being used.

    EM_METRIC.remove_category(p_class_name, p_category_name);

  END delete_category;



 
  -- Category Association API
  PROCEDURE categorize_metric(
              p_metric_name        IN VARCHAR2,  
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL)
  IS
    l_metric_column mgmt_metrics.metric_column%TYPE;
    l_metric_guid   mgmt_metrics.metric_guid%TYPE;
  BEGIN

    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');

    l_metric_column := NVL(p_metric_column, ' ');

    l_metric_guid := get_metric_guid(p_target_type, p_metric_name, p_metric_column);

    EM_METRIC.add_object_categories(
              p_object_guid  => l_metric_guid,
              p_object_type  => MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
              p_target_type  => p_target_type,
              p_type_meta_ver => p_type_meta_ver,
              p_category_list => p_category_list);

  END categorize_metric;

  PROCEDURE categorize_policy(
              p_policy_name        IN VARCHAR2,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL)
  IS
    l_policy_guid   mgmt_policies.policy_guid%TYPE;
  BEGIN
    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_policy_name, 'p_policy_name');
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');

    l_policy_guid := MGMT_POLICY.get_policy_guid(p_target_type, p_policy_name);

    EM_METRIC.add_object_categories(
              p_object_guid  => l_policy_guid,
              p_object_type  => MGMT_GLOBAL.G_TYPE_POLICY,
              p_target_type  => p_target_type,
              p_type_meta_ver => p_type_meta_ver,
              p_category_list => p_category_list);

  END categorize_policy;


  PROCEDURE remove_metric_categories(
              p_metric_name        IN VARCHAR2,  
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL)
  IS
    l_metric_column mgmt_metrics.metric_column%TYPE;
    l_metric_guid   mgmt_metrics.metric_guid%TYPE;
  BEGIN
    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_metric_name, 'p_metric_name');
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');

    l_metric_column := NVL(p_metric_column, ' ');

    l_metric_guid := get_metric_guid(p_target_type, p_metric_name, p_metric_column);

    EM_METRIC.remove_object_categories(
              p_object_guid  => l_metric_guid,
              p_object_type  => MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC,
              p_target_type  => p_target_type,
              p_type_meta_ver => p_type_meta_ver,
              p_category_list => p_category_list);

  END remove_metric_categories;

  PROCEDURE remove_policy_categories(
              p_policy_name        IN VARCHAR2,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
              p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL)
  IS
    l_policy_guid   mgmt_policies.policy_guid%TYPE;
  BEGIN
    EM_CHECK.check_super_user_priv;
    EM_CHECK.check_not_null(p_policy_name, 'p_policy_name');
    EM_CHECK.check_not_null(p_target_type, 'p_target_type');

    l_policy_guid := MGMT_POLICY.get_policy_guid(p_target_type, p_policy_name);

    EM_METRIC.add_object_categories(
              p_object_guid  => l_policy_guid,
              p_object_type  => MGMT_GLOBAL.G_TYPE_POLICY,
              p_target_type  => p_target_type,
              p_type_meta_ver => p_type_meta_ver,
              p_category_list => p_category_list);

  END remove_policy_categories;

END mgmt_metric;
/

show errors

