Rem
Rem $Header: sdk_metric_pkgdef.sql 01-sep-2005.15:44:41 rpinnama Exp $
Rem
Rem sdk_metric_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_metric_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    09/01/05 - Add set_end_type_meta_ver API 
Rem    rpinnama    08/31/05 - Change the type_meta_ver default for 
Rem                           delete_metric 
Rem    rpinnama    05/17/05 - Add is_renderable to create_metric API. 
Rem    jsadras     05/02/05 - add is_long_running 
Rem    rpinnama    02/25/05 - Bug 3924067: Add non_thresholded_alerts and 
Rem                           keyonly_thresholds columns 
Rem    rpinnama    01/07/05 - Add support for start/end type_meta_vers 
Rem    rpinnama    01/06/05 - Fix delete_metric API 
Rem    rpinnama    10/05/04 - Support source at metric column level 
Rem    gan         09/14/04 - add remote parameter 
Rem    rpinnama    08/19/04 - Add has_push, has_pull attributes 
Rem    rpinnama    08/18/04 - Add is_test_metric to create_metric API 
Rem    streddy     08/10/04 - Add is_transposed to create_metric 
Rem    rpinnama    08/16/04 - Change the signature to accept snapshot_array 
Rem    rpinnama    08/03/04 - Default source_type to 0 
Rem    rpinnama    07/29/04 - Add snapshopt_list 
Rem    rpinnama    07/23/04 - Add get_metric_guid API 
Rem    rpinnama    07/07/04 - rpinnama_add_metric_api
Rem    rpinnama    06/29/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_metric
AS

  -- The module name for error and performance logging
  G_MODULE_NAME constant varchar2(40) := 'MGMT_METRIC';

  --
  -- FUNCTION: generate_metric_guid
  --
  -- PURPOSE:
  --   Given a target type,  metric name and column name, this function 
  --   computes the metric guid for the metric. The guid is an MD5 hash of
  --   the target type and metric name. 
  --
  -- IN Parameters:
  --   p_target_type: The type of the target
  --   p_metric_name: The name of the metric
  --   p_metric_column : The name of the column
  --
  -- RETURN:
  --   The generated metric guid
  --
  FUNCTION generate_metric_guid(p_target_type   IN VARCHAR2,
                                p_metric_name   IN VARCHAR2,
                                p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE;


  --
  -- FUNCTION: get_metric_guid
  --
  -- PURPOSE: 
  --   The metrics in the repository are identified by a globally unique
  --   identifier (guid). This function returns the guid for a given metric.
  -- 
  -- IN Parameters:
  --   p_target_type: VARCHAR2 The type of the target
  --   p_metric_name: VARCHAR2 The name of the metric
  --   p_metric_column: VARCHAR2 The name of the metric column
  -- 
  -- OUT Parameters:
  --   The GUID for the requested metric.
  -- 
  -- ERROR CODES:
  --   NO_SUCH_METRIC_FOUND: No such metric was found.
  --
  -- NOTES:
  --   This is primarily intended to be used by the SDK but it may also be used 
  --   to write more customized PL/SQL to access the repository information.
  --   Please remember to check to see if your requirements can be handled by 
  --   the SDK. Writing customized PL/SQL has the problem of having to deal with 
  --   changes to the underlying table structure.
  --
  FUNCTION get_metric_guid(p_target_type   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE;


  --
  -- FUNCTION: get_metric_guid_for_target
  --
  -- PURPOSE: 
  --   This function returns the guid of a metric, if the metric is
  --   valid for the target.
  -- 
  -- IN Parameters:
  --   p_target_type: VARCHAR2 The type of the target
  --   p_target_name: VARCHAR2 The name of the target
  --   p_metric_name: VARCHAR2 The name of the metric
  --   p_metric_column: VARCHAR2 The name of the metric column
  -- 
  -- OUT Parameters:
  --   The GUID for the requested metric.
  -- 
  -- ERROR CODES:
  --   NO_SUCH_METRIC_FOUND: No such metric was found.
  --
  -- NOTES:
  FUNCTION get_metric_guid_for_target(
                           p_target_type   IN VARCHAR2,
                           p_target_name   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ')
    RETURN mgmt_metrics.metric_guid%TYPE;

  --
  -- FUNCTION: get_metric_guid_for_props
  --
  -- PURPOSE: 
  --   This function returns the guid of a metric for the given metaversion
  --   and category properties
  -- 
  -- IN Parameters:
  --   p_target_type: VARCHAR2 The type of the target
  --   p_metric_name: VARCHAR2 The name of the metric
  --   p_metric_column: VARCHAR2 The name of the metric column
  --   p_type_meta_ver: VARCHAR2 The metaversion of the target type
  --   p_category_prop_1: VARCHAR2 The value of the category property 1
  --   p_category_prop_2: VARCHAR2 The value of the category property 2
  --   p_category_prop_3: VARCHAR2 The value of the category property 3
  --   p_category_prop_4: VARCHAR2 The value of the category property 4
  --   p_category_prop_5: VARCHAR2 The value of the category property 5
  -- 
  -- OUT Parameters:
  --   The GUID for the requested metric.
  -- 
  -- ERROR CODES:
  --   NO_SUCH_METRIC_FOUND: No such metric was found.
  --
  -- NOTES:
  FUNCTION get_metric_guid_for_props(
                           p_target_type   IN VARCHAR2,
                           p_metric_name   IN VARCHAR2,
                           p_metric_column IN VARCHAR2 DEFAULT ' ',
			   p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
			   p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
			   p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
			   p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
			   p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
			   p_category_prop_5 IN VARCHAR2 DEFAULT ' ')

    RETURN mgmt_metrics.metric_guid%TYPE;

  -- Metric Definition API

  --
  -- FUNCTION: create_metric
  --
  -- PURPOSE:
  --   Given a target type,  metric name and other details, the metric is created
  --   with all ValidIfs and its columns.
  --
  PROCEDURE create_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                          p_valid_if_list      IN MGMT_VALIDIF_ARRAY DEFAULT NULL,
                          p_metric_type        IN NUMBER   DEFAULT 0,
                          p_usage_type         IN NUMBER   DEFAULT 0,
                          p_metric_label       IN VARCHAR2 DEFAULT NULL,
                          p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
                          p_description        IN VARCHAR2 DEFAULT ' ',
                          p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
                          p_unit               IN VARCHAR2 DEFAULT ' ',
                          p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
                          p_short_name         IN VARCHAR2 DEFAULT NULL,
                          p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
                          p_is_repository      IN NUMBER   DEFAULT 0,
                          p_author             IN VARCHAR2 DEFAULT 'ORACLE',
                          p_source_type        IN NUMBER   DEFAULT 0,
                          p_source             IN VARCHAR2 DEFAULT NULL,
                          p_keys_from_mult_colls IN NUMBER DEFAULT 0,
			  p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL,
                          p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
                          p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY DEFAULT NULL,
	                  p_is_transposed      IN NUMBER   DEFAULT 0,
			  p_is_test_metric     IN NUMBER   DEFAULT 0,
	                  p_has_push           IN NUMBER   DEFAULT 0,
	                  p_has_pull           IN NUMBER   DEFAULT 0,
	                  p_remote             IN NUMBER   DEFAULT 0,
	                  p_non_thresholded_alerts IN NUMBER DEFAULT 0,
	                  p_keyonly_thresholds IN NUMBER  DEFAULT 0,
			  p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
                          p_is_long_running    IN NUMBER   DEFAULT 0,
                          p_is_renderable      IN NUMBER   DEFAULT 1);

  PROCEDURE modify_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                          p_valid_if_list      IN MGMT_VALIDIF_ARRAY DEFAULT NULL,
                          p_metric_type        IN NUMBER   DEFAULT 0,
                          p_usage_type         IN NUMBER   DEFAULT 0,
                          p_metric_label       IN VARCHAR2 DEFAULT NULL,
                          p_metric_label_nlsid IN VARCHAR2 DEFAULT NULL,
                          p_description        IN VARCHAR2 DEFAULT ' ',
                          p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
                          p_unit               IN VARCHAR2 DEFAULT ' ',
                          p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
                          p_short_name         IN VARCHAR2 DEFAULT NULL,
                          p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
                          p_is_repository      IN NUMBER   DEFAULT 0,
                          p_author             IN VARCHAR2 DEFAULT 'ORACLE',
                          p_source_type        IN NUMBER   DEFAULT 0,
                          p_source             IN VARCHAR2 DEFAULT NULL,
                          p_keys_from_mult_colls IN NUMBER DEFAULT 0 ,
			  p_snapshot_name_list IN MGMT_SNAPSHOT_ARRAY DEFAULT NULL,
                          p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
                          p_metric_column_list IN MGMT_METRIC_COLUMN_ARRAY DEFAULT NULL,
	                  p_is_transposed      IN NUMBER   DEFAULT NULL,
			  p_is_test_metric     IN NUMBER   DEFAULT NULL,
	                  p_has_push           IN NUMBER   DEFAULT NULL,
	                  p_has_pull           IN NUMBER   DEFAULT NULL,
	                  p_remote             IN NUMBER   DEFAULT NULL,
	                  p_non_thresholded_alerts IN NUMBER DEFAULT NULL,
	                  p_keyonly_thresholds IN NUMBER   DEFAULT NULL,
			  p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL,
                          p_is_long_running    IN NUMBER   DEFAULT NULL,
                          p_is_renderable      IN NUMBER   DEFAULT NULL);

  PROCEDURE delete_metric(p_target_type        IN VARCHAR2, 
                          p_metric_name        IN VARCHAR2,  
                          p_type_meta_ver      IN VARCHAR2 DEFAULT NULL);

  PROCEDURE delete_metric_metadata(
              p_target_type        IN VARCHAR2, 
              p_metric_name        IN VARCHAR2,  
              p_type_meta_ver      IN VARCHAR2 DEFAULT NULL);

  -- Sets the end type meta ver for a give repository metric
  PROCEDURE set_end_type_meta_ver(
              p_target_type        IN VARCHAR2, 
              p_metric_name        IN VARCHAR2,  
              p_end_type_meta_ver  IN VARCHAR2 DEFAULT NULL);


  -- Category Class Definition API
  PROCEDURE create_category_class(
              p_class_name        IN VARCHAR2, 
              p_class_name_nlsid  IN VARCHAR2 DEFAULT NULL,
              p_category_def_list IN MGMT_CATEGORY_DEF_ARRAY DEFAULT NULL);

  PROCEDURE delete_category_class(
              p_class_name        IN VARCHAR2);

  -- Category Definition API
  PROCEDURE create_categories(
              p_class_name        IN VARCHAR2, 
              p_category_def_list IN MGMT_CATEGORY_DEF_ARRAY DEFAULT NULL);

  PROCEDURE create_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2,  
              p_category_name_nlsid IN VARCHAR2 DEFAULT NULL);

  PROCEDURE delete_category(
              p_class_name          IN VARCHAR2, 
              p_category_name       IN VARCHAR2);

 
  -- Category Association API
  PROCEDURE categorize_metric(
              p_metric_name        IN VARCHAR2,  
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

  PROCEDURE categorize_policy(
              p_policy_name        IN VARCHAR2,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

  PROCEDURE remove_metric_categories(
              p_metric_name        IN VARCHAR2,  
              p_metric_column      IN VARCHAR2 DEFAULT ' ',
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

  PROCEDURE remove_policy_categories(
              p_policy_name        IN VARCHAR2,
              p_target_type        IN VARCHAR2 DEFAULT NULL,
              p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
	      p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL);

END mgmt_metric;
/

show errors

