Rem
Rem $Header: sdk_monitoring_pkgdef.sql 16-jun-2005.18:06:46 rzazueta Exp $
Rem
Rem sdk_monitoring_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_monitoring_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rzazueta    06/16/05 - Add new delete_mntr_set_copy 
Rem    rpinnama    06/21/05 - Fix 4361635: Provide get_target_settings API 
Rem    rpinnama    04/15/05 - Add module name 
Rem    rpinnama    11/18/04 - Add delete_target_config API 
Rem    groyal      10/25/04 - Add save_target_policy_config 
Rem    rpinnama    10/10/04 - Change template to mntr 
Rem    rpinnama    09/27/04 - 
Rem    rpinnama    09/24/04 - Add APIs for monitoring sets 
Rem    rpinnama    08/26/04 - Add save settings API 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/26/04 - Created
Rem



CREATE OR REPLACE PACKAGE mgmt_monitoring
AS

  -- The module name for error and performance logging
  G_MODULE_NAME constant varchar2(40) := 'MGMT_MONITORING';

  -- 
  -- Gets the monitoring settings, which include
  --    List of metircs and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credentials
  --
  PROCEDURE get_target_settings(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_list        OUT MGMT_MNTR_METRIC_ARRAY,
      p_policy_list        OUT MGMT_MNTR_POLICY_ARRAY,
      p_collection_list    OUT MGMT_MNTR_COLLECTION_ARRAY);

  -- 
  -- Saves the monitoring settings, which include
  --    List of metircs and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credential
  --
  -- NOTES: This API is used by console to save monitoring settings
  --
  PROCEDURE SAVE_SETTINGS (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_list        IN MGMT_MNTR_METRIC_ARRAY DEFAULT NULL,
      p_policy_list        IN MGMT_MNTR_POLICY_ARRAY DEFAULT NULL,
      p_collection_list    IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL
    );

  --
  --  Saves the threshold settings for a given target-metric association
  --
  PROCEDURE save_target_metric_config (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2,
      p_coll_name          IN VARCHAR2,
      p_is_enabled         IN NUMBER DEFAULT 1,
      p_policy_val_list    IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
    );

  --
  --  Deletes the threshold settings for a given target-metric association
  --
  PROCEDURE delete_target_metric_config (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2,
      p_coll_name          IN VARCHAR2
  );

  --
  --  Saves the policy settings for a given target-policy association
  --
  PROCEDURE save_target_policy_config (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,      
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_is_enabled         IN NUMBER DEFAULT 1,
      p_policy_val_list    IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
    );

  --
  --  Deletes the policy settings for a given target-policy association
  --
  PROCEDURE delete_target_policy_config (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,      
      p_coll_name          IN VARCHAR2 DEFAULT ' ');

  PROCEDURE SET_THRESHOLD(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_crit_threshold     IN VARCHAR2 DEFAULT NULL,
      p_warn_threshold     IN VARCHAR2 DEFAULT NULL,
      p_info_threshold     IN VARCHAR2 DEFAULT NULL);

  
  -- Monitoring Settings copy API
  -- Generate monitoring set guid
  FUNCTION generate_mntr_set_copy_guid (
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_copy_req_guid      IN RAW)
     RETURN RAW;

  FUNCTION get_mntr_set_copy_guid (
      p_target_type      IN VARCHAR2,
      p_target_name      IN VARCHAR2,
      p_copy_req_guid    IN RAW)
     RETURN RAW;

  -- 
  -- Gets the monitoring settings, which include
  --    List of metircs and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credentials
  --
  PROCEDURE get_mntr_set_copy_settings(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_copy_req_guid      IN RAW,
      p_metric_list        OUT MGMT_MNTR_METRIC_ARRAY,
      p_policy_list        OUT MGMT_MNTR_POLICY_ARRAY,
      p_collection_list    OUT MGMT_MNTR_COLLECTION_ARRAY);

  --
  -- Only metric and collection arrays are saved with a monitoring set copy
  -- Policy array is not required as policies are not sent to agent
  FUNCTION create_mntr_set_copy (
      p_target_type     IN VARCHAR2,
      p_target_name     IN VARCHAR2,
      p_copy_req_guid   IN RAW,
      p_metric_list     IN MGMT_MNTR_METRIC_ARRAY DEFAULT NULL,
      p_collection_list IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL)
    RETURN RAW;

  -- Delete a given monitoring set copy
  PROCEDURE delete_mntr_set_copy (
      p_target_type      IN VARCHAR2,
      p_target_name      IN VARCHAR2,
      p_copy_req_guid    IN RAW
   );

  -- Delete a given monitoring set copy
  PROCEDURE delete_mntr_set_copy (
      p_mntr_set_copy_guid    IN RAW
   );


END mgmt_monitoring;
/

show errors;

