Rem
Rem $Header: sdk_notification_pkgbody.sql 19-may-2007.22:45:58 neearora Exp $
Rem
Rem sdk_notification_pkgbody.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_notification_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    05/03/07 - added API to get set global repeat settings
Rem    neearora    11/15/05 - Created
Rem

--
-- This package provides APIs to create, modify, and
-- delete notification_methods and to associate / deassociate.
-- methods with rules

CREATE OR REPLACE PACKAGE BODY mgmt_notification
AS

--
-- PROCEDURE: ADD_JAVA_DEVICE
--
-- PURPOSE:
--   Create a new notification device of type Java.
--
-- IN Parameters:
--   p_device_name  : Name of the notification device
--   p_profile_name : The name of the admin profile  
--   p_java         : Fully qualified name of the class implementing the notification interface
--   p_description  : Description for this device
--   p_context      : String array of context that will be passed to the notify method while delivering the notification.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE ADD_JAVA_DEVICE(p_device_name  IN VARCHAR2,
                          p_profile_name IN VARCHAR2,
                          p_class        IN VARCHAR2,
                          p_description  IN VARCHAR2 DEFAULT '',
                          p_context      IN MGMT_MEDIUM_STRING_TABLE DEFAULT NULL) 
IS
BEGIN
  EMD_NOTIFICATION.add_java_device(v_device_name  => p_device_name,
                                   v_profile_name => p_profile_name,    
                                   v_class        => p_class,
                                   v_description  => p_description,
                                   v_context      => p_context
                                  );
END ADD_JAVA_DEVICE;     

--
-- PROCEDURE: EDIT_JAVA_DEVICE
--
-- PURPOSE:
--   Modify the existing notification device of type Java.
--   Update p_class, p_description and context for the given p_device_name and p_profile_name
--   New context will override the previous context 
--
-- IN Parameters:
--   p_device_name  : Name of the notification device
--   p_profile_name : The name of the admin profile  
--   p_class        : Fully qualified name of the class implementing the notification interface
--   p_description  : Description for this device
--   p_context      : String array of context that will be passed to the notify method while delivering the notification.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE EDIT_JAVA_DEVICE(p_device_name  IN VARCHAR2,
                           p_profile_name IN VARCHAR2,
                           p_class        IN VARCHAR2,
                           p_description  IN VARCHAR2 DEFAULT '',
                           p_context      IN MGMT_MEDIUM_STRING_TABLE DEFAULT NULL) 
IS
BEGIN
  EMD_NOTIFICATION.edit_java_device(v_device_name  => p_device_name,
                                    v_profile_name => p_profile_name,    
                                    v_class        => p_class,
                                    v_description  => p_description,
                                    v_context      => p_context
                                  );
END EDIT_JAVA_DEVICE;     

-- 
-- PROCEDURE: DELETE_DEVICE
--
-- PURPOSE
-- 
-- PROCEDURE: DELETE_DEVICE
--
-- PURPOSE
--   Procedure to delete a notification device associated with an administrator
--   profile
-- PARAMETERS
--   p_profile_name - The name of the admin profile
--   p_device_name - Name of the device
PROCEDURE DELETE_DEVICE(p_profile_name    IN VARCHAR2,
                        p_device_name     IN VARCHAR2)
IS
BEGIN
  EMD_NOTIFICATION.delete_device(v_profile_name => p_profile_name,
                                 v_device_name  => p_device_name);
END DELETE_DEVICE;


-- PURPOSE
--   Procedure to assign notification devices to a notification rule
-- PARAMETERS
--   p_rule_name - Name of the notification rule
--   p_owner - The owner of the notification rule
--   p_device_name - The name of the device
--   p_profile_name - The name of the admin profile
PROCEDURE ADD_DEVICE_TO_RULE(p_rule_name    IN VARCHAR2,
                             p_owner        IN VARCHAR2,
                             p_device_name  IN VARCHAR2,
                             p_profile_name IN VARCHAR2)
IS
BEGIN
  EMD_NOTIFICATION.add_device_to_rule(v_rule_name    => p_rule_name,
                                      v_owner        => p_owner,
                                      v_device_name  => p_device_name,
                                      v_profile_name => p_profile_name);
END ADD_DEVICE_TO_RULE;   

-- 
-- PROCEDURE: DELETE_DEVICE_FROM_RULE
--
-- PURPOSE
--   Procedure to remove notification devices from a notification rule
-- PARAMETERS
--   p_rule_name - Name of the notification rule
--   p_owner - The owner of the notification rule
--   p_device_name - The name of the device
PROCEDURE DELETE_DEVICE_FROM_RULE(p_rule_name       IN VARCHAR2,
                                  p_owner           IN VARCHAR2,
                                  p_device_name     IN VARCHAR2)
IS
BEGIN
  EMD_NOTIFICATION.delete_device_from_rule(v_rule_name    => p_rule_name,
                                           v_owner        => p_owner,     
                                           v_device_name  => p_device_name);
END DELETE_DEVICE_FROM_RULE; 


-- 
-- PROCEDURE: SET_GLOBAL_REPEAT_SETTINGS
--
-- PURPOSE
--   To set global repeat settings
--
-- PARAMETERS
--  p_enabled - 1 if enabled, 0 is disabled
--  p_frequency - frequency in minutes,
--  p_count -- maximum repeat count
--
PROCEDURE SET_GLOBAL_REPEAT_SETTINGS(
            p_enabled IN NUMBER DEFAULT REPEAT_ENABLED_DEFAULT,
            p_frequency IN NUMBER DEFAULT REPEAT_FREQUENCY_DEFAULT,
            p_count IN NUMBER DEFAULT REPEAT_COUNT_DEFAULT)
IS
BEGIN
   EMD_NOTIFICATION.SET_GLOBAL_REPEAT_SETTINGS(p_enabled,
                                               p_frequency, p_count);
END SET_GLOBAL_REPEAT_SETTINGS;


-- 
-- PROCEDURE: GET_GLOBAL_REPEAT_SETTINGS
--
-- PURPOSE
--  To retrieve global repeat settings
--
-- PARAMETERS
--  p_enabled - 1 if enabled, 0 is disabled
--  p_frequency - frequency in minutes,
--  p_count -- maximum repeat count
--
PROCEDURE GET_GLOBAL_REPEAT_SETTINGS(
            p_enabled OUT NUMBER,
            p_frequency OUT NUMBER,
            p_count OUT NUMBER)
IS
BEGIN
   EMD_NOTIFICATION.GET_GLOBAL_REPEAT_SETTINGS(p_enabled,
                                               p_frequency, p_count);
END GET_GLOBAL_REPEAT_SETTINGS;

-- 
-- PROCEDURE: ACKNOWLEDGE_ALERT
--
-- PURPOSE
--  To acknowledge a particular alert record.
--
-- PARAMETERS
--  p_violation_guid - GUID of the violation record that needs to be acknowledged.
--  p_acknowledged_by - User name who aknowledged this alert.
--  p_annotation_type - Annotation type for severity acknowledged annotation
--  p_message - Annotation message
PROCEDURE ACKNOWLEDGE_ALERT(p_violation_guid  IN RAW,
                            p_acknowledged_by IN VARCHAR2,
                            p_annotation_type IN VARCHAR2,
                            p_message         IN VARCHAR2)
IS
BEGIN
  EMD_NOTIFICATION.ACKNOWLEDGE_ALERT(p_violation_guid,
                                     p_acknowledged_by,
                                     p_annotation_type,
                                     p_message);      
END;

-- PURPOSE
--   Procedure to enable/disable repeat setting for a rule
-- PARAMETERS
--   P_RULE_NAME - name of the notification rule
--   P_OWNER - the owner of the notification rule
--   P_ENABLE_REPEAT - whether to enable or disable the reepat.
PROCEDURE SET_RULE_REPEAT(p_rule_name   IN VARCHAR2,
                          p_owner       IN VARCHAR2,
                          p_enable_repeat IN NUMBER)
IS
BEGIN
  EMD_NOTIFICATION.SET_RULE_REPEAT(p_rule_name, p_owner, p_enable_repeat);
END SET_RULE_REPEAT;

END mgmt_notification;
/

show errors;
