Rem
Rem $Header: sdk_policy_pkgdef.sql 03-aug-2006.22:51:40 sthiruna Exp $
Rem
Rem sdk_policy_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_policy_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sthiruna    07/31/06 - Copying 10.2.0.3 Config Standard changes from
Rem                           EMCORE_MAIN_LINUX
Rem    niramach    03/01/06 - Change owner to author in 
Rem                           generate_cs_policy_name. 
Rem    niramach    01/25/06 - Add generate_cs_policy_name function. 
Rem    rpinnama    09/01/05 - Add delete_policy_metadata API 
Rem    rpinnama    05/20/05 - Change the signature of add/enable/disable 
Rem                           target policy 
Rem    rpinnama    04/15/05 - Add module name 
Rem    rpinnama    03/14/05 - Bug 4012110 : API to autoenable on existing 
Rem                           targets 
Rem    rpinnama    01/07/05 - Add support for start/end type_meta_vers 
Rem    rpinnama    12/02/04 - Support for clear_message and 
Rem                           clear_message_nlsid 
Rem    groyal      11/01/04 - Fix url_link_type constants 
Rem    rpinnama    10/06/04 - Change modify_policy signature 
Rem    groyal      09/14/04 - Add globals for policy parameter types 
Rem    rpinnama    09/02/04 - Add get_config_key_details procedure 
Rem    rpinnama    08/16/04 - Add delete_ca_assocs API 
Rem    pshishir    08/28/04 - Adding p_job_id to ca related procedures
Rem    rpinnama    08/04/04 - Add corrective action procedures 
Rem    rpinnama    08/03/04 - Add API fro corrective action 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/14/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_policy
AS

  -- The module name for error and performance logging
  G_MODULE_NAME constant varchar2(40) := 'MGMT_TEMPLATE';

  G_URL_TYPE_JSP         CONSTANT NUMBER(1) := 0;
  G_URL_TYPE_UIX         CONSTANT NUMBER(1) := 1;

  G_PARAM_TYPE_NUMBER    CONSTANT NUMBER(1) := 1;
  G_PARAM_TYPE_STRING    CONSTANT NUMBER(1) := 2;

  --
  -- FUNCTION: generate_policy_guid
  --
  -- PURPOSE:
  --   Given a target type,  policy name, this function 
  --   computes the policy guid for the policy. The guid is an MD5 hash of
  --   the target type and policy name. 
  --
  -- IN Parameters:
  --   p_target_type: The type of the target
  --   p_policy_name: The name of the metric
  --
  -- RETURN:
  --   The generated policy guid
  --
  FUNCTION generate_policy_guid(p_target_type   IN VARCHAR2,
                                p_policy_name   IN VARCHAR2)
    RETURN RAW;

  FUNCTION get_policy_guid(p_target_type   IN VARCHAR2,
                           p_policy_name   IN VARCHAR2)
    RETURN RAW;

  --
  -- FUNCTION: generate_cs_policy_name
  --
  -- PURPOSE:
  --   Given a original policy name,configuration standard name,rule name, 
  --   author and version this function computes the cs policy name for the rule.
  --   MD5 hashing of config standard name,rule name,author and version is done 
  --   to get a unique id.
  --
  --   Then original policy name is prepended up to a length of 96 characters to
  --   the unique id.
  --
  -- IN Parameters:
  --   p_orig_policy_name: The original 10.2 policy name
  --   p_config_std_name: The configuration standard name
  --   p_rule_name : The rule name to which the cs policy belongs to.  
  --   p_author : The author of config std
  --   p_version : The version of config std.
  --
  -- RETURN:
  --   The generated configuration standard policy name.
  --
  FUNCTION generate_cs_policy_name(p_orig_policy_name IN VARCHAR2,
                                   p_config_std_name IN VARCHAR2,
                                   p_rule_name IN VARCHAR2,
                                   p_author IN VARCHAR2,
                                   p_version IN NUMBER)
    RETURN VARCHAR2;    

  PROCEDURE create_policy(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2,
      p_metric_name              IN VARCHAR2,
      p_author                   IN VARCHAR2 DEFAULT 'ORACLE',
      p_policy_label_nlsid       IN VARCHAR2 DEFAULT NULL,
      p_description              IN VARCHAR2 DEFAULT ' ',
      p_description_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_impact                   IN VARCHAR2 DEFAULT ' ',
      p_impact_nlsid             IN VARCHAR2 DEFAULT NULL,
      p_recommendation           IN VARCHAR2 DEFAULT ' ',
      p_recommendation_nlsid     IN VARCHAR2 DEFAULT NULL,
      p_violation_level          IN NUMBER   DEFAULT NULL,
      p_condition_type           IN NUMBER   DEFAULT 1,
      p_condition                IN VARCHAR2 DEFAULT NULL,
      p_condition_operator       IN NUMBER   DEFAULT 0,
      p_detailed_url_link        IN VARCHAR2 DEFAULT NULL,
      p_message                  IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid            IN VARCHAR2 DEFAULT NULL,
      p_clear_message            IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid      IN VARCHAR2 DEFAULT NULL,
      p_auto_enable              IN NUMBER   DEFAULT 0,
      p_cs_consider_percentage   IN NUMBER   DEFAULT 0,
      p_start_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
      p_end_type_meta_ver        IN VARCHAR2 DEFAULT NULL,
      p_category_list            IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
      p_policy_param_list        IN MGMT_POLICY_PARAM_DEF_ARRAY DEFAULT NULL,
      p_dflt_param_val_list      IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL,
      p_viol_ctxt_list           IN MGMT_VIOL_CTXT_DEF_ARRAY DEFAULT NULL);


  PROCEDURE modify_policy(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2,
      p_metric_name              IN VARCHAR2 DEFAULT NULL,
      p_author                   IN VARCHAR2 DEFAULT NULL,
      p_policy_label_nlsid       IN VARCHAR2 DEFAULT NULL,
      p_description              IN VARCHAR2 DEFAULT NULL,
      p_description_nlsid        IN VARCHAR2 DEFAULT NULL,
      p_impact                   IN VARCHAR2 DEFAULT NULL,
      p_impact_nlsid             IN VARCHAR2 DEFAULT NULL,
      p_recommendation           IN VARCHAR2 DEFAULT NULL,
      p_recommendation_nlsid     IN VARCHAR2 DEFAULT NULL,
      p_violation_level          IN NUMBER   DEFAULT NULL,
      p_condition_type           IN NUMBER   DEFAULT 1,
      p_condition                IN VARCHAR2 DEFAULT NULL,
      p_condition_operator       IN NUMBER   DEFAULT 0,
      p_detailed_url_link        IN VARCHAR2 DEFAULT NULL,
      p_message                  IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid            IN VARCHAR2 DEFAULT NULL,
      p_clear_message            IN VARCHAR2 DEFAULT NULL,
      p_clear_message_nlsid      IN VARCHAR2 DEFAULT NULL,
      p_auto_enable              IN NUMBER   DEFAULT 0,
      p_cs_consider_percentage   IN NUMBER   DEFAULT 0,
      p_start_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
      p_end_type_meta_ver        IN VARCHAR2 DEFAULT NULL,
      p_category_list            IN MGMT_CATEGORY_ARRAY DEFAULT NULL,
      p_policy_param_list        IN MGMT_POLICY_PARAM_DEF_ARRAY DEFAULT NULL,
      p_dflt_param_val_list      IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL,
      p_viol_ctxt_list           IN MGMT_VIOL_CTXT_DEF_ARRAY DEFAULT NULL);


  -- Deletes the policy and all the data associated with it
  -- Does intermittent commits
  PROCEDURE delete_policy(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2);

  -- Deletes policy metadata
  -- This can be used along with create_policy to recreate the policy
  -- without affecting the policy associations
  PROCEDURE delete_policy_metadata(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2);

  -- Sets the end type metaver for a given policy
  PROCEDURE set_end_type_meta_ver(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2,
      p_end_type_meta_ver        IN VARCHAR2);

  --
  -- PROCEDURE: auto_enable_existing_targets
  --
  -- PURPOSE: 
  --   Associates all existing targets with the policy.
  --   This procedure removes the existing configuration for the policy and
  --   copies the default configuration of the policy to all the targets.
  -- 
  -- IN Parameters:
  --   p_target_type  : VARCHAR2 
  --       The name of the target type
  --   p_policy_name  : VARCHAR2 
  --       The name of the policy to be auto associated
  --
  -- OUT Parameters: NONE
  -- 
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --
  -- NOTE: 1. This procedure commits after associating each target.
  --    2. For newly created targets the auto_enable flag on mgmt_policies
  --       table drives the auto association.
  --    3. This is provided as a different procedure and not included in create_policy API 
  --       to avoid creating large undo space requirement while auto associating
  --       existing targets
  --
  PROCEDURE auto_enable_existing_targets(
      p_target_type              IN VARCHAR2,
      p_policy_name              IN VARCHAR2);


  PROCEDURE add_target_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL,
      p_is_enabled         IN NUMBER   DEFAULT 1,
      p_policy_val_list    IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
    );

  PROCEDURE enable_target_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL
    );
     
  PROCEDURE disable_target_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL
    );

  PROCEDURE remove_target_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL
    );

  PROCEDURE add_template_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL,
      p_is_enabled         IN NUMBER DEFAULT 1,
      p_policy_val_list    IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
    );

  PROCEDURE enable_template_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL
    );
     
  PROCEDURE disable_template_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT NULL
    );

  PROCEDURE remove_template_policy_assoc(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_policy_name        IN VARCHAR2
    );

  PROCEDURE set_target_policy_ca(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_violation_level    IN NUMBER   DEFAULT MGMT_GLOBAL.G_SEVERITY_CRITICAL,
      p_job_id             IN RAW
   );

  PROCEDURE set_target_metric_ca(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2 DEFAULT NULL,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_violation_level    IN NUMBER   DEFAULT MGMT_GLOBAL.G_SEVERITY_CRITICAL,
      p_job_id             IN RAW);

  PROCEDURE set_target_metric_fixit_job(
      p_target_type        IN VARCHAR2,
      p_target_name        IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2 DEFAULT NULL,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_agent_fixit        IN VARCHAR2 DEFAULT NULL);

  PROCEDURE set_template_policy_ca(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_policy_name        IN VARCHAR2,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_violation_level    IN NUMBER   DEFAULT MGMT_GLOBAL.G_SEVERITY_CRITICAL,
      p_job_id             IN RAW);

  PROCEDURE set_template_metric_ca(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2 DEFAULT NULL,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_violation_level    IN NUMBER   DEFAULT MGMT_GLOBAL.G_SEVERITY_CRITICAL,
      p_job_id             IN RAW);

  PROCEDURE set_template_metric_fixit_job(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_metric_name        IN VARCHAR2,
      p_metric_column      IN VARCHAR2 DEFAULT NULL,
      p_coll_name          IN VARCHAR2 DEFAULT ' ',
      p_key_value          IN VARCHAR2 DEFAULT ' ',
      p_key_operator       IN NUMBER   DEFAULT 0,
      p_agent_fixit        IN VARCHAR2 DEFAULT NULL);

END mgmt_policy;
/

show errors


